/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkemulticloud.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkemulticloud.v1.AzureClient;
import com.google.cloud.gkemulticloud.v1.AzureClientName;
import com.google.cloud.gkemulticloud.v1.AzureCluster;
import com.google.cloud.gkemulticloud.v1.AzureClusterName;
import com.google.cloud.gkemulticloud.v1.AzureClustersSettings;
import com.google.cloud.gkemulticloud.v1.AzureJsonWebKeys;
import com.google.cloud.gkemulticloud.v1.AzureNodePool;
import com.google.cloud.gkemulticloud.v1.AzureNodePoolName;
import com.google.cloud.gkemulticloud.v1.AzureOpenIdConfig;
import com.google.cloud.gkemulticloud.v1.AzureServerConfig;
import com.google.cloud.gkemulticloud.v1.AzureServerConfigName;
import com.google.cloud.gkemulticloud.v1.CreateAzureClientRequest;
import com.google.cloud.gkemulticloud.v1.CreateAzureClusterRequest;
import com.google.cloud.gkemulticloud.v1.CreateAzureNodePoolRequest;
import com.google.cloud.gkemulticloud.v1.DeleteAzureClientRequest;
import com.google.cloud.gkemulticloud.v1.DeleteAzureClusterRequest;
import com.google.cloud.gkemulticloud.v1.DeleteAzureNodePoolRequest;
import com.google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenRequest;
import com.google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenResponse;
import com.google.cloud.gkemulticloud.v1.GenerateAzureClusterAgentTokenRequest;
import com.google.cloud.gkemulticloud.v1.GenerateAzureClusterAgentTokenResponse;
import com.google.cloud.gkemulticloud.v1.GetAzureClientRequest;
import com.google.cloud.gkemulticloud.v1.GetAzureClusterRequest;
import com.google.cloud.gkemulticloud.v1.GetAzureJsonWebKeysRequest;
import com.google.cloud.gkemulticloud.v1.GetAzureNodePoolRequest;
import com.google.cloud.gkemulticloud.v1.GetAzureOpenIdConfigRequest;
import com.google.cloud.gkemulticloud.v1.GetAzureServerConfigRequest;
import com.google.cloud.gkemulticloud.v1.ListAzureClientsRequest;
import com.google.cloud.gkemulticloud.v1.ListAzureClientsResponse;
import com.google.cloud.gkemulticloud.v1.ListAzureClustersRequest;
import com.google.cloud.gkemulticloud.v1.ListAzureClustersResponse;
import com.google.cloud.gkemulticloud.v1.ListAzureNodePoolsRequest;
import com.google.cloud.gkemulticloud.v1.ListAzureNodePoolsResponse;
import com.google.cloud.gkemulticloud.v1.LocationName;
import com.google.cloud.gkemulticloud.v1.OperationMetadata;
import com.google.cloud.gkemulticloud.v1.UpdateAzureClusterRequest;
import com.google.cloud.gkemulticloud.v1.UpdateAzureNodePoolRequest;
import com.google.cloud.gkemulticloud.v1.stub.AzureClustersStub;
import com.google.cloud.gkemulticloud.v1.stub.AzureClustersStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AzureClustersClient
implements BackgroundResource {
    private final AzureClustersSettings settings;
    private final AzureClustersStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final AzureClustersClient create() throws IOException {
        return AzureClustersClient.create(AzureClustersSettings.newBuilder().build());
    }

    public static final AzureClustersClient create(AzureClustersSettings settings) throws IOException {
        return new AzureClustersClient(settings);
    }

    public static final AzureClustersClient create(AzureClustersStub stub) {
        return new AzureClustersClient(stub);
    }

    protected AzureClustersClient(AzureClustersSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AzureClustersStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected AzureClustersClient(AzureClustersStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final AzureClustersSettings getSettings() {
        return this.settings;
    }

    public AzureClustersStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<AzureClient, OperationMetadata> createAzureClientAsync(LocationName parent, AzureClient azureClient, String azureClientId) {
        CreateAzureClientRequest request = CreateAzureClientRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAzureClient(azureClient).setAzureClientId(azureClientId).build();
        return this.createAzureClientAsync(request);
    }

    public final OperationFuture<AzureClient, OperationMetadata> createAzureClientAsync(String parent, AzureClient azureClient, String azureClientId) {
        CreateAzureClientRequest request = CreateAzureClientRequest.newBuilder().setParent(parent).setAzureClient(azureClient).setAzureClientId(azureClientId).build();
        return this.createAzureClientAsync(request);
    }

    public final OperationFuture<AzureClient, OperationMetadata> createAzureClientAsync(CreateAzureClientRequest request) {
        return this.createAzureClientOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAzureClientRequest, AzureClient, OperationMetadata> createAzureClientOperationCallable() {
        return this.stub.createAzureClientOperationCallable();
    }

    public final UnaryCallable<CreateAzureClientRequest, Operation> createAzureClientCallable() {
        return this.stub.createAzureClientCallable();
    }

    public final AzureClient getAzureClient(AzureClientName name) {
        GetAzureClientRequest request = GetAzureClientRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAzureClient(request);
    }

    public final AzureClient getAzureClient(String name) {
        GetAzureClientRequest request = GetAzureClientRequest.newBuilder().setName(name).build();
        return this.getAzureClient(request);
    }

    public final AzureClient getAzureClient(GetAzureClientRequest request) {
        return (AzureClient)this.getAzureClientCallable().call((Object)request);
    }

    public final UnaryCallable<GetAzureClientRequest, AzureClient> getAzureClientCallable() {
        return this.stub.getAzureClientCallable();
    }

    public final ListAzureClientsPagedResponse listAzureClients(LocationName parent) {
        ListAzureClientsRequest request = ListAzureClientsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAzureClients(request);
    }

    public final ListAzureClientsPagedResponse listAzureClients(String parent) {
        ListAzureClientsRequest request = ListAzureClientsRequest.newBuilder().setParent(parent).build();
        return this.listAzureClients(request);
    }

    public final ListAzureClientsPagedResponse listAzureClients(ListAzureClientsRequest request) {
        return (ListAzureClientsPagedResponse)((Object)this.listAzureClientsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAzureClientsRequest, ListAzureClientsPagedResponse> listAzureClientsPagedCallable() {
        return this.stub.listAzureClientsPagedCallable();
    }

    public final UnaryCallable<ListAzureClientsRequest, ListAzureClientsResponse> listAzureClientsCallable() {
        return this.stub.listAzureClientsCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAzureClientAsync(AzureClientName name) {
        DeleteAzureClientRequest request = DeleteAzureClientRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAzureClientAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAzureClientAsync(String name) {
        DeleteAzureClientRequest request = DeleteAzureClientRequest.newBuilder().setName(name).build();
        return this.deleteAzureClientAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAzureClientAsync(DeleteAzureClientRequest request) {
        return this.deleteAzureClientOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAzureClientRequest, Empty, OperationMetadata> deleteAzureClientOperationCallable() {
        return this.stub.deleteAzureClientOperationCallable();
    }

    public final UnaryCallable<DeleteAzureClientRequest, Operation> deleteAzureClientCallable() {
        return this.stub.deleteAzureClientCallable();
    }

    public final OperationFuture<AzureCluster, OperationMetadata> createAzureClusterAsync(LocationName parent, AzureCluster azureCluster, String azureClusterId) {
        CreateAzureClusterRequest request = CreateAzureClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAzureCluster(azureCluster).setAzureClusterId(azureClusterId).build();
        return this.createAzureClusterAsync(request);
    }

    public final OperationFuture<AzureCluster, OperationMetadata> createAzureClusterAsync(String parent, AzureCluster azureCluster, String azureClusterId) {
        CreateAzureClusterRequest request = CreateAzureClusterRequest.newBuilder().setParent(parent).setAzureCluster(azureCluster).setAzureClusterId(azureClusterId).build();
        return this.createAzureClusterAsync(request);
    }

    public final OperationFuture<AzureCluster, OperationMetadata> createAzureClusterAsync(CreateAzureClusterRequest request) {
        return this.createAzureClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAzureClusterRequest, AzureCluster, OperationMetadata> createAzureClusterOperationCallable() {
        return this.stub.createAzureClusterOperationCallable();
    }

    public final UnaryCallable<CreateAzureClusterRequest, Operation> createAzureClusterCallable() {
        return this.stub.createAzureClusterCallable();
    }

    public final OperationFuture<AzureCluster, OperationMetadata> updateAzureClusterAsync(AzureCluster azureCluster, FieldMask updateMask) {
        UpdateAzureClusterRequest request = UpdateAzureClusterRequest.newBuilder().setAzureCluster(azureCluster).setUpdateMask(updateMask).build();
        return this.updateAzureClusterAsync(request);
    }

    public final OperationFuture<AzureCluster, OperationMetadata> updateAzureClusterAsync(UpdateAzureClusterRequest request) {
        return this.updateAzureClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAzureClusterRequest, AzureCluster, OperationMetadata> updateAzureClusterOperationCallable() {
        return this.stub.updateAzureClusterOperationCallable();
    }

    public final UnaryCallable<UpdateAzureClusterRequest, Operation> updateAzureClusterCallable() {
        return this.stub.updateAzureClusterCallable();
    }

    public final AzureCluster getAzureCluster(AzureClusterName name) {
        GetAzureClusterRequest request = GetAzureClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAzureCluster(request);
    }

    public final AzureCluster getAzureCluster(String name) {
        GetAzureClusterRequest request = GetAzureClusterRequest.newBuilder().setName(name).build();
        return this.getAzureCluster(request);
    }

    public final AzureCluster getAzureCluster(GetAzureClusterRequest request) {
        return (AzureCluster)this.getAzureClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetAzureClusterRequest, AzureCluster> getAzureClusterCallable() {
        return this.stub.getAzureClusterCallable();
    }

    public final ListAzureClustersPagedResponse listAzureClusters(LocationName parent) {
        ListAzureClustersRequest request = ListAzureClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAzureClusters(request);
    }

    public final ListAzureClustersPagedResponse listAzureClusters(String parent) {
        ListAzureClustersRequest request = ListAzureClustersRequest.newBuilder().setParent(parent).build();
        return this.listAzureClusters(request);
    }

    public final ListAzureClustersPagedResponse listAzureClusters(ListAzureClustersRequest request) {
        return (ListAzureClustersPagedResponse)((Object)this.listAzureClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAzureClustersRequest, ListAzureClustersPagedResponse> listAzureClustersPagedCallable() {
        return this.stub.listAzureClustersPagedCallable();
    }

    public final UnaryCallable<ListAzureClustersRequest, ListAzureClustersResponse> listAzureClustersCallable() {
        return this.stub.listAzureClustersCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAzureClusterAsync(AzureClusterName name) {
        DeleteAzureClusterRequest request = DeleteAzureClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAzureClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAzureClusterAsync(String name) {
        DeleteAzureClusterRequest request = DeleteAzureClusterRequest.newBuilder().setName(name).build();
        return this.deleteAzureClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAzureClusterAsync(DeleteAzureClusterRequest request) {
        return this.deleteAzureClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAzureClusterRequest, Empty, OperationMetadata> deleteAzureClusterOperationCallable() {
        return this.stub.deleteAzureClusterOperationCallable();
    }

    public final UnaryCallable<DeleteAzureClusterRequest, Operation> deleteAzureClusterCallable() {
        return this.stub.deleteAzureClusterCallable();
    }

    public final GenerateAzureClusterAgentTokenResponse generateAzureClusterAgentToken(GenerateAzureClusterAgentTokenRequest request) {
        return (GenerateAzureClusterAgentTokenResponse)this.generateAzureClusterAgentTokenCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateAzureClusterAgentTokenRequest, GenerateAzureClusterAgentTokenResponse> generateAzureClusterAgentTokenCallable() {
        return this.stub.generateAzureClusterAgentTokenCallable();
    }

    public final GenerateAzureAccessTokenResponse generateAzureAccessToken(GenerateAzureAccessTokenRequest request) {
        return (GenerateAzureAccessTokenResponse)this.generateAzureAccessTokenCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateAzureAccessTokenRequest, GenerateAzureAccessTokenResponse> generateAzureAccessTokenCallable() {
        return this.stub.generateAzureAccessTokenCallable();
    }

    public final OperationFuture<AzureNodePool, OperationMetadata> createAzureNodePoolAsync(AzureClusterName parent, AzureNodePool azureNodePool, String azureNodePoolId) {
        CreateAzureNodePoolRequest request = CreateAzureNodePoolRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAzureNodePool(azureNodePool).setAzureNodePoolId(azureNodePoolId).build();
        return this.createAzureNodePoolAsync(request);
    }

    public final OperationFuture<AzureNodePool, OperationMetadata> createAzureNodePoolAsync(String parent, AzureNodePool azureNodePool, String azureNodePoolId) {
        CreateAzureNodePoolRequest request = CreateAzureNodePoolRequest.newBuilder().setParent(parent).setAzureNodePool(azureNodePool).setAzureNodePoolId(azureNodePoolId).build();
        return this.createAzureNodePoolAsync(request);
    }

    public final OperationFuture<AzureNodePool, OperationMetadata> createAzureNodePoolAsync(CreateAzureNodePoolRequest request) {
        return this.createAzureNodePoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAzureNodePoolRequest, AzureNodePool, OperationMetadata> createAzureNodePoolOperationCallable() {
        return this.stub.createAzureNodePoolOperationCallable();
    }

    public final UnaryCallable<CreateAzureNodePoolRequest, Operation> createAzureNodePoolCallable() {
        return this.stub.createAzureNodePoolCallable();
    }

    public final OperationFuture<AzureNodePool, OperationMetadata> updateAzureNodePoolAsync(AzureNodePool azureNodePool, FieldMask updateMask) {
        UpdateAzureNodePoolRequest request = UpdateAzureNodePoolRequest.newBuilder().setAzureNodePool(azureNodePool).setUpdateMask(updateMask).build();
        return this.updateAzureNodePoolAsync(request);
    }

    public final OperationFuture<AzureNodePool, OperationMetadata> updateAzureNodePoolAsync(UpdateAzureNodePoolRequest request) {
        return this.updateAzureNodePoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAzureNodePoolRequest, AzureNodePool, OperationMetadata> updateAzureNodePoolOperationCallable() {
        return this.stub.updateAzureNodePoolOperationCallable();
    }

    public final UnaryCallable<UpdateAzureNodePoolRequest, Operation> updateAzureNodePoolCallable() {
        return this.stub.updateAzureNodePoolCallable();
    }

    public final AzureNodePool getAzureNodePool(AzureNodePoolName name) {
        GetAzureNodePoolRequest request = GetAzureNodePoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAzureNodePool(request);
    }

    public final AzureNodePool getAzureNodePool(String name) {
        GetAzureNodePoolRequest request = GetAzureNodePoolRequest.newBuilder().setName(name).build();
        return this.getAzureNodePool(request);
    }

    public final AzureNodePool getAzureNodePool(GetAzureNodePoolRequest request) {
        return (AzureNodePool)this.getAzureNodePoolCallable().call((Object)request);
    }

    public final UnaryCallable<GetAzureNodePoolRequest, AzureNodePool> getAzureNodePoolCallable() {
        return this.stub.getAzureNodePoolCallable();
    }

    public final ListAzureNodePoolsPagedResponse listAzureNodePools(AzureClusterName parent) {
        ListAzureNodePoolsRequest request = ListAzureNodePoolsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAzureNodePools(request);
    }

    public final ListAzureNodePoolsPagedResponse listAzureNodePools(String parent) {
        ListAzureNodePoolsRequest request = ListAzureNodePoolsRequest.newBuilder().setParent(parent).build();
        return this.listAzureNodePools(request);
    }

    public final ListAzureNodePoolsPagedResponse listAzureNodePools(ListAzureNodePoolsRequest request) {
        return (ListAzureNodePoolsPagedResponse)((Object)this.listAzureNodePoolsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAzureNodePoolsRequest, ListAzureNodePoolsPagedResponse> listAzureNodePoolsPagedCallable() {
        return this.stub.listAzureNodePoolsPagedCallable();
    }

    public final UnaryCallable<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse> listAzureNodePoolsCallable() {
        return this.stub.listAzureNodePoolsCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAzureNodePoolAsync(AzureNodePoolName name) {
        DeleteAzureNodePoolRequest request = DeleteAzureNodePoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAzureNodePoolAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAzureNodePoolAsync(String name) {
        DeleteAzureNodePoolRequest request = DeleteAzureNodePoolRequest.newBuilder().setName(name).build();
        return this.deleteAzureNodePoolAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAzureNodePoolAsync(DeleteAzureNodePoolRequest request) {
        return this.deleteAzureNodePoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAzureNodePoolRequest, Empty, OperationMetadata> deleteAzureNodePoolOperationCallable() {
        return this.stub.deleteAzureNodePoolOperationCallable();
    }

    public final UnaryCallable<DeleteAzureNodePoolRequest, Operation> deleteAzureNodePoolCallable() {
        return this.stub.deleteAzureNodePoolCallable();
    }

    public final AzureOpenIdConfig getAzureOpenIdConfig(AzureClusterName azureCluster) {
        GetAzureOpenIdConfigRequest request = GetAzureOpenIdConfigRequest.newBuilder().setAzureCluster(azureCluster == null ? null : azureCluster.toString()).build();
        return this.getAzureOpenIdConfig(request);
    }

    public final AzureOpenIdConfig getAzureOpenIdConfig(String azureCluster) {
        GetAzureOpenIdConfigRequest request = GetAzureOpenIdConfigRequest.newBuilder().setAzureCluster(azureCluster).build();
        return this.getAzureOpenIdConfig(request);
    }

    public final AzureOpenIdConfig getAzureOpenIdConfig(GetAzureOpenIdConfigRequest request) {
        return (AzureOpenIdConfig)this.getAzureOpenIdConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetAzureOpenIdConfigRequest, AzureOpenIdConfig> getAzureOpenIdConfigCallable() {
        return this.stub.getAzureOpenIdConfigCallable();
    }

    public final AzureJsonWebKeys getAzureJsonWebKeys(AzureClusterName azureCluster) {
        GetAzureJsonWebKeysRequest request = GetAzureJsonWebKeysRequest.newBuilder().setAzureCluster(azureCluster == null ? null : azureCluster.toString()).build();
        return this.getAzureJsonWebKeys(request);
    }

    public final AzureJsonWebKeys getAzureJsonWebKeys(String azureCluster) {
        GetAzureJsonWebKeysRequest request = GetAzureJsonWebKeysRequest.newBuilder().setAzureCluster(azureCluster).build();
        return this.getAzureJsonWebKeys(request);
    }

    public final AzureJsonWebKeys getAzureJsonWebKeys(GetAzureJsonWebKeysRequest request) {
        return (AzureJsonWebKeys)this.getAzureJsonWebKeysCallable().call((Object)request);
    }

    public final UnaryCallable<GetAzureJsonWebKeysRequest, AzureJsonWebKeys> getAzureJsonWebKeysCallable() {
        return this.stub.getAzureJsonWebKeysCallable();
    }

    public final AzureServerConfig getAzureServerConfig(AzureServerConfigName name) {
        GetAzureServerConfigRequest request = GetAzureServerConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAzureServerConfig(request);
    }

    public final AzureServerConfig getAzureServerConfig(String name) {
        GetAzureServerConfigRequest request = GetAzureServerConfigRequest.newBuilder().setName(name).build();
        return this.getAzureServerConfig(request);
    }

    public final AzureServerConfig getAzureServerConfig(GetAzureServerConfigRequest request) {
        return (AzureServerConfig)this.getAzureServerConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetAzureServerConfigRequest, AzureServerConfig> getAzureServerConfigCallable() {
        return this.stub.getAzureServerConfigCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAzureNodePoolsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse, AzureNodePool, ListAzureNodePoolsPage, ListAzureNodePoolsFixedSizeCollection> {
        private ListAzureNodePoolsFixedSizeCollection(List<ListAzureNodePoolsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAzureNodePoolsFixedSizeCollection createEmptyCollection() {
            return new ListAzureNodePoolsFixedSizeCollection(null, 0);
        }

        protected ListAzureNodePoolsFixedSizeCollection createCollection(List<ListAzureNodePoolsPage> pages, int collectionSize) {
            return new ListAzureNodePoolsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAzureNodePoolsPage
    extends AbstractPage<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse, AzureNodePool, ListAzureNodePoolsPage> {
        private ListAzureNodePoolsPage(PageContext<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse, AzureNodePool> context, ListAzureNodePoolsResponse response) {
            super(context, (Object)response);
        }

        private static ListAzureNodePoolsPage createEmptyPage() {
            return new ListAzureNodePoolsPage(null, null);
        }

        protected ListAzureNodePoolsPage createPage(PageContext<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse, AzureNodePool> context, ListAzureNodePoolsResponse response) {
            return new ListAzureNodePoolsPage(context, response);
        }

        public ApiFuture<ListAzureNodePoolsPage> createPageAsync(PageContext<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse, AzureNodePool> context, ApiFuture<ListAzureNodePoolsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAzureNodePoolsPagedResponse
    extends AbstractPagedListResponse<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse, AzureNodePool, ListAzureNodePoolsPage, ListAzureNodePoolsFixedSizeCollection> {
        public static ApiFuture<ListAzureNodePoolsPagedResponse> createAsync(PageContext<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse, AzureNodePool> context, ApiFuture<ListAzureNodePoolsResponse> futureResponse) {
            ApiFuture<ListAzureNodePoolsPage> futurePage = ListAzureNodePoolsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAzureNodePoolsPagedResponse((ListAzureNodePoolsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAzureNodePoolsPagedResponse(ListAzureNodePoolsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAzureNodePoolsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAzureClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAzureClustersRequest, ListAzureClustersResponse, AzureCluster, ListAzureClustersPage, ListAzureClustersFixedSizeCollection> {
        private ListAzureClustersFixedSizeCollection(List<ListAzureClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAzureClustersFixedSizeCollection createEmptyCollection() {
            return new ListAzureClustersFixedSizeCollection(null, 0);
        }

        protected ListAzureClustersFixedSizeCollection createCollection(List<ListAzureClustersPage> pages, int collectionSize) {
            return new ListAzureClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAzureClustersPage
    extends AbstractPage<ListAzureClustersRequest, ListAzureClustersResponse, AzureCluster, ListAzureClustersPage> {
        private ListAzureClustersPage(PageContext<ListAzureClustersRequest, ListAzureClustersResponse, AzureCluster> context, ListAzureClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListAzureClustersPage createEmptyPage() {
            return new ListAzureClustersPage(null, null);
        }

        protected ListAzureClustersPage createPage(PageContext<ListAzureClustersRequest, ListAzureClustersResponse, AzureCluster> context, ListAzureClustersResponse response) {
            return new ListAzureClustersPage(context, response);
        }

        public ApiFuture<ListAzureClustersPage> createPageAsync(PageContext<ListAzureClustersRequest, ListAzureClustersResponse, AzureCluster> context, ApiFuture<ListAzureClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAzureClustersPagedResponse
    extends AbstractPagedListResponse<ListAzureClustersRequest, ListAzureClustersResponse, AzureCluster, ListAzureClustersPage, ListAzureClustersFixedSizeCollection> {
        public static ApiFuture<ListAzureClustersPagedResponse> createAsync(PageContext<ListAzureClustersRequest, ListAzureClustersResponse, AzureCluster> context, ApiFuture<ListAzureClustersResponse> futureResponse) {
            ApiFuture<ListAzureClustersPage> futurePage = ListAzureClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAzureClustersPagedResponse((ListAzureClustersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAzureClustersPagedResponse(ListAzureClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAzureClustersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAzureClientsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAzureClientsRequest, ListAzureClientsResponse, AzureClient, ListAzureClientsPage, ListAzureClientsFixedSizeCollection> {
        private ListAzureClientsFixedSizeCollection(List<ListAzureClientsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAzureClientsFixedSizeCollection createEmptyCollection() {
            return new ListAzureClientsFixedSizeCollection(null, 0);
        }

        protected ListAzureClientsFixedSizeCollection createCollection(List<ListAzureClientsPage> pages, int collectionSize) {
            return new ListAzureClientsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAzureClientsPage
    extends AbstractPage<ListAzureClientsRequest, ListAzureClientsResponse, AzureClient, ListAzureClientsPage> {
        private ListAzureClientsPage(PageContext<ListAzureClientsRequest, ListAzureClientsResponse, AzureClient> context, ListAzureClientsResponse response) {
            super(context, (Object)response);
        }

        private static ListAzureClientsPage createEmptyPage() {
            return new ListAzureClientsPage(null, null);
        }

        protected ListAzureClientsPage createPage(PageContext<ListAzureClientsRequest, ListAzureClientsResponse, AzureClient> context, ListAzureClientsResponse response) {
            return new ListAzureClientsPage(context, response);
        }

        public ApiFuture<ListAzureClientsPage> createPageAsync(PageContext<ListAzureClientsRequest, ListAzureClientsResponse, AzureClient> context, ApiFuture<ListAzureClientsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAzureClientsPagedResponse
    extends AbstractPagedListResponse<ListAzureClientsRequest, ListAzureClientsResponse, AzureClient, ListAzureClientsPage, ListAzureClientsFixedSizeCollection> {
        public static ApiFuture<ListAzureClientsPagedResponse> createAsync(PageContext<ListAzureClientsRequest, ListAzureClientsResponse, AzureClient> context, ApiFuture<ListAzureClientsResponse> futureResponse) {
            ApiFuture<ListAzureClientsPage> futurePage = ListAzureClientsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAzureClientsPagedResponse((ListAzureClientsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAzureClientsPagedResponse(ListAzureClientsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAzureClientsFixedSizeCollection.createEmptyCollection());
        }
    }
}

