/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkemulticloud.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkemulticloud.v1.AwsCluster;
import com.google.cloud.gkemulticloud.v1.AwsClusterName;
import com.google.cloud.gkemulticloud.v1.AwsClustersSettings;
import com.google.cloud.gkemulticloud.v1.AwsNodePool;
import com.google.cloud.gkemulticloud.v1.AwsNodePoolName;
import com.google.cloud.gkemulticloud.v1.AwsServerConfig;
import com.google.cloud.gkemulticloud.v1.AwsServerConfigName;
import com.google.cloud.gkemulticloud.v1.CreateAwsClusterRequest;
import com.google.cloud.gkemulticloud.v1.CreateAwsNodePoolRequest;
import com.google.cloud.gkemulticloud.v1.DeleteAwsClusterRequest;
import com.google.cloud.gkemulticloud.v1.DeleteAwsNodePoolRequest;
import com.google.cloud.gkemulticloud.v1.GenerateAwsAccessTokenRequest;
import com.google.cloud.gkemulticloud.v1.GenerateAwsAccessTokenResponse;
import com.google.cloud.gkemulticloud.v1.GetAwsClusterRequest;
import com.google.cloud.gkemulticloud.v1.GetAwsNodePoolRequest;
import com.google.cloud.gkemulticloud.v1.GetAwsServerConfigRequest;
import com.google.cloud.gkemulticloud.v1.ListAwsClustersRequest;
import com.google.cloud.gkemulticloud.v1.ListAwsClustersResponse;
import com.google.cloud.gkemulticloud.v1.ListAwsNodePoolsRequest;
import com.google.cloud.gkemulticloud.v1.ListAwsNodePoolsResponse;
import com.google.cloud.gkemulticloud.v1.LocationName;
import com.google.cloud.gkemulticloud.v1.OperationMetadata;
import com.google.cloud.gkemulticloud.v1.UpdateAwsClusterRequest;
import com.google.cloud.gkemulticloud.v1.UpdateAwsNodePoolRequest;
import com.google.cloud.gkemulticloud.v1.stub.AwsClustersStub;
import com.google.cloud.gkemulticloud.v1.stub.AwsClustersStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AwsClustersClient
implements BackgroundResource {
    private final AwsClustersSettings settings;
    private final AwsClustersStub stub;
    private final OperationsClient operationsClient;

    public static final AwsClustersClient create() throws IOException {
        return AwsClustersClient.create(AwsClustersSettings.newBuilder().build());
    }

    public static final AwsClustersClient create(AwsClustersSettings settings) throws IOException {
        return new AwsClustersClient(settings);
    }

    public static final AwsClustersClient create(AwsClustersStub stub) {
        return new AwsClustersClient(stub);
    }

    protected AwsClustersClient(AwsClustersSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AwsClustersStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected AwsClustersClient(AwsClustersStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final AwsClustersSettings getSettings() {
        return this.settings;
    }

    public AwsClustersStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<AwsCluster, OperationMetadata> createAwsClusterAsync(LocationName parent, AwsCluster awsCluster, String awsClusterId) {
        CreateAwsClusterRequest request = CreateAwsClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAwsCluster(awsCluster).setAwsClusterId(awsClusterId).build();
        return this.createAwsClusterAsync(request);
    }

    public final OperationFuture<AwsCluster, OperationMetadata> createAwsClusterAsync(String parent, AwsCluster awsCluster, String awsClusterId) {
        CreateAwsClusterRequest request = CreateAwsClusterRequest.newBuilder().setParent(parent).setAwsCluster(awsCluster).setAwsClusterId(awsClusterId).build();
        return this.createAwsClusterAsync(request);
    }

    public final OperationFuture<AwsCluster, OperationMetadata> createAwsClusterAsync(CreateAwsClusterRequest request) {
        return this.createAwsClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAwsClusterRequest, AwsCluster, OperationMetadata> createAwsClusterOperationCallable() {
        return this.stub.createAwsClusterOperationCallable();
    }

    public final UnaryCallable<CreateAwsClusterRequest, Operation> createAwsClusterCallable() {
        return this.stub.createAwsClusterCallable();
    }

    public final OperationFuture<AwsCluster, OperationMetadata> updateAwsClusterAsync(AwsCluster awsCluster, FieldMask updateMask) {
        UpdateAwsClusterRequest request = UpdateAwsClusterRequest.newBuilder().setAwsCluster(awsCluster).setUpdateMask(updateMask).build();
        return this.updateAwsClusterAsync(request);
    }

    public final OperationFuture<AwsCluster, OperationMetadata> updateAwsClusterAsync(UpdateAwsClusterRequest request) {
        return this.updateAwsClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAwsClusterRequest, AwsCluster, OperationMetadata> updateAwsClusterOperationCallable() {
        return this.stub.updateAwsClusterOperationCallable();
    }

    public final UnaryCallable<UpdateAwsClusterRequest, Operation> updateAwsClusterCallable() {
        return this.stub.updateAwsClusterCallable();
    }

    public final AwsCluster getAwsCluster(AwsClusterName name) {
        GetAwsClusterRequest request = GetAwsClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAwsCluster(request);
    }

    public final AwsCluster getAwsCluster(String name) {
        GetAwsClusterRequest request = GetAwsClusterRequest.newBuilder().setName(name).build();
        return this.getAwsCluster(request);
    }

    public final AwsCluster getAwsCluster(GetAwsClusterRequest request) {
        return (AwsCluster)this.getAwsClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetAwsClusterRequest, AwsCluster> getAwsClusterCallable() {
        return this.stub.getAwsClusterCallable();
    }

    public final ListAwsClustersPagedResponse listAwsClusters(LocationName parent) {
        ListAwsClustersRequest request = ListAwsClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAwsClusters(request);
    }

    public final ListAwsClustersPagedResponse listAwsClusters(String parent) {
        ListAwsClustersRequest request = ListAwsClustersRequest.newBuilder().setParent(parent).build();
        return this.listAwsClusters(request);
    }

    public final ListAwsClustersPagedResponse listAwsClusters(ListAwsClustersRequest request) {
        return (ListAwsClustersPagedResponse)((Object)this.listAwsClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAwsClustersRequest, ListAwsClustersPagedResponse> listAwsClustersPagedCallable() {
        return this.stub.listAwsClustersPagedCallable();
    }

    public final UnaryCallable<ListAwsClustersRequest, ListAwsClustersResponse> listAwsClustersCallable() {
        return this.stub.listAwsClustersCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAwsClusterAsync(AwsClusterName name) {
        DeleteAwsClusterRequest request = DeleteAwsClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAwsClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAwsClusterAsync(String name) {
        DeleteAwsClusterRequest request = DeleteAwsClusterRequest.newBuilder().setName(name).build();
        return this.deleteAwsClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAwsClusterAsync(DeleteAwsClusterRequest request) {
        return this.deleteAwsClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAwsClusterRequest, Empty, OperationMetadata> deleteAwsClusterOperationCallable() {
        return this.stub.deleteAwsClusterOperationCallable();
    }

    public final UnaryCallable<DeleteAwsClusterRequest, Operation> deleteAwsClusterCallable() {
        return this.stub.deleteAwsClusterCallable();
    }

    public final GenerateAwsAccessTokenResponse generateAwsAccessToken(GenerateAwsAccessTokenRequest request) {
        return (GenerateAwsAccessTokenResponse)this.generateAwsAccessTokenCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateAwsAccessTokenRequest, GenerateAwsAccessTokenResponse> generateAwsAccessTokenCallable() {
        return this.stub.generateAwsAccessTokenCallable();
    }

    public final OperationFuture<AwsNodePool, OperationMetadata> createAwsNodePoolAsync(AwsClusterName parent, AwsNodePool awsNodePool, String awsNodePoolId) {
        CreateAwsNodePoolRequest request = CreateAwsNodePoolRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAwsNodePool(awsNodePool).setAwsNodePoolId(awsNodePoolId).build();
        return this.createAwsNodePoolAsync(request);
    }

    public final OperationFuture<AwsNodePool, OperationMetadata> createAwsNodePoolAsync(String parent, AwsNodePool awsNodePool, String awsNodePoolId) {
        CreateAwsNodePoolRequest request = CreateAwsNodePoolRequest.newBuilder().setParent(parent).setAwsNodePool(awsNodePool).setAwsNodePoolId(awsNodePoolId).build();
        return this.createAwsNodePoolAsync(request);
    }

    public final OperationFuture<AwsNodePool, OperationMetadata> createAwsNodePoolAsync(CreateAwsNodePoolRequest request) {
        return this.createAwsNodePoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAwsNodePoolRequest, AwsNodePool, OperationMetadata> createAwsNodePoolOperationCallable() {
        return this.stub.createAwsNodePoolOperationCallable();
    }

    public final UnaryCallable<CreateAwsNodePoolRequest, Operation> createAwsNodePoolCallable() {
        return this.stub.createAwsNodePoolCallable();
    }

    public final OperationFuture<AwsNodePool, OperationMetadata> updateAwsNodePoolAsync(AwsNodePool awsNodePool, FieldMask updateMask) {
        UpdateAwsNodePoolRequest request = UpdateAwsNodePoolRequest.newBuilder().setAwsNodePool(awsNodePool).setUpdateMask(updateMask).build();
        return this.updateAwsNodePoolAsync(request);
    }

    public final OperationFuture<AwsNodePool, OperationMetadata> updateAwsNodePoolAsync(UpdateAwsNodePoolRequest request) {
        return this.updateAwsNodePoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAwsNodePoolRequest, AwsNodePool, OperationMetadata> updateAwsNodePoolOperationCallable() {
        return this.stub.updateAwsNodePoolOperationCallable();
    }

    public final UnaryCallable<UpdateAwsNodePoolRequest, Operation> updateAwsNodePoolCallable() {
        return this.stub.updateAwsNodePoolCallable();
    }

    public final AwsNodePool getAwsNodePool(AwsNodePoolName name) {
        GetAwsNodePoolRequest request = GetAwsNodePoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAwsNodePool(request);
    }

    public final AwsNodePool getAwsNodePool(String name) {
        GetAwsNodePoolRequest request = GetAwsNodePoolRequest.newBuilder().setName(name).build();
        return this.getAwsNodePool(request);
    }

    public final AwsNodePool getAwsNodePool(GetAwsNodePoolRequest request) {
        return (AwsNodePool)this.getAwsNodePoolCallable().call((Object)request);
    }

    public final UnaryCallable<GetAwsNodePoolRequest, AwsNodePool> getAwsNodePoolCallable() {
        return this.stub.getAwsNodePoolCallable();
    }

    public final ListAwsNodePoolsPagedResponse listAwsNodePools(AwsClusterName parent) {
        ListAwsNodePoolsRequest request = ListAwsNodePoolsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAwsNodePools(request);
    }

    public final ListAwsNodePoolsPagedResponse listAwsNodePools(String parent) {
        ListAwsNodePoolsRequest request = ListAwsNodePoolsRequest.newBuilder().setParent(parent).build();
        return this.listAwsNodePools(request);
    }

    public final ListAwsNodePoolsPagedResponse listAwsNodePools(ListAwsNodePoolsRequest request) {
        return (ListAwsNodePoolsPagedResponse)((Object)this.listAwsNodePoolsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAwsNodePoolsRequest, ListAwsNodePoolsPagedResponse> listAwsNodePoolsPagedCallable() {
        return this.stub.listAwsNodePoolsPagedCallable();
    }

    public final UnaryCallable<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse> listAwsNodePoolsCallable() {
        return this.stub.listAwsNodePoolsCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAwsNodePoolAsync(AwsNodePoolName name) {
        DeleteAwsNodePoolRequest request = DeleteAwsNodePoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAwsNodePoolAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAwsNodePoolAsync(String name) {
        DeleteAwsNodePoolRequest request = DeleteAwsNodePoolRequest.newBuilder().setName(name).build();
        return this.deleteAwsNodePoolAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAwsNodePoolAsync(DeleteAwsNodePoolRequest request) {
        return this.deleteAwsNodePoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAwsNodePoolRequest, Empty, OperationMetadata> deleteAwsNodePoolOperationCallable() {
        return this.stub.deleteAwsNodePoolOperationCallable();
    }

    public final UnaryCallable<DeleteAwsNodePoolRequest, Operation> deleteAwsNodePoolCallable() {
        return this.stub.deleteAwsNodePoolCallable();
    }

    public final AwsServerConfig getAwsServerConfig(AwsServerConfigName name) {
        GetAwsServerConfigRequest request = GetAwsServerConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAwsServerConfig(request);
    }

    public final AwsServerConfig getAwsServerConfig(String name) {
        GetAwsServerConfigRequest request = GetAwsServerConfigRequest.newBuilder().setName(name).build();
        return this.getAwsServerConfig(request);
    }

    public final AwsServerConfig getAwsServerConfig(GetAwsServerConfigRequest request) {
        return (AwsServerConfig)this.getAwsServerConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetAwsServerConfigRequest, AwsServerConfig> getAwsServerConfigCallable() {
        return this.stub.getAwsServerConfigCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAwsNodePoolsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse, AwsNodePool, ListAwsNodePoolsPage, ListAwsNodePoolsFixedSizeCollection> {
        private ListAwsNodePoolsFixedSizeCollection(List<ListAwsNodePoolsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAwsNodePoolsFixedSizeCollection createEmptyCollection() {
            return new ListAwsNodePoolsFixedSizeCollection(null, 0);
        }

        protected ListAwsNodePoolsFixedSizeCollection createCollection(List<ListAwsNodePoolsPage> pages, int collectionSize) {
            return new ListAwsNodePoolsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAwsNodePoolsPage
    extends AbstractPage<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse, AwsNodePool, ListAwsNodePoolsPage> {
        private ListAwsNodePoolsPage(PageContext<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse, AwsNodePool> context, ListAwsNodePoolsResponse response) {
            super(context, (Object)response);
        }

        private static ListAwsNodePoolsPage createEmptyPage() {
            return new ListAwsNodePoolsPage(null, null);
        }

        protected ListAwsNodePoolsPage createPage(PageContext<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse, AwsNodePool> context, ListAwsNodePoolsResponse response) {
            return new ListAwsNodePoolsPage(context, response);
        }

        public ApiFuture<ListAwsNodePoolsPage> createPageAsync(PageContext<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse, AwsNodePool> context, ApiFuture<ListAwsNodePoolsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAwsNodePoolsPagedResponse
    extends AbstractPagedListResponse<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse, AwsNodePool, ListAwsNodePoolsPage, ListAwsNodePoolsFixedSizeCollection> {
        public static ApiFuture<ListAwsNodePoolsPagedResponse> createAsync(PageContext<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse, AwsNodePool> context, ApiFuture<ListAwsNodePoolsResponse> futureResponse) {
            ApiFuture<ListAwsNodePoolsPage> futurePage = ListAwsNodePoolsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAwsNodePoolsPagedResponse((ListAwsNodePoolsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAwsNodePoolsPagedResponse(ListAwsNodePoolsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAwsNodePoolsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAwsClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAwsClustersRequest, ListAwsClustersResponse, AwsCluster, ListAwsClustersPage, ListAwsClustersFixedSizeCollection> {
        private ListAwsClustersFixedSizeCollection(List<ListAwsClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAwsClustersFixedSizeCollection createEmptyCollection() {
            return new ListAwsClustersFixedSizeCollection(null, 0);
        }

        protected ListAwsClustersFixedSizeCollection createCollection(List<ListAwsClustersPage> pages, int collectionSize) {
            return new ListAwsClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAwsClustersPage
    extends AbstractPage<ListAwsClustersRequest, ListAwsClustersResponse, AwsCluster, ListAwsClustersPage> {
        private ListAwsClustersPage(PageContext<ListAwsClustersRequest, ListAwsClustersResponse, AwsCluster> context, ListAwsClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListAwsClustersPage createEmptyPage() {
            return new ListAwsClustersPage(null, null);
        }

        protected ListAwsClustersPage createPage(PageContext<ListAwsClustersRequest, ListAwsClustersResponse, AwsCluster> context, ListAwsClustersResponse response) {
            return new ListAwsClustersPage(context, response);
        }

        public ApiFuture<ListAwsClustersPage> createPageAsync(PageContext<ListAwsClustersRequest, ListAwsClustersResponse, AwsCluster> context, ApiFuture<ListAwsClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAwsClustersPagedResponse
    extends AbstractPagedListResponse<ListAwsClustersRequest, ListAwsClustersResponse, AwsCluster, ListAwsClustersPage, ListAwsClustersFixedSizeCollection> {
        public static ApiFuture<ListAwsClustersPagedResponse> createAsync(PageContext<ListAwsClustersRequest, ListAwsClustersResponse, AwsCluster> context, ApiFuture<ListAwsClustersResponse> futureResponse) {
            ApiFuture<ListAwsClustersPage> futurePage = ListAwsClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAwsClustersPagedResponse((ListAwsClustersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAwsClustersPagedResponse(ListAwsClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAwsClustersFixedSizeCollection.createEmptyCollection());
        }
    }
}

