/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkebackup.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkebackup.v1.Backup;
import com.google.cloud.gkebackup.v1.BackupForGKEClient;
import com.google.cloud.gkebackup.v1.BackupPlan;
import com.google.cloud.gkebackup.v1.CreateBackupPlanRequest;
import com.google.cloud.gkebackup.v1.CreateBackupRequest;
import com.google.cloud.gkebackup.v1.CreateRestorePlanRequest;
import com.google.cloud.gkebackup.v1.CreateRestoreRequest;
import com.google.cloud.gkebackup.v1.DeleteBackupPlanRequest;
import com.google.cloud.gkebackup.v1.DeleteBackupRequest;
import com.google.cloud.gkebackup.v1.DeleteRestorePlanRequest;
import com.google.cloud.gkebackup.v1.DeleteRestoreRequest;
import com.google.cloud.gkebackup.v1.GetBackupIndexDownloadUrlRequest;
import com.google.cloud.gkebackup.v1.GetBackupIndexDownloadUrlResponse;
import com.google.cloud.gkebackup.v1.GetBackupPlanRequest;
import com.google.cloud.gkebackup.v1.GetBackupRequest;
import com.google.cloud.gkebackup.v1.GetRestorePlanRequest;
import com.google.cloud.gkebackup.v1.GetRestoreRequest;
import com.google.cloud.gkebackup.v1.GetVolumeBackupRequest;
import com.google.cloud.gkebackup.v1.GetVolumeRestoreRequest;
import com.google.cloud.gkebackup.v1.ListBackupPlansRequest;
import com.google.cloud.gkebackup.v1.ListBackupPlansResponse;
import com.google.cloud.gkebackup.v1.ListBackupsRequest;
import com.google.cloud.gkebackup.v1.ListBackupsResponse;
import com.google.cloud.gkebackup.v1.ListRestorePlansRequest;
import com.google.cloud.gkebackup.v1.ListRestorePlansResponse;
import com.google.cloud.gkebackup.v1.ListRestoresRequest;
import com.google.cloud.gkebackup.v1.ListRestoresResponse;
import com.google.cloud.gkebackup.v1.ListVolumeBackupsRequest;
import com.google.cloud.gkebackup.v1.ListVolumeBackupsResponse;
import com.google.cloud.gkebackup.v1.ListVolumeRestoresRequest;
import com.google.cloud.gkebackup.v1.ListVolumeRestoresResponse;
import com.google.cloud.gkebackup.v1.OperationMetadata;
import com.google.cloud.gkebackup.v1.Restore;
import com.google.cloud.gkebackup.v1.RestorePlan;
import com.google.cloud.gkebackup.v1.UpdateBackupPlanRequest;
import com.google.cloud.gkebackup.v1.UpdateBackupRequest;
import com.google.cloud.gkebackup.v1.UpdateRestorePlanRequest;
import com.google.cloud.gkebackup.v1.UpdateRestoreRequest;
import com.google.cloud.gkebackup.v1.VolumeBackup;
import com.google.cloud.gkebackup.v1.VolumeRestore;
import com.google.cloud.gkebackup.v1.stub.BackupForGKEStub;
import com.google.cloud.gkebackup.v1.stub.GrpcBackupForGKEStub;
import com.google.cloud.gkebackup.v1.stub.HttpJsonBackupForGKEStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class BackupForGKEStubSettings
extends StubSettings<BackupForGKEStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateBackupPlanRequest, Operation> createBackupPlanSettings;
    private final OperationCallSettings<CreateBackupPlanRequest, BackupPlan, OperationMetadata> createBackupPlanOperationSettings;
    private final PagedCallSettings<ListBackupPlansRequest, ListBackupPlansResponse, BackupForGKEClient.ListBackupPlansPagedResponse> listBackupPlansSettings;
    private final UnaryCallSettings<GetBackupPlanRequest, BackupPlan> getBackupPlanSettings;
    private final UnaryCallSettings<UpdateBackupPlanRequest, Operation> updateBackupPlanSettings;
    private final OperationCallSettings<UpdateBackupPlanRequest, BackupPlan, OperationMetadata> updateBackupPlanOperationSettings;
    private final UnaryCallSettings<DeleteBackupPlanRequest, Operation> deleteBackupPlanSettings;
    private final OperationCallSettings<DeleteBackupPlanRequest, Empty, OperationMetadata> deleteBackupPlanOperationSettings;
    private final UnaryCallSettings<CreateBackupRequest, Operation> createBackupSettings;
    private final OperationCallSettings<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationSettings;
    private final PagedCallSettings<ListBackupsRequest, ListBackupsResponse, BackupForGKEClient.ListBackupsPagedResponse> listBackupsSettings;
    private final UnaryCallSettings<GetBackupRequest, Backup> getBackupSettings;
    private final UnaryCallSettings<UpdateBackupRequest, Operation> updateBackupSettings;
    private final OperationCallSettings<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationSettings;
    private final UnaryCallSettings<DeleteBackupRequest, Operation> deleteBackupSettings;
    private final OperationCallSettings<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationSettings;
    private final PagedCallSettings<ListVolumeBackupsRequest, ListVolumeBackupsResponse, BackupForGKEClient.ListVolumeBackupsPagedResponse> listVolumeBackupsSettings;
    private final UnaryCallSettings<GetVolumeBackupRequest, VolumeBackup> getVolumeBackupSettings;
    private final UnaryCallSettings<CreateRestorePlanRequest, Operation> createRestorePlanSettings;
    private final OperationCallSettings<CreateRestorePlanRequest, RestorePlan, OperationMetadata> createRestorePlanOperationSettings;
    private final PagedCallSettings<ListRestorePlansRequest, ListRestorePlansResponse, BackupForGKEClient.ListRestorePlansPagedResponse> listRestorePlansSettings;
    private final UnaryCallSettings<GetRestorePlanRequest, RestorePlan> getRestorePlanSettings;
    private final UnaryCallSettings<UpdateRestorePlanRequest, Operation> updateRestorePlanSettings;
    private final OperationCallSettings<UpdateRestorePlanRequest, RestorePlan, OperationMetadata> updateRestorePlanOperationSettings;
    private final UnaryCallSettings<DeleteRestorePlanRequest, Operation> deleteRestorePlanSettings;
    private final OperationCallSettings<DeleteRestorePlanRequest, Empty, OperationMetadata> deleteRestorePlanOperationSettings;
    private final UnaryCallSettings<CreateRestoreRequest, Operation> createRestoreSettings;
    private final OperationCallSettings<CreateRestoreRequest, Restore, OperationMetadata> createRestoreOperationSettings;
    private final PagedCallSettings<ListRestoresRequest, ListRestoresResponse, BackupForGKEClient.ListRestoresPagedResponse> listRestoresSettings;
    private final UnaryCallSettings<GetRestoreRequest, Restore> getRestoreSettings;
    private final UnaryCallSettings<UpdateRestoreRequest, Operation> updateRestoreSettings;
    private final OperationCallSettings<UpdateRestoreRequest, Restore, OperationMetadata> updateRestoreOperationSettings;
    private final UnaryCallSettings<DeleteRestoreRequest, Operation> deleteRestoreSettings;
    private final OperationCallSettings<DeleteRestoreRequest, Empty, OperationMetadata> deleteRestoreOperationSettings;
    private final PagedCallSettings<ListVolumeRestoresRequest, ListVolumeRestoresResponse, BackupForGKEClient.ListVolumeRestoresPagedResponse> listVolumeRestoresSettings;
    private final UnaryCallSettings<GetVolumeRestoreRequest, VolumeRestore> getVolumeRestoreSettings;
    private final UnaryCallSettings<GetBackupIndexDownloadUrlRequest, GetBackupIndexDownloadUrlResponse> getBackupIndexDownloadUrlSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, BackupForGKEClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan> LIST_BACKUP_PLANS_PAGE_STR_DESC = new PagedListDescriptor<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan>(){

        public String emptyToken() {
            return "";
        }

        public ListBackupPlansRequest injectToken(ListBackupPlansRequest payload, String token) {
            return ListBackupPlansRequest.newBuilder((ListBackupPlansRequest)payload).setPageToken(token).build();
        }

        public ListBackupPlansRequest injectPageSize(ListBackupPlansRequest payload, int pageSize) {
            return ListBackupPlansRequest.newBuilder((ListBackupPlansRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBackupPlansRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBackupPlansResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BackupPlan> extractResources(ListBackupPlansResponse payload) {
            return payload.getBackupPlansList();
        }
    };
    private static final PagedListDescriptor<ListBackupsRequest, ListBackupsResponse, Backup> LIST_BACKUPS_PAGE_STR_DESC = new PagedListDescriptor<ListBackupsRequest, ListBackupsResponse, Backup>(){

        public String emptyToken() {
            return "";
        }

        public ListBackupsRequest injectToken(ListBackupsRequest payload, String token) {
            return ListBackupsRequest.newBuilder((ListBackupsRequest)payload).setPageToken(token).build();
        }

        public ListBackupsRequest injectPageSize(ListBackupsRequest payload, int pageSize) {
            return ListBackupsRequest.newBuilder((ListBackupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBackupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBackupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Backup> extractResources(ListBackupsResponse payload) {
            return payload.getBackupsList();
        }
    };
    private static final PagedListDescriptor<ListVolumeBackupsRequest, ListVolumeBackupsResponse, VolumeBackup> LIST_VOLUME_BACKUPS_PAGE_STR_DESC = new PagedListDescriptor<ListVolumeBackupsRequest, ListVolumeBackupsResponse, VolumeBackup>(){

        public String emptyToken() {
            return "";
        }

        public ListVolumeBackupsRequest injectToken(ListVolumeBackupsRequest payload, String token) {
            return ListVolumeBackupsRequest.newBuilder((ListVolumeBackupsRequest)payload).setPageToken(token).build();
        }

        public ListVolumeBackupsRequest injectPageSize(ListVolumeBackupsRequest payload, int pageSize) {
            return ListVolumeBackupsRequest.newBuilder((ListVolumeBackupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListVolumeBackupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListVolumeBackupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<VolumeBackup> extractResources(ListVolumeBackupsResponse payload) {
            return payload.getVolumeBackupsList();
        }
    };
    private static final PagedListDescriptor<ListRestorePlansRequest, ListRestorePlansResponse, RestorePlan> LIST_RESTORE_PLANS_PAGE_STR_DESC = new PagedListDescriptor<ListRestorePlansRequest, ListRestorePlansResponse, RestorePlan>(){

        public String emptyToken() {
            return "";
        }

        public ListRestorePlansRequest injectToken(ListRestorePlansRequest payload, String token) {
            return ListRestorePlansRequest.newBuilder((ListRestorePlansRequest)payload).setPageToken(token).build();
        }

        public ListRestorePlansRequest injectPageSize(ListRestorePlansRequest payload, int pageSize) {
            return ListRestorePlansRequest.newBuilder((ListRestorePlansRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRestorePlansRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRestorePlansResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<RestorePlan> extractResources(ListRestorePlansResponse payload) {
            return payload.getRestorePlansList();
        }
    };
    private static final PagedListDescriptor<ListRestoresRequest, ListRestoresResponse, Restore> LIST_RESTORES_PAGE_STR_DESC = new PagedListDescriptor<ListRestoresRequest, ListRestoresResponse, Restore>(){

        public String emptyToken() {
            return "";
        }

        public ListRestoresRequest injectToken(ListRestoresRequest payload, String token) {
            return ListRestoresRequest.newBuilder((ListRestoresRequest)payload).setPageToken(token).build();
        }

        public ListRestoresRequest injectPageSize(ListRestoresRequest payload, int pageSize) {
            return ListRestoresRequest.newBuilder((ListRestoresRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRestoresRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRestoresResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Restore> extractResources(ListRestoresResponse payload) {
            return payload.getRestoresList();
        }
    };
    private static final PagedListDescriptor<ListVolumeRestoresRequest, ListVolumeRestoresResponse, VolumeRestore> LIST_VOLUME_RESTORES_PAGE_STR_DESC = new PagedListDescriptor<ListVolumeRestoresRequest, ListVolumeRestoresResponse, VolumeRestore>(){

        public String emptyToken() {
            return "";
        }

        public ListVolumeRestoresRequest injectToken(ListVolumeRestoresRequest payload, String token) {
            return ListVolumeRestoresRequest.newBuilder((ListVolumeRestoresRequest)payload).setPageToken(token).build();
        }

        public ListVolumeRestoresRequest injectPageSize(ListVolumeRestoresRequest payload, int pageSize) {
            return ListVolumeRestoresRequest.newBuilder((ListVolumeRestoresRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListVolumeRestoresRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListVolumeRestoresResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<VolumeRestore> extractResources(ListVolumeRestoresResponse payload) {
            return payload.getVolumeRestoresList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListBackupPlansRequest, ListBackupPlansResponse, BackupForGKEClient.ListBackupPlansPagedResponse> LIST_BACKUP_PLANS_PAGE_STR_FACT = new PagedListResponseFactory<ListBackupPlansRequest, ListBackupPlansResponse, BackupForGKEClient.ListBackupPlansPagedResponse>(){

        public ApiFuture<BackupForGKEClient.ListBackupPlansPagedResponse> getFuturePagedResponse(UnaryCallable<ListBackupPlansRequest, ListBackupPlansResponse> callable, ListBackupPlansRequest request, ApiCallContext context, ApiFuture<ListBackupPlansResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BACKUP_PLANS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackupForGKEClient.ListBackupPlansPagedResponse.createAsync((PageContext<ListBackupPlansRequest, ListBackupPlansResponse, BackupPlan>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListBackupsRequest, ListBackupsResponse, BackupForGKEClient.ListBackupsPagedResponse> LIST_BACKUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListBackupsRequest, ListBackupsResponse, BackupForGKEClient.ListBackupsPagedResponse>(){

        public ApiFuture<BackupForGKEClient.ListBackupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBackupsRequest, ListBackupsResponse> callable, ListBackupsRequest request, ApiCallContext context, ApiFuture<ListBackupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BACKUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackupForGKEClient.ListBackupsPagedResponse.createAsync((PageContext<ListBackupsRequest, ListBackupsResponse, Backup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListVolumeBackupsRequest, ListVolumeBackupsResponse, BackupForGKEClient.ListVolumeBackupsPagedResponse> LIST_VOLUME_BACKUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListVolumeBackupsRequest, ListVolumeBackupsResponse, BackupForGKEClient.ListVolumeBackupsPagedResponse>(){

        public ApiFuture<BackupForGKEClient.ListVolumeBackupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListVolumeBackupsRequest, ListVolumeBackupsResponse> callable, ListVolumeBackupsRequest request, ApiCallContext context, ApiFuture<ListVolumeBackupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_VOLUME_BACKUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackupForGKEClient.ListVolumeBackupsPagedResponse.createAsync((PageContext<ListVolumeBackupsRequest, ListVolumeBackupsResponse, VolumeBackup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRestorePlansRequest, ListRestorePlansResponse, BackupForGKEClient.ListRestorePlansPagedResponse> LIST_RESTORE_PLANS_PAGE_STR_FACT = new PagedListResponseFactory<ListRestorePlansRequest, ListRestorePlansResponse, BackupForGKEClient.ListRestorePlansPagedResponse>(){

        public ApiFuture<BackupForGKEClient.ListRestorePlansPagedResponse> getFuturePagedResponse(UnaryCallable<ListRestorePlansRequest, ListRestorePlansResponse> callable, ListRestorePlansRequest request, ApiCallContext context, ApiFuture<ListRestorePlansResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RESTORE_PLANS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackupForGKEClient.ListRestorePlansPagedResponse.createAsync((PageContext<ListRestorePlansRequest, ListRestorePlansResponse, RestorePlan>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRestoresRequest, ListRestoresResponse, BackupForGKEClient.ListRestoresPagedResponse> LIST_RESTORES_PAGE_STR_FACT = new PagedListResponseFactory<ListRestoresRequest, ListRestoresResponse, BackupForGKEClient.ListRestoresPagedResponse>(){

        public ApiFuture<BackupForGKEClient.ListRestoresPagedResponse> getFuturePagedResponse(UnaryCallable<ListRestoresRequest, ListRestoresResponse> callable, ListRestoresRequest request, ApiCallContext context, ApiFuture<ListRestoresResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RESTORES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackupForGKEClient.ListRestoresPagedResponse.createAsync((PageContext<ListRestoresRequest, ListRestoresResponse, Restore>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListVolumeRestoresRequest, ListVolumeRestoresResponse, BackupForGKEClient.ListVolumeRestoresPagedResponse> LIST_VOLUME_RESTORES_PAGE_STR_FACT = new PagedListResponseFactory<ListVolumeRestoresRequest, ListVolumeRestoresResponse, BackupForGKEClient.ListVolumeRestoresPagedResponse>(){

        public ApiFuture<BackupForGKEClient.ListVolumeRestoresPagedResponse> getFuturePagedResponse(UnaryCallable<ListVolumeRestoresRequest, ListVolumeRestoresResponse> callable, ListVolumeRestoresRequest request, ApiCallContext context, ApiFuture<ListVolumeRestoresResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_VOLUME_RESTORES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackupForGKEClient.ListVolumeRestoresPagedResponse.createAsync((PageContext<ListVolumeRestoresRequest, ListVolumeRestoresResponse, VolumeRestore>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, BackupForGKEClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, BackupForGKEClient.ListLocationsPagedResponse>(){

        public ApiFuture<BackupForGKEClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackupForGKEClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateBackupPlanRequest, Operation> createBackupPlanSettings() {
        return this.createBackupPlanSettings;
    }

    public OperationCallSettings<CreateBackupPlanRequest, BackupPlan, OperationMetadata> createBackupPlanOperationSettings() {
        return this.createBackupPlanOperationSettings;
    }

    public PagedCallSettings<ListBackupPlansRequest, ListBackupPlansResponse, BackupForGKEClient.ListBackupPlansPagedResponse> listBackupPlansSettings() {
        return this.listBackupPlansSettings;
    }

    public UnaryCallSettings<GetBackupPlanRequest, BackupPlan> getBackupPlanSettings() {
        return this.getBackupPlanSettings;
    }

    public UnaryCallSettings<UpdateBackupPlanRequest, Operation> updateBackupPlanSettings() {
        return this.updateBackupPlanSettings;
    }

    public OperationCallSettings<UpdateBackupPlanRequest, BackupPlan, OperationMetadata> updateBackupPlanOperationSettings() {
        return this.updateBackupPlanOperationSettings;
    }

    public UnaryCallSettings<DeleteBackupPlanRequest, Operation> deleteBackupPlanSettings() {
        return this.deleteBackupPlanSettings;
    }

    public OperationCallSettings<DeleteBackupPlanRequest, Empty, OperationMetadata> deleteBackupPlanOperationSettings() {
        return this.deleteBackupPlanOperationSettings;
    }

    public UnaryCallSettings<CreateBackupRequest, Operation> createBackupSettings() {
        return this.createBackupSettings;
    }

    public OperationCallSettings<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationSettings() {
        return this.createBackupOperationSettings;
    }

    public PagedCallSettings<ListBackupsRequest, ListBackupsResponse, BackupForGKEClient.ListBackupsPagedResponse> listBackupsSettings() {
        return this.listBackupsSettings;
    }

    public UnaryCallSettings<GetBackupRequest, Backup> getBackupSettings() {
        return this.getBackupSettings;
    }

    public UnaryCallSettings<UpdateBackupRequest, Operation> updateBackupSettings() {
        return this.updateBackupSettings;
    }

    public OperationCallSettings<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationSettings() {
        return this.updateBackupOperationSettings;
    }

    public UnaryCallSettings<DeleteBackupRequest, Operation> deleteBackupSettings() {
        return this.deleteBackupSettings;
    }

    public OperationCallSettings<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationSettings() {
        return this.deleteBackupOperationSettings;
    }

    public PagedCallSettings<ListVolumeBackupsRequest, ListVolumeBackupsResponse, BackupForGKEClient.ListVolumeBackupsPagedResponse> listVolumeBackupsSettings() {
        return this.listVolumeBackupsSettings;
    }

    public UnaryCallSettings<GetVolumeBackupRequest, VolumeBackup> getVolumeBackupSettings() {
        return this.getVolumeBackupSettings;
    }

    public UnaryCallSettings<CreateRestorePlanRequest, Operation> createRestorePlanSettings() {
        return this.createRestorePlanSettings;
    }

    public OperationCallSettings<CreateRestorePlanRequest, RestorePlan, OperationMetadata> createRestorePlanOperationSettings() {
        return this.createRestorePlanOperationSettings;
    }

    public PagedCallSettings<ListRestorePlansRequest, ListRestorePlansResponse, BackupForGKEClient.ListRestorePlansPagedResponse> listRestorePlansSettings() {
        return this.listRestorePlansSettings;
    }

    public UnaryCallSettings<GetRestorePlanRequest, RestorePlan> getRestorePlanSettings() {
        return this.getRestorePlanSettings;
    }

    public UnaryCallSettings<UpdateRestorePlanRequest, Operation> updateRestorePlanSettings() {
        return this.updateRestorePlanSettings;
    }

    public OperationCallSettings<UpdateRestorePlanRequest, RestorePlan, OperationMetadata> updateRestorePlanOperationSettings() {
        return this.updateRestorePlanOperationSettings;
    }

    public UnaryCallSettings<DeleteRestorePlanRequest, Operation> deleteRestorePlanSettings() {
        return this.deleteRestorePlanSettings;
    }

    public OperationCallSettings<DeleteRestorePlanRequest, Empty, OperationMetadata> deleteRestorePlanOperationSettings() {
        return this.deleteRestorePlanOperationSettings;
    }

    public UnaryCallSettings<CreateRestoreRequest, Operation> createRestoreSettings() {
        return this.createRestoreSettings;
    }

    public OperationCallSettings<CreateRestoreRequest, Restore, OperationMetadata> createRestoreOperationSettings() {
        return this.createRestoreOperationSettings;
    }

    public PagedCallSettings<ListRestoresRequest, ListRestoresResponse, BackupForGKEClient.ListRestoresPagedResponse> listRestoresSettings() {
        return this.listRestoresSettings;
    }

    public UnaryCallSettings<GetRestoreRequest, Restore> getRestoreSettings() {
        return this.getRestoreSettings;
    }

    public UnaryCallSettings<UpdateRestoreRequest, Operation> updateRestoreSettings() {
        return this.updateRestoreSettings;
    }

    public OperationCallSettings<UpdateRestoreRequest, Restore, OperationMetadata> updateRestoreOperationSettings() {
        return this.updateRestoreOperationSettings;
    }

    public UnaryCallSettings<DeleteRestoreRequest, Operation> deleteRestoreSettings() {
        return this.deleteRestoreSettings;
    }

    public OperationCallSettings<DeleteRestoreRequest, Empty, OperationMetadata> deleteRestoreOperationSettings() {
        return this.deleteRestoreOperationSettings;
    }

    public PagedCallSettings<ListVolumeRestoresRequest, ListVolumeRestoresResponse, BackupForGKEClient.ListVolumeRestoresPagedResponse> listVolumeRestoresSettings() {
        return this.listVolumeRestoresSettings;
    }

    public UnaryCallSettings<GetVolumeRestoreRequest, VolumeRestore> getVolumeRestoreSettings() {
        return this.getVolumeRestoreSettings;
    }

    public UnaryCallSettings<GetBackupIndexDownloadUrlRequest, GetBackupIndexDownloadUrlResponse> getBackupIndexDownloadUrlSettings() {
        return this.getBackupIndexDownloadUrlSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, BackupForGKEClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public BackupForGKEStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBackupForGKEStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonBackupForGKEStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "gkebackup";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "gkebackup.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "gkebackup.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BackupForGKEStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BackupForGKEStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BackupForGKEStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return BackupForGKEStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BackupForGKEStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createBackupPlanSettings = settingsBuilder.createBackupPlanSettings().build();
        this.createBackupPlanOperationSettings = settingsBuilder.createBackupPlanOperationSettings().build();
        this.listBackupPlansSettings = settingsBuilder.listBackupPlansSettings().build();
        this.getBackupPlanSettings = settingsBuilder.getBackupPlanSettings().build();
        this.updateBackupPlanSettings = settingsBuilder.updateBackupPlanSettings().build();
        this.updateBackupPlanOperationSettings = settingsBuilder.updateBackupPlanOperationSettings().build();
        this.deleteBackupPlanSettings = settingsBuilder.deleteBackupPlanSettings().build();
        this.deleteBackupPlanOperationSettings = settingsBuilder.deleteBackupPlanOperationSettings().build();
        this.createBackupSettings = settingsBuilder.createBackupSettings().build();
        this.createBackupOperationSettings = settingsBuilder.createBackupOperationSettings().build();
        this.listBackupsSettings = settingsBuilder.listBackupsSettings().build();
        this.getBackupSettings = settingsBuilder.getBackupSettings().build();
        this.updateBackupSettings = settingsBuilder.updateBackupSettings().build();
        this.updateBackupOperationSettings = settingsBuilder.updateBackupOperationSettings().build();
        this.deleteBackupSettings = settingsBuilder.deleteBackupSettings().build();
        this.deleteBackupOperationSettings = settingsBuilder.deleteBackupOperationSettings().build();
        this.listVolumeBackupsSettings = settingsBuilder.listVolumeBackupsSettings().build();
        this.getVolumeBackupSettings = settingsBuilder.getVolumeBackupSettings().build();
        this.createRestorePlanSettings = settingsBuilder.createRestorePlanSettings().build();
        this.createRestorePlanOperationSettings = settingsBuilder.createRestorePlanOperationSettings().build();
        this.listRestorePlansSettings = settingsBuilder.listRestorePlansSettings().build();
        this.getRestorePlanSettings = settingsBuilder.getRestorePlanSettings().build();
        this.updateRestorePlanSettings = settingsBuilder.updateRestorePlanSettings().build();
        this.updateRestorePlanOperationSettings = settingsBuilder.updateRestorePlanOperationSettings().build();
        this.deleteRestorePlanSettings = settingsBuilder.deleteRestorePlanSettings().build();
        this.deleteRestorePlanOperationSettings = settingsBuilder.deleteRestorePlanOperationSettings().build();
        this.createRestoreSettings = settingsBuilder.createRestoreSettings().build();
        this.createRestoreOperationSettings = settingsBuilder.createRestoreOperationSettings().build();
        this.listRestoresSettings = settingsBuilder.listRestoresSettings().build();
        this.getRestoreSettings = settingsBuilder.getRestoreSettings().build();
        this.updateRestoreSettings = settingsBuilder.updateRestoreSettings().build();
        this.updateRestoreOperationSettings = settingsBuilder.updateRestoreOperationSettings().build();
        this.deleteRestoreSettings = settingsBuilder.deleteRestoreSettings().build();
        this.deleteRestoreOperationSettings = settingsBuilder.deleteRestoreOperationSettings().build();
        this.listVolumeRestoresSettings = settingsBuilder.listVolumeRestoresSettings().build();
        this.getVolumeRestoreSettings = settingsBuilder.getVolumeRestoreSettings().build();
        this.getBackupIndexDownloadUrlSettings = settingsBuilder.getBackupIndexDownloadUrlSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BackupForGKEStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateBackupPlanRequest, Operation> createBackupPlanSettings;
        private final OperationCallSettings.Builder<CreateBackupPlanRequest, BackupPlan, OperationMetadata> createBackupPlanOperationSettings;
        private final PagedCallSettings.Builder<ListBackupPlansRequest, ListBackupPlansResponse, BackupForGKEClient.ListBackupPlansPagedResponse> listBackupPlansSettings;
        private final UnaryCallSettings.Builder<GetBackupPlanRequest, BackupPlan> getBackupPlanSettings;
        private final UnaryCallSettings.Builder<UpdateBackupPlanRequest, Operation> updateBackupPlanSettings;
        private final OperationCallSettings.Builder<UpdateBackupPlanRequest, BackupPlan, OperationMetadata> updateBackupPlanOperationSettings;
        private final UnaryCallSettings.Builder<DeleteBackupPlanRequest, Operation> deleteBackupPlanSettings;
        private final OperationCallSettings.Builder<DeleteBackupPlanRequest, Empty, OperationMetadata> deleteBackupPlanOperationSettings;
        private final UnaryCallSettings.Builder<CreateBackupRequest, Operation> createBackupSettings;
        private final OperationCallSettings.Builder<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationSettings;
        private final PagedCallSettings.Builder<ListBackupsRequest, ListBackupsResponse, BackupForGKEClient.ListBackupsPagedResponse> listBackupsSettings;
        private final UnaryCallSettings.Builder<GetBackupRequest, Backup> getBackupSettings;
        private final UnaryCallSettings.Builder<UpdateBackupRequest, Operation> updateBackupSettings;
        private final OperationCallSettings.Builder<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationSettings;
        private final UnaryCallSettings.Builder<DeleteBackupRequest, Operation> deleteBackupSettings;
        private final OperationCallSettings.Builder<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationSettings;
        private final PagedCallSettings.Builder<ListVolumeBackupsRequest, ListVolumeBackupsResponse, BackupForGKEClient.ListVolumeBackupsPagedResponse> listVolumeBackupsSettings;
        private final UnaryCallSettings.Builder<GetVolumeBackupRequest, VolumeBackup> getVolumeBackupSettings;
        private final UnaryCallSettings.Builder<CreateRestorePlanRequest, Operation> createRestorePlanSettings;
        private final OperationCallSettings.Builder<CreateRestorePlanRequest, RestorePlan, OperationMetadata> createRestorePlanOperationSettings;
        private final PagedCallSettings.Builder<ListRestorePlansRequest, ListRestorePlansResponse, BackupForGKEClient.ListRestorePlansPagedResponse> listRestorePlansSettings;
        private final UnaryCallSettings.Builder<GetRestorePlanRequest, RestorePlan> getRestorePlanSettings;
        private final UnaryCallSettings.Builder<UpdateRestorePlanRequest, Operation> updateRestorePlanSettings;
        private final OperationCallSettings.Builder<UpdateRestorePlanRequest, RestorePlan, OperationMetadata> updateRestorePlanOperationSettings;
        private final UnaryCallSettings.Builder<DeleteRestorePlanRequest, Operation> deleteRestorePlanSettings;
        private final OperationCallSettings.Builder<DeleteRestorePlanRequest, Empty, OperationMetadata> deleteRestorePlanOperationSettings;
        private final UnaryCallSettings.Builder<CreateRestoreRequest, Operation> createRestoreSettings;
        private final OperationCallSettings.Builder<CreateRestoreRequest, Restore, OperationMetadata> createRestoreOperationSettings;
        private final PagedCallSettings.Builder<ListRestoresRequest, ListRestoresResponse, BackupForGKEClient.ListRestoresPagedResponse> listRestoresSettings;
        private final UnaryCallSettings.Builder<GetRestoreRequest, Restore> getRestoreSettings;
        private final UnaryCallSettings.Builder<UpdateRestoreRequest, Operation> updateRestoreSettings;
        private final OperationCallSettings.Builder<UpdateRestoreRequest, Restore, OperationMetadata> updateRestoreOperationSettings;
        private final UnaryCallSettings.Builder<DeleteRestoreRequest, Operation> deleteRestoreSettings;
        private final OperationCallSettings.Builder<DeleteRestoreRequest, Empty, OperationMetadata> deleteRestoreOperationSettings;
        private final PagedCallSettings.Builder<ListVolumeRestoresRequest, ListVolumeRestoresResponse, BackupForGKEClient.ListVolumeRestoresPagedResponse> listVolumeRestoresSettings;
        private final UnaryCallSettings.Builder<GetVolumeRestoreRequest, VolumeRestore> getVolumeRestoreSettings;
        private final UnaryCallSettings.Builder<GetBackupIndexDownloadUrlRequest, GetBackupIndexDownloadUrlResponse> getBackupIndexDownloadUrlSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, BackupForGKEClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createBackupPlanSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBackupPlanOperationSettings = OperationCallSettings.newBuilder();
            this.listBackupPlansSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BACKUP_PLANS_PAGE_STR_FACT);
            this.getBackupPlanSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBackupPlanSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBackupPlanOperationSettings = OperationCallSettings.newBuilder();
            this.deleteBackupPlanSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteBackupPlanOperationSettings = OperationCallSettings.newBuilder();
            this.createBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBackupOperationSettings = OperationCallSettings.newBuilder();
            this.listBackupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BACKUPS_PAGE_STR_FACT);
            this.getBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBackupOperationSettings = OperationCallSettings.newBuilder();
            this.deleteBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteBackupOperationSettings = OperationCallSettings.newBuilder();
            this.listVolumeBackupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_VOLUME_BACKUPS_PAGE_STR_FACT);
            this.getVolumeBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRestorePlanSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRestorePlanOperationSettings = OperationCallSettings.newBuilder();
            this.listRestorePlansSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RESTORE_PLANS_PAGE_STR_FACT);
            this.getRestorePlanSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRestorePlanSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRestorePlanOperationSettings = OperationCallSettings.newBuilder();
            this.deleteRestorePlanSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRestorePlanOperationSettings = OperationCallSettings.newBuilder();
            this.createRestoreSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRestoreOperationSettings = OperationCallSettings.newBuilder();
            this.listRestoresSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RESTORES_PAGE_STR_FACT);
            this.getRestoreSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRestoreSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRestoreOperationSettings = OperationCallSettings.newBuilder();
            this.deleteRestoreSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRestoreOperationSettings = OperationCallSettings.newBuilder();
            this.listVolumeRestoresSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_VOLUME_RESTORES_PAGE_STR_FACT);
            this.getVolumeRestoreSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getBackupIndexDownloadUrlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createBackupPlanSettings, this.listBackupPlansSettings, this.getBackupPlanSettings, this.updateBackupPlanSettings, this.deleteBackupPlanSettings, this.createBackupSettings, this.listBackupsSettings, this.getBackupSettings, this.updateBackupSettings, this.deleteBackupSettings, this.listVolumeBackupsSettings, this.getVolumeBackupSettings, (Object[])new UnaryCallSettings.Builder[]{this.createRestorePlanSettings, this.listRestorePlansSettings, this.getRestorePlanSettings, this.updateRestorePlanSettings, this.deleteRestorePlanSettings, this.createRestoreSettings, this.listRestoresSettings, this.getRestoreSettings, this.updateRestoreSettings, this.deleteRestoreSettings, this.listVolumeRestoresSettings, this.getVolumeRestoreSettings, this.getBackupIndexDownloadUrlSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(BackupForGKEStubSettings settings) {
            super((StubSettings)settings);
            this.createBackupPlanSettings = settings.createBackupPlanSettings.toBuilder();
            this.createBackupPlanOperationSettings = settings.createBackupPlanOperationSettings.toBuilder();
            this.listBackupPlansSettings = settings.listBackupPlansSettings.toBuilder();
            this.getBackupPlanSettings = settings.getBackupPlanSettings.toBuilder();
            this.updateBackupPlanSettings = settings.updateBackupPlanSettings.toBuilder();
            this.updateBackupPlanOperationSettings = settings.updateBackupPlanOperationSettings.toBuilder();
            this.deleteBackupPlanSettings = settings.deleteBackupPlanSettings.toBuilder();
            this.deleteBackupPlanOperationSettings = settings.deleteBackupPlanOperationSettings.toBuilder();
            this.createBackupSettings = settings.createBackupSettings.toBuilder();
            this.createBackupOperationSettings = settings.createBackupOperationSettings.toBuilder();
            this.listBackupsSettings = settings.listBackupsSettings.toBuilder();
            this.getBackupSettings = settings.getBackupSettings.toBuilder();
            this.updateBackupSettings = settings.updateBackupSettings.toBuilder();
            this.updateBackupOperationSettings = settings.updateBackupOperationSettings.toBuilder();
            this.deleteBackupSettings = settings.deleteBackupSettings.toBuilder();
            this.deleteBackupOperationSettings = settings.deleteBackupOperationSettings.toBuilder();
            this.listVolumeBackupsSettings = settings.listVolumeBackupsSettings.toBuilder();
            this.getVolumeBackupSettings = settings.getVolumeBackupSettings.toBuilder();
            this.createRestorePlanSettings = settings.createRestorePlanSettings.toBuilder();
            this.createRestorePlanOperationSettings = settings.createRestorePlanOperationSettings.toBuilder();
            this.listRestorePlansSettings = settings.listRestorePlansSettings.toBuilder();
            this.getRestorePlanSettings = settings.getRestorePlanSettings.toBuilder();
            this.updateRestorePlanSettings = settings.updateRestorePlanSettings.toBuilder();
            this.updateRestorePlanOperationSettings = settings.updateRestorePlanOperationSettings.toBuilder();
            this.deleteRestorePlanSettings = settings.deleteRestorePlanSettings.toBuilder();
            this.deleteRestorePlanOperationSettings = settings.deleteRestorePlanOperationSettings.toBuilder();
            this.createRestoreSettings = settings.createRestoreSettings.toBuilder();
            this.createRestoreOperationSettings = settings.createRestoreOperationSettings.toBuilder();
            this.listRestoresSettings = settings.listRestoresSettings.toBuilder();
            this.getRestoreSettings = settings.getRestoreSettings.toBuilder();
            this.updateRestoreSettings = settings.updateRestoreSettings.toBuilder();
            this.updateRestoreOperationSettings = settings.updateRestoreOperationSettings.toBuilder();
            this.deleteRestoreSettings = settings.deleteRestoreSettings.toBuilder();
            this.deleteRestoreOperationSettings = settings.deleteRestoreOperationSettings.toBuilder();
            this.listVolumeRestoresSettings = settings.listVolumeRestoresSettings.toBuilder();
            this.getVolumeRestoreSettings = settings.getVolumeRestoreSettings.toBuilder();
            this.getBackupIndexDownloadUrlSettings = settings.getBackupIndexDownloadUrlSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createBackupPlanSettings, this.listBackupPlansSettings, this.getBackupPlanSettings, this.updateBackupPlanSettings, this.deleteBackupPlanSettings, this.createBackupSettings, this.listBackupsSettings, this.getBackupSettings, this.updateBackupSettings, this.deleteBackupSettings, this.listVolumeBackupsSettings, this.getVolumeBackupSettings, (Object[])new UnaryCallSettings.Builder[]{this.createRestorePlanSettings, this.listRestorePlansSettings, this.getRestorePlanSettings, this.updateRestorePlanSettings, this.deleteRestorePlanSettings, this.createRestoreSettings, this.listRestoresSettings, this.getRestoreSettings, this.updateRestoreSettings, this.deleteRestoreSettings, this.listVolumeRestoresSettings, this.getVolumeRestoreSettings, this.getBackupIndexDownloadUrlSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BackupForGKEStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BackupForGKEStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BackupForGKEStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(BackupForGKEStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)BackupForGKEStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)BackupForGKEStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BackupForGKEStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(BackupForGKEStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createBackupPlanSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.listBackupPlansSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getBackupPlanSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateBackupPlanSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteBackupPlanSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.listBackupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.listVolumeBackupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getVolumeBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createRestorePlanSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.listRestorePlansSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRestorePlanSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateRestorePlanSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteRestorePlanSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createRestoreSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.listRestoresSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRestoreSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateRestoreSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteRestoreSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listVolumeRestoresSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getVolumeRestoreSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getBackupIndexDownloadUrlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createBackupPlanOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BackupPlan.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateBackupPlanOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BackupPlan.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteBackupPlanOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Backup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Backup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createRestorePlanOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(RestorePlan.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateRestorePlanOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(RestorePlan.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteRestorePlanOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createRestoreOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Restore.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateRestoreOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Restore.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteRestoreOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateBackupPlanRequest, Operation> createBackupPlanSettings() {
            return this.createBackupPlanSettings;
        }

        public OperationCallSettings.Builder<CreateBackupPlanRequest, BackupPlan, OperationMetadata> createBackupPlanOperationSettings() {
            return this.createBackupPlanOperationSettings;
        }

        public PagedCallSettings.Builder<ListBackupPlansRequest, ListBackupPlansResponse, BackupForGKEClient.ListBackupPlansPagedResponse> listBackupPlansSettings() {
            return this.listBackupPlansSettings;
        }

        public UnaryCallSettings.Builder<GetBackupPlanRequest, BackupPlan> getBackupPlanSettings() {
            return this.getBackupPlanSettings;
        }

        public UnaryCallSettings.Builder<UpdateBackupPlanRequest, Operation> updateBackupPlanSettings() {
            return this.updateBackupPlanSettings;
        }

        public OperationCallSettings.Builder<UpdateBackupPlanRequest, BackupPlan, OperationMetadata> updateBackupPlanOperationSettings() {
            return this.updateBackupPlanOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteBackupPlanRequest, Operation> deleteBackupPlanSettings() {
            return this.deleteBackupPlanSettings;
        }

        public OperationCallSettings.Builder<DeleteBackupPlanRequest, Empty, OperationMetadata> deleteBackupPlanOperationSettings() {
            return this.deleteBackupPlanOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateBackupRequest, Operation> createBackupSettings() {
            return this.createBackupSettings;
        }

        public OperationCallSettings.Builder<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationSettings() {
            return this.createBackupOperationSettings;
        }

        public PagedCallSettings.Builder<ListBackupsRequest, ListBackupsResponse, BackupForGKEClient.ListBackupsPagedResponse> listBackupsSettings() {
            return this.listBackupsSettings;
        }

        public UnaryCallSettings.Builder<GetBackupRequest, Backup> getBackupSettings() {
            return this.getBackupSettings;
        }

        public UnaryCallSettings.Builder<UpdateBackupRequest, Operation> updateBackupSettings() {
            return this.updateBackupSettings;
        }

        public OperationCallSettings.Builder<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationSettings() {
            return this.updateBackupOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteBackupRequest, Operation> deleteBackupSettings() {
            return this.deleteBackupSettings;
        }

        public OperationCallSettings.Builder<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationSettings() {
            return this.deleteBackupOperationSettings;
        }

        public PagedCallSettings.Builder<ListVolumeBackupsRequest, ListVolumeBackupsResponse, BackupForGKEClient.ListVolumeBackupsPagedResponse> listVolumeBackupsSettings() {
            return this.listVolumeBackupsSettings;
        }

        public UnaryCallSettings.Builder<GetVolumeBackupRequest, VolumeBackup> getVolumeBackupSettings() {
            return this.getVolumeBackupSettings;
        }

        public UnaryCallSettings.Builder<CreateRestorePlanRequest, Operation> createRestorePlanSettings() {
            return this.createRestorePlanSettings;
        }

        public OperationCallSettings.Builder<CreateRestorePlanRequest, RestorePlan, OperationMetadata> createRestorePlanOperationSettings() {
            return this.createRestorePlanOperationSettings;
        }

        public PagedCallSettings.Builder<ListRestorePlansRequest, ListRestorePlansResponse, BackupForGKEClient.ListRestorePlansPagedResponse> listRestorePlansSettings() {
            return this.listRestorePlansSettings;
        }

        public UnaryCallSettings.Builder<GetRestorePlanRequest, RestorePlan> getRestorePlanSettings() {
            return this.getRestorePlanSettings;
        }

        public UnaryCallSettings.Builder<UpdateRestorePlanRequest, Operation> updateRestorePlanSettings() {
            return this.updateRestorePlanSettings;
        }

        public OperationCallSettings.Builder<UpdateRestorePlanRequest, RestorePlan, OperationMetadata> updateRestorePlanOperationSettings() {
            return this.updateRestorePlanOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteRestorePlanRequest, Operation> deleteRestorePlanSettings() {
            return this.deleteRestorePlanSettings;
        }

        public OperationCallSettings.Builder<DeleteRestorePlanRequest, Empty, OperationMetadata> deleteRestorePlanOperationSettings() {
            return this.deleteRestorePlanOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateRestoreRequest, Operation> createRestoreSettings() {
            return this.createRestoreSettings;
        }

        public OperationCallSettings.Builder<CreateRestoreRequest, Restore, OperationMetadata> createRestoreOperationSettings() {
            return this.createRestoreOperationSettings;
        }

        public PagedCallSettings.Builder<ListRestoresRequest, ListRestoresResponse, BackupForGKEClient.ListRestoresPagedResponse> listRestoresSettings() {
            return this.listRestoresSettings;
        }

        public UnaryCallSettings.Builder<GetRestoreRequest, Restore> getRestoreSettings() {
            return this.getRestoreSettings;
        }

        public UnaryCallSettings.Builder<UpdateRestoreRequest, Operation> updateRestoreSettings() {
            return this.updateRestoreSettings;
        }

        public OperationCallSettings.Builder<UpdateRestoreRequest, Restore, OperationMetadata> updateRestoreOperationSettings() {
            return this.updateRestoreOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteRestoreRequest, Operation> deleteRestoreSettings() {
            return this.deleteRestoreSettings;
        }

        public OperationCallSettings.Builder<DeleteRestoreRequest, Empty, OperationMetadata> deleteRestoreOperationSettings() {
            return this.deleteRestoreOperationSettings;
        }

        public PagedCallSettings.Builder<ListVolumeRestoresRequest, ListVolumeRestoresResponse, BackupForGKEClient.ListVolumeRestoresPagedResponse> listVolumeRestoresSettings() {
            return this.listVolumeRestoresSettings;
        }

        public UnaryCallSettings.Builder<GetVolumeRestoreRequest, VolumeRestore> getVolumeRestoreSettings() {
            return this.getVolumeRestoreSettings;
        }

        public UnaryCallSettings.Builder<GetBackupIndexDownloadUrlRequest, GetBackupIndexDownloadUrlResponse> getBackupIndexDownloadUrlSettings() {
            return this.getBackupIndexDownloadUrlSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, BackupForGKEClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public BackupForGKEStubSettings build() throws IOException {
            return new BackupForGKEStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(300000L)).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build();
            definitions.put((Object)"no_retry_3_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(120000L)).setTotalTimeoutDuration(Duration.ofMillis(120000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

