/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.FieldPath;
import com.google.firestore.v1.StructuredQuery;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Filter {
    @Nonnull
    public static Filter equalTo(@Nonnull String field, @Nullable Object value) {
        return Filter.equalTo(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public static Filter equalTo(@Nonnull FieldPath fieldPath, @Nullable Object value) {
        return new UnaryFilter(fieldPath, StructuredQuery.FieldFilter.Operator.EQUAL, value);
    }

    @Nonnull
    public static Filter notEqualTo(@Nonnull String field, @Nullable Object value) {
        return Filter.notEqualTo(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public static Filter notEqualTo(@Nonnull FieldPath fieldPath, @Nullable Object value) {
        return new UnaryFilter(fieldPath, StructuredQuery.FieldFilter.Operator.NOT_EQUAL, value);
    }

    @Nonnull
    public static Filter greaterThan(@Nonnull String field, @Nullable Object value) {
        return Filter.greaterThan(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public static Filter greaterThan(@Nonnull FieldPath fieldPath, @Nullable Object value) {
        return new UnaryFilter(fieldPath, StructuredQuery.FieldFilter.Operator.GREATER_THAN, value);
    }

    @Nonnull
    public static Filter greaterThanOrEqualTo(@Nonnull String field, @Nullable Object value) {
        return Filter.greaterThanOrEqualTo(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public static Filter greaterThanOrEqualTo(@Nonnull FieldPath fieldPath, @Nullable Object value) {
        return new UnaryFilter(fieldPath, StructuredQuery.FieldFilter.Operator.GREATER_THAN_OR_EQUAL, value);
    }

    @Nonnull
    public static Filter lessThan(@Nonnull String field, @Nullable Object value) {
        return Filter.lessThan(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public static Filter lessThan(@Nonnull FieldPath fieldPath, @Nullable Object value) {
        return new UnaryFilter(fieldPath, StructuredQuery.FieldFilter.Operator.LESS_THAN, value);
    }

    @Nonnull
    public static Filter lessThanOrEqualTo(@Nonnull String field, @Nullable Object value) {
        return Filter.lessThanOrEqualTo(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public static Filter lessThanOrEqualTo(@Nonnull FieldPath fieldPath, @Nullable Object value) {
        return new UnaryFilter(fieldPath, StructuredQuery.FieldFilter.Operator.LESS_THAN_OR_EQUAL, value);
    }

    @Nonnull
    public static Filter arrayContains(@Nonnull String field, @Nullable Object value) {
        return Filter.arrayContains(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public static Filter arrayContains(@Nonnull FieldPath fieldPath, @Nullable Object value) {
        return new UnaryFilter(fieldPath, StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS, value);
    }

    @Nonnull
    public static Filter arrayContainsAny(@Nonnull String field, @Nullable Object value) {
        return Filter.arrayContainsAny(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public static Filter arrayContainsAny(@Nonnull FieldPath fieldPath, @Nullable Object value) {
        return new UnaryFilter(fieldPath, StructuredQuery.FieldFilter.Operator.ARRAY_CONTAINS_ANY, value);
    }

    @Nonnull
    public static Filter inArray(@Nonnull String field, @Nullable Object value) {
        return Filter.inArray(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public static Filter inArray(@Nonnull FieldPath fieldPath, @Nullable Object value) {
        return new UnaryFilter(fieldPath, StructuredQuery.FieldFilter.Operator.IN, value);
    }

    @Nonnull
    public static Filter notInArray(@Nonnull String field, @Nullable Object value) {
        return Filter.notInArray(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public static Filter notInArray(@Nonnull FieldPath fieldPath, @Nullable Object value) {
        return new UnaryFilter(fieldPath, StructuredQuery.FieldFilter.Operator.NOT_IN, value);
    }

    @Nonnull
    public static Filter or(Filter ... filters) {
        return new CompositeFilter(Arrays.asList(filters), StructuredQuery.CompositeFilter.Operator.OPERATOR_UNSPECIFIED);
    }

    @Nonnull
    public static Filter and(Filter ... filters) {
        return new CompositeFilter(Arrays.asList(filters), StructuredQuery.CompositeFilter.Operator.AND);
    }

    static class CompositeFilter
    extends Filter {
        private final List<Filter> filters;
        private final StructuredQuery.CompositeFilter.Operator operator;

        public CompositeFilter(@Nonnull List<Filter> filters, StructuredQuery.CompositeFilter.Operator operator) {
            this.filters = filters;
            this.operator = operator;
        }

        public List<Filter> getFilters() {
            return this.filters;
        }

        public StructuredQuery.CompositeFilter.Operator getOperator() {
            return this.operator;
        }
    }

    static class UnaryFilter
    extends Filter {
        private final FieldPath field;
        private final StructuredQuery.FieldFilter.Operator operator;
        private final Object value;

        public UnaryFilter(FieldPath field, StructuredQuery.FieldFilter.Operator operator, @Nullable Object value) {
            this.field = field;
            this.operator = operator;
            this.value = value;
        }

        public FieldPath getField() {
            return this.field;
        }

        public StructuredQuery.FieldFilter.Operator getOperator() {
            return this.operator;
        }

        @Nullable
        public Object getValue() {
            return this.value;
        }
    }
}

