/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.AggregateQuerySnapshot;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.Query;
import com.google.firestore.v1.RunAggregationQueryRequest;
import com.google.firestore.v1.RunAggregationQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.StructuredAggregationQuery;
import com.google.firestore.v1.Value;
import com.google.protobuf.ByteString;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalExtensionOnly
public class AggregateQuery {
    private static final String ALIAS_COUNT = "count";
    @Nonnull
    private final Query query;

    AggregateQuery(@Nonnull Query query) {
        this.query = query;
    }

    @Nonnull
    public Query getQuery() {
        return this.query;
    }

    @Nonnull
    public ApiFuture<AggregateQuerySnapshot> get() {
        return this.get(null);
    }

    @Nonnull
    ApiFuture<AggregateQuerySnapshot> get(@Nullable ByteString transactionId) {
        RunAggregationQueryRequest request = this.toProto(transactionId);
        AggregateQueryResponseObserver responseObserver = new AggregateQueryResponseObserver();
        ServerStreamingCallable<RunAggregationQueryRequest, RunAggregationQueryResponse> callable = this.query.rpcContext.getClient().runAggregationQueryCallable();
        this.query.rpcContext.streamRequest(request, responseObserver, callable);
        return responseObserver.getFuture();
    }

    @Nonnull
    public RunAggregationQueryRequest toProto() {
        return this.toProto(null);
    }

    @Nonnull
    RunAggregationQueryRequest toProto(@Nullable ByteString transactionId) {
        RunQueryRequest runQueryRequest = this.query.toProto();
        RunAggregationQueryRequest.Builder request = RunAggregationQueryRequest.newBuilder();
        request.setParent(runQueryRequest.getParent());
        if (transactionId != null) {
            request.setTransaction(transactionId);
        }
        StructuredAggregationQuery.Builder structuredAggregationQuery = request.getStructuredAggregationQueryBuilder();
        structuredAggregationQuery.setStructuredQuery(runQueryRequest.getStructuredQuery());
        StructuredAggregationQuery.Aggregation.Builder aggregation = StructuredAggregationQuery.Aggregation.newBuilder();
        aggregation.setCount(StructuredAggregationQuery.Aggregation.Count.getDefaultInstance());
        aggregation.setAlias(ALIAS_COUNT);
        structuredAggregationQuery.addAggregations(aggregation);
        return request.build();
    }

    @Nonnull
    public static AggregateQuery fromProto(Firestore firestore, RunAggregationQueryRequest proto) {
        RunQueryRequest runQueryRequest = RunQueryRequest.newBuilder().setParent(proto.getParent()).setStructuredQuery(proto.getStructuredAggregationQuery().getStructuredQuery()).build();
        Query query = Query.fromProto(firestore, runQueryRequest);
        return new AggregateQuery(query);
    }

    public int hashCode() {
        return this.query.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AggregateQuery)) {
            return false;
        }
        AggregateQuery other = (AggregateQuery)object;
        return this.query.equals(other.query);
    }

    private final class AggregateQueryResponseObserver
    implements ResponseObserver<RunAggregationQueryResponse> {
        private final SettableApiFuture<AggregateQuerySnapshot> future = SettableApiFuture.create();
        private final AtomicBoolean isFutureNotified = new AtomicBoolean(false);
        private StreamController streamController;

        private AggregateQueryResponseObserver() {
        }

        SettableApiFuture<AggregateQuerySnapshot> getFuture() {
            return this.future;
        }

        public void onStart(StreamController streamController) {
            this.streamController = streamController;
        }

        public void onResponse(RunAggregationQueryResponse response) {
            if (!this.isFutureNotified.compareAndSet(false, true)) {
                return;
            }
            Timestamp readTime = Timestamp.fromProto((com.google.protobuf.Timestamp)response.getReadTime());
            Value value = (Value)response.getResult().getAggregateFieldsMap().get(AggregateQuery.ALIAS_COUNT);
            if (value == null) {
                throw new IllegalArgumentException("RunAggregationQueryResponse is missing required alias: count");
            }
            if (value.getValueTypeCase() != Value.ValueTypeCase.INTEGER_VALUE) {
                throw new IllegalArgumentException("RunAggregationQueryResponse alias count has incorrect type: " + value.getValueTypeCase());
            }
            long count = value.getIntegerValue();
            this.future.set((Object)new AggregateQuerySnapshot(AggregateQuery.this, readTime, count));
            this.streamController.cancel();
        }

        public void onError(Throwable throwable) {
            if (!this.isFutureNotified.compareAndSet(false, true)) {
                return;
            }
            this.future.setException(throwable);
        }

        public void onComplete() {
        }
    }
}

