/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.AggregateField;
import com.google.cloud.firestore.AggregateQuerySnapshot;
import com.google.cloud.firestore.ExplainMetrics;
import com.google.cloud.firestore.ExplainOptions;
import com.google.cloud.firestore.ExplainResults;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.v1.FirestoreSettings;
import com.google.common.collect.ImmutableMap;
import com.google.firestore.v1.RunAggregationQueryRequest;
import com.google.firestore.v1.RunAggregationQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.StructuredAggregationQuery;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Value;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalExtensionOnly
public class AggregateQuery {
    @Nonnull
    private final Query query;
    @Nonnull
    private final List<AggregateField> aggregateFieldList;
    @Nonnull
    private final Map<String, String> aliasMap;

    AggregateQuery(@Nonnull Query query, @Nonnull List<AggregateField> aggregateFields) {
        this.query = query;
        this.aggregateFieldList = aggregateFields;
        this.aliasMap = new HashMap<String, String>();
    }

    @Nonnull
    public Query getQuery() {
        return this.query;
    }

    @Nonnull
    public ApiFuture<AggregateQuerySnapshot> get() {
        return this.get(null, null);
    }

    @Nonnull
    public ApiFuture<ExplainResults<AggregateQuerySnapshot>> explain(ExplainOptions options) {
        AggregateQueryExplainResponseDeliverer responseDeliverer = new AggregateQueryExplainResponseDeliverer(null, null, this.query.rpcContext.getClock().nanoTime(), options);
        this.runQuery(responseDeliverer);
        return responseDeliverer.getFuture();
    }

    @Nonnull
    ApiFuture<AggregateQuerySnapshot> get(@Nullable ByteString transactionId, @Nullable com.google.protobuf.Timestamp readTime) {
        AggregateQueryResponseDeliverer responseDeliverer = new AggregateQueryResponseDeliverer(transactionId, readTime, this.query.rpcContext.getClock().nanoTime());
        this.runQuery(responseDeliverer);
        return responseDeliverer.getFuture();
    }

    private <T> void runQuery(ResponseDeliverer<T> responseDeliverer) {
        RunAggregationQueryRequest request = this.toProto(responseDeliverer.getTransactionId(), responseDeliverer.getReadTime(), responseDeliverer.getExplainOptions());
        AggregateQueryResponseObserver<T> responseObserver = new AggregateQueryResponseObserver<T>(responseDeliverer);
        ServerStreamingCallable<RunAggregationQueryRequest, RunAggregationQueryResponse> callable = this.query.rpcContext.getClient().runAggregationQueryCallable();
        this.query.rpcContext.streamRequest(request, responseObserver, callable);
    }

    @Nonnull
    private Map<String, Value> convertServerAggregateFieldsMapToClientAggregateFieldsMap(@Nonnull Map<String, Value> data) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        data.forEach((serverAlias, value) -> builder.put((Object)this.aliasMap.get(serverAlias), value));
        return builder.build();
    }

    @Nonnull
    public RunAggregationQueryRequest toProto() {
        return this.toProto(null, null, null);
    }

    @Nonnull
    RunAggregationQueryRequest toProto(@Nullable ByteString transactionId, @Nullable com.google.protobuf.Timestamp readTime, @Nullable ExplainOptions explainOptions) {
        RunQueryRequest runQueryRequest = this.query.toProto();
        RunAggregationQueryRequest.Builder request = RunAggregationQueryRequest.newBuilder();
        request.setParent(runQueryRequest.getParent());
        if (transactionId != null) {
            request.setTransaction(transactionId);
        }
        if (readTime != null) {
            request.setReadTime(readTime);
        }
        if (explainOptions != null) {
            request.setExplainOptions(explainOptions.toProto());
        }
        StructuredAggregationQuery.Builder structuredAggregationQuery = request.getStructuredAggregationQueryBuilder();
        structuredAggregationQuery.setStructuredQuery(runQueryRequest.getStructuredQuery());
        HashSet<String> uniqueAggregates = new HashSet<String>();
        ArrayList<StructuredAggregationQuery.Aggregation> aggregations = new ArrayList<StructuredAggregationQuery.Aggregation>();
        int aggregationNum = 0;
        for (AggregateField aggregateField : this.aggregateFieldList) {
            boolean isNewAggregateField = uniqueAggregates.add(aggregateField.getAlias());
            if (!isNewAggregateField) continue;
            StructuredQuery.FieldReference field = null;
            if (!aggregateField.getFieldPath().isEmpty()) {
                field = StructuredQuery.FieldReference.newBuilder().setFieldPath(aggregateField.getFieldPath()).build();
            }
            StructuredAggregationQuery.Aggregation.Builder aggregation = StructuredAggregationQuery.Aggregation.newBuilder();
            if (aggregateField instanceof AggregateField.CountAggregateField) {
                aggregation.setCount(StructuredAggregationQuery.Aggregation.Count.getDefaultInstance());
            } else if (aggregateField instanceof AggregateField.SumAggregateField) {
                aggregation.setSum(StructuredAggregationQuery.Aggregation.Sum.newBuilder().setField(field).build());
            } else if (aggregateField instanceof AggregateField.AverageAggregateField) {
                aggregation.setAvg(StructuredAggregationQuery.Aggregation.Avg.newBuilder().setField(field).build());
            } else {
                throw new RuntimeException("Unsupported aggregation");
            }
            String serverAlias = "aggregate_" + aggregationNum++;
            this.aliasMap.put(serverAlias, aggregateField.getAlias());
            aggregation.setAlias(serverAlias);
            aggregations.add(aggregation.build());
        }
        structuredAggregationQuery.addAllAggregations(aggregations);
        return request.build();
    }

    @Nonnull
    public static AggregateQuery fromProto(Firestore firestore, RunAggregationQueryRequest proto) {
        RunQueryRequest runQueryRequest = RunQueryRequest.newBuilder().setParent(proto.getParent()).setStructuredQuery(proto.getStructuredAggregationQuery().getStructuredQuery()).build();
        Query query = Query.fromProto(firestore, runQueryRequest);
        ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
        List aggregations = proto.getStructuredAggregationQuery().getAggregationsList();
        aggregations.forEach(aggregation -> {
            if (aggregation.hasCount()) {
                aggregateFields.add(AggregateField.count());
            } else if (aggregation.hasAvg()) {
                aggregateFields.add(AggregateField.average(aggregation.getAvg().getField().getFieldPath()));
            } else if (aggregation.hasSum()) {
                aggregateFields.add(AggregateField.sum(aggregation.getSum().getField().getFieldPath()));
            } else {
                throw new RuntimeException("Unsupported aggregation.");
            }
        });
        return new AggregateQuery(query, aggregateFields);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.aggregateFieldList);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AggregateQuery)) {
            return false;
        }
        AggregateQuery other = (AggregateQuery)object;
        return this.query.equals(other.query) && this.aggregateFieldList.equals(other.aggregateFieldList);
    }

    private static abstract class ResponseDeliverer<T> {
        @Nullable
        private final ByteString transactionId;
        @Nullable
        private final com.google.protobuf.Timestamp readTime;
        private final long startTimeNanos;
        private final SettableApiFuture<T> future = SettableApiFuture.create();

        ResponseDeliverer(@Nullable ByteString transactionId, @Nullable com.google.protobuf.Timestamp readTime, long startTimeNanos) {
            this.transactionId = transactionId;
            this.readTime = readTime;
            this.startTimeNanos = startTimeNanos;
        }

        @Nullable
        ByteString getTransactionId() {
            return this.transactionId;
        }

        @Nullable
        com.google.protobuf.Timestamp getReadTime() {
            return this.readTime;
        }

        long getStartTimeNanos() {
            return this.startTimeNanos;
        }

        @Nullable
        ExplainOptions getExplainOptions() {
            return null;
        }

        ApiFuture<T> getFuture() {
            return this.future;
        }

        protected void setFuture(T value) {
            this.future.set(value);
        }

        void deliverError(Throwable throwable) {
            this.future.setException(throwable);
        }

        abstract void deliverResult(@Nullable Map<String, Value> var1, Timestamp var2, @Nullable ExplainMetrics var3);
    }

    private final class AggregateQueryExplainResponseDeliverer
    extends ResponseDeliverer<ExplainResults<AggregateQuerySnapshot>> {
        @Nullable
        private final ExplainOptions explainOptions;

        AggregateQueryExplainResponseDeliverer(@Nullable ByteString transactionId, com.google.protobuf.Timestamp readTime, @Nullable long startTimeNanos, ExplainOptions explainOptions) {
            super(transactionId, readTime, startTimeNanos);
            this.explainOptions = explainOptions;
        }

        @Override
        @Nullable
        ExplainOptions getExplainOptions() {
            return this.explainOptions;
        }

        @Override
        void deliverResult(@Nullable Map<String, Value> serverData, Timestamp readTime, @Nullable ExplainMetrics metrics) {
            if (metrics == null) {
                this.deliverError(new RuntimeException("Did not receive any metrics for explain query."));
                return;
            }
            AggregateQuerySnapshot snapshot = serverData == null ? null : new AggregateQuerySnapshot(AggregateQuery.this, readTime, AggregateQuery.this.convertServerAggregateFieldsMapToClientAggregateFieldsMap(serverData));
            this.setFuture(new ExplainResults<AggregateQuerySnapshot>(metrics, snapshot));
        }
    }

    private class AggregateQueryResponseDeliverer
    extends ResponseDeliverer<AggregateQuerySnapshot> {
        AggregateQueryResponseDeliverer(@Nullable ByteString transactionId, com.google.protobuf.Timestamp readTime, long startTimeNanos) {
            super(transactionId, readTime, startTimeNanos);
        }

        @Override
        void deliverResult(@Nullable Map<String, Value> serverData, Timestamp readTime, @Nullable ExplainMetrics metrics) {
            if (serverData == null) {
                this.deliverError(new RuntimeException("Did not receive any aggregate query results."));
                return;
            }
            this.setFuture(new AggregateQuerySnapshot(AggregateQuery.this, readTime, AggregateQuery.this.convertServerAggregateFieldsMapToClientAggregateFieldsMap(serverData)));
        }
    }

    private final class AggregateQueryResponseObserver<T>
    implements ResponseObserver<RunAggregationQueryResponse> {
        private final ResponseDeliverer<T> responseDeliverer;
        private Timestamp readTime = Timestamp.MAX_VALUE;
        @Nullable
        private Map<String, Value> aggregateFieldsMap = null;
        @Nullable
        private ExplainMetrics metrics = null;

        AggregateQueryResponseObserver(ResponseDeliverer<T> responseDeliverer) {
            this.responseDeliverer = responseDeliverer;
        }

        private boolean isExplainQuery() {
            return this.responseDeliverer.getExplainOptions() != null;
        }

        public void onStart(StreamController streamController) {
        }

        public void onResponse(RunAggregationQueryResponse response) {
            if (response.hasReadTime()) {
                this.readTime = Timestamp.fromProto((com.google.protobuf.Timestamp)response.getReadTime());
            }
            if (response.hasResult()) {
                this.aggregateFieldsMap = response.getResult().getAggregateFieldsMap();
            }
            if (response.hasExplainMetrics()) {
                this.metrics = new ExplainMetrics(response.getExplainMetrics());
            }
            if (!this.isExplainQuery()) {
                this.onComplete();
            }
        }

        public void onError(Throwable throwable) {
            if (this.shouldRetry(throwable)) {
                AggregateQuery.this.runQuery(this.responseDeliverer);
            } else {
                this.responseDeliverer.deliverError(throwable);
            }
        }

        private boolean shouldRetry(Throwable throwable) {
            if (this.isExplainQuery()) {
                return false;
            }
            Set retryableCodes = FirestoreSettings.newBuilder().runAggregationQuerySettings().getRetryableCodes();
            return AggregateQuery.this.query.shouldRetryQuery(throwable, this.responseDeliverer.getTransactionId(), this.responseDeliverer.getStartTimeNanos(), retryableCodes);
        }

        public void onComplete() {
            this.responseDeliverer.deliverResult(this.aggregateFieldsMap, this.readTime, this.metrics);
        }
    }
}

