/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.firestore.AggregateQuery;
import com.google.cloud.firestore.AggregateQuerySnapshot;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.Transaction;
import com.google.cloud.firestore.TransactionOptions;
import com.google.cloud.firestore.WriteResult;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firestore.v1.BeginTransactionRequest;
import com.google.firestore.v1.BeginTransactionResponse;
import com.google.firestore.v1.RollbackRequest;
import com.google.firestore.v1.TransactionOptions;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import io.opencensus.trace.Tracing;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class ServerSideTransaction
extends Transaction {
    private static final Logger LOGGER = Logger.getLogger(ServerSideTransaction.class.getName());
    private static final String READ_BEFORE_WRITE_ERROR_MSG = "Firestore transactions require all reads to be executed before all writes";
    private final FirestoreImpl firestore;
    final ByteString transactionId;

    private ServerSideTransaction(FirestoreImpl firestore, ByteString transactionId) {
        super(firestore);
        this.firestore = firestore;
        this.transactionId = transactionId;
    }

    public ByteString getTransactionId() {
        return this.transactionId;
    }

    public static ApiFuture<ServerSideTransaction> begin(FirestoreImpl firestore, TransactionOptions transactionOptions, @Nullable ServerSideTransaction previousTransaction) {
        ByteString previousTransactionId;
        Tracing.getTracer().getCurrentSpan().addAnnotation("CloudFirestoreOperation.BeginTransaction");
        BeginTransactionRequest.Builder beginTransaction = BeginTransactionRequest.newBuilder();
        beginTransaction.setDatabase(firestore.getDatabaseName());
        ByteString byteString = previousTransactionId = previousTransaction != null ? previousTransaction.transactionId : null;
        if (TransactionOptions.TransactionOptionsType.READ_WRITE.equals((Object)transactionOptions.getType()) && previousTransactionId != null) {
            beginTransaction.getOptionsBuilder().getReadWriteBuilder().setRetryTransaction(previousTransactionId);
        } else if (TransactionOptions.TransactionOptionsType.READ_ONLY.equals((Object)transactionOptions.getType())) {
            TransactionOptions.ReadOnly.Builder readOnlyBuilder = TransactionOptions.ReadOnly.newBuilder();
            if (transactionOptions.getReadTime() != null) {
                readOnlyBuilder.setReadTime(transactionOptions.getReadTime());
            }
            beginTransaction.getOptionsBuilder().setReadOnly(readOnlyBuilder);
        }
        ApiFuture<BeginTransactionResponse> transactionBeginFuture = firestore.sendRequest(beginTransaction.build(), firestore.getClient().beginTransactionCallable());
        return ApiFutures.transform(transactionBeginFuture, beginTransactionResponse -> new ServerSideTransaction(firestore, beginTransactionResponse.getTransaction()), (Executor)MoreExecutors.directExecutor());
    }

    ApiFuture<List<WriteResult>> commit() {
        return super.commit(this.transactionId);
    }

    ApiFuture<Void> rollback() {
        Tracing.getTracer().getCurrentSpan().addAnnotation("CloudFirestoreOperation.Rollback");
        RollbackRequest req = RollbackRequest.newBuilder().setTransaction(this.transactionId).setDatabase(this.firestore.getDatabaseName()).build();
        ApiFuture<Empty> rollbackFuture = this.firestore.sendRequest(req, this.firestore.getClient().rollbackCallable());
        ApiFuture transform = ApiFutures.transform(rollbackFuture, resp -> null, (Executor)MoreExecutors.directExecutor());
        return ApiFutures.catching((ApiFuture)transform, Throwable.class, error -> {
            LOGGER.log(Level.WARNING, "Failed best effort to rollback of transaction " + this.transactionId, (Throwable)error);
            return null;
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public boolean hasTransactionId() {
        return true;
    }

    @Override
    @Nonnull
    public ApiFuture<DocumentSnapshot> get(@Nonnull DocumentReference documentRef) {
        Tracing.getTracer().getCurrentSpan().addAnnotation("CloudFirestoreOperation.GetDocument");
        Preconditions.checkState((boolean)this.isEmpty(), (Object)READ_BEFORE_WRITE_ERROR_MSG);
        return ApiFutures.transform(this.firestore.getAll(new DocumentReference[]{documentRef}, null, this.transactionId, null), snapshots -> snapshots.isEmpty() ? null : (DocumentSnapshot)snapshots.get(0), (Executor)MoreExecutors.directExecutor());
    }

    @Override
    @Nonnull
    public ApiFuture<List<DocumentSnapshot>> getAll(DocumentReference ... documentReferences) {
        Preconditions.checkState((boolean)this.isEmpty(), (Object)READ_BEFORE_WRITE_ERROR_MSG);
        return this.firestore.getAll(documentReferences, null, this.transactionId, null);
    }

    @Override
    @Nonnull
    public ApiFuture<List<DocumentSnapshot>> getAll(@Nonnull DocumentReference[] documentReferences, @Nullable FieldMask fieldMask) {
        Preconditions.checkState((boolean)this.isEmpty(), (Object)READ_BEFORE_WRITE_ERROR_MSG);
        return this.firestore.getAll(documentReferences, fieldMask, this.transactionId, null);
    }

    @Override
    @Nonnull
    public ApiFuture<QuerySnapshot> get(@Nonnull Query query) {
        Preconditions.checkState((boolean)this.isEmpty(), (Object)READ_BEFORE_WRITE_ERROR_MSG);
        return query.get(this.transactionId, null);
    }

    @Override
    @Nonnull
    public ApiFuture<AggregateQuerySnapshot> get(@Nonnull AggregateQuery query) {
        Preconditions.checkState((boolean)this.isEmpty(), (Object)READ_BEFORE_WRITE_ERROR_MSG);
        return query.get(this.transactionId, null);
    }
}

