package com.google.cloud.firestore;

import com.google.common.collect.ImmutableList;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.StructuredQuery;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Query_QueryOptions extends Query.QueryOptions {

  private final ResourcePath parentPath;

  private final String collectionId;

  private final boolean allDescendants;

  private final Integer limit;

  private final Query.LimitType limitType;

  private final Integer offset;

  private final Cursor startCursor;

  private final Cursor endCursor;

  private final ImmutableList<Query.FieldFilter> fieldFilters;

  private final ImmutableList<Query.FieldOrder> fieldOrders;

  private final ImmutableList<StructuredQuery.FieldReference> fieldProjections;

  private AutoValue_Query_QueryOptions(
      ResourcePath parentPath,
      String collectionId,
      boolean allDescendants,
      @Nullable Integer limit,
      Query.LimitType limitType,
      @Nullable Integer offset,
      @Nullable Cursor startCursor,
      @Nullable Cursor endCursor,
      ImmutableList<Query.FieldFilter> fieldFilters,
      ImmutableList<Query.FieldOrder> fieldOrders,
      ImmutableList<StructuredQuery.FieldReference> fieldProjections) {
    this.parentPath = parentPath;
    this.collectionId = collectionId;
    this.allDescendants = allDescendants;
    this.limit = limit;
    this.limitType = limitType;
    this.offset = offset;
    this.startCursor = startCursor;
    this.endCursor = endCursor;
    this.fieldFilters = fieldFilters;
    this.fieldOrders = fieldOrders;
    this.fieldProjections = fieldProjections;
  }

  @Override
  ResourcePath getParentPath() {
    return parentPath;
  }

  @Override
  String getCollectionId() {
    return collectionId;
  }

  @Override
  boolean getAllDescendants() {
    return allDescendants;
  }

  @Nullable
  @Override
  Integer getLimit() {
    return limit;
  }

  @Override
  Query.LimitType getLimitType() {
    return limitType;
  }

  @Nullable
  @Override
  Integer getOffset() {
    return offset;
  }

  @Nullable
  @Override
  Cursor getStartCursor() {
    return startCursor;
  }

  @Nullable
  @Override
  Cursor getEndCursor() {
    return endCursor;
  }

  @Override
  ImmutableList<Query.FieldFilter> getFieldFilters() {
    return fieldFilters;
  }

  @Override
  ImmutableList<Query.FieldOrder> getFieldOrders() {
    return fieldOrders;
  }

  @Override
  ImmutableList<StructuredQuery.FieldReference> getFieldProjections() {
    return fieldProjections;
  }

  @Override
  public String toString() {
    return "QueryOptions{"
        + "parentPath=" + parentPath + ", "
        + "collectionId=" + collectionId + ", "
        + "allDescendants=" + allDescendants + ", "
        + "limit=" + limit + ", "
        + "limitType=" + limitType + ", "
        + "offset=" + offset + ", "
        + "startCursor=" + startCursor + ", "
        + "endCursor=" + endCursor + ", "
        + "fieldFilters=" + fieldFilters + ", "
        + "fieldOrders=" + fieldOrders + ", "
        + "fieldProjections=" + fieldProjections
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Query.QueryOptions) {
      Query.QueryOptions that = (Query.QueryOptions) o;
      return this.parentPath.equals(that.getParentPath())
          && this.collectionId.equals(that.getCollectionId())
          && this.allDescendants == that.getAllDescendants()
          && (this.limit == null ? that.getLimit() == null : this.limit.equals(that.getLimit()))
          && this.limitType.equals(that.getLimitType())
          && (this.offset == null ? that.getOffset() == null : this.offset.equals(that.getOffset()))
          && (this.startCursor == null ? that.getStartCursor() == null : this.startCursor.equals(that.getStartCursor()))
          && (this.endCursor == null ? that.getEndCursor() == null : this.endCursor.equals(that.getEndCursor()))
          && this.fieldFilters.equals(that.getFieldFilters())
          && this.fieldOrders.equals(that.getFieldOrders())
          && this.fieldProjections.equals(that.getFieldProjections());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= parentPath.hashCode();
    h$ *= 1000003;
    h$ ^= collectionId.hashCode();
    h$ *= 1000003;
    h$ ^= allDescendants ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (limit == null) ? 0 : limit.hashCode();
    h$ *= 1000003;
    h$ ^= limitType.hashCode();
    h$ *= 1000003;
    h$ ^= (offset == null) ? 0 : offset.hashCode();
    h$ *= 1000003;
    h$ ^= (startCursor == null) ? 0 : startCursor.hashCode();
    h$ *= 1000003;
    h$ ^= (endCursor == null) ? 0 : endCursor.hashCode();
    h$ *= 1000003;
    h$ ^= fieldFilters.hashCode();
    h$ *= 1000003;
    h$ ^= fieldOrders.hashCode();
    h$ *= 1000003;
    h$ ^= fieldProjections.hashCode();
    return h$;
  }

  @Override
  Query.QueryOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends Query.QueryOptions.Builder {
    private ResourcePath parentPath;
    private String collectionId;
    private Boolean allDescendants;
    private Integer limit;
    private Query.LimitType limitType;
    private Integer offset;
    private Cursor startCursor;
    private Cursor endCursor;
    private ImmutableList<Query.FieldFilter> fieldFilters;
    private ImmutableList<Query.FieldOrder> fieldOrders;
    private ImmutableList<StructuredQuery.FieldReference> fieldProjections;
    Builder() {
    }
    private Builder(Query.QueryOptions source) {
      this.parentPath = source.getParentPath();
      this.collectionId = source.getCollectionId();
      this.allDescendants = source.getAllDescendants();
      this.limit = source.getLimit();
      this.limitType = source.getLimitType();
      this.offset = source.getOffset();
      this.startCursor = source.getStartCursor();
      this.endCursor = source.getEndCursor();
      this.fieldFilters = source.getFieldFilters();
      this.fieldOrders = source.getFieldOrders();
      this.fieldProjections = source.getFieldProjections();
    }
    @Override
    Query.QueryOptions.Builder setParentPath(ResourcePath parentPath) {
      if (parentPath == null) {
        throw new NullPointerException("Null parentPath");
      }
      this.parentPath = parentPath;
      return this;
    }
    @Override
    Query.QueryOptions.Builder setCollectionId(String collectionId) {
      if (collectionId == null) {
        throw new NullPointerException("Null collectionId");
      }
      this.collectionId = collectionId;
      return this;
    }
    @Override
    Query.QueryOptions.Builder setAllDescendants(boolean allDescendants) {
      this.allDescendants = allDescendants;
      return this;
    }
    @Override
    Query.QueryOptions.Builder setLimit(Integer limit) {
      this.limit = limit;
      return this;
    }
    @Override
    Query.QueryOptions.Builder setLimitType(Query.LimitType limitType) {
      if (limitType == null) {
        throw new NullPointerException("Null limitType");
      }
      this.limitType = limitType;
      return this;
    }
    @Override
    Query.QueryOptions.Builder setOffset(Integer offset) {
      this.offset = offset;
      return this;
    }
    @Override
    Query.QueryOptions.Builder setStartCursor(@Nullable Cursor startCursor) {
      this.startCursor = startCursor;
      return this;
    }
    @Override
    Query.QueryOptions.Builder setEndCursor(@Nullable Cursor endCursor) {
      this.endCursor = endCursor;
      return this;
    }
    @Override
    Query.QueryOptions.Builder setFieldFilters(ImmutableList<Query.FieldFilter> fieldFilters) {
      if (fieldFilters == null) {
        throw new NullPointerException("Null fieldFilters");
      }
      this.fieldFilters = fieldFilters;
      return this;
    }
    @Override
    Query.QueryOptions.Builder setFieldOrders(ImmutableList<Query.FieldOrder> fieldOrders) {
      if (fieldOrders == null) {
        throw new NullPointerException("Null fieldOrders");
      }
      this.fieldOrders = fieldOrders;
      return this;
    }
    @Override
    Query.QueryOptions.Builder setFieldProjections(ImmutableList<StructuredQuery.FieldReference> fieldProjections) {
      if (fieldProjections == null) {
        throw new NullPointerException("Null fieldProjections");
      }
      this.fieldProjections = fieldProjections;
      return this;
    }
    @Override
    Query.QueryOptions build() {
      String missing = "";
      if (this.parentPath == null) {
        missing += " parentPath";
      }
      if (this.collectionId == null) {
        missing += " collectionId";
      }
      if (this.allDescendants == null) {
        missing += " allDescendants";
      }
      if (this.limitType == null) {
        missing += " limitType";
      }
      if (this.fieldFilters == null) {
        missing += " fieldFilters";
      }
      if (this.fieldOrders == null) {
        missing += " fieldOrders";
      }
      if (this.fieldProjections == null) {
        missing += " fieldProjections";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Query_QueryOptions(
          this.parentPath,
          this.collectionId,
          this.allDescendants,
          this.limit,
          this.limitType,
          this.offset,
          this.startCursor,
          this.endCursor,
          this.fieldFilters,
          this.fieldOrders,
          this.fieldProjections);
    }
  }

}
