/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.Timestamp;
import com.google.cloud.firestore.Blob;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.GeoPoint;
import com.google.common.base.Preconditions;
import com.google.firestore.v1beta1.ArrayValue;
import com.google.firestore.v1beta1.MapValue;
import com.google.firestore.v1beta1.Value;
import com.google.protobuf.NullValue;
import com.google.protobuf.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class UserDataConverter {
    static final EncodingOptions NO_DELETES = new EncodingOptions(){

        @Override
        public boolean allowDelete(FieldPath fieldPath) {
            return false;
        }
    };
    static final EncodingOptions ALLOW_ALL_DELETES = new EncodingOptions(){

        @Override
        public boolean allowDelete(FieldPath fieldPath) {
            return true;
        }
    };

    private UserDataConverter() {
    }

    @Nullable
    static Value encodeValue(FieldPath path, @Nullable Object sanitizedObject, EncodingOptions options) {
        if (sanitizedObject == FieldValue.DELETE_SENTINEL) {
            Preconditions.checkArgument((boolean)options.allowDelete(path), (String)"Encountered unexpected delete sentinel at field '%s'.", (Object)path);
            return null;
        }
        if (sanitizedObject == FieldValue.SERVER_TIMESTAMP_SENTINEL) {
            return null;
        }
        if (sanitizedObject == null) {
            return Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
        }
        if (sanitizedObject instanceof String) {
            return Value.newBuilder().setStringValue((String)sanitizedObject).build();
        }
        if (sanitizedObject instanceof Integer) {
            return Value.newBuilder().setIntegerValue((long)((Integer)sanitizedObject).intValue()).build();
        }
        if (sanitizedObject instanceof Long) {
            return Value.newBuilder().setIntegerValue(((Long)sanitizedObject).longValue()).build();
        }
        if (sanitizedObject instanceof Double) {
            return Value.newBuilder().setDoubleValue(((Double)sanitizedObject).doubleValue()).build();
        }
        if (sanitizedObject instanceof Boolean) {
            return Value.newBuilder().setBooleanValue(((Boolean)sanitizedObject).booleanValue()).build();
        }
        if (sanitizedObject instanceof Date) {
            Date date = (Date)sanitizedObject;
            long epochSeconds = TimeUnit.MILLISECONDS.toSeconds(date.getTime());
            long msOffset = date.getTime() - TimeUnit.SECONDS.toMillis(epochSeconds);
            Timestamp.Builder timestampBuilder = com.google.protobuf.Timestamp.newBuilder();
            timestampBuilder.setSeconds(epochSeconds);
            timestampBuilder.setNanos((int)TimeUnit.MILLISECONDS.toNanos(msOffset));
            return Value.newBuilder().setTimestampValue(timestampBuilder.build()).build();
        }
        if (sanitizedObject instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)sanitizedObject;
            return Value.newBuilder().setTimestampValue(timestamp.toProto()).build();
        }
        if (sanitizedObject instanceof List) {
            ArrayValue.Builder res = ArrayValue.newBuilder();
            int i = 0;
            for (Object child : (List)sanitizedObject) {
                Value encodedValue;
                if ((encodedValue = UserDataConverter.encodeValue((FieldPath)path.append(Integer.toString(i++)), child, options)) == null) continue;
                res.addValues(encodedValue);
            }
            return Value.newBuilder().setArrayValue(res.build()).build();
        }
        if (sanitizedObject instanceof GeoPoint) {
            GeoPoint geopoint = (GeoPoint)sanitizedObject;
            return Value.newBuilder().setGeoPointValue(geopoint.toProto()).build();
        }
        if (sanitizedObject instanceof Blob) {
            Blob blob = (Blob)sanitizedObject;
            return Value.newBuilder().setBytesValue(blob.toByteString()).build();
        }
        if (sanitizedObject instanceof DocumentReference) {
            DocumentReference docRef = (DocumentReference)sanitizedObject;
            return Value.newBuilder().setReferenceValue(docRef.getName()).build();
        }
        if (sanitizedObject instanceof Map) {
            MapValue.Builder res = MapValue.newBuilder();
            Map map = (Map)sanitizedObject;
            for (Map.Entry entry : map.entrySet()) {
                Value encodedValue = UserDataConverter.encodeValue((FieldPath)path.append((String)entry.getKey()), entry.getValue(), options);
                if (encodedValue == null) continue;
                res.putFields((String)entry.getKey(), encodedValue);
            }
            if (map.isEmpty() || res.getFieldsCount() != 0) {
                return Value.newBuilder().setMapValue(res.build()).build();
            }
            return null;
        }
        throw FirestoreException.invalidState("Cannot convert %s to Firestore Value", sanitizedObject);
    }

    static interface EncodingOptions {
        public boolean allowDelete(FieldPath var1);
    }
}

