/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.Blob;
import com.google.cloud.firestore.CustomClassMapper;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.GeoPoint;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.UserDataConverter;
import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import com.google.firestore.v1beta1.Document;
import com.google.firestore.v1beta1.Value;
import com.google.firestore.v1beta1.Write;
import com.google.protobuf.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Instant;

public class DocumentSnapshot {
    private final FirestoreImpl firestore;
    private final DocumentReference docRef;
    @Nullable
    private final Map<String, Value> fields;
    @Nullable
    private Instant readTime;
    @Nullable
    private Instant updateTime;
    @Nullable
    private Instant createTime;

    DocumentSnapshot(FirestoreImpl firestore, DocumentReference docRef, @Nullable Map<String, Value> fields, @Nullable Instant readTime, @Nullable Instant updateTime, @Nullable Instant createTime) {
        this.firestore = firestore;
        this.docRef = docRef;
        this.fields = fields;
        this.readTime = readTime;
        this.updateTime = updateTime;
        this.createTime = createTime;
    }

    @Nonnull
    public String getId() {
        return this.docRef.getId();
    }

    static DocumentSnapshot fromObject(FirestoreImpl firestore, DocumentReference docRef, Map<String, Object> values, UserDataConverter.EncodingOptions options) {
        HashMap<String, Value> fields = new HashMap<String, Value>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            Value encodedValue = UserDataConverter.encodeValue(FieldPath.of(entry.getKey()), entry.getValue(), options);
            if (encodedValue == null) continue;
            fields.put(entry.getKey(), encodedValue);
        }
        return new DocumentSnapshot(firestore, docRef, fields, null, null, null);
    }

    static DocumentSnapshot fromDocument(FirestoreImpl firestore, Timestamp readTime, Document document) {
        Timestamp updateTime = document.getUpdateTime();
        Timestamp createTime = document.getCreateTime();
        return new DocumentSnapshot(firestore, new DocumentReference(firestore, ResourcePath.create(document.getName())), document.getFieldsMap(), Instant.ofEpochSecond((long)readTime.getSeconds(), (long)readTime.getNanos()), Instant.ofEpochSecond((long)updateTime.getSeconds(), (long)updateTime.getNanos()), Instant.ofEpochSecond((long)createTime.getSeconds(), (long)createTime.getNanos()));
    }

    static DocumentSnapshot fromMissing(FirestoreImpl firestore, DocumentReference documentReference, Instant readTime) {
        return new DocumentSnapshot(firestore, documentReference, null, readTime, null, null);
    }

    private Object decodeValue(Value v) {
        Value.ValueTypeCase typeCase = v.getValueTypeCase();
        switch (typeCase) {
            case NULL_VALUE: {
                return null;
            }
            case BOOLEAN_VALUE: {
                return v.getBooleanValue();
            }
            case INTEGER_VALUE: {
                return v.getIntegerValue();
            }
            case DOUBLE_VALUE: {
                return v.getDoubleValue();
            }
            case TIMESTAMP_VALUE: {
                Timestamp timestamp = v.getTimestampValue();
                long milliseconds = TimeUnit.SECONDS.toMillis(timestamp.getSeconds()) + TimeUnit.NANOSECONDS.toMillis(timestamp.getNanos());
                return new Date(milliseconds);
            }
            case STRING_VALUE: {
                return v.getStringValue();
            }
            case BYTES_VALUE: {
                return Blob.fromByteString(v.getBytesValue());
            }
            case REFERENCE_VALUE: {
                String pathName = v.getReferenceValue();
                return new DocumentReference(this.firestore, ResourcePath.create(pathName));
            }
            case GEO_POINT_VALUE: {
                return new GeoPoint(v.getGeoPointValue().getLatitude(), v.getGeoPointValue().getLongitude());
            }
            case ARRAY_VALUE: {
                ArrayList<Object> list = new ArrayList<Object>();
                List lv = v.getArrayValue().getValuesList();
                for (Value iv : lv) {
                    list.add(this.decodeValue(iv));
                }
                return list;
            }
            case MAP_VALUE: {
                HashMap outputMap = new HashMap();
                Map inputMap = v.getMapValue().getFieldsMap();
                for (Map.Entry entry : inputMap.entrySet()) {
                    outputMap.put(entry.getKey(), this.decodeValue((Value)entry.getValue()));
                }
                return outputMap;
            }
        }
        throw FirestoreException.invalidState(String.format("Unknown Value Type: %s", typeCase), new Object[0]);
    }

    @Nullable
    public Instant getReadTime() {
        return this.readTime;
    }

    @Nullable
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Nullable
    public Instant getCreateTime() {
        return this.createTime;
    }

    public boolean exists() {
        return this.fields != null;
    }

    boolean isEmpty() {
        return this.fields == null || this.fields.isEmpty();
    }

    @Nullable
    public Map<String, Object> getData() {
        if (this.fields == null) {
            return null;
        }
        HashMap<String, Object> decodedFields = new HashMap<String, Object>();
        for (Map.Entry<String, Value> entry : this.fields.entrySet()) {
            decodedFields.put(entry.getKey(), this.decodeValue(entry.getValue()));
        }
        return decodedFields;
    }

    @Nullable
    public <T> T toObject(@Nonnull Class<T> valueType) {
        Map<String, Object> data = this.getData();
        return data == null ? null : (T)CustomClassMapper.convertToCustomClass(this.getData(), valueType);
    }

    public boolean contains(@Nonnull String field) {
        return this.contains(FieldPath.fromDotSeparatedString(field));
    }

    public boolean contains(@Nonnull FieldPath fieldPath) {
        return this.extractField(fieldPath) != null;
    }

    @Nullable
    public Object get(@Nonnull String field) {
        return this.get(FieldPath.fromDotSeparatedString(field));
    }

    @Nullable
    public Object get(@Nonnull FieldPath fieldPath) {
        Value value = this.extractField(fieldPath);
        if (value == null) {
            return null;
        }
        return this.decodeValue(value);
    }

    @Nullable
    Value extractField(@Nonnull FieldPath fieldPath) {
        Value value = null;
        if (this.fields != null) {
            UnmodifiableIterator components = fieldPath.getSegments().iterator();
            value = this.fields.get(components.next());
            while (value != null && components.hasNext()) {
                if (value.getValueTypeCase() != Value.ValueTypeCase.MAP_VALUE) {
                    return null;
                }
                value = value.getMapValue().getFieldsOrDefault((String)components.next(), null);
            }
        }
        return value;
    }

    @Nullable
    public Boolean getBoolean(@Nonnull String field) {
        return (Boolean)this.get(field);
    }

    @Nullable
    public Double getDouble(@Nonnull String field) {
        Number number = (Number)this.get(field);
        return number == null ? null : Double.valueOf(number.doubleValue());
    }

    @Nullable
    public String getString(@Nonnull String field) {
        return (String)this.get(field);
    }

    @Nullable
    public Long getLong(@Nonnull String field) {
        Number number = (Number)this.get(field);
        return number == null ? null : Long.valueOf(number.longValue());
    }

    @Nullable
    public Date getDate(@Nonnull String field) {
        return (Date)this.get(field);
    }

    @Nullable
    public Blob getBlob(@Nonnull String field) {
        return (Blob)this.get(field);
    }

    @Nullable
    public GeoPoint getGeoPoint(@Nonnull String field) {
        return (GeoPoint)this.get(field);
    }

    @Nonnull
    public DocumentReference getReference() {
        return this.docRef;
    }

    Write.Builder toPb() {
        Preconditions.checkState((boolean)this.exists(), (Object)"Can't call toDocument() on a document that doesn't exist");
        Write.Builder write = Write.newBuilder();
        Document.Builder document = write.getUpdateBuilder();
        document.setName(this.docRef.getName());
        document.putAllFields(this.fields);
        return write;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentSnapshot that = (DocumentSnapshot)o;
        return Objects.equals(this.firestore, that.firestore) && Objects.equals(this.docRef, that.docRef) && Objects.equals(this.fields, that.fields) && Objects.equals(this.readTime, that.readTime) && Objects.equals(this.updateTime, that.updateTime) && Objects.equals(this.createTime, that.createTime);
    }

    public int hashCode() {
        return Objects.hash(this.firestore, this.docRef, this.fields, this.readTime, this.updateTime, this.createTime);
    }
}

