/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.grpc.BaseGrpcServiceException;
import io.grpc.Status;
import java.io.IOException;

public final class FirestoreException
extends BaseGrpcServiceException {
    private FirestoreException(String reason, Status status) {
        super(reason, null, status.getCode().value(), false);
    }

    private FirestoreException(IOException exception, boolean retryable) {
        super(exception, retryable);
    }

    private FirestoreException(ApiException exception) {
        super(exception);
    }

    static FirestoreException invalidState(String message, Object ... params) {
        return new FirestoreException(String.format(message, params), Status.INVALID_ARGUMENT);
    }

    static FirestoreException serverRejected(Status status, String message, Object ... params) {
        return new FirestoreException(String.format(message, params), status);
    }

    static FirestoreException networkException(IOException exception, boolean retryable) {
        return new FirestoreException(exception, retryable);
    }

    static FirestoreException apiException(ApiException exception) {
        return new FirestoreException(exception);
    }
}

