/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class Blob
implements Serializable {
    private static final long serialVersionUID = 1441087101882481208L;
    private final ByteString byteString;

    private Blob(ByteString byteString) {
        this.byteString = byteString;
    }

    @Nonnull
    public static Blob fromByteString(@Nonnull ByteString byteString) {
        return new Blob(byteString);
    }

    @Nonnull
    public static Blob fromBytes(@Nonnull byte[] bytes) {
        return new Blob(ByteString.copyFrom((byte[])bytes));
    }

    @Nonnull
    public ByteString toByteString() {
        return this.byteString;
    }

    @Nonnull
    public byte[] toBytes() {
        return this.byteString.toByteArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Blob blob = (Blob)o;
        return Objects.equals(this.byteString, blob.byteString);
    }

    public int hashCode() {
        return Objects.hash(this.byteString);
    }
}

