/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.firestore.CustomClassMapper;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.WriteResult;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CollectionReference
extends Query {
    CollectionReference(FirestoreImpl firestore, ResourcePath collectionPath) {
        super(firestore, collectionPath);
    }

    @Nonnull
    public String getId() {
        return this.path.getId();
    }

    @Nullable
    public DocumentReference getParent() {
        ResourcePath parent = (ResourcePath)this.path.getParent();
        return parent.isDocument() ? new DocumentReference(this.firestore, parent) : null;
    }

    @Nonnull
    public String getPath() {
        return this.path.toString();
    }

    @Nonnull
    public DocumentReference document() {
        return this.document(FirestoreImpl.autoId());
    }

    @Nonnull
    public DocumentReference document(@Nonnull String childPath) {
        ResourcePath documentPath = (ResourcePath)this.path.append(childPath);
        Preconditions.checkArgument((boolean)documentPath.isDocument(), (Object)String.format("Path should point to a Document Reference: %s", this.path));
        return new DocumentReference(this.firestore, documentPath);
    }

    @Nonnull
    public ApiFuture<DocumentReference> add(@Nonnull Map<String, Object> fields) {
        final DocumentReference documentReference = this.document();
        ApiFuture<WriteResult> createFuture = documentReference.create(fields);
        return ApiFutures.transform(createFuture, (ApiFunction)new ApiFunction<WriteResult, DocumentReference>(){

            public DocumentReference apply(WriteResult writeResult) {
                return documentReference;
            }
        });
    }

    public ApiFuture<DocumentReference> add(Object pojo) {
        Object converted = CustomClassMapper.convertToPlainJavaTypes(pojo);
        if (!(converted instanceof Map)) {
            FirestoreException.invalidState("Can't set a document's data to an array or primitive", new Object[0]);
        }
        return this.add((Map)converted);
    }
}

