/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.WriteBatch;
import com.google.cloud.firestore.WriteResult;
import com.google.firestore.v1beta1.ListCollectionIdsRequest;
import com.google.firestore.v1beta1.ListCollectionIdsResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class DocumentReference {
    private final ResourcePath path;
    private final FirestoreImpl firestore;

    DocumentReference(FirestoreImpl firestore, ResourcePath path) {
        this.path = path;
        this.firestore = firestore;
    }

    @Nonnull
    public Firestore getFirestore() {
        return this.firestore;
    }

    @Nonnull
    public String getId() {
        return this.path.getId();
    }

    @Nonnull
    public CollectionReference getParent() {
        return new CollectionReference(this.firestore, (ResourcePath)this.path.getParent());
    }

    @Nonnull
    public String getPath() {
        return this.path.toString();
    }

    @Nonnull
    public CollectionReference collection(@Nonnull String collectionPath) {
        return new CollectionReference(this.firestore, (ResourcePath)this.path.append(collectionPath));
    }

    private <T> ApiFuture<T> extractFirst(ApiFuture<List<T>> results) {
        return ApiFutures.transform(results, (ApiFunction)new ApiFunction<List<T>, T>(){

            public T apply(List<T> results) {
                return results.isEmpty() ? null : (Object)results.get(0);
            }
        });
    }

    @Nonnull
    public ApiFuture<WriteResult> create(@Nonnull Map<String, Object> fields) {
        WriteBatch writeBatch = this.firestore.batch();
        return this.extractFirst(((WriteBatch)writeBatch.create(this, fields)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> create(@Nonnull Object pojo) {
        WriteBatch writeBatch = this.firestore.batch();
        return this.extractFirst(((WriteBatch)writeBatch.create(this, pojo)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> set(@Nonnull Map<String, Object> fields) {
        WriteBatch writeBatch = this.firestore.batch();
        return this.extractFirst(((WriteBatch)writeBatch.set(this, fields)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> set(@Nonnull Map<String, Object> fields, @Nonnull SetOptions options) {
        WriteBatch writeBatch = this.firestore.batch();
        return this.extractFirst(((WriteBatch)writeBatch.set(this, fields, options)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> set(@Nonnull Object pojo) {
        WriteBatch writeBatch = this.firestore.batch();
        return this.extractFirst(((WriteBatch)writeBatch.set(this, pojo)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> set(@Nonnull Object pojo, @Nonnull SetOptions options) {
        WriteBatch writeBatch = this.firestore.batch();
        return this.extractFirst(((WriteBatch)writeBatch.set(this, pojo, options)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull Map<String, Object> fields) {
        WriteBatch writeBatch = this.firestore.batch();
        return this.extractFirst(((WriteBatch)writeBatch.update(this, fields)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull Map<String, Object> fields, Precondition options) {
        WriteBatch writeBatch = this.firestore.batch();
        return this.extractFirst(((WriteBatch)writeBatch.update(this, fields, options)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        WriteBatch writeBatch = this.firestore.batch();
        return this.extractFirst(((WriteBatch)writeBatch.update(this, field, value, moreFieldsAndValues)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        WriteBatch writeBatch = this.firestore.batch();
        return this.extractFirst(((WriteBatch)writeBatch.update(this, fieldPath, value, moreFieldsAndValues)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull Precondition options, @Nonnull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        WriteBatch writeBatch = this.firestore.batch();
        return this.extractFirst(((WriteBatch)writeBatch.update(this, options, field, value, moreFieldsAndValues)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> update(@Nonnull Precondition options, @Nonnull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        WriteBatch writeBatch = this.firestore.batch();
        return this.extractFirst(((WriteBatch)writeBatch.update(this, options, fieldPath, value, moreFieldsAndValues)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> delete(@Nonnull Precondition options) {
        WriteBatch writeBatch = this.firestore.batch();
        return this.extractFirst(((WriteBatch)writeBatch.delete(this, options)).commit());
    }

    @Nonnull
    public ApiFuture<WriteResult> delete() {
        WriteBatch writeBatch = this.firestore.batch();
        return this.extractFirst(((WriteBatch)writeBatch.delete(this)).commit());
    }

    @Nonnull
    public ApiFuture<DocumentSnapshot> get() {
        return this.extractFirst(this.firestore.getAll(this));
    }

    public ApiFuture<List<CollectionReference>> getCollections() {
        ListCollectionIdsRequest.Builder request = ListCollectionIdsRequest.newBuilder();
        request.setParent(this.path.toString());
        ApiFuture<ListCollectionIdsResponse> response = this.firestore.sendRequest(request.build(), this.firestore.getClient().listCollectionIdsCallable());
        return ApiFutures.transform(response, (ApiFunction)new ApiFunction<ListCollectionIdsResponse, List<CollectionReference>>(){

            public List<CollectionReference> apply(ListCollectionIdsResponse response) {
                ArrayList<CollectionReference> collectionList = new ArrayList<CollectionReference>();
                TreeSet sortedIds = new TreeSet(response.getCollectionIdsList());
                for (String collectionId : sortedIds) {
                    collectionList.add(DocumentReference.this.collection(collectionId));
                }
                return collectionList;
            }
        });
    }

    public String toString() {
        return String.format("DocumentReference{path=%s}", this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentReference that = (DocumentReference)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.firestore, that.firestore);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.firestore);
    }
}

