/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.spi.v1beta1;

import com.google.api.core.ApiFunction;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.GrpcTransport;
import com.google.api.gax.grpc.GrpcTransportProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.Transport;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.spi.v1beta1.FirestoreRpc;
import com.google.cloud.firestore.v1beta1.FirestoreSettings;
import com.google.cloud.firestore.v1beta1.stub.FirestoreStub;
import com.google.cloud.firestore.v1beta1.stub.GrpcFirestoreStub;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.firestore.v1beta1.BatchGetDocumentsRequest;
import com.google.firestore.v1beta1.BatchGetDocumentsResponse;
import com.google.firestore.v1beta1.BeginTransactionRequest;
import com.google.firestore.v1beta1.BeginTransactionResponse;
import com.google.firestore.v1beta1.CommitRequest;
import com.google.firestore.v1beta1.CommitResponse;
import com.google.firestore.v1beta1.DatabaseName;
import com.google.firestore.v1beta1.ListCollectionIdsRequest;
import com.google.firestore.v1beta1.ListCollectionIdsResponse;
import com.google.firestore.v1beta1.RollbackRequest;
import com.google.firestore.v1beta1.RunQueryRequest;
import com.google.firestore.v1beta1.RunQueryResponse;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class GrpcFirestoreRpc
implements FirestoreRpc {
    private final FirestoreStub firestoreStub;
    private final ScheduledExecutorService executor;
    private final GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory;
    private final ClientContext clientContext;
    private boolean closed;

    public GrpcFirestoreRpc(final FirestoreOptions options) throws IOException {
        GrpcTransportOptions transportOptions = (GrpcTransportOptions)options.getTransportOptions();
        this.executorFactory = transportOptions.getExecutorFactory();
        this.executor = (ScheduledExecutorService)this.executorFactory.get();
        try {
            if (options.getHost().contains("localhost") || NoCredentials.getInstance().equals((Object)options.getCredentials())) {
                ManagedChannel managedChannel = ManagedChannelBuilder.forTarget((String)options.getHost()).usePlaintext(true).executor((Executor)this.executor).build();
                this.clientContext = ClientContext.newBuilder().setCredentials(null).setExecutor(this.executor).setTransportContext((Transport)GrpcTransport.newBuilder().setChannel((Channel)managedChannel).build()).build();
            } else {
                DatabaseName databaseName = DatabaseName.create((String)options.getProjectId(), (String)options.getDatabaseId());
                Credentials credentials = GrpcTransportOptions.setUpCredentialsProvider((ServiceOptions)options).getCredentials();
                InstantiatingChannelProvider.Builder channelBuilder = FirestoreSettings.defaultGrpcChannelProviderBuilder();
                channelBuilder.setGoogleCloudResourcePrefix(databaseName.toString());
                ChannelProvider channelProvider = GrpcTransportOptions.setUpChannelProvider((InstantiatingChannelProvider.Builder)channelBuilder, (ServiceOptions)options);
                GrpcTransportProvider transportProviders = GrpcTransportProvider.newBuilder().setChannelProvider(channelProvider).build();
                GrpcTransport transport = transportProviders.needsExecutor() ? transportProviders.getTransport(this.executor) : transportProviders.getTransport();
                this.clientContext = ClientContext.newBuilder().setCredentials(credentials).setExecutor(this.executor).setTransportContext((Transport)transport).setBackgroundResources(transport.getBackgroundResources()).build();
            }
            ApiFunction<UnaryCallSettings.Builder, Void> retrySettingsSetter = new ApiFunction<UnaryCallSettings.Builder, Void>(){

                public Void apply(UnaryCallSettings.Builder builder) {
                    builder.setRetrySettings(options.getRetrySettings());
                    return null;
                }
            };
            FirestoreSettings.Builder firestoreBuilder = FirestoreSettings.newBuilder(this.clientContext).applyToAllUnaryMethods(retrySettingsSetter);
            this.firestoreStub = GrpcFirestoreStub.create(firestoreBuilder.build());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.firestoreStub.close();
        for (BackgroundResource resource : this.clientContext.getBackgroundResources()) {
            resource.close();
        }
        this.executorFactory.release((ExecutorService)this.executor);
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public UnaryCallable<CommitRequest, CommitResponse> commitCallable() {
        return this.firestoreStub.commitCallable();
    }

    @Override
    public ServerStreamingCallable<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsCallable() {
        return this.firestoreStub.batchGetDocumentsCallable();
    }

    @Override
    public ServerStreamingCallable<RunQueryRequest, RunQueryResponse> runQueryCallable() {
        return this.firestoreStub.runQueryCallable();
    }

    @Override
    public UnaryCallable<BeginTransactionRequest, BeginTransactionResponse> beginTransactionCallable() {
        return this.firestoreStub.beginTransactionCallable();
    }

    @Override
    public UnaryCallable<RollbackRequest, Empty> rollbackCallable() {
        return this.firestoreStub.rollbackCallable();
    }

    @Override
    public UnaryCallable<ListCollectionIdsRequest, ListCollectionIdsResponse> listCollectionIdsCallable() {
        return this.firestoreStub.listCollectionIdsCallable();
    }
}

