/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;

abstract class BasePath<B extends BasePath<B>> {
    BasePath() {
    }

    abstract ImmutableList<String> getSegments();

    @Nullable
    B getParent() {
        ImmutableList<String> parts = this.getSegments();
        if (parts.isEmpty()) {
            return null;
        }
        return this.createPathWithSegments((ImmutableList<String>)parts.subList(0, parts.size() - 1));
    }

    B append(String path) {
        ImmutableList.Builder components = ImmutableList.builder();
        components.addAll(this.getSegments());
        components.add((Object[])this.splitChildPath(path));
        return this.createPathWithSegments((ImmutableList<String>)components.build());
    }

    B append(BasePath<B> path) {
        ImmutableList.Builder components = ImmutableList.builder();
        components.addAll(this.getSegments());
        components.addAll(path.getSegments());
        return this.createPathWithSegments((ImmutableList<String>)components.build());
    }

    abstract String[] splitChildPath(String var1);

    abstract B createPathWithSegments(ImmutableList<String> var1);
}

