/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.eventarc.v1.Channel;
import com.google.cloud.eventarc.v1.ChannelConnection;
import com.google.cloud.eventarc.v1.CreateChannelConnectionRequest;
import com.google.cloud.eventarc.v1.CreateChannelRequest;
import com.google.cloud.eventarc.v1.CreateTriggerRequest;
import com.google.cloud.eventarc.v1.DeleteChannelConnectionRequest;
import com.google.cloud.eventarc.v1.DeleteChannelRequest;
import com.google.cloud.eventarc.v1.DeleteTriggerRequest;
import com.google.cloud.eventarc.v1.EventarcClient;
import com.google.cloud.eventarc.v1.GetChannelConnectionRequest;
import com.google.cloud.eventarc.v1.GetChannelRequest;
import com.google.cloud.eventarc.v1.GetGoogleChannelConfigRequest;
import com.google.cloud.eventarc.v1.GetProviderRequest;
import com.google.cloud.eventarc.v1.GetTriggerRequest;
import com.google.cloud.eventarc.v1.GoogleChannelConfig;
import com.google.cloud.eventarc.v1.ListChannelConnectionsRequest;
import com.google.cloud.eventarc.v1.ListChannelConnectionsResponse;
import com.google.cloud.eventarc.v1.ListChannelsRequest;
import com.google.cloud.eventarc.v1.ListChannelsResponse;
import com.google.cloud.eventarc.v1.ListProvidersRequest;
import com.google.cloud.eventarc.v1.ListProvidersResponse;
import com.google.cloud.eventarc.v1.ListTriggersRequest;
import com.google.cloud.eventarc.v1.ListTriggersResponse;
import com.google.cloud.eventarc.v1.OperationMetadata;
import com.google.cloud.eventarc.v1.Provider;
import com.google.cloud.eventarc.v1.Trigger;
import com.google.cloud.eventarc.v1.UpdateChannelRequest;
import com.google.cloud.eventarc.v1.UpdateGoogleChannelConfigRequest;
import com.google.cloud.eventarc.v1.UpdateTriggerRequest;
import com.google.cloud.eventarc.v1.stub.EventarcStub;
import com.google.cloud.eventarc.v1.stub.EventarcStubSettings;
import com.google.cloud.eventarc.v1.stub.GrpcEventarcCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcEventarcStub
extends EventarcStub {
    private static final MethodDescriptor<GetTriggerRequest, Trigger> getTriggerMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/GetTrigger").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTriggerRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Trigger.getDefaultInstance())).build();
    private static final MethodDescriptor<ListTriggersRequest, ListTriggersResponse> listTriggersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/ListTriggers").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTriggersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTriggersResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateTriggerRequest, Operation> createTriggerMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/CreateTrigger").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateTriggerRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateTriggerRequest, Operation> updateTriggerMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/UpdateTrigger").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateTriggerRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteTriggerRequest, Operation> deleteTriggerMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/DeleteTrigger").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteTriggerRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetChannelRequest, Channel> getChannelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/GetChannel").setRequestMarshaller(ProtoUtils.marshaller((Message)GetChannelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Channel.getDefaultInstance())).build();
    private static final MethodDescriptor<ListChannelsRequest, ListChannelsResponse> listChannelsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/ListChannels").setRequestMarshaller(ProtoUtils.marshaller((Message)ListChannelsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListChannelsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateChannelRequest, Operation> createChannelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/CreateChannel").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateChannelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateChannelRequest, Operation> updateChannelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/UpdateChannel").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateChannelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteChannelRequest, Operation> deleteChannelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/DeleteChannel").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteChannelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetProviderRequest, Provider> getProviderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/GetProvider").setRequestMarshaller(ProtoUtils.marshaller((Message)GetProviderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Provider.getDefaultInstance())).build();
    private static final MethodDescriptor<ListProvidersRequest, ListProvidersResponse> listProvidersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/ListProviders").setRequestMarshaller(ProtoUtils.marshaller((Message)ListProvidersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListProvidersResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetChannelConnectionRequest, ChannelConnection> getChannelConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/GetChannelConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)GetChannelConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ChannelConnection.getDefaultInstance())).build();
    private static final MethodDescriptor<ListChannelConnectionsRequest, ListChannelConnectionsResponse> listChannelConnectionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/ListChannelConnections").setRequestMarshaller(ProtoUtils.marshaller((Message)ListChannelConnectionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListChannelConnectionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateChannelConnectionRequest, Operation> createChannelConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/CreateChannelConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateChannelConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteChannelConnectionRequest, Operation> deleteChannelConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/DeleteChannelConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteChannelConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetGoogleChannelConfigRequest, GoogleChannelConfig> getGoogleChannelConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/GetGoogleChannelConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetGoogleChannelConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GoogleChannelConfig.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateGoogleChannelConfigRequest, GoogleChannelConfig> updateGoogleChannelConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/UpdateGoogleChannelConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateGoogleChannelConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GoogleChannelConfig.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetTriggerRequest, Trigger> getTriggerCallable;
    private final UnaryCallable<ListTriggersRequest, ListTriggersResponse> listTriggersCallable;
    private final UnaryCallable<ListTriggersRequest, EventarcClient.ListTriggersPagedResponse> listTriggersPagedCallable;
    private final UnaryCallable<CreateTriggerRequest, Operation> createTriggerCallable;
    private final OperationCallable<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationCallable;
    private final UnaryCallable<UpdateTriggerRequest, Operation> updateTriggerCallable;
    private final OperationCallable<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationCallable;
    private final UnaryCallable<DeleteTriggerRequest, Operation> deleteTriggerCallable;
    private final OperationCallable<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationCallable;
    private final UnaryCallable<GetChannelRequest, Channel> getChannelCallable;
    private final UnaryCallable<ListChannelsRequest, ListChannelsResponse> listChannelsCallable;
    private final UnaryCallable<ListChannelsRequest, EventarcClient.ListChannelsPagedResponse> listChannelsPagedCallable;
    private final UnaryCallable<CreateChannelRequest, Operation> createChannelCallable;
    private final OperationCallable<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationCallable;
    private final UnaryCallable<UpdateChannelRequest, Operation> updateChannelCallable;
    private final OperationCallable<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationCallable;
    private final UnaryCallable<DeleteChannelRequest, Operation> deleteChannelCallable;
    private final OperationCallable<DeleteChannelRequest, Channel, OperationMetadata> deleteChannelOperationCallable;
    private final UnaryCallable<GetProviderRequest, Provider> getProviderCallable;
    private final UnaryCallable<ListProvidersRequest, ListProvidersResponse> listProvidersCallable;
    private final UnaryCallable<ListProvidersRequest, EventarcClient.ListProvidersPagedResponse> listProvidersPagedCallable;
    private final UnaryCallable<GetChannelConnectionRequest, ChannelConnection> getChannelConnectionCallable;
    private final UnaryCallable<ListChannelConnectionsRequest, ListChannelConnectionsResponse> listChannelConnectionsCallable;
    private final UnaryCallable<ListChannelConnectionsRequest, EventarcClient.ListChannelConnectionsPagedResponse> listChannelConnectionsPagedCallable;
    private final UnaryCallable<CreateChannelConnectionRequest, Operation> createChannelConnectionCallable;
    private final OperationCallable<CreateChannelConnectionRequest, ChannelConnection, OperationMetadata> createChannelConnectionOperationCallable;
    private final UnaryCallable<DeleteChannelConnectionRequest, Operation> deleteChannelConnectionCallable;
    private final OperationCallable<DeleteChannelConnectionRequest, ChannelConnection, OperationMetadata> deleteChannelConnectionOperationCallable;
    private final UnaryCallable<GetGoogleChannelConfigRequest, GoogleChannelConfig> getGoogleChannelConfigCallable;
    private final UnaryCallable<UpdateGoogleChannelConfigRequest, GoogleChannelConfig> updateGoogleChannelConfigCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, EventarcClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcEventarcStub create(EventarcStubSettings settings) throws IOException {
        return new GrpcEventarcStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcEventarcStub create(ClientContext clientContext) throws IOException {
        return new GrpcEventarcStub(EventarcStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcEventarcStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcEventarcStub(EventarcStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcEventarcStub(EventarcStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcEventarcCallableFactory());
    }

    protected GrpcEventarcStub(EventarcStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getTriggerTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTriggerMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listTriggersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTriggersMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings createTriggerTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTriggerMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateTriggerTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateTriggerMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"trigger.name", (Object)String.valueOf(request.getTrigger().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteTriggerTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteTriggerMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getChannelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getChannelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listChannelsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listChannelsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings createChannelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createChannelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateChannelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateChannelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"channel.name", (Object)String.valueOf(request.getChannel().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteChannelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteChannelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getProviderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getProviderMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listProvidersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listProvidersMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getChannelConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getChannelConnectionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listChannelConnectionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listChannelConnectionsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings createChannelConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createChannelConnectionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings deleteChannelConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteChannelConnectionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getGoogleChannelConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getGoogleChannelConfigMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateGoogleChannelConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateGoogleChannelConfigMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"google_channel_config.name", (Object)String.valueOf(request.getGoogleChannelConfig().getName()));
            return params.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        this.getTriggerCallable = callableFactory.createUnaryCallable(getTriggerTransportSettings, settings.getTriggerSettings(), clientContext);
        this.listTriggersCallable = callableFactory.createUnaryCallable(listTriggersTransportSettings, settings.listTriggersSettings(), clientContext);
        this.listTriggersPagedCallable = callableFactory.createPagedCallable(listTriggersTransportSettings, settings.listTriggersSettings(), clientContext);
        this.createTriggerCallable = callableFactory.createUnaryCallable(createTriggerTransportSettings, settings.createTriggerSettings(), clientContext);
        this.createTriggerOperationCallable = callableFactory.createOperationCallable(createTriggerTransportSettings, settings.createTriggerOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateTriggerCallable = callableFactory.createUnaryCallable(updateTriggerTransportSettings, settings.updateTriggerSettings(), clientContext);
        this.updateTriggerOperationCallable = callableFactory.createOperationCallable(updateTriggerTransportSettings, settings.updateTriggerOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteTriggerCallable = callableFactory.createUnaryCallable(deleteTriggerTransportSettings, settings.deleteTriggerSettings(), clientContext);
        this.deleteTriggerOperationCallable = callableFactory.createOperationCallable(deleteTriggerTransportSettings, settings.deleteTriggerOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getChannelCallable = callableFactory.createUnaryCallable(getChannelTransportSettings, settings.getChannelSettings(), clientContext);
        this.listChannelsCallable = callableFactory.createUnaryCallable(listChannelsTransportSettings, settings.listChannelsSettings(), clientContext);
        this.listChannelsPagedCallable = callableFactory.createPagedCallable(listChannelsTransportSettings, settings.listChannelsSettings(), clientContext);
        this.createChannelCallable = callableFactory.createUnaryCallable(createChannelTransportSettings, settings.createChannelSettings(), clientContext);
        this.createChannelOperationCallable = callableFactory.createOperationCallable(createChannelTransportSettings, settings.createChannelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateChannelCallable = callableFactory.createUnaryCallable(updateChannelTransportSettings, settings.updateChannelSettings(), clientContext);
        this.updateChannelOperationCallable = callableFactory.createOperationCallable(updateChannelTransportSettings, settings.updateChannelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteChannelCallable = callableFactory.createUnaryCallable(deleteChannelTransportSettings, settings.deleteChannelSettings(), clientContext);
        this.deleteChannelOperationCallable = callableFactory.createOperationCallable(deleteChannelTransportSettings, settings.deleteChannelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getProviderCallable = callableFactory.createUnaryCallable(getProviderTransportSettings, settings.getProviderSettings(), clientContext);
        this.listProvidersCallable = callableFactory.createUnaryCallable(listProvidersTransportSettings, settings.listProvidersSettings(), clientContext);
        this.listProvidersPagedCallable = callableFactory.createPagedCallable(listProvidersTransportSettings, settings.listProvidersSettings(), clientContext);
        this.getChannelConnectionCallable = callableFactory.createUnaryCallable(getChannelConnectionTransportSettings, settings.getChannelConnectionSettings(), clientContext);
        this.listChannelConnectionsCallable = callableFactory.createUnaryCallable(listChannelConnectionsTransportSettings, settings.listChannelConnectionsSettings(), clientContext);
        this.listChannelConnectionsPagedCallable = callableFactory.createPagedCallable(listChannelConnectionsTransportSettings, settings.listChannelConnectionsSettings(), clientContext);
        this.createChannelConnectionCallable = callableFactory.createUnaryCallable(createChannelConnectionTransportSettings, settings.createChannelConnectionSettings(), clientContext);
        this.createChannelConnectionOperationCallable = callableFactory.createOperationCallable(createChannelConnectionTransportSettings, settings.createChannelConnectionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteChannelConnectionCallable = callableFactory.createUnaryCallable(deleteChannelConnectionTransportSettings, settings.deleteChannelConnectionSettings(), clientContext);
        this.deleteChannelConnectionOperationCallable = callableFactory.createOperationCallable(deleteChannelConnectionTransportSettings, settings.deleteChannelConnectionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getGoogleChannelConfigCallable = callableFactory.createUnaryCallable(getGoogleChannelConfigTransportSettings, settings.getGoogleChannelConfigSettings(), clientContext);
        this.updateGoogleChannelConfigCallable = callableFactory.createUnaryCallable(updateGoogleChannelConfigTransportSettings, settings.updateGoogleChannelConfigSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetTriggerRequest, Trigger> getTriggerCallable() {
        return this.getTriggerCallable;
    }

    @Override
    public UnaryCallable<ListTriggersRequest, ListTriggersResponse> listTriggersCallable() {
        return this.listTriggersCallable;
    }

    @Override
    public UnaryCallable<ListTriggersRequest, EventarcClient.ListTriggersPagedResponse> listTriggersPagedCallable() {
        return this.listTriggersPagedCallable;
    }

    @Override
    public UnaryCallable<CreateTriggerRequest, Operation> createTriggerCallable() {
        return this.createTriggerCallable;
    }

    @Override
    public OperationCallable<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationCallable() {
        return this.createTriggerOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateTriggerRequest, Operation> updateTriggerCallable() {
        return this.updateTriggerCallable;
    }

    @Override
    public OperationCallable<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationCallable() {
        return this.updateTriggerOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteTriggerRequest, Operation> deleteTriggerCallable() {
        return this.deleteTriggerCallable;
    }

    @Override
    public OperationCallable<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationCallable() {
        return this.deleteTriggerOperationCallable;
    }

    @Override
    public UnaryCallable<GetChannelRequest, Channel> getChannelCallable() {
        return this.getChannelCallable;
    }

    @Override
    public UnaryCallable<ListChannelsRequest, ListChannelsResponse> listChannelsCallable() {
        return this.listChannelsCallable;
    }

    @Override
    public UnaryCallable<ListChannelsRequest, EventarcClient.ListChannelsPagedResponse> listChannelsPagedCallable() {
        return this.listChannelsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateChannelRequest, Operation> createChannelCallable() {
        return this.createChannelCallable;
    }

    @Override
    public OperationCallable<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationCallable() {
        return this.createChannelOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateChannelRequest, Operation> updateChannelCallable() {
        return this.updateChannelCallable;
    }

    @Override
    public OperationCallable<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationCallable() {
        return this.updateChannelOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteChannelRequest, Operation> deleteChannelCallable() {
        return this.deleteChannelCallable;
    }

    @Override
    public OperationCallable<DeleteChannelRequest, Channel, OperationMetadata> deleteChannelOperationCallable() {
        return this.deleteChannelOperationCallable;
    }

    @Override
    public UnaryCallable<GetProviderRequest, Provider> getProviderCallable() {
        return this.getProviderCallable;
    }

    @Override
    public UnaryCallable<ListProvidersRequest, ListProvidersResponse> listProvidersCallable() {
        return this.listProvidersCallable;
    }

    @Override
    public UnaryCallable<ListProvidersRequest, EventarcClient.ListProvidersPagedResponse> listProvidersPagedCallable() {
        return this.listProvidersPagedCallable;
    }

    @Override
    public UnaryCallable<GetChannelConnectionRequest, ChannelConnection> getChannelConnectionCallable() {
        return this.getChannelConnectionCallable;
    }

    @Override
    public UnaryCallable<ListChannelConnectionsRequest, ListChannelConnectionsResponse> listChannelConnectionsCallable() {
        return this.listChannelConnectionsCallable;
    }

    @Override
    public UnaryCallable<ListChannelConnectionsRequest, EventarcClient.ListChannelConnectionsPagedResponse> listChannelConnectionsPagedCallable() {
        return this.listChannelConnectionsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateChannelConnectionRequest, Operation> createChannelConnectionCallable() {
        return this.createChannelConnectionCallable;
    }

    @Override
    public OperationCallable<CreateChannelConnectionRequest, ChannelConnection, OperationMetadata> createChannelConnectionOperationCallable() {
        return this.createChannelConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteChannelConnectionRequest, Operation> deleteChannelConnectionCallable() {
        return this.deleteChannelConnectionCallable;
    }

    @Override
    public OperationCallable<DeleteChannelConnectionRequest, ChannelConnection, OperationMetadata> deleteChannelConnectionOperationCallable() {
        return this.deleteChannelConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<GetGoogleChannelConfigRequest, GoogleChannelConfig> getGoogleChannelConfigCallable() {
        return this.getGoogleChannelConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateGoogleChannelConfigRequest, GoogleChannelConfig> updateGoogleChannelConfigCallable() {
        return this.updateGoogleChannelConfigCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, EventarcClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

