/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.documentai.v1.BatchProcessMetadata;
import com.google.cloud.documentai.v1.BatchProcessRequest;
import com.google.cloud.documentai.v1.BatchProcessResponse;
import com.google.cloud.documentai.v1.ProcessRequest;
import com.google.cloud.documentai.v1.ProcessResponse;
import com.google.cloud.documentai.v1.ReviewDocumentOperationMetadata;
import com.google.cloud.documentai.v1.ReviewDocumentRequest;
import com.google.cloud.documentai.v1.ReviewDocumentResponse;
import com.google.cloud.documentai.v1.stub.DocumentProcessorServiceStub;
import com.google.cloud.documentai.v1.stub.DocumentProcessorServiceStubSettings;
import com.google.cloud.documentai.v1.stub.HttpJsonDocumentProcessorServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonDocumentProcessorServiceStub
extends DocumentProcessorServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(BatchProcessResponse.getDescriptor()).add(ReviewDocumentResponse.getDescriptor()).add(ReviewDocumentOperationMetadata.getDescriptor()).add(BatchProcessMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<ProcessRequest, ProcessResponse> processDocumentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.documentai.v1.DocumentProcessorService/ProcessDocument").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/processors/*}:process", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ProcessResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchProcessRequest, Operation> batchProcessDocumentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.documentai.v1.DocumentProcessorService/BatchProcessDocuments").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/processors/*}:batchProcess", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ReviewDocumentRequest, Operation> reviewDocumentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.documentai.v1.DocumentProcessorService/ReviewDocument").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{humanReviewConfig=projects/*/locations/*/processors/*/humanReviewConfig}:reviewDocument", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "humanReviewConfig", (Object)request.getHumanReviewConfig());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearHumanReviewConfig().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<ProcessRequest, ProcessResponse> processDocumentCallable;
    private final UnaryCallable<BatchProcessRequest, Operation> batchProcessDocumentsCallable;
    private final OperationCallable<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationCallable;
    private final UnaryCallable<ReviewDocumentRequest, Operation> reviewDocumentCallable;
    private final OperationCallable<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDocumentProcessorServiceStub create(DocumentProcessorServiceStubSettings settings) throws IOException {
        return new HttpJsonDocumentProcessorServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDocumentProcessorServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDocumentProcessorServiceStub(DocumentProcessorServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDocumentProcessorServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDocumentProcessorServiceStub(DocumentProcessorServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDocumentProcessorServiceStub(DocumentProcessorServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDocumentProcessorServiceCallableFactory());
    }

    protected HttpJsonDocumentProcessorServiceStub(DocumentProcessorServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings processDocumentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(processDocumentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings batchProcessDocumentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchProcessDocumentsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings reviewDocumentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(reviewDocumentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.processDocumentCallable = callableFactory.createUnaryCallable(processDocumentTransportSettings, settings.processDocumentSettings(), clientContext);
        this.batchProcessDocumentsCallable = callableFactory.createUnaryCallable(batchProcessDocumentsTransportSettings, settings.batchProcessDocumentsSettings(), clientContext);
        this.batchProcessDocumentsOperationCallable = callableFactory.createOperationCallable(batchProcessDocumentsTransportSettings, settings.batchProcessDocumentsOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.reviewDocumentCallable = callableFactory.createUnaryCallable(reviewDocumentTransportSettings, settings.reviewDocumentSettings(), clientContext);
        this.reviewDocumentOperationCallable = callableFactory.createOperationCallable(reviewDocumentTransportSettings, settings.reviewDocumentOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(processDocumentMethodDescriptor);
        methodDescriptors.add(batchProcessDocumentsMethodDescriptor);
        methodDescriptors.add(reviewDocumentMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ProcessRequest, ProcessResponse> processDocumentCallable() {
        return this.processDocumentCallable;
    }

    @Override
    public UnaryCallable<BatchProcessRequest, Operation> batchProcessDocumentsCallable() {
        return this.batchProcessDocumentsCallable;
    }

    @Override
    public OperationCallable<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationCallable() {
        return this.batchProcessDocumentsOperationCallable;
    }

    @Override
    public UnaryCallable<ReviewDocumentRequest, Operation> reviewDocumentCallable() {
        return this.reviewDocumentCallable;
    }

    @Override
    public OperationCallable<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationCallable() {
        return this.reviewDocumentOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

