/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta3;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.documentai.v1beta3.BatchProcessMetadata;
import com.google.cloud.documentai.v1beta3.BatchProcessRequest;
import com.google.cloud.documentai.v1beta3.BatchProcessResponse;
import com.google.cloud.documentai.v1beta3.DocumentProcessorServiceSettings;
import com.google.cloud.documentai.v1beta3.HumanReviewConfigName;
import com.google.cloud.documentai.v1beta3.ProcessRequest;
import com.google.cloud.documentai.v1beta3.ProcessResponse;
import com.google.cloud.documentai.v1beta3.ProcessorName;
import com.google.cloud.documentai.v1beta3.ReviewDocumentOperationMetadata;
import com.google.cloud.documentai.v1beta3.ReviewDocumentRequest;
import com.google.cloud.documentai.v1beta3.ReviewDocumentResponse;
import com.google.cloud.documentai.v1beta3.stub.DocumentProcessorServiceStub;
import com.google.cloud.documentai.v1beta3.stub.DocumentProcessorServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DocumentProcessorServiceClient
implements BackgroundResource {
    private final DocumentProcessorServiceSettings settings;
    private final DocumentProcessorServiceStub stub;
    private final OperationsClient operationsClient;

    public static final DocumentProcessorServiceClient create() throws IOException {
        return DocumentProcessorServiceClient.create(DocumentProcessorServiceSettings.newBuilder().build());
    }

    public static final DocumentProcessorServiceClient create(DocumentProcessorServiceSettings settings) throws IOException {
        return new DocumentProcessorServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DocumentProcessorServiceClient create(DocumentProcessorServiceStub stub) {
        return new DocumentProcessorServiceClient(stub);
    }

    protected DocumentProcessorServiceClient(DocumentProcessorServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DocumentProcessorServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DocumentProcessorServiceClient(DocumentProcessorServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DocumentProcessorServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DocumentProcessorServiceStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ProcessResponse processDocument(ProcessorName name) {
        ProcessRequest request = ProcessRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.processDocument(request);
    }

    public final ProcessResponse processDocument(String name) {
        ProcessRequest request = ProcessRequest.newBuilder().setName(name).build();
        return this.processDocument(request);
    }

    public final ProcessResponse processDocument(ProcessRequest request) {
        return (ProcessResponse)this.processDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<ProcessRequest, ProcessResponse> processDocumentCallable() {
        return this.stub.processDocumentCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsAsync(ProcessorName name) {
        BatchProcessRequest request = BatchProcessRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.batchProcessDocumentsAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsAsync(String name) {
        BatchProcessRequest request = BatchProcessRequest.newBuilder().setName(name).build();
        return this.batchProcessDocumentsAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsAsync(BatchProcessRequest request) {
        return this.batchProcessDocumentsOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationCallable() {
        return this.stub.batchProcessDocumentsOperationCallable();
    }

    public final UnaryCallable<BatchProcessRequest, Operation> batchProcessDocumentsCallable() {
        return this.stub.batchProcessDocumentsCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentAsync(HumanReviewConfigName humanReviewConfig) {
        ReviewDocumentRequest request = ReviewDocumentRequest.newBuilder().setHumanReviewConfig(humanReviewConfig == null ? null : humanReviewConfig.toString()).build();
        return this.reviewDocumentAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentAsync(String humanReviewConfig) {
        ReviewDocumentRequest request = ReviewDocumentRequest.newBuilder().setHumanReviewConfig(humanReviewConfig).build();
        return this.reviewDocumentAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentAsync(ReviewDocumentRequest request) {
        return this.reviewDocumentOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationCallable() {
        return this.stub.reviewDocumentOperationCallable();
    }

    public final UnaryCallable<ReviewDocumentRequest, Operation> reviewDocumentCallable() {
        return this.stub.reviewDocumentCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

