/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dns;

import com.google.api.gax.paging.Page;
import com.google.cloud.FieldSelector;
import com.google.cloud.Service;
import com.google.cloud.dns.ChangeRequest;
import com.google.cloud.dns.ChangeRequestInfo;
import com.google.cloud.dns.DnsBatch;
import com.google.cloud.dns.DnsOptions;
import com.google.cloud.dns.Option;
import com.google.cloud.dns.ProjectInfo;
import com.google.cloud.dns.RecordSet;
import com.google.cloud.dns.Zone;
import com.google.cloud.dns.ZoneInfo;
import com.google.cloud.dns.spi.v1.DnsRpc;
import com.google.common.collect.ImmutableList;
import java.util.List;

public interface Dns
extends Service<DnsOptions> {
    public Zone create(ZoneInfo var1, ZoneOption ... var2);

    public Zone getZone(String var1, ZoneOption ... var2);

    public Page<Zone> listZones(ZoneListOption ... var1);

    public boolean delete(String var1);

    public Page<RecordSet> listRecordSets(String var1, RecordSetListOption ... var2);

    public ProjectInfo getProject(ProjectOption ... var1);

    public ChangeRequest applyChangeRequest(String var1, ChangeRequestInfo var2, ChangeRequestOption ... var3);

    public ChangeRequest getChangeRequest(String var1, String var2, ChangeRequestOption ... var3);

    public Page<ChangeRequest> listChangeRequests(String var1, ChangeRequestListOption ... var2);

    public DnsBatch batch();

    public static class ChangeRequestListOption
    extends Option {
        private static final long serialVersionUID = -900209143895376089L;

        ChangeRequestListOption(DnsRpc.Option option, Object value) {
            super(option, value);
        }

        public static ChangeRequestListOption fields(ChangeRequestField ... fields) {
            return new ChangeRequestListOption(DnsRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"changes", ChangeRequestField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }

        public static ChangeRequestListOption pageToken(String pageToken) {
            return new ChangeRequestListOption(DnsRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static ChangeRequestListOption pageSize(int pageSize) {
            return new ChangeRequestListOption(DnsRpc.Option.PAGE_SIZE, pageSize);
        }

        public static ChangeRequestListOption sortOrder(SortingOrder order) {
            return new ChangeRequestListOption(DnsRpc.Option.SORTING_ORDER, order.selector());
        }
    }

    public static class ChangeRequestOption
    extends Option {
        private static final long serialVersionUID = 1067273695061077782L;

        ChangeRequestOption(DnsRpc.Option option, Object value) {
            super(option, value);
        }

        public static ChangeRequestOption fields(ChangeRequestField ... fields) {
            return new ChangeRequestOption(DnsRpc.Option.FIELDS, FieldSelector.Helper.selector(ChangeRequestField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class ProjectOption
    extends Option {
        private static final long serialVersionUID = 6817937338218847748L;

        ProjectOption(DnsRpc.Option option, Object value) {
            super(option, value);
        }

        public static ProjectOption fields(ProjectField ... fields) {
            return new ProjectOption(DnsRpc.Option.FIELDS, FieldSelector.Helper.selector(ProjectField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class ZoneListOption
    extends Option {
        private static final long serialVersionUID = -2830645032124504717L;

        ZoneListOption(DnsRpc.Option option, Object value) {
            super(option, value);
        }

        public static ZoneListOption fields(ZoneField ... fields) {
            return new ZoneListOption(DnsRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"managedZones", ZoneField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }

        public static ZoneListOption pageToken(String pageToken) {
            return new ZoneListOption(DnsRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static ZoneListOption dnsName(String dnsName) {
            return new ZoneListOption(DnsRpc.Option.DNS_NAME, dnsName);
        }

        public static ZoneListOption pageSize(int pageSize) {
            return new ZoneListOption(DnsRpc.Option.PAGE_SIZE, pageSize);
        }
    }

    public static class ZoneOption
    extends Option {
        private static final long serialVersionUID = -8065564464895945037L;

        ZoneOption(DnsRpc.Option option, Object value) {
            super(option, value);
        }

        public static ZoneOption fields(ZoneField ... fields) {
            return new ZoneOption(DnsRpc.Option.FIELDS, FieldSelector.Helper.selector(ZoneField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }
    }

    public static class RecordSetListOption
    extends Option {
        private static final long serialVersionUID = 1009627025381096098L;

        RecordSetListOption(DnsRpc.Option option, Object value) {
            super(option, value);
        }

        public static RecordSetListOption fields(RecordSetField ... fields) {
            return new RecordSetListOption(DnsRpc.Option.FIELDS, FieldSelector.Helper.listSelector((String)"rrsets", RecordSetField.REQUIRED_FIELDS, (FieldSelector[])fields));
        }

        public static RecordSetListOption pageToken(String pageToken) {
            return new RecordSetListOption(DnsRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static RecordSetListOption pageSize(int pageSize) {
            return new RecordSetListOption(DnsRpc.Option.PAGE_SIZE, pageSize);
        }

        public static RecordSetListOption dnsName(String dnsName) {
            return new RecordSetListOption(DnsRpc.Option.NAME, dnsName);
        }

        public static RecordSetListOption type(RecordSet.Type type) {
            return new RecordSetListOption(DnsRpc.Option.DNS_TYPE, type.name());
        }
    }

    public static enum SortingOrder {
        DESCENDING,
        ASCENDING;


        public String selector() {
            return this.name().toLowerCase();
        }
    }

    public static enum ChangeRequestField implements FieldSelector
    {
        ID("id"),
        START_TIME("startTime"),
        STATUS("status"),
        ADDITIONS("additions"),
        DELETIONS("deletions");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private ChangeRequestField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)ID));
        }
    }

    public static enum RecordSetField implements FieldSelector
    {
        DNS_RECORDS("rrdatas"),
        NAME("name"),
        TTL("ttl"),
        TYPE("type");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private RecordSetField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)NAME), (Object)((Object)TYPE));
        }
    }

    public static enum ZoneField implements FieldSelector
    {
        CREATION_TIME("creationTime"),
        DESCRIPTION("description"),
        DNS_NAME("dnsName"),
        ZONE_ID("id"),
        NAME("name"),
        NAME_SERVER_SET("nameServerSet"),
        NAME_SERVERS("nameServers"),
        DNSSEC("dnssecConfig"),
        LABELS("labels");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private ZoneField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)NAME));
        }
    }

    public static enum ProjectField implements FieldSelector
    {
        PROJECT_ID("id"),
        PROJECT_NUMBER("number"),
        QUOTA("quota");

        static final List<? extends FieldSelector> REQUIRED_FIELDS;
        private final String selector;

        private ProjectField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static {
            REQUIRED_FIELDS = ImmutableList.of((Object)((Object)PROJECT_ID));
        }
    }
}

