/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dns;

import com.google.api.services.dns.model.ResourceRecordSet;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class RecordSet
implements Serializable {
    static final Function<ResourceRecordSet, RecordSet> FROM_PB_FUNCTION = new Function<ResourceRecordSet, RecordSet>(){

        public RecordSet apply(ResourceRecordSet pb) {
            return RecordSet.fromPb(pb);
        }
    };
    static final Function<RecordSet, ResourceRecordSet> TO_PB_FUNCTION = new Function<RecordSet, ResourceRecordSet>(){

        public ResourceRecordSet apply(RecordSet recordSet) {
            return recordSet.toPb();
        }
    };
    private static final long serialVersionUID = 8148009870800115261L;
    private final String name;
    private final List<String> rrdatas;
    private final Integer ttl;
    private final Type type;

    private RecordSet(Builder builder) {
        this.name = builder.name;
        this.rrdatas = ImmutableList.copyOf((Collection)builder.rrdatas);
        this.ttl = builder.ttl;
        this.type = builder.type;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Deprecated
    public static Builder builder(String name, Type type) {
        return RecordSet.newBuilder(name, type);
    }

    public static Builder newBuilder(String name, Type type) {
        return new Builder(name, type);
    }

    @Deprecated
    public String name() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public List<String> records() {
        return this.getRecords();
    }

    public List<String> getRecords() {
        return this.rrdatas;
    }

    @Deprecated
    public Integer ttl() {
        return this.getTtl();
    }

    public Integer getTtl() {
        return this.ttl;
    }

    @Deprecated
    public Type type() {
        return this.getType();
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.rrdatas, this.ttl, this.type});
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof RecordSet && Objects.equals(this.toPb(), ((RecordSet)obj).toPb());
    }

    ResourceRecordSet toPb() {
        ResourceRecordSet pb = new ResourceRecordSet();
        pb.setName(this.getName());
        pb.setRrdatas(this.getRecords());
        pb.setTtl(this.getTtl());
        pb.setType(this.getType().name());
        return pb;
    }

    static RecordSet fromPb(ResourceRecordSet pb) {
        Builder builder = RecordSet.newBuilder(pb.getName(), Type.valueOf(pb.getType()));
        if (pb.getRrdatas() != null) {
            builder.setRecords(pb.getRrdatas());
        }
        if (pb.getTtl() != null) {
            builder.setTtl(pb.getTtl(), TimeUnit.SECONDS);
        }
        return builder.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("rrdatas", this.getRecords()).add("ttl", (Object)this.getTtl()).add("type", (Object)this.getType()).toString();
    }

    public static class Builder {
        private List<String> rrdatas = new LinkedList<String>();
        private String name;
        private Integer ttl;
        private Type type;

        private Builder(String name, Type type) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        }

        private Builder(RecordSet record) {
            this.name = record.name;
            this.ttl = record.ttl;
            this.type = record.type;
            this.rrdatas.addAll(record.rrdatas);
        }

        public Builder addRecord(String record) {
            this.rrdatas.add((String)Preconditions.checkNotNull((Object)record));
            return this;
        }

        public Builder removeRecord(String record) {
            this.rrdatas.remove(Preconditions.checkNotNull((Object)record));
            return this;
        }

        public Builder clearRecords() {
            this.rrdatas.clear();
            return this;
        }

        @Deprecated
        public Builder records(List<String> records) {
            return this.setRecords(records);
        }

        public Builder setRecords(List<String> records) {
            this.rrdatas = Lists.newLinkedList((Iterable)((Iterable)Preconditions.checkNotNull(records)));
            return this;
        }

        @Deprecated
        public Builder name(String name) {
            return this.setName(name);
        }

        public Builder setName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        @Deprecated
        public Builder ttl(int duration, TimeUnit unit) {
            return this.setTtl(duration, unit);
        }

        public Builder setTtl(int duration, TimeUnit unit) {
            Preconditions.checkArgument((duration >= 0 ? 1 : 0) != 0, (String)"Duration cannot be negative. The supplied value was %s.", (Object[])new Object[]{duration});
            Preconditions.checkNotNull((Object)((Object)unit));
            long converted = unit.toSeconds(duration);
            this.ttl = Ints.checkedCast((long)converted);
            return this;
        }

        @Deprecated
        public Builder type(Type type) {
            return this.setType(type);
        }

        public Builder setType(Type type) {
            this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
            return this;
        }

        public RecordSet build() {
            return new RecordSet(this);
        }
    }

    public static enum Type {
        A,
        AAAA,
        CNAME,
        MX,
        NAPTR,
        NS,
        PTR,
        SOA,
        SPF,
        SRV,
        TXT;

    }
}

