/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dns;

import com.google.api.services.dns.model.ManagedZone;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;

public class ZoneInfo
implements Serializable {
    private static final long serialVersionUID = -5313169712036079818L;
    private final String name;
    private final String generatedId;
    private final Long creationTimeMillis;
    private final String dnsName;
    private final String description;
    private final String nameServerSet;
    private final List<String> nameServers;

    ZoneInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.generatedId = builder.generatedId;
        this.creationTimeMillis = builder.creationTimeMillis;
        this.dnsName = builder.dnsName;
        this.description = builder.description;
        this.nameServerSet = builder.nameServerSet;
        this.nameServers = builder.nameServers == null ? null : ImmutableList.copyOf((Collection)builder.nameServers);
    }

    public static ZoneInfo of(String name, String dnsName, String description) {
        return new BuilderImpl(name).setDnsName(dnsName).setDescription(description).build();
    }

    public String getName() {
        return this.name;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public Long getCreationTimeMillis() {
        return this.creationTimeMillis;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNameServerSet() {
        return this.nameServerSet;
    }

    public List<String> getNameServers() {
        return this.nameServers == null ? ImmutableList.of() : this.nameServers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    ManagedZone toPb() {
        ManagedZone pb = new ManagedZone();
        pb.setDescription(this.getDescription());
        pb.setDnsName(this.getDnsName());
        if (this.getGeneratedId() != null) {
            pb.setId(new BigInteger(this.getGeneratedId()));
        }
        pb.setName(this.getName());
        pb.setNameServers(this.nameServers);
        pb.setNameServerSet(this.getNameServerSet());
        if (this.getCreationTimeMillis() != null) {
            pb.setCreationTime(ISODateTimeFormat.dateTime().withZoneUTC().print(this.getCreationTimeMillis().longValue()));
        }
        return pb;
    }

    static ZoneInfo fromPb(ManagedZone pb) {
        BuilderImpl builder = new BuilderImpl(pb.getName());
        if (pb.getDescription() != null) {
            ((Builder)builder).setDescription(pb.getDescription());
        }
        if (pb.getDnsName() != null) {
            ((Builder)builder).setDnsName(pb.getDnsName());
        }
        if (pb.getId() != null) {
            ((Builder)builder).setGeneratedId(pb.getId().toString());
        }
        if (pb.getNameServers() != null) {
            ((Builder)builder).setNameServers(pb.getNameServers());
        }
        if (pb.getNameServerSet() != null) {
            ((Builder)builder).setNameServerSet(pb.getNameServerSet());
        }
        if (pb.getCreationTime() != null) {
            ((Builder)builder).setCreationTimeMillis(DateTime.parse((String)pb.getCreationTime()).getMillis());
        }
        return ((Builder)builder).build();
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(ZoneInfo.class) && Objects.equals(this.toPb(), ((ZoneInfo)obj).toPb());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.generatedId, this.creationTimeMillis, this.dnsName, this.description, this.nameServerSet, this.nameServers);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("generatedId", (Object)this.getGeneratedId()).add("description", (Object)this.getDescription()).add("dnsName", (Object)this.getDnsName()).add("nameServerSet", (Object)this.getNameServerSet()).add("nameServers", this.getNameServers()).add("creationTimeMillis", (Object)this.getCreationTimeMillis()).toString();
    }

    static class BuilderImpl
    extends Builder {
        private String name;
        private String generatedId;
        private Long creationTimeMillis;
        private String dnsName;
        private String description;
        private String nameServerSet;
        private List<String> nameServers;

        private BuilderImpl(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        BuilderImpl(ZoneInfo info) {
            this.name = info.name;
            this.generatedId = info.generatedId;
            this.creationTimeMillis = info.creationTimeMillis;
            this.dnsName = info.dnsName;
            this.description = info.description;
            this.nameServerSet = info.nameServerSet;
            if (info.nameServers != null) {
                this.nameServers = ImmutableList.copyOf((Collection)info.nameServers);
            }
        }

        @Override
        public Builder setName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        Builder setCreationTimeMillis(long creationTimeMillis) {
            this.creationTimeMillis = creationTimeMillis;
            return this;
        }

        @Override
        public Builder setDnsName(String dnsName) {
            this.dnsName = (String)Preconditions.checkNotNull((Object)dnsName);
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description);
            return this;
        }

        @Override
        Builder setNameServerSet(String nameServerSet) {
            this.nameServerSet = (String)Preconditions.checkNotNull((Object)nameServerSet);
            return this;
        }

        @Override
        Builder setNameServers(List<String> nameServers) {
            Preconditions.checkNotNull(nameServers);
            this.nameServers = Lists.newLinkedList(nameServers);
            return this;
        }

        @Override
        public ZoneInfo build() {
            return new ZoneInfo(this);
        }
    }

    public static abstract class Builder {
        public abstract Builder setName(String var1);

        abstract Builder setGeneratedId(String var1);

        abstract Builder setCreationTimeMillis(long var1);

        public abstract Builder setDnsName(String var1);

        public abstract Builder setDescription(String var1);

        abstract Builder setNameServerSet(String var1);

        abstract Builder setNameServers(List<String> var1);

        public abstract ZoneInfo build();
    }
}

