/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dns;

import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.google.api.services.dns.model.Project;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;

public class ProjectInfo
implements Serializable {
    private static final long serialVersionUID = 8696578863323485036L;
    private final String id;
    private final BigInteger number;
    private final Quota quota;

    private ProjectInfo(Builder builder) {
        this.id = builder.id;
        this.number = builder.number;
        this.quota = builder.quota;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    public Quota quota() {
        return this.getQuota();
    }

    public Quota getQuota() {
        return this.quota;
    }

    BigInteger getNumber() {
        return this.number;
    }

    @Deprecated
    String id() {
        return this.getId();
    }

    String getId() {
        return this.id;
    }

    Project toPb() {
        Project pb = new Project();
        pb.setId(this.id);
        pb.setNumber(this.number);
        if (this.quota != null) {
            pb.setQuota(this.quota.toPb());
        }
        return pb;
    }

    static ProjectInfo fromPb(Project pb) {
        Builder builder = ProjectInfo.newBuilder();
        if (pb.getId() != null) {
            builder.setId(pb.getId());
        }
        if (pb.getNumber() != null) {
            builder.setNumber(pb.getNumber());
        }
        if (pb.getQuota() != null) {
            builder.setQuota(Quota.fromPb(pb.getQuota()));
        }
        return builder.build();
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(ProjectInfo.class) && this.toPb().equals((Object)((ProjectInfo)obj).toPb());
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.number, this.quota);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("number", (Object)this.number).add("quota", (Object)this.quota).toString();
    }

    static class Builder {
        private String id;
        private BigInteger number;
        private Quota quota;

        private Builder() {
        }

        Builder setId(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id);
            return this;
        }

        Builder setNumber(BigInteger number) {
            this.number = (BigInteger)Preconditions.checkNotNull((Object)number);
            return this;
        }

        Builder setQuota(Quota quota) {
            this.quota = (Quota)Preconditions.checkNotNull((Object)quota);
            return this;
        }

        ProjectInfo build() {
            return new ProjectInfo(this);
        }
    }

    public static class Quota
    implements Serializable {
        private static final long serialVersionUID = 6854685970605363639L;
        private final int zones;
        private final int resourceRecordsPerRrset;
        private final int rrsetAdditionsPerChange;
        private final int rrsetDeletionsPerChange;
        private final int rrsetsPerZone;
        private final int totalRrdataSizePerChange;

        Quota(int zones, int resourceRecordsPerRrset, int rrsetAdditionsPerChange, int rrsetDeletionsPerChange, int rrsetsPerZone, int totalRrdataSizePerChange) {
            this.zones = zones;
            this.resourceRecordsPerRrset = resourceRecordsPerRrset;
            this.rrsetAdditionsPerChange = rrsetAdditionsPerChange;
            this.rrsetDeletionsPerChange = rrsetDeletionsPerChange;
            this.rrsetsPerZone = rrsetsPerZone;
            this.totalRrdataSizePerChange = totalRrdataSizePerChange;
        }

        @Deprecated
        public int zones() {
            return this.getZones();
        }

        public int getZones() {
            return this.zones;
        }

        @Deprecated
        public int resourceRecordsPerRrset() {
            return this.getResourceRecordsPerRrset();
        }

        public int getResourceRecordsPerRrset() {
            return this.resourceRecordsPerRrset;
        }

        @Deprecated
        public int rrsetAdditionsPerChange() {
            return this.getRrsetAdditionsPerChange();
        }

        public int getRrsetAdditionsPerChange() {
            return this.rrsetAdditionsPerChange;
        }

        @Deprecated
        public int rrsetDeletionsPerChange() {
            return this.getRrsetDeletionsPerChange();
        }

        public int getRrsetDeletionsPerChange() {
            return this.rrsetDeletionsPerChange;
        }

        @Deprecated
        public int rrsetsPerZone() {
            return this.getRrsetsPerZone();
        }

        public int getRrsetsPerZone() {
            return this.rrsetsPerZone;
        }

        @Deprecated
        public int totalRrdataSizePerChange() {
            return this.getTotalRrdataSizePerChange();
        }

        public int getTotalRrdataSizePerChange() {
            return this.totalRrdataSizePerChange;
        }

        public boolean equals(Object other) {
            return other instanceof Quota && this.toPb().equals((Object)((Quota)other).toPb());
        }

        public int hashCode() {
            return Objects.hash(this.zones, this.resourceRecordsPerRrset, this.rrsetAdditionsPerChange, this.rrsetDeletionsPerChange, this.rrsetsPerZone, this.totalRrdataSizePerChange);
        }

        com.google.api.services.dns.model.Quota toPb() {
            com.google.api.services.dns.model.Quota pb = new com.google.api.services.dns.model.Quota();
            pb.setManagedZones(Integer.valueOf(this.zones));
            pb.setResourceRecordsPerRrset(Integer.valueOf(this.resourceRecordsPerRrset));
            pb.setRrsetAdditionsPerChange(Integer.valueOf(this.rrsetAdditionsPerChange));
            pb.setRrsetDeletionsPerChange(Integer.valueOf(this.rrsetDeletionsPerChange));
            pb.setRrsetsPerManagedZone(Integer.valueOf(this.rrsetsPerZone));
            pb.setTotalRrdataSizePerChange(Integer.valueOf(this.totalRrdataSizePerChange));
            return pb;
        }

        static Quota fromPb(com.google.api.services.dns.model.Quota pb) {
            return new Quota(pb.getManagedZones(), pb.getResourceRecordsPerRrset(), pb.getRrsetAdditionsPerChange(), pb.getRrsetDeletionsPerChange(), pb.getRrsetsPerManagedZone(), pb.getTotalRrdataSizePerChange());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("zones", this.zones).add("resourceRecordsPerRrset", this.resourceRecordsPerRrset).add("rrsetAdditionsPerChange", this.rrsetAdditionsPerChange).add("rrsetDeletionsPerChange", this.rrsetDeletionsPerChange).add("rrsetsPerZone", this.rrsetsPerZone).add("totalRrdataSizePerChange", this.totalRrdataSizePerChange).toString();
        }
    }
}

