/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dns.testing;

import com.google.api.services.dns.model.Change;
import com.google.api.services.dns.model.ManagedZone;
import com.google.api.services.dns.model.Project;
import com.google.api.services.dns.model.ResourceRecordSet;
import java.util.HashMap;
import java.util.Map;

class OptionParsers {
    private OptionParsers() {
    }

    static Map<String, Object> parseListZonesOptions(String query) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (query != null) {
            String[] args;
            block12: for (String arg : args = query.split("&")) {
                String[] argEntry = arg.split("=");
                switch (argEntry[0]) {
                    case "fields": {
                        String replaced = argEntry[1].replace("managedZones(", ",");
                        replaced = replaced.replace(")", ",");
                        options.put("fields", replaced.split(","));
                        continue block12;
                    }
                    case "dnsName": {
                        options.put("dnsName", argEntry[1]);
                        continue block12;
                    }
                    case "pageToken": {
                        options.put("pageToken", argEntry[1]);
                        continue block12;
                    }
                    case "maxResults": {
                        options.put("maxResults", argEntry[1]);
                        continue block12;
                    }
                }
            }
        }
        return options;
    }

    static String[] parseGetOptions(String query) {
        if (query != null) {
            String[] args;
            for (String arg : args = query.split("&")) {
                String[] argEntry = arg.split("=");
                if (!argEntry[0].equals("fields")) continue;
                return argEntry[1].split(",");
            }
        }
        return new String[0];
    }

    static ManagedZone extractFields(ManagedZone fullZone, String ... fields) {
        if (fields == null || fields.length == 0) {
            return fullZone;
        }
        ManagedZone managedZone = new ManagedZone();
        String[] arr$ = fields;
        int len$ = arr$.length;
        block18: for (int i$ = 0; i$ < len$; ++i$) {
            String field;
            switch (field = arr$[i$]) {
                case "creationTime": {
                    managedZone.setCreationTime(fullZone.getCreationTime());
                    continue block18;
                }
                case "description": {
                    managedZone.setDescription(fullZone.getDescription());
                    continue block18;
                }
                case "dnsName": {
                    managedZone.setDnsName(fullZone.getDnsName());
                    continue block18;
                }
                case "id": {
                    managedZone.setId(fullZone.getId());
                    continue block18;
                }
                case "name": {
                    managedZone.setName(fullZone.getName());
                    continue block18;
                }
                case "nameServerSet": {
                    managedZone.setNameServerSet(fullZone.getNameServerSet());
                    continue block18;
                }
                case "nameServers": {
                    managedZone.setNameServers(fullZone.getNameServers());
                    continue block18;
                }
            }
        }
        return managedZone;
    }

    static Change extractFields(Change fullChange, String ... fields) {
        if (fields == null || fields.length == 0) {
            return fullChange;
        }
        Change change = new Change();
        String[] arr$ = fields;
        int len$ = arr$.length;
        block14: for (int i$ = 0; i$ < len$; ++i$) {
            String field;
            switch (field = arr$[i$]) {
                case "additions": {
                    change.setAdditions(fullChange.getAdditions());
                    continue block14;
                }
                case "deletions": {
                    change.setDeletions(fullChange.getDeletions());
                    continue block14;
                }
                case "id": {
                    change.setId(fullChange.getId());
                    continue block14;
                }
                case "startTime": {
                    change.setStartTime(fullChange.getStartTime());
                    continue block14;
                }
                case "status": {
                    change.setStatus(fullChange.getStatus());
                    continue block14;
                }
            }
        }
        return change;
    }

    static Project extractFields(Project fullProject, String ... fields) {
        if (fields == null || fields.length == 0) {
            return fullProject;
        }
        Project project = new Project();
        String[] arr$ = fields;
        int len$ = arr$.length;
        block10: for (int i$ = 0; i$ < len$; ++i$) {
            String field;
            switch (field = arr$[i$]) {
                case "id": {
                    project.setId(fullProject.getId());
                    continue block10;
                }
                case "number": {
                    project.setNumber(fullProject.getNumber());
                    continue block10;
                }
                case "quota": {
                    project.setQuota(fullProject.getQuota());
                    continue block10;
                }
            }
        }
        return project;
    }

    static ResourceRecordSet extractFields(ResourceRecordSet fullRecord, String ... fields) {
        if (fields == null || fields.length == 0) {
            return fullRecord;
        }
        ResourceRecordSet recordSet = new ResourceRecordSet();
        String[] arr$ = fields;
        int len$ = arr$.length;
        block12: for (int i$ = 0; i$ < len$; ++i$) {
            String field;
            switch (field = arr$[i$]) {
                case "name": {
                    recordSet.setName(fullRecord.getName());
                    continue block12;
                }
                case "rrdatas": {
                    recordSet.setRrdatas(fullRecord.getRrdatas());
                    continue block12;
                }
                case "type": {
                    recordSet.setType(fullRecord.getType());
                    continue block12;
                }
                case "ttl": {
                    recordSet.setTtl(fullRecord.getTtl());
                    continue block12;
                }
            }
        }
        return recordSet;
    }

    static Map<String, Object> parseListChangesOptions(String query) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (query != null) {
            String[] args;
            block14: for (String arg : args = query.split("&")) {
                String[] argEntry = arg.split("=");
                switch (argEntry[0]) {
                    case "fields": {
                        String replaced = argEntry[1].replace("changes(", ",").replace(")", ",");
                        options.put("fields", replaced.split(","));
                        continue block14;
                    }
                    case "pageToken": {
                        options.put("pageToken", argEntry[1]);
                        continue block14;
                    }
                    case "sortBy": {
                        options.put("sortBy", argEntry[1]);
                        continue block14;
                    }
                    case "sortOrder": {
                        options.put("sortOrder", argEntry[1]);
                        continue block14;
                    }
                    case "maxResults": {
                        options.put("maxResults", argEntry[1]);
                        continue block14;
                    }
                }
            }
        }
        return options;
    }

    static Map<String, Object> parseListDnsRecordsOptions(String query) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (query != null) {
            String[] args;
            block14: for (String arg : args = query.split("&")) {
                String[] argEntry = arg.split("=");
                switch (argEntry[0]) {
                    case "fields": {
                        String replace = argEntry[1].replace("rrsets(", ",");
                        replace = replace.replace(")", ",");
                        options.put("fields", replace.split(","));
                        continue block14;
                    }
                    case "name": {
                        options.put("name", argEntry[1]);
                        continue block14;
                    }
                    case "type": {
                        options.put("type", argEntry[1]);
                        continue block14;
                    }
                    case "pageToken": {
                        options.put("pageToken", argEntry[1]);
                        continue block14;
                    }
                    case "maxResults": {
                        options.put("maxResults", argEntry[1]);
                        continue block14;
                    }
                }
            }
        }
        return options;
    }
}

