/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.clouddms.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.clouddms.v1.ConnectionProfile;
import com.google.cloud.clouddms.v1.CreateConnectionProfileRequest;
import com.google.cloud.clouddms.v1.CreateMigrationJobRequest;
import com.google.cloud.clouddms.v1.DataMigrationServiceClient;
import com.google.cloud.clouddms.v1.DeleteConnectionProfileRequest;
import com.google.cloud.clouddms.v1.DeleteMigrationJobRequest;
import com.google.cloud.clouddms.v1.GenerateSshScriptRequest;
import com.google.cloud.clouddms.v1.GetConnectionProfileRequest;
import com.google.cloud.clouddms.v1.GetMigrationJobRequest;
import com.google.cloud.clouddms.v1.ListConnectionProfilesRequest;
import com.google.cloud.clouddms.v1.ListConnectionProfilesResponse;
import com.google.cloud.clouddms.v1.ListMigrationJobsRequest;
import com.google.cloud.clouddms.v1.ListMigrationJobsResponse;
import com.google.cloud.clouddms.v1.MigrationJob;
import com.google.cloud.clouddms.v1.OperationMetadata;
import com.google.cloud.clouddms.v1.PromoteMigrationJobRequest;
import com.google.cloud.clouddms.v1.RestartMigrationJobRequest;
import com.google.cloud.clouddms.v1.ResumeMigrationJobRequest;
import com.google.cloud.clouddms.v1.SshScript;
import com.google.cloud.clouddms.v1.StartMigrationJobRequest;
import com.google.cloud.clouddms.v1.StopMigrationJobRequest;
import com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest;
import com.google.cloud.clouddms.v1.UpdateMigrationJobRequest;
import com.google.cloud.clouddms.v1.VerifyMigrationJobRequest;
import com.google.cloud.clouddms.v1.stub.DataMigrationServiceStub;
import com.google.cloud.clouddms.v1.stub.GrpcDataMigrationServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class DataMigrationServiceStubSettings
extends StubSettings<DataMigrationServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListMigrationJobsRequest, ListMigrationJobsResponse, DataMigrationServiceClient.ListMigrationJobsPagedResponse> listMigrationJobsSettings;
    private final UnaryCallSettings<GetMigrationJobRequest, MigrationJob> getMigrationJobSettings;
    private final UnaryCallSettings<CreateMigrationJobRequest, Operation> createMigrationJobSettings;
    private final OperationCallSettings<CreateMigrationJobRequest, MigrationJob, OperationMetadata> createMigrationJobOperationSettings;
    private final UnaryCallSettings<UpdateMigrationJobRequest, Operation> updateMigrationJobSettings;
    private final OperationCallSettings<UpdateMigrationJobRequest, MigrationJob, OperationMetadata> updateMigrationJobOperationSettings;
    private final UnaryCallSettings<DeleteMigrationJobRequest, Operation> deleteMigrationJobSettings;
    private final OperationCallSettings<DeleteMigrationJobRequest, Empty, OperationMetadata> deleteMigrationJobOperationSettings;
    private final UnaryCallSettings<StartMigrationJobRequest, Operation> startMigrationJobSettings;
    private final OperationCallSettings<StartMigrationJobRequest, MigrationJob, OperationMetadata> startMigrationJobOperationSettings;
    private final UnaryCallSettings<StopMigrationJobRequest, Operation> stopMigrationJobSettings;
    private final OperationCallSettings<StopMigrationJobRequest, MigrationJob, OperationMetadata> stopMigrationJobOperationSettings;
    private final UnaryCallSettings<ResumeMigrationJobRequest, Operation> resumeMigrationJobSettings;
    private final OperationCallSettings<ResumeMigrationJobRequest, MigrationJob, OperationMetadata> resumeMigrationJobOperationSettings;
    private final UnaryCallSettings<PromoteMigrationJobRequest, Operation> promoteMigrationJobSettings;
    private final OperationCallSettings<PromoteMigrationJobRequest, MigrationJob, OperationMetadata> promoteMigrationJobOperationSettings;
    private final UnaryCallSettings<VerifyMigrationJobRequest, Operation> verifyMigrationJobSettings;
    private final OperationCallSettings<VerifyMigrationJobRequest, MigrationJob, OperationMetadata> verifyMigrationJobOperationSettings;
    private final UnaryCallSettings<RestartMigrationJobRequest, Operation> restartMigrationJobSettings;
    private final OperationCallSettings<RestartMigrationJobRequest, MigrationJob, OperationMetadata> restartMigrationJobOperationSettings;
    private final UnaryCallSettings<GenerateSshScriptRequest, SshScript> generateSshScriptSettings;
    private final PagedCallSettings<ListConnectionProfilesRequest, ListConnectionProfilesResponse, DataMigrationServiceClient.ListConnectionProfilesPagedResponse> listConnectionProfilesSettings;
    private final UnaryCallSettings<GetConnectionProfileRequest, ConnectionProfile> getConnectionProfileSettings;
    private final UnaryCallSettings<CreateConnectionProfileRequest, Operation> createConnectionProfileSettings;
    private final OperationCallSettings<CreateConnectionProfileRequest, ConnectionProfile, OperationMetadata> createConnectionProfileOperationSettings;
    private final UnaryCallSettings<UpdateConnectionProfileRequest, Operation> updateConnectionProfileSettings;
    private final OperationCallSettings<UpdateConnectionProfileRequest, ConnectionProfile, OperationMetadata> updateConnectionProfileOperationSettings;
    private final UnaryCallSettings<DeleteConnectionProfileRequest, Operation> deleteConnectionProfileSettings;
    private final OperationCallSettings<DeleteConnectionProfileRequest, Empty, OperationMetadata> deleteConnectionProfileOperationSettings;
    private static final PagedListDescriptor<ListMigrationJobsRequest, ListMigrationJobsResponse, MigrationJob> LIST_MIGRATION_JOBS_PAGE_STR_DESC = new PagedListDescriptor<ListMigrationJobsRequest, ListMigrationJobsResponse, MigrationJob>(){

        public String emptyToken() {
            return "";
        }

        public ListMigrationJobsRequest injectToken(ListMigrationJobsRequest payload, String token) {
            return ListMigrationJobsRequest.newBuilder((ListMigrationJobsRequest)payload).setPageToken(token).build();
        }

        public ListMigrationJobsRequest injectPageSize(ListMigrationJobsRequest payload, int pageSize) {
            return ListMigrationJobsRequest.newBuilder((ListMigrationJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMigrationJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMigrationJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MigrationJob> extractResources(ListMigrationJobsResponse payload) {
            return payload.getMigrationJobsList() == null ? ImmutableList.of() : payload.getMigrationJobsList();
        }
    };
    private static final PagedListDescriptor<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile> LIST_CONNECTION_PROFILES_PAGE_STR_DESC = new PagedListDescriptor<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile>(){

        public String emptyToken() {
            return "";
        }

        public ListConnectionProfilesRequest injectToken(ListConnectionProfilesRequest payload, String token) {
            return ListConnectionProfilesRequest.newBuilder((ListConnectionProfilesRequest)payload).setPageToken(token).build();
        }

        public ListConnectionProfilesRequest injectPageSize(ListConnectionProfilesRequest payload, int pageSize) {
            return ListConnectionProfilesRequest.newBuilder((ListConnectionProfilesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConnectionProfilesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConnectionProfilesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ConnectionProfile> extractResources(ListConnectionProfilesResponse payload) {
            return payload.getConnectionProfilesList() == null ? ImmutableList.of() : payload.getConnectionProfilesList();
        }
    };
    private static final PagedListResponseFactory<ListMigrationJobsRequest, ListMigrationJobsResponse, DataMigrationServiceClient.ListMigrationJobsPagedResponse> LIST_MIGRATION_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<ListMigrationJobsRequest, ListMigrationJobsResponse, DataMigrationServiceClient.ListMigrationJobsPagedResponse>(){

        public ApiFuture<DataMigrationServiceClient.ListMigrationJobsPagedResponse> getFuturePagedResponse(UnaryCallable<ListMigrationJobsRequest, ListMigrationJobsResponse> callable, ListMigrationJobsRequest request, ApiCallContext context, ApiFuture<ListMigrationJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MIGRATION_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataMigrationServiceClient.ListMigrationJobsPagedResponse.createAsync((PageContext<ListMigrationJobsRequest, ListMigrationJobsResponse, MigrationJob>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListConnectionProfilesRequest, ListConnectionProfilesResponse, DataMigrationServiceClient.ListConnectionProfilesPagedResponse> LIST_CONNECTION_PROFILES_PAGE_STR_FACT = new PagedListResponseFactory<ListConnectionProfilesRequest, ListConnectionProfilesResponse, DataMigrationServiceClient.ListConnectionProfilesPagedResponse>(){

        public ApiFuture<DataMigrationServiceClient.ListConnectionProfilesPagedResponse> getFuturePagedResponse(UnaryCallable<ListConnectionProfilesRequest, ListConnectionProfilesResponse> callable, ListConnectionProfilesRequest request, ApiCallContext context, ApiFuture<ListConnectionProfilesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONNECTION_PROFILES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataMigrationServiceClient.ListConnectionProfilesPagedResponse.createAsync((PageContext<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListMigrationJobsRequest, ListMigrationJobsResponse, DataMigrationServiceClient.ListMigrationJobsPagedResponse> listMigrationJobsSettings() {
        return this.listMigrationJobsSettings;
    }

    public UnaryCallSettings<GetMigrationJobRequest, MigrationJob> getMigrationJobSettings() {
        return this.getMigrationJobSettings;
    }

    public UnaryCallSettings<CreateMigrationJobRequest, Operation> createMigrationJobSettings() {
        return this.createMigrationJobSettings;
    }

    public OperationCallSettings<CreateMigrationJobRequest, MigrationJob, OperationMetadata> createMigrationJobOperationSettings() {
        return this.createMigrationJobOperationSettings;
    }

    public UnaryCallSettings<UpdateMigrationJobRequest, Operation> updateMigrationJobSettings() {
        return this.updateMigrationJobSettings;
    }

    public OperationCallSettings<UpdateMigrationJobRequest, MigrationJob, OperationMetadata> updateMigrationJobOperationSettings() {
        return this.updateMigrationJobOperationSettings;
    }

    public UnaryCallSettings<DeleteMigrationJobRequest, Operation> deleteMigrationJobSettings() {
        return this.deleteMigrationJobSettings;
    }

    public OperationCallSettings<DeleteMigrationJobRequest, Empty, OperationMetadata> deleteMigrationJobOperationSettings() {
        return this.deleteMigrationJobOperationSettings;
    }

    public UnaryCallSettings<StartMigrationJobRequest, Operation> startMigrationJobSettings() {
        return this.startMigrationJobSettings;
    }

    public OperationCallSettings<StartMigrationJobRequest, MigrationJob, OperationMetadata> startMigrationJobOperationSettings() {
        return this.startMigrationJobOperationSettings;
    }

    public UnaryCallSettings<StopMigrationJobRequest, Operation> stopMigrationJobSettings() {
        return this.stopMigrationJobSettings;
    }

    public OperationCallSettings<StopMigrationJobRequest, MigrationJob, OperationMetadata> stopMigrationJobOperationSettings() {
        return this.stopMigrationJobOperationSettings;
    }

    public UnaryCallSettings<ResumeMigrationJobRequest, Operation> resumeMigrationJobSettings() {
        return this.resumeMigrationJobSettings;
    }

    public OperationCallSettings<ResumeMigrationJobRequest, MigrationJob, OperationMetadata> resumeMigrationJobOperationSettings() {
        return this.resumeMigrationJobOperationSettings;
    }

    public UnaryCallSettings<PromoteMigrationJobRequest, Operation> promoteMigrationJobSettings() {
        return this.promoteMigrationJobSettings;
    }

    public OperationCallSettings<PromoteMigrationJobRequest, MigrationJob, OperationMetadata> promoteMigrationJobOperationSettings() {
        return this.promoteMigrationJobOperationSettings;
    }

    public UnaryCallSettings<VerifyMigrationJobRequest, Operation> verifyMigrationJobSettings() {
        return this.verifyMigrationJobSettings;
    }

    public OperationCallSettings<VerifyMigrationJobRequest, MigrationJob, OperationMetadata> verifyMigrationJobOperationSettings() {
        return this.verifyMigrationJobOperationSettings;
    }

    public UnaryCallSettings<RestartMigrationJobRequest, Operation> restartMigrationJobSettings() {
        return this.restartMigrationJobSettings;
    }

    public OperationCallSettings<RestartMigrationJobRequest, MigrationJob, OperationMetadata> restartMigrationJobOperationSettings() {
        return this.restartMigrationJobOperationSettings;
    }

    public UnaryCallSettings<GenerateSshScriptRequest, SshScript> generateSshScriptSettings() {
        return this.generateSshScriptSettings;
    }

    public PagedCallSettings<ListConnectionProfilesRequest, ListConnectionProfilesResponse, DataMigrationServiceClient.ListConnectionProfilesPagedResponse> listConnectionProfilesSettings() {
        return this.listConnectionProfilesSettings;
    }

    public UnaryCallSettings<GetConnectionProfileRequest, ConnectionProfile> getConnectionProfileSettings() {
        return this.getConnectionProfileSettings;
    }

    public UnaryCallSettings<CreateConnectionProfileRequest, Operation> createConnectionProfileSettings() {
        return this.createConnectionProfileSettings;
    }

    public OperationCallSettings<CreateConnectionProfileRequest, ConnectionProfile, OperationMetadata> createConnectionProfileOperationSettings() {
        return this.createConnectionProfileOperationSettings;
    }

    public UnaryCallSettings<UpdateConnectionProfileRequest, Operation> updateConnectionProfileSettings() {
        return this.updateConnectionProfileSettings;
    }

    public OperationCallSettings<UpdateConnectionProfileRequest, ConnectionProfile, OperationMetadata> updateConnectionProfileOperationSettings() {
        return this.updateConnectionProfileOperationSettings;
    }

    public UnaryCallSettings<DeleteConnectionProfileRequest, Operation> deleteConnectionProfileSettings() {
        return this.deleteConnectionProfileSettings;
    }

    public OperationCallSettings<DeleteConnectionProfileRequest, Empty, OperationMetadata> deleteConnectionProfileOperationSettings() {
        return this.deleteConnectionProfileOperationSettings;
    }

    public DataMigrationServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataMigrationServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "datamigration.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "datamigration.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataMigrationServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataMigrationServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataMigrationServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listMigrationJobsSettings = settingsBuilder.listMigrationJobsSettings().build();
        this.getMigrationJobSettings = settingsBuilder.getMigrationJobSettings().build();
        this.createMigrationJobSettings = settingsBuilder.createMigrationJobSettings().build();
        this.createMigrationJobOperationSettings = settingsBuilder.createMigrationJobOperationSettings().build();
        this.updateMigrationJobSettings = settingsBuilder.updateMigrationJobSettings().build();
        this.updateMigrationJobOperationSettings = settingsBuilder.updateMigrationJobOperationSettings().build();
        this.deleteMigrationJobSettings = settingsBuilder.deleteMigrationJobSettings().build();
        this.deleteMigrationJobOperationSettings = settingsBuilder.deleteMigrationJobOperationSettings().build();
        this.startMigrationJobSettings = settingsBuilder.startMigrationJobSettings().build();
        this.startMigrationJobOperationSettings = settingsBuilder.startMigrationJobOperationSettings().build();
        this.stopMigrationJobSettings = settingsBuilder.stopMigrationJobSettings().build();
        this.stopMigrationJobOperationSettings = settingsBuilder.stopMigrationJobOperationSettings().build();
        this.resumeMigrationJobSettings = settingsBuilder.resumeMigrationJobSettings().build();
        this.resumeMigrationJobOperationSettings = settingsBuilder.resumeMigrationJobOperationSettings().build();
        this.promoteMigrationJobSettings = settingsBuilder.promoteMigrationJobSettings().build();
        this.promoteMigrationJobOperationSettings = settingsBuilder.promoteMigrationJobOperationSettings().build();
        this.verifyMigrationJobSettings = settingsBuilder.verifyMigrationJobSettings().build();
        this.verifyMigrationJobOperationSettings = settingsBuilder.verifyMigrationJobOperationSettings().build();
        this.restartMigrationJobSettings = settingsBuilder.restartMigrationJobSettings().build();
        this.restartMigrationJobOperationSettings = settingsBuilder.restartMigrationJobOperationSettings().build();
        this.generateSshScriptSettings = settingsBuilder.generateSshScriptSettings().build();
        this.listConnectionProfilesSettings = settingsBuilder.listConnectionProfilesSettings().build();
        this.getConnectionProfileSettings = settingsBuilder.getConnectionProfileSettings().build();
        this.createConnectionProfileSettings = settingsBuilder.createConnectionProfileSettings().build();
        this.createConnectionProfileOperationSettings = settingsBuilder.createConnectionProfileOperationSettings().build();
        this.updateConnectionProfileSettings = settingsBuilder.updateConnectionProfileSettings().build();
        this.updateConnectionProfileOperationSettings = settingsBuilder.updateConnectionProfileOperationSettings().build();
        this.deleteConnectionProfileSettings = settingsBuilder.deleteConnectionProfileSettings().build();
        this.deleteConnectionProfileOperationSettings = settingsBuilder.deleteConnectionProfileOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataMigrationServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListMigrationJobsRequest, ListMigrationJobsResponse, DataMigrationServiceClient.ListMigrationJobsPagedResponse> listMigrationJobsSettings;
        private final UnaryCallSettings.Builder<GetMigrationJobRequest, MigrationJob> getMigrationJobSettings;
        private final UnaryCallSettings.Builder<CreateMigrationJobRequest, Operation> createMigrationJobSettings;
        private final OperationCallSettings.Builder<CreateMigrationJobRequest, MigrationJob, OperationMetadata> createMigrationJobOperationSettings;
        private final UnaryCallSettings.Builder<UpdateMigrationJobRequest, Operation> updateMigrationJobSettings;
        private final OperationCallSettings.Builder<UpdateMigrationJobRequest, MigrationJob, OperationMetadata> updateMigrationJobOperationSettings;
        private final UnaryCallSettings.Builder<DeleteMigrationJobRequest, Operation> deleteMigrationJobSettings;
        private final OperationCallSettings.Builder<DeleteMigrationJobRequest, Empty, OperationMetadata> deleteMigrationJobOperationSettings;
        private final UnaryCallSettings.Builder<StartMigrationJobRequest, Operation> startMigrationJobSettings;
        private final OperationCallSettings.Builder<StartMigrationJobRequest, MigrationJob, OperationMetadata> startMigrationJobOperationSettings;
        private final UnaryCallSettings.Builder<StopMigrationJobRequest, Operation> stopMigrationJobSettings;
        private final OperationCallSettings.Builder<StopMigrationJobRequest, MigrationJob, OperationMetadata> stopMigrationJobOperationSettings;
        private final UnaryCallSettings.Builder<ResumeMigrationJobRequest, Operation> resumeMigrationJobSettings;
        private final OperationCallSettings.Builder<ResumeMigrationJobRequest, MigrationJob, OperationMetadata> resumeMigrationJobOperationSettings;
        private final UnaryCallSettings.Builder<PromoteMigrationJobRequest, Operation> promoteMigrationJobSettings;
        private final OperationCallSettings.Builder<PromoteMigrationJobRequest, MigrationJob, OperationMetadata> promoteMigrationJobOperationSettings;
        private final UnaryCallSettings.Builder<VerifyMigrationJobRequest, Operation> verifyMigrationJobSettings;
        private final OperationCallSettings.Builder<VerifyMigrationJobRequest, MigrationJob, OperationMetadata> verifyMigrationJobOperationSettings;
        private final UnaryCallSettings.Builder<RestartMigrationJobRequest, Operation> restartMigrationJobSettings;
        private final OperationCallSettings.Builder<RestartMigrationJobRequest, MigrationJob, OperationMetadata> restartMigrationJobOperationSettings;
        private final UnaryCallSettings.Builder<GenerateSshScriptRequest, SshScript> generateSshScriptSettings;
        private final PagedCallSettings.Builder<ListConnectionProfilesRequest, ListConnectionProfilesResponse, DataMigrationServiceClient.ListConnectionProfilesPagedResponse> listConnectionProfilesSettings;
        private final UnaryCallSettings.Builder<GetConnectionProfileRequest, ConnectionProfile> getConnectionProfileSettings;
        private final UnaryCallSettings.Builder<CreateConnectionProfileRequest, Operation> createConnectionProfileSettings;
        private final OperationCallSettings.Builder<CreateConnectionProfileRequest, ConnectionProfile, OperationMetadata> createConnectionProfileOperationSettings;
        private final UnaryCallSettings.Builder<UpdateConnectionProfileRequest, Operation> updateConnectionProfileSettings;
        private final OperationCallSettings.Builder<UpdateConnectionProfileRequest, ConnectionProfile, OperationMetadata> updateConnectionProfileOperationSettings;
        private final UnaryCallSettings.Builder<DeleteConnectionProfileRequest, Operation> deleteConnectionProfileSettings;
        private final OperationCallSettings.Builder<DeleteConnectionProfileRequest, Empty, OperationMetadata> deleteConnectionProfileOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listMigrationJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MIGRATION_JOBS_PAGE_STR_FACT);
            this.getMigrationJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMigrationJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMigrationJobOperationSettings = OperationCallSettings.newBuilder();
            this.updateMigrationJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateMigrationJobOperationSettings = OperationCallSettings.newBuilder();
            this.deleteMigrationJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteMigrationJobOperationSettings = OperationCallSettings.newBuilder();
            this.startMigrationJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startMigrationJobOperationSettings = OperationCallSettings.newBuilder();
            this.stopMigrationJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.stopMigrationJobOperationSettings = OperationCallSettings.newBuilder();
            this.resumeMigrationJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resumeMigrationJobOperationSettings = OperationCallSettings.newBuilder();
            this.promoteMigrationJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.promoteMigrationJobOperationSettings = OperationCallSettings.newBuilder();
            this.verifyMigrationJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.verifyMigrationJobOperationSettings = OperationCallSettings.newBuilder();
            this.restartMigrationJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restartMigrationJobOperationSettings = OperationCallSettings.newBuilder();
            this.generateSshScriptSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listConnectionProfilesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONNECTION_PROFILES_PAGE_STR_FACT);
            this.getConnectionProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConnectionProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConnectionProfileOperationSettings = OperationCallSettings.newBuilder();
            this.updateConnectionProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateConnectionProfileOperationSettings = OperationCallSettings.newBuilder();
            this.deleteConnectionProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteConnectionProfileOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listMigrationJobsSettings, this.getMigrationJobSettings, this.createMigrationJobSettings, this.updateMigrationJobSettings, this.deleteMigrationJobSettings, this.startMigrationJobSettings, this.stopMigrationJobSettings, this.resumeMigrationJobSettings, this.promoteMigrationJobSettings, this.verifyMigrationJobSettings, this.restartMigrationJobSettings, this.generateSshScriptSettings, (Object[])new UnaryCallSettings.Builder[]{this.listConnectionProfilesSettings, this.getConnectionProfileSettings, this.createConnectionProfileSettings, this.updateConnectionProfileSettings, this.deleteConnectionProfileSettings});
            Builder.initDefaults(this);
        }

        protected Builder(DataMigrationServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listMigrationJobsSettings = settings.listMigrationJobsSettings.toBuilder();
            this.getMigrationJobSettings = settings.getMigrationJobSettings.toBuilder();
            this.createMigrationJobSettings = settings.createMigrationJobSettings.toBuilder();
            this.createMigrationJobOperationSettings = settings.createMigrationJobOperationSettings.toBuilder();
            this.updateMigrationJobSettings = settings.updateMigrationJobSettings.toBuilder();
            this.updateMigrationJobOperationSettings = settings.updateMigrationJobOperationSettings.toBuilder();
            this.deleteMigrationJobSettings = settings.deleteMigrationJobSettings.toBuilder();
            this.deleteMigrationJobOperationSettings = settings.deleteMigrationJobOperationSettings.toBuilder();
            this.startMigrationJobSettings = settings.startMigrationJobSettings.toBuilder();
            this.startMigrationJobOperationSettings = settings.startMigrationJobOperationSettings.toBuilder();
            this.stopMigrationJobSettings = settings.stopMigrationJobSettings.toBuilder();
            this.stopMigrationJobOperationSettings = settings.stopMigrationJobOperationSettings.toBuilder();
            this.resumeMigrationJobSettings = settings.resumeMigrationJobSettings.toBuilder();
            this.resumeMigrationJobOperationSettings = settings.resumeMigrationJobOperationSettings.toBuilder();
            this.promoteMigrationJobSettings = settings.promoteMigrationJobSettings.toBuilder();
            this.promoteMigrationJobOperationSettings = settings.promoteMigrationJobOperationSettings.toBuilder();
            this.verifyMigrationJobSettings = settings.verifyMigrationJobSettings.toBuilder();
            this.verifyMigrationJobOperationSettings = settings.verifyMigrationJobOperationSettings.toBuilder();
            this.restartMigrationJobSettings = settings.restartMigrationJobSettings.toBuilder();
            this.restartMigrationJobOperationSettings = settings.restartMigrationJobOperationSettings.toBuilder();
            this.generateSshScriptSettings = settings.generateSshScriptSettings.toBuilder();
            this.listConnectionProfilesSettings = settings.listConnectionProfilesSettings.toBuilder();
            this.getConnectionProfileSettings = settings.getConnectionProfileSettings.toBuilder();
            this.createConnectionProfileSettings = settings.createConnectionProfileSettings.toBuilder();
            this.createConnectionProfileOperationSettings = settings.createConnectionProfileOperationSettings.toBuilder();
            this.updateConnectionProfileSettings = settings.updateConnectionProfileSettings.toBuilder();
            this.updateConnectionProfileOperationSettings = settings.updateConnectionProfileOperationSettings.toBuilder();
            this.deleteConnectionProfileSettings = settings.deleteConnectionProfileSettings.toBuilder();
            this.deleteConnectionProfileOperationSettings = settings.deleteConnectionProfileOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listMigrationJobsSettings, this.getMigrationJobSettings, this.createMigrationJobSettings, this.updateMigrationJobSettings, this.deleteMigrationJobSettings, this.startMigrationJobSettings, this.stopMigrationJobSettings, this.resumeMigrationJobSettings, this.promoteMigrationJobSettings, this.verifyMigrationJobSettings, this.restartMigrationJobSettings, this.generateSshScriptSettings, (Object[])new UnaryCallSettings.Builder[]{this.listConnectionProfilesSettings, this.getConnectionProfileSettings, this.createConnectionProfileSettings, this.updateConnectionProfileSettings, this.deleteConnectionProfileSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataMigrationServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataMigrationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataMigrationServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DataMigrationServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DataMigrationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listMigrationJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getMigrationJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createMigrationJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateMigrationJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteMigrationJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.startMigrationJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.stopMigrationJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.resumeMigrationJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.promoteMigrationJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.verifyMigrationJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.restartMigrationJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.generateSshScriptSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listConnectionProfilesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getConnectionProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createConnectionProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateConnectionProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteConnectionProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createMigrationJobOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MigrationJob.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateMigrationJobOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MigrationJob.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteMigrationJobOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.startMigrationJobOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MigrationJob.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.stopMigrationJobOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MigrationJob.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.resumeMigrationJobOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MigrationJob.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.promoteMigrationJobOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MigrationJob.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.verifyMigrationJobOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MigrationJob.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.restartMigrationJobOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MigrationJob.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createConnectionProfileOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ConnectionProfile.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateConnectionProfileOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ConnectionProfile.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteConnectionProfileOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListMigrationJobsRequest, ListMigrationJobsResponse, DataMigrationServiceClient.ListMigrationJobsPagedResponse> listMigrationJobsSettings() {
            return this.listMigrationJobsSettings;
        }

        public UnaryCallSettings.Builder<GetMigrationJobRequest, MigrationJob> getMigrationJobSettings() {
            return this.getMigrationJobSettings;
        }

        public UnaryCallSettings.Builder<CreateMigrationJobRequest, Operation> createMigrationJobSettings() {
            return this.createMigrationJobSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateMigrationJobRequest, MigrationJob, OperationMetadata> createMigrationJobOperationSettings() {
            return this.createMigrationJobOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateMigrationJobRequest, Operation> updateMigrationJobSettings() {
            return this.updateMigrationJobSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateMigrationJobRequest, MigrationJob, OperationMetadata> updateMigrationJobOperationSettings() {
            return this.updateMigrationJobOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteMigrationJobRequest, Operation> deleteMigrationJobSettings() {
            return this.deleteMigrationJobSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteMigrationJobRequest, Empty, OperationMetadata> deleteMigrationJobOperationSettings() {
            return this.deleteMigrationJobOperationSettings;
        }

        public UnaryCallSettings.Builder<StartMigrationJobRequest, Operation> startMigrationJobSettings() {
            return this.startMigrationJobSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StartMigrationJobRequest, MigrationJob, OperationMetadata> startMigrationJobOperationSettings() {
            return this.startMigrationJobOperationSettings;
        }

        public UnaryCallSettings.Builder<StopMigrationJobRequest, Operation> stopMigrationJobSettings() {
            return this.stopMigrationJobSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StopMigrationJobRequest, MigrationJob, OperationMetadata> stopMigrationJobOperationSettings() {
            return this.stopMigrationJobOperationSettings;
        }

        public UnaryCallSettings.Builder<ResumeMigrationJobRequest, Operation> resumeMigrationJobSettings() {
            return this.resumeMigrationJobSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ResumeMigrationJobRequest, MigrationJob, OperationMetadata> resumeMigrationJobOperationSettings() {
            return this.resumeMigrationJobOperationSettings;
        }

        public UnaryCallSettings.Builder<PromoteMigrationJobRequest, Operation> promoteMigrationJobSettings() {
            return this.promoteMigrationJobSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<PromoteMigrationJobRequest, MigrationJob, OperationMetadata> promoteMigrationJobOperationSettings() {
            return this.promoteMigrationJobOperationSettings;
        }

        public UnaryCallSettings.Builder<VerifyMigrationJobRequest, Operation> verifyMigrationJobSettings() {
            return this.verifyMigrationJobSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<VerifyMigrationJobRequest, MigrationJob, OperationMetadata> verifyMigrationJobOperationSettings() {
            return this.verifyMigrationJobOperationSettings;
        }

        public UnaryCallSettings.Builder<RestartMigrationJobRequest, Operation> restartMigrationJobSettings() {
            return this.restartMigrationJobSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RestartMigrationJobRequest, MigrationJob, OperationMetadata> restartMigrationJobOperationSettings() {
            return this.restartMigrationJobOperationSettings;
        }

        public UnaryCallSettings.Builder<GenerateSshScriptRequest, SshScript> generateSshScriptSettings() {
            return this.generateSshScriptSettings;
        }

        public PagedCallSettings.Builder<ListConnectionProfilesRequest, ListConnectionProfilesResponse, DataMigrationServiceClient.ListConnectionProfilesPagedResponse> listConnectionProfilesSettings() {
            return this.listConnectionProfilesSettings;
        }

        public UnaryCallSettings.Builder<GetConnectionProfileRequest, ConnectionProfile> getConnectionProfileSettings() {
            return this.getConnectionProfileSettings;
        }

        public UnaryCallSettings.Builder<CreateConnectionProfileRequest, Operation> createConnectionProfileSettings() {
            return this.createConnectionProfileSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateConnectionProfileRequest, ConnectionProfile, OperationMetadata> createConnectionProfileOperationSettings() {
            return this.createConnectionProfileOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateConnectionProfileRequest, Operation> updateConnectionProfileSettings() {
            return this.updateConnectionProfileSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateConnectionProfileRequest, ConnectionProfile, OperationMetadata> updateConnectionProfileOperationSettings() {
            return this.updateConnectionProfileOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteConnectionProfileRequest, Operation> deleteConnectionProfileSettings() {
            return this.deleteConnectionProfileSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteConnectionProfileRequest, Empty, OperationMetadata> deleteConnectionProfileOperationSettings() {
            return this.deleteConnectionProfileOperationSettings;
        }

        public DataMigrationServiceStubSettings build() throws IOException {
            return new DataMigrationServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

