/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dlp.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dlp.v2.DlpServiceSettings;
import com.google.cloud.dlp.v2.stub.DlpServiceStub;
import com.google.cloud.dlp.v2.stub.DlpServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.privacy.dlp.v2.ActivateJobTriggerRequest;
import com.google.privacy.dlp.v2.CancelDlpJobRequest;
import com.google.privacy.dlp.v2.ColumnDataProfile;
import com.google.privacy.dlp.v2.ColumnDataProfileName;
import com.google.privacy.dlp.v2.Connection;
import com.google.privacy.dlp.v2.ConnectionName;
import com.google.privacy.dlp.v2.CreateConnectionRequest;
import com.google.privacy.dlp.v2.CreateDeidentifyTemplateRequest;
import com.google.privacy.dlp.v2.CreateDiscoveryConfigRequest;
import com.google.privacy.dlp.v2.CreateDlpJobRequest;
import com.google.privacy.dlp.v2.CreateInspectTemplateRequest;
import com.google.privacy.dlp.v2.CreateJobTriggerRequest;
import com.google.privacy.dlp.v2.CreateStoredInfoTypeRequest;
import com.google.privacy.dlp.v2.DeidentifyContentRequest;
import com.google.privacy.dlp.v2.DeidentifyContentResponse;
import com.google.privacy.dlp.v2.DeidentifyTemplate;
import com.google.privacy.dlp.v2.DeidentifyTemplateName;
import com.google.privacy.dlp.v2.DeleteConnectionRequest;
import com.google.privacy.dlp.v2.DeleteDeidentifyTemplateRequest;
import com.google.privacy.dlp.v2.DeleteDiscoveryConfigRequest;
import com.google.privacy.dlp.v2.DeleteDlpJobRequest;
import com.google.privacy.dlp.v2.DeleteInspectTemplateRequest;
import com.google.privacy.dlp.v2.DeleteJobTriggerRequest;
import com.google.privacy.dlp.v2.DeleteStoredInfoTypeRequest;
import com.google.privacy.dlp.v2.DeleteTableDataProfileRequest;
import com.google.privacy.dlp.v2.DiscoveryConfig;
import com.google.privacy.dlp.v2.DiscoveryConfigName;
import com.google.privacy.dlp.v2.DlpJob;
import com.google.privacy.dlp.v2.DlpJobName;
import com.google.privacy.dlp.v2.FinishDlpJobRequest;
import com.google.privacy.dlp.v2.GetColumnDataProfileRequest;
import com.google.privacy.dlp.v2.GetConnectionRequest;
import com.google.privacy.dlp.v2.GetDeidentifyTemplateRequest;
import com.google.privacy.dlp.v2.GetDiscoveryConfigRequest;
import com.google.privacy.dlp.v2.GetDlpJobRequest;
import com.google.privacy.dlp.v2.GetInspectTemplateRequest;
import com.google.privacy.dlp.v2.GetJobTriggerRequest;
import com.google.privacy.dlp.v2.GetProjectDataProfileRequest;
import com.google.privacy.dlp.v2.GetStoredInfoTypeRequest;
import com.google.privacy.dlp.v2.GetTableDataProfileRequest;
import com.google.privacy.dlp.v2.HybridInspectDlpJobRequest;
import com.google.privacy.dlp.v2.HybridInspectJobTriggerRequest;
import com.google.privacy.dlp.v2.HybridInspectResponse;
import com.google.privacy.dlp.v2.InspectContentRequest;
import com.google.privacy.dlp.v2.InspectContentResponse;
import com.google.privacy.dlp.v2.InspectJobConfig;
import com.google.privacy.dlp.v2.InspectTemplate;
import com.google.privacy.dlp.v2.InspectTemplateName;
import com.google.privacy.dlp.v2.JobTrigger;
import com.google.privacy.dlp.v2.JobTriggerName;
import com.google.privacy.dlp.v2.ListColumnDataProfilesRequest;
import com.google.privacy.dlp.v2.ListColumnDataProfilesResponse;
import com.google.privacy.dlp.v2.ListConnectionsRequest;
import com.google.privacy.dlp.v2.ListConnectionsResponse;
import com.google.privacy.dlp.v2.ListDeidentifyTemplatesRequest;
import com.google.privacy.dlp.v2.ListDeidentifyTemplatesResponse;
import com.google.privacy.dlp.v2.ListDiscoveryConfigsRequest;
import com.google.privacy.dlp.v2.ListDiscoveryConfigsResponse;
import com.google.privacy.dlp.v2.ListDlpJobsRequest;
import com.google.privacy.dlp.v2.ListDlpJobsResponse;
import com.google.privacy.dlp.v2.ListInfoTypesRequest;
import com.google.privacy.dlp.v2.ListInfoTypesResponse;
import com.google.privacy.dlp.v2.ListInspectTemplatesRequest;
import com.google.privacy.dlp.v2.ListInspectTemplatesResponse;
import com.google.privacy.dlp.v2.ListJobTriggersRequest;
import com.google.privacy.dlp.v2.ListJobTriggersResponse;
import com.google.privacy.dlp.v2.ListProjectDataProfilesRequest;
import com.google.privacy.dlp.v2.ListProjectDataProfilesResponse;
import com.google.privacy.dlp.v2.ListStoredInfoTypesRequest;
import com.google.privacy.dlp.v2.ListStoredInfoTypesResponse;
import com.google.privacy.dlp.v2.ListTableDataProfilesRequest;
import com.google.privacy.dlp.v2.ListTableDataProfilesResponse;
import com.google.privacy.dlp.v2.LocationName;
import com.google.privacy.dlp.v2.OrganizationLocationName;
import com.google.privacy.dlp.v2.OrganizationName;
import com.google.privacy.dlp.v2.ProjectDataProfile;
import com.google.privacy.dlp.v2.ProjectDataProfileName;
import com.google.privacy.dlp.v2.ProjectName;
import com.google.privacy.dlp.v2.RedactImageRequest;
import com.google.privacy.dlp.v2.RedactImageResponse;
import com.google.privacy.dlp.v2.ReidentifyContentRequest;
import com.google.privacy.dlp.v2.ReidentifyContentResponse;
import com.google.privacy.dlp.v2.RiskAnalysisJobConfig;
import com.google.privacy.dlp.v2.SearchConnectionsRequest;
import com.google.privacy.dlp.v2.SearchConnectionsResponse;
import com.google.privacy.dlp.v2.StoredInfoType;
import com.google.privacy.dlp.v2.StoredInfoTypeConfig;
import com.google.privacy.dlp.v2.StoredInfoTypeName;
import com.google.privacy.dlp.v2.TableDataProfile;
import com.google.privacy.dlp.v2.TableDataProfileName;
import com.google.privacy.dlp.v2.UpdateConnectionRequest;
import com.google.privacy.dlp.v2.UpdateDeidentifyTemplateRequest;
import com.google.privacy.dlp.v2.UpdateDiscoveryConfigRequest;
import com.google.privacy.dlp.v2.UpdateInspectTemplateRequest;
import com.google.privacy.dlp.v2.UpdateJobTriggerRequest;
import com.google.privacy.dlp.v2.UpdateStoredInfoTypeRequest;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DlpServiceClient
implements BackgroundResource {
    private final DlpServiceSettings settings;
    private final DlpServiceStub stub;

    public static final DlpServiceClient create() throws IOException {
        return DlpServiceClient.create(DlpServiceSettings.newBuilder().build());
    }

    public static final DlpServiceClient create(DlpServiceSettings settings) throws IOException {
        return new DlpServiceClient(settings);
    }

    public static final DlpServiceClient create(DlpServiceStub stub) {
        return new DlpServiceClient(stub);
    }

    protected DlpServiceClient(DlpServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DlpServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected DlpServiceClient(DlpServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DlpServiceSettings getSettings() {
        return this.settings;
    }

    public DlpServiceStub getStub() {
        return this.stub;
    }

    public final InspectContentResponse inspectContent(InspectContentRequest request) {
        return (InspectContentResponse)this.inspectContentCallable().call((Object)request);
    }

    public final UnaryCallable<InspectContentRequest, InspectContentResponse> inspectContentCallable() {
        return this.stub.inspectContentCallable();
    }

    public final RedactImageResponse redactImage(RedactImageRequest request) {
        return (RedactImageResponse)this.redactImageCallable().call((Object)request);
    }

    public final UnaryCallable<RedactImageRequest, RedactImageResponse> redactImageCallable() {
        return this.stub.redactImageCallable();
    }

    public final DeidentifyContentResponse deidentifyContent(DeidentifyContentRequest request) {
        return (DeidentifyContentResponse)this.deidentifyContentCallable().call((Object)request);
    }

    public final UnaryCallable<DeidentifyContentRequest, DeidentifyContentResponse> deidentifyContentCallable() {
        return this.stub.deidentifyContentCallable();
    }

    public final ReidentifyContentResponse reidentifyContent(ReidentifyContentRequest request) {
        return (ReidentifyContentResponse)this.reidentifyContentCallable().call((Object)request);
    }

    public final UnaryCallable<ReidentifyContentRequest, ReidentifyContentResponse> reidentifyContentCallable() {
        return this.stub.reidentifyContentCallable();
    }

    public final ListInfoTypesResponse listInfoTypes(String parent) {
        ListInfoTypesRequest request = ListInfoTypesRequest.newBuilder().setParent(parent).build();
        return this.listInfoTypes(request);
    }

    public final ListInfoTypesResponse listInfoTypes(ListInfoTypesRequest request) {
        return (ListInfoTypesResponse)this.listInfoTypesCallable().call((Object)request);
    }

    public final UnaryCallable<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesCallable() {
        return this.stub.listInfoTypesCallable();
    }

    public final InspectTemplate createInspectTemplate(LocationName parent, InspectTemplate inspectTemplate) {
        CreateInspectTemplateRequest request = CreateInspectTemplateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInspectTemplate(inspectTemplate).build();
        return this.createInspectTemplate(request);
    }

    public final InspectTemplate createInspectTemplate(OrganizationLocationName parent, InspectTemplate inspectTemplate) {
        CreateInspectTemplateRequest request = CreateInspectTemplateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInspectTemplate(inspectTemplate).build();
        return this.createInspectTemplate(request);
    }

    public final InspectTemplate createInspectTemplate(OrganizationName parent, InspectTemplate inspectTemplate) {
        CreateInspectTemplateRequest request = CreateInspectTemplateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInspectTemplate(inspectTemplate).build();
        return this.createInspectTemplate(request);
    }

    public final InspectTemplate createInspectTemplate(ProjectName parent, InspectTemplate inspectTemplate) {
        CreateInspectTemplateRequest request = CreateInspectTemplateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInspectTemplate(inspectTemplate).build();
        return this.createInspectTemplate(request);
    }

    public final InspectTemplate createInspectTemplate(String parent, InspectTemplate inspectTemplate) {
        CreateInspectTemplateRequest request = CreateInspectTemplateRequest.newBuilder().setParent(parent).setInspectTemplate(inspectTemplate).build();
        return this.createInspectTemplate(request);
    }

    public final InspectTemplate createInspectTemplate(CreateInspectTemplateRequest request) {
        return (InspectTemplate)this.createInspectTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<CreateInspectTemplateRequest, InspectTemplate> createInspectTemplateCallable() {
        return this.stub.createInspectTemplateCallable();
    }

    public final InspectTemplate updateInspectTemplate(InspectTemplateName name, InspectTemplate inspectTemplate, FieldMask updateMask) {
        UpdateInspectTemplateRequest request = UpdateInspectTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).setInspectTemplate(inspectTemplate).setUpdateMask(updateMask).build();
        return this.updateInspectTemplate(request);
    }

    public final InspectTemplate updateInspectTemplate(String name, InspectTemplate inspectTemplate, FieldMask updateMask) {
        UpdateInspectTemplateRequest request = UpdateInspectTemplateRequest.newBuilder().setName(name).setInspectTemplate(inspectTemplate).setUpdateMask(updateMask).build();
        return this.updateInspectTemplate(request);
    }

    public final InspectTemplate updateInspectTemplate(UpdateInspectTemplateRequest request) {
        return (InspectTemplate)this.updateInspectTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateInspectTemplateRequest, InspectTemplate> updateInspectTemplateCallable() {
        return this.stub.updateInspectTemplateCallable();
    }

    public final InspectTemplate getInspectTemplate(InspectTemplateName name) {
        GetInspectTemplateRequest request = GetInspectTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInspectTemplate(request);
    }

    public final InspectTemplate getInspectTemplate(String name) {
        GetInspectTemplateRequest request = GetInspectTemplateRequest.newBuilder().setName(name).build();
        return this.getInspectTemplate(request);
    }

    public final InspectTemplate getInspectTemplate(GetInspectTemplateRequest request) {
        return (InspectTemplate)this.getInspectTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<GetInspectTemplateRequest, InspectTemplate> getInspectTemplateCallable() {
        return this.stub.getInspectTemplateCallable();
    }

    public final ListInspectTemplatesPagedResponse listInspectTemplates(LocationName parent) {
        ListInspectTemplatesRequest request = ListInspectTemplatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInspectTemplates(request);
    }

    public final ListInspectTemplatesPagedResponse listInspectTemplates(OrganizationLocationName parent) {
        ListInspectTemplatesRequest request = ListInspectTemplatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInspectTemplates(request);
    }

    public final ListInspectTemplatesPagedResponse listInspectTemplates(OrganizationName parent) {
        ListInspectTemplatesRequest request = ListInspectTemplatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInspectTemplates(request);
    }

    public final ListInspectTemplatesPagedResponse listInspectTemplates(ProjectName parent) {
        ListInspectTemplatesRequest request = ListInspectTemplatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInspectTemplates(request);
    }

    public final ListInspectTemplatesPagedResponse listInspectTemplates(String parent) {
        ListInspectTemplatesRequest request = ListInspectTemplatesRequest.newBuilder().setParent(parent).build();
        return this.listInspectTemplates(request);
    }

    public final ListInspectTemplatesPagedResponse listInspectTemplates(ListInspectTemplatesRequest request) {
        return (ListInspectTemplatesPagedResponse)((Object)this.listInspectTemplatesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInspectTemplatesRequest, ListInspectTemplatesPagedResponse> listInspectTemplatesPagedCallable() {
        return this.stub.listInspectTemplatesPagedCallable();
    }

    public final UnaryCallable<ListInspectTemplatesRequest, ListInspectTemplatesResponse> listInspectTemplatesCallable() {
        return this.stub.listInspectTemplatesCallable();
    }

    public final void deleteInspectTemplate(InspectTemplateName name) {
        DeleteInspectTemplateRequest request = DeleteInspectTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteInspectTemplate(request);
    }

    public final void deleteInspectTemplate(String name) {
        DeleteInspectTemplateRequest request = DeleteInspectTemplateRequest.newBuilder().setName(name).build();
        this.deleteInspectTemplate(request);
    }

    public final void deleteInspectTemplate(DeleteInspectTemplateRequest request) {
        this.deleteInspectTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteInspectTemplateRequest, Empty> deleteInspectTemplateCallable() {
        return this.stub.deleteInspectTemplateCallable();
    }

    public final DeidentifyTemplate createDeidentifyTemplate(LocationName parent, DeidentifyTemplate deidentifyTemplate) {
        CreateDeidentifyTemplateRequest request = CreateDeidentifyTemplateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDeidentifyTemplate(deidentifyTemplate).build();
        return this.createDeidentifyTemplate(request);
    }

    public final DeidentifyTemplate createDeidentifyTemplate(OrganizationLocationName parent, DeidentifyTemplate deidentifyTemplate) {
        CreateDeidentifyTemplateRequest request = CreateDeidentifyTemplateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDeidentifyTemplate(deidentifyTemplate).build();
        return this.createDeidentifyTemplate(request);
    }

    public final DeidentifyTemplate createDeidentifyTemplate(OrganizationName parent, DeidentifyTemplate deidentifyTemplate) {
        CreateDeidentifyTemplateRequest request = CreateDeidentifyTemplateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDeidentifyTemplate(deidentifyTemplate).build();
        return this.createDeidentifyTemplate(request);
    }

    public final DeidentifyTemplate createDeidentifyTemplate(ProjectName parent, DeidentifyTemplate deidentifyTemplate) {
        CreateDeidentifyTemplateRequest request = CreateDeidentifyTemplateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDeidentifyTemplate(deidentifyTemplate).build();
        return this.createDeidentifyTemplate(request);
    }

    public final DeidentifyTemplate createDeidentifyTemplate(String parent, DeidentifyTemplate deidentifyTemplate) {
        CreateDeidentifyTemplateRequest request = CreateDeidentifyTemplateRequest.newBuilder().setParent(parent).setDeidentifyTemplate(deidentifyTemplate).build();
        return this.createDeidentifyTemplate(request);
    }

    public final DeidentifyTemplate createDeidentifyTemplate(CreateDeidentifyTemplateRequest request) {
        return (DeidentifyTemplate)this.createDeidentifyTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDeidentifyTemplateRequest, DeidentifyTemplate> createDeidentifyTemplateCallable() {
        return this.stub.createDeidentifyTemplateCallable();
    }

    public final DeidentifyTemplate updateDeidentifyTemplate(DeidentifyTemplateName name, DeidentifyTemplate deidentifyTemplate, FieldMask updateMask) {
        UpdateDeidentifyTemplateRequest request = UpdateDeidentifyTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).setDeidentifyTemplate(deidentifyTemplate).setUpdateMask(updateMask).build();
        return this.updateDeidentifyTemplate(request);
    }

    public final DeidentifyTemplate updateDeidentifyTemplate(String name, DeidentifyTemplate deidentifyTemplate, FieldMask updateMask) {
        UpdateDeidentifyTemplateRequest request = UpdateDeidentifyTemplateRequest.newBuilder().setName(name).setDeidentifyTemplate(deidentifyTemplate).setUpdateMask(updateMask).build();
        return this.updateDeidentifyTemplate(request);
    }

    public final DeidentifyTemplate updateDeidentifyTemplate(UpdateDeidentifyTemplateRequest request) {
        return (DeidentifyTemplate)this.updateDeidentifyTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDeidentifyTemplateRequest, DeidentifyTemplate> updateDeidentifyTemplateCallable() {
        return this.stub.updateDeidentifyTemplateCallable();
    }

    public final DeidentifyTemplate getDeidentifyTemplate(DeidentifyTemplateName name) {
        GetDeidentifyTemplateRequest request = GetDeidentifyTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDeidentifyTemplate(request);
    }

    public final DeidentifyTemplate getDeidentifyTemplate(String name) {
        GetDeidentifyTemplateRequest request = GetDeidentifyTemplateRequest.newBuilder().setName(name).build();
        return this.getDeidentifyTemplate(request);
    }

    public final DeidentifyTemplate getDeidentifyTemplate(GetDeidentifyTemplateRequest request) {
        return (DeidentifyTemplate)this.getDeidentifyTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeidentifyTemplateRequest, DeidentifyTemplate> getDeidentifyTemplateCallable() {
        return this.stub.getDeidentifyTemplateCallable();
    }

    public final ListDeidentifyTemplatesPagedResponse listDeidentifyTemplates(LocationName parent) {
        ListDeidentifyTemplatesRequest request = ListDeidentifyTemplatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeidentifyTemplates(request);
    }

    public final ListDeidentifyTemplatesPagedResponse listDeidentifyTemplates(OrganizationLocationName parent) {
        ListDeidentifyTemplatesRequest request = ListDeidentifyTemplatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeidentifyTemplates(request);
    }

    public final ListDeidentifyTemplatesPagedResponse listDeidentifyTemplates(OrganizationName parent) {
        ListDeidentifyTemplatesRequest request = ListDeidentifyTemplatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeidentifyTemplates(request);
    }

    public final ListDeidentifyTemplatesPagedResponse listDeidentifyTemplates(ProjectName parent) {
        ListDeidentifyTemplatesRequest request = ListDeidentifyTemplatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeidentifyTemplates(request);
    }

    public final ListDeidentifyTemplatesPagedResponse listDeidentifyTemplates(String parent) {
        ListDeidentifyTemplatesRequest request = ListDeidentifyTemplatesRequest.newBuilder().setParent(parent).build();
        return this.listDeidentifyTemplates(request);
    }

    public final ListDeidentifyTemplatesPagedResponse listDeidentifyTemplates(ListDeidentifyTemplatesRequest request) {
        return (ListDeidentifyTemplatesPagedResponse)((Object)this.listDeidentifyTemplatesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesPagedResponse> listDeidentifyTemplatesPagedCallable() {
        return this.stub.listDeidentifyTemplatesPagedCallable();
    }

    public final UnaryCallable<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse> listDeidentifyTemplatesCallable() {
        return this.stub.listDeidentifyTemplatesCallable();
    }

    public final void deleteDeidentifyTemplate(DeidentifyTemplateName name) {
        DeleteDeidentifyTemplateRequest request = DeleteDeidentifyTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDeidentifyTemplate(request);
    }

    public final void deleteDeidentifyTemplate(String name) {
        DeleteDeidentifyTemplateRequest request = DeleteDeidentifyTemplateRequest.newBuilder().setName(name).build();
        this.deleteDeidentifyTemplate(request);
    }

    public final void deleteDeidentifyTemplate(DeleteDeidentifyTemplateRequest request) {
        this.deleteDeidentifyTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDeidentifyTemplateRequest, Empty> deleteDeidentifyTemplateCallable() {
        return this.stub.deleteDeidentifyTemplateCallable();
    }

    public final JobTrigger createJobTrigger(LocationName parent, JobTrigger jobTrigger) {
        CreateJobTriggerRequest request = CreateJobTriggerRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setJobTrigger(jobTrigger).build();
        return this.createJobTrigger(request);
    }

    public final JobTrigger createJobTrigger(ProjectName parent, JobTrigger jobTrigger) {
        CreateJobTriggerRequest request = CreateJobTriggerRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setJobTrigger(jobTrigger).build();
        return this.createJobTrigger(request);
    }

    public final JobTrigger createJobTrigger(String parent, JobTrigger jobTrigger) {
        CreateJobTriggerRequest request = CreateJobTriggerRequest.newBuilder().setParent(parent).setJobTrigger(jobTrigger).build();
        return this.createJobTrigger(request);
    }

    public final JobTrigger createJobTrigger(CreateJobTriggerRequest request) {
        return (JobTrigger)this.createJobTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<CreateJobTriggerRequest, JobTrigger> createJobTriggerCallable() {
        return this.stub.createJobTriggerCallable();
    }

    public final JobTrigger updateJobTrigger(JobTriggerName name, JobTrigger jobTrigger, FieldMask updateMask) {
        UpdateJobTriggerRequest request = UpdateJobTriggerRequest.newBuilder().setName(name == null ? null : name.toString()).setJobTrigger(jobTrigger).setUpdateMask(updateMask).build();
        return this.updateJobTrigger(request);
    }

    public final JobTrigger updateJobTrigger(String name, JobTrigger jobTrigger, FieldMask updateMask) {
        UpdateJobTriggerRequest request = UpdateJobTriggerRequest.newBuilder().setName(name).setJobTrigger(jobTrigger).setUpdateMask(updateMask).build();
        return this.updateJobTrigger(request);
    }

    public final JobTrigger updateJobTrigger(UpdateJobTriggerRequest request) {
        return (JobTrigger)this.updateJobTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateJobTriggerRequest, JobTrigger> updateJobTriggerCallable() {
        return this.stub.updateJobTriggerCallable();
    }

    public final HybridInspectResponse hybridInspectJobTrigger(JobTriggerName name) {
        HybridInspectJobTriggerRequest request = HybridInspectJobTriggerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.hybridInspectJobTrigger(request);
    }

    public final HybridInspectResponse hybridInspectJobTrigger(String name) {
        HybridInspectJobTriggerRequest request = HybridInspectJobTriggerRequest.newBuilder().setName(name).build();
        return this.hybridInspectJobTrigger(request);
    }

    public final HybridInspectResponse hybridInspectJobTrigger(HybridInspectJobTriggerRequest request) {
        return (HybridInspectResponse)this.hybridInspectJobTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<HybridInspectJobTriggerRequest, HybridInspectResponse> hybridInspectJobTriggerCallable() {
        return this.stub.hybridInspectJobTriggerCallable();
    }

    public final JobTrigger getJobTrigger(JobTriggerName name) {
        GetJobTriggerRequest request = GetJobTriggerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getJobTrigger(request);
    }

    public final JobTrigger getJobTrigger(String name) {
        GetJobTriggerRequest request = GetJobTriggerRequest.newBuilder().setName(name).build();
        return this.getJobTrigger(request);
    }

    public final JobTrigger getJobTrigger(GetJobTriggerRequest request) {
        return (JobTrigger)this.getJobTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<GetJobTriggerRequest, JobTrigger> getJobTriggerCallable() {
        return this.stub.getJobTriggerCallable();
    }

    public final ListJobTriggersPagedResponse listJobTriggers(LocationName parent) {
        ListJobTriggersRequest request = ListJobTriggersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listJobTriggers(request);
    }

    public final ListJobTriggersPagedResponse listJobTriggers(ProjectName parent) {
        ListJobTriggersRequest request = ListJobTriggersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listJobTriggers(request);
    }

    public final ListJobTriggersPagedResponse listJobTriggers(String parent) {
        ListJobTriggersRequest request = ListJobTriggersRequest.newBuilder().setParent(parent).build();
        return this.listJobTriggers(request);
    }

    public final ListJobTriggersPagedResponse listJobTriggers(ListJobTriggersRequest request) {
        return (ListJobTriggersPagedResponse)((Object)this.listJobTriggersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListJobTriggersRequest, ListJobTriggersPagedResponse> listJobTriggersPagedCallable() {
        return this.stub.listJobTriggersPagedCallable();
    }

    public final UnaryCallable<ListJobTriggersRequest, ListJobTriggersResponse> listJobTriggersCallable() {
        return this.stub.listJobTriggersCallable();
    }

    public final void deleteJobTrigger(JobTriggerName name) {
        DeleteJobTriggerRequest request = DeleteJobTriggerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteJobTrigger(request);
    }

    public final void deleteJobTrigger(String name) {
        DeleteJobTriggerRequest request = DeleteJobTriggerRequest.newBuilder().setName(name).build();
        this.deleteJobTrigger(request);
    }

    public final void deleteJobTrigger(DeleteJobTriggerRequest request) {
        this.deleteJobTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteJobTriggerRequest, Empty> deleteJobTriggerCallable() {
        return this.stub.deleteJobTriggerCallable();
    }

    public final DlpJob activateJobTrigger(ActivateJobTriggerRequest request) {
        return (DlpJob)this.activateJobTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<ActivateJobTriggerRequest, DlpJob> activateJobTriggerCallable() {
        return this.stub.activateJobTriggerCallable();
    }

    public final DiscoveryConfig createDiscoveryConfig(LocationName parent, DiscoveryConfig discoveryConfig) {
        CreateDiscoveryConfigRequest request = CreateDiscoveryConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDiscoveryConfig(discoveryConfig).build();
        return this.createDiscoveryConfig(request);
    }

    public final DiscoveryConfig createDiscoveryConfig(String parent, DiscoveryConfig discoveryConfig) {
        CreateDiscoveryConfigRequest request = CreateDiscoveryConfigRequest.newBuilder().setParent(parent).setDiscoveryConfig(discoveryConfig).build();
        return this.createDiscoveryConfig(request);
    }

    public final DiscoveryConfig createDiscoveryConfig(CreateDiscoveryConfigRequest request) {
        return (DiscoveryConfig)this.createDiscoveryConfigCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDiscoveryConfigRequest, DiscoveryConfig> createDiscoveryConfigCallable() {
        return this.stub.createDiscoveryConfigCallable();
    }

    public final DiscoveryConfig updateDiscoveryConfig(DiscoveryConfigName name, DiscoveryConfig discoveryConfig, FieldMask updateMask) {
        UpdateDiscoveryConfigRequest request = UpdateDiscoveryConfigRequest.newBuilder().setName(name == null ? null : name.toString()).setDiscoveryConfig(discoveryConfig).setUpdateMask(updateMask).build();
        return this.updateDiscoveryConfig(request);
    }

    public final DiscoveryConfig updateDiscoveryConfig(String name, DiscoveryConfig discoveryConfig, FieldMask updateMask) {
        UpdateDiscoveryConfigRequest request = UpdateDiscoveryConfigRequest.newBuilder().setName(name).setDiscoveryConfig(discoveryConfig).setUpdateMask(updateMask).build();
        return this.updateDiscoveryConfig(request);
    }

    public final DiscoveryConfig updateDiscoveryConfig(UpdateDiscoveryConfigRequest request) {
        return (DiscoveryConfig)this.updateDiscoveryConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDiscoveryConfigRequest, DiscoveryConfig> updateDiscoveryConfigCallable() {
        return this.stub.updateDiscoveryConfigCallable();
    }

    public final DiscoveryConfig getDiscoveryConfig(DiscoveryConfigName name) {
        GetDiscoveryConfigRequest request = GetDiscoveryConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDiscoveryConfig(request);
    }

    public final DiscoveryConfig getDiscoveryConfig(String name) {
        GetDiscoveryConfigRequest request = GetDiscoveryConfigRequest.newBuilder().setName(name).build();
        return this.getDiscoveryConfig(request);
    }

    public final DiscoveryConfig getDiscoveryConfig(GetDiscoveryConfigRequest request) {
        return (DiscoveryConfig)this.getDiscoveryConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetDiscoveryConfigRequest, DiscoveryConfig> getDiscoveryConfigCallable() {
        return this.stub.getDiscoveryConfigCallable();
    }

    public final ListDiscoveryConfigsPagedResponse listDiscoveryConfigs(LocationName parent) {
        ListDiscoveryConfigsRequest request = ListDiscoveryConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDiscoveryConfigs(request);
    }

    public final ListDiscoveryConfigsPagedResponse listDiscoveryConfigs(String parent) {
        ListDiscoveryConfigsRequest request = ListDiscoveryConfigsRequest.newBuilder().setParent(parent).build();
        return this.listDiscoveryConfigs(request);
    }

    public final ListDiscoveryConfigsPagedResponse listDiscoveryConfigs(ListDiscoveryConfigsRequest request) {
        return (ListDiscoveryConfigsPagedResponse)((Object)this.listDiscoveryConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDiscoveryConfigsRequest, ListDiscoveryConfigsPagedResponse> listDiscoveryConfigsPagedCallable() {
        return this.stub.listDiscoveryConfigsPagedCallable();
    }

    public final UnaryCallable<ListDiscoveryConfigsRequest, ListDiscoveryConfigsResponse> listDiscoveryConfigsCallable() {
        return this.stub.listDiscoveryConfigsCallable();
    }

    public final void deleteDiscoveryConfig(DiscoveryConfigName name) {
        DeleteDiscoveryConfigRequest request = DeleteDiscoveryConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDiscoveryConfig(request);
    }

    public final void deleteDiscoveryConfig(String name) {
        DeleteDiscoveryConfigRequest request = DeleteDiscoveryConfigRequest.newBuilder().setName(name).build();
        this.deleteDiscoveryConfig(request);
    }

    public final void deleteDiscoveryConfig(DeleteDiscoveryConfigRequest request) {
        this.deleteDiscoveryConfigCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDiscoveryConfigRequest, Empty> deleteDiscoveryConfigCallable() {
        return this.stub.deleteDiscoveryConfigCallable();
    }

    public final DlpJob createDlpJob(LocationName parent, InspectJobConfig inspectJob) {
        CreateDlpJobRequest request = CreateDlpJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInspectJob(inspectJob).build();
        return this.createDlpJob(request);
    }

    public final DlpJob createDlpJob(LocationName parent, RiskAnalysisJobConfig riskJob) {
        CreateDlpJobRequest request = CreateDlpJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRiskJob(riskJob).build();
        return this.createDlpJob(request);
    }

    public final DlpJob createDlpJob(ProjectName parent, InspectJobConfig inspectJob) {
        CreateDlpJobRequest request = CreateDlpJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInspectJob(inspectJob).build();
        return this.createDlpJob(request);
    }

    public final DlpJob createDlpJob(ProjectName parent, RiskAnalysisJobConfig riskJob) {
        CreateDlpJobRequest request = CreateDlpJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRiskJob(riskJob).build();
        return this.createDlpJob(request);
    }

    public final DlpJob createDlpJob(String parent, InspectJobConfig inspectJob) {
        CreateDlpJobRequest request = CreateDlpJobRequest.newBuilder().setParent(parent).setInspectJob(inspectJob).build();
        return this.createDlpJob(request);
    }

    public final DlpJob createDlpJob(String parent, RiskAnalysisJobConfig riskJob) {
        CreateDlpJobRequest request = CreateDlpJobRequest.newBuilder().setParent(parent).setRiskJob(riskJob).build();
        return this.createDlpJob(request);
    }

    public final DlpJob createDlpJob(CreateDlpJobRequest request) {
        return (DlpJob)this.createDlpJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDlpJobRequest, DlpJob> createDlpJobCallable() {
        return this.stub.createDlpJobCallable();
    }

    public final ListDlpJobsPagedResponse listDlpJobs(LocationName parent) {
        ListDlpJobsRequest request = ListDlpJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDlpJobs(request);
    }

    public final ListDlpJobsPagedResponse listDlpJobs(ProjectName parent) {
        ListDlpJobsRequest request = ListDlpJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDlpJobs(request);
    }

    public final ListDlpJobsPagedResponse listDlpJobs(String parent) {
        ListDlpJobsRequest request = ListDlpJobsRequest.newBuilder().setParent(parent).build();
        return this.listDlpJobs(request);
    }

    public final ListDlpJobsPagedResponse listDlpJobs(ListDlpJobsRequest request) {
        return (ListDlpJobsPagedResponse)((Object)this.listDlpJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDlpJobsRequest, ListDlpJobsPagedResponse> listDlpJobsPagedCallable() {
        return this.stub.listDlpJobsPagedCallable();
    }

    public final UnaryCallable<ListDlpJobsRequest, ListDlpJobsResponse> listDlpJobsCallable() {
        return this.stub.listDlpJobsCallable();
    }

    public final DlpJob getDlpJob(DlpJobName name) {
        GetDlpJobRequest request = GetDlpJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDlpJob(request);
    }

    public final DlpJob getDlpJob(String name) {
        GetDlpJobRequest request = GetDlpJobRequest.newBuilder().setName(name).build();
        return this.getDlpJob(request);
    }

    public final DlpJob getDlpJob(GetDlpJobRequest request) {
        return (DlpJob)this.getDlpJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetDlpJobRequest, DlpJob> getDlpJobCallable() {
        return this.stub.getDlpJobCallable();
    }

    public final void deleteDlpJob(DlpJobName name) {
        DeleteDlpJobRequest request = DeleteDlpJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDlpJob(request);
    }

    public final void deleteDlpJob(String name) {
        DeleteDlpJobRequest request = DeleteDlpJobRequest.newBuilder().setName(name).build();
        this.deleteDlpJob(request);
    }

    public final void deleteDlpJob(DeleteDlpJobRequest request) {
        this.deleteDlpJobCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDlpJobRequest, Empty> deleteDlpJobCallable() {
        return this.stub.deleteDlpJobCallable();
    }

    public final void cancelDlpJob(CancelDlpJobRequest request) {
        this.cancelDlpJobCallable().call((Object)request);
    }

    public final UnaryCallable<CancelDlpJobRequest, Empty> cancelDlpJobCallable() {
        return this.stub.cancelDlpJobCallable();
    }

    public final StoredInfoType createStoredInfoType(LocationName parent, StoredInfoTypeConfig config) {
        CreateStoredInfoTypeRequest request = CreateStoredInfoTypeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConfig(config).build();
        return this.createStoredInfoType(request);
    }

    public final StoredInfoType createStoredInfoType(OrganizationLocationName parent, StoredInfoTypeConfig config) {
        CreateStoredInfoTypeRequest request = CreateStoredInfoTypeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConfig(config).build();
        return this.createStoredInfoType(request);
    }

    public final StoredInfoType createStoredInfoType(OrganizationName parent, StoredInfoTypeConfig config) {
        CreateStoredInfoTypeRequest request = CreateStoredInfoTypeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConfig(config).build();
        return this.createStoredInfoType(request);
    }

    public final StoredInfoType createStoredInfoType(ProjectName parent, StoredInfoTypeConfig config) {
        CreateStoredInfoTypeRequest request = CreateStoredInfoTypeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConfig(config).build();
        return this.createStoredInfoType(request);
    }

    public final StoredInfoType createStoredInfoType(String parent, StoredInfoTypeConfig config) {
        CreateStoredInfoTypeRequest request = CreateStoredInfoTypeRequest.newBuilder().setParent(parent).setConfig(config).build();
        return this.createStoredInfoType(request);
    }

    public final StoredInfoType createStoredInfoType(CreateStoredInfoTypeRequest request) {
        return (StoredInfoType)this.createStoredInfoTypeCallable().call((Object)request);
    }

    public final UnaryCallable<CreateStoredInfoTypeRequest, StoredInfoType> createStoredInfoTypeCallable() {
        return this.stub.createStoredInfoTypeCallable();
    }

    public final StoredInfoType updateStoredInfoType(StoredInfoTypeName name, StoredInfoTypeConfig config, FieldMask updateMask) {
        UpdateStoredInfoTypeRequest request = UpdateStoredInfoTypeRequest.newBuilder().setName(name == null ? null : name.toString()).setConfig(config).setUpdateMask(updateMask).build();
        return this.updateStoredInfoType(request);
    }

    public final StoredInfoType updateStoredInfoType(String name, StoredInfoTypeConfig config, FieldMask updateMask) {
        UpdateStoredInfoTypeRequest request = UpdateStoredInfoTypeRequest.newBuilder().setName(name).setConfig(config).setUpdateMask(updateMask).build();
        return this.updateStoredInfoType(request);
    }

    public final StoredInfoType updateStoredInfoType(UpdateStoredInfoTypeRequest request) {
        return (StoredInfoType)this.updateStoredInfoTypeCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateStoredInfoTypeRequest, StoredInfoType> updateStoredInfoTypeCallable() {
        return this.stub.updateStoredInfoTypeCallable();
    }

    public final StoredInfoType getStoredInfoType(StoredInfoTypeName name) {
        GetStoredInfoTypeRequest request = GetStoredInfoTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getStoredInfoType(request);
    }

    public final StoredInfoType getStoredInfoType(String name) {
        GetStoredInfoTypeRequest request = GetStoredInfoTypeRequest.newBuilder().setName(name).build();
        return this.getStoredInfoType(request);
    }

    public final StoredInfoType getStoredInfoType(GetStoredInfoTypeRequest request) {
        return (StoredInfoType)this.getStoredInfoTypeCallable().call((Object)request);
    }

    public final UnaryCallable<GetStoredInfoTypeRequest, StoredInfoType> getStoredInfoTypeCallable() {
        return this.stub.getStoredInfoTypeCallable();
    }

    public final ListStoredInfoTypesPagedResponse listStoredInfoTypes(LocationName parent) {
        ListStoredInfoTypesRequest request = ListStoredInfoTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listStoredInfoTypes(request);
    }

    public final ListStoredInfoTypesPagedResponse listStoredInfoTypes(OrganizationLocationName parent) {
        ListStoredInfoTypesRequest request = ListStoredInfoTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listStoredInfoTypes(request);
    }

    public final ListStoredInfoTypesPagedResponse listStoredInfoTypes(OrganizationName parent) {
        ListStoredInfoTypesRequest request = ListStoredInfoTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listStoredInfoTypes(request);
    }

    public final ListStoredInfoTypesPagedResponse listStoredInfoTypes(ProjectName parent) {
        ListStoredInfoTypesRequest request = ListStoredInfoTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listStoredInfoTypes(request);
    }

    public final ListStoredInfoTypesPagedResponse listStoredInfoTypes(String parent) {
        ListStoredInfoTypesRequest request = ListStoredInfoTypesRequest.newBuilder().setParent(parent).build();
        return this.listStoredInfoTypes(request);
    }

    public final ListStoredInfoTypesPagedResponse listStoredInfoTypes(ListStoredInfoTypesRequest request) {
        return (ListStoredInfoTypesPagedResponse)((Object)this.listStoredInfoTypesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListStoredInfoTypesRequest, ListStoredInfoTypesPagedResponse> listStoredInfoTypesPagedCallable() {
        return this.stub.listStoredInfoTypesPagedCallable();
    }

    public final UnaryCallable<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse> listStoredInfoTypesCallable() {
        return this.stub.listStoredInfoTypesCallable();
    }

    public final void deleteStoredInfoType(StoredInfoTypeName name) {
        DeleteStoredInfoTypeRequest request = DeleteStoredInfoTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteStoredInfoType(request);
    }

    public final void deleteStoredInfoType(String name) {
        DeleteStoredInfoTypeRequest request = DeleteStoredInfoTypeRequest.newBuilder().setName(name).build();
        this.deleteStoredInfoType(request);
    }

    public final void deleteStoredInfoType(DeleteStoredInfoTypeRequest request) {
        this.deleteStoredInfoTypeCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteStoredInfoTypeRequest, Empty> deleteStoredInfoTypeCallable() {
        return this.stub.deleteStoredInfoTypeCallable();
    }

    public final ListProjectDataProfilesPagedResponse listProjectDataProfiles(LocationName parent) {
        ListProjectDataProfilesRequest request = ListProjectDataProfilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProjectDataProfiles(request);
    }

    public final ListProjectDataProfilesPagedResponse listProjectDataProfiles(OrganizationLocationName parent) {
        ListProjectDataProfilesRequest request = ListProjectDataProfilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProjectDataProfiles(request);
    }

    public final ListProjectDataProfilesPagedResponse listProjectDataProfiles(String parent) {
        ListProjectDataProfilesRequest request = ListProjectDataProfilesRequest.newBuilder().setParent(parent).build();
        return this.listProjectDataProfiles(request);
    }

    public final ListProjectDataProfilesPagedResponse listProjectDataProfiles(ListProjectDataProfilesRequest request) {
        return (ListProjectDataProfilesPagedResponse)((Object)this.listProjectDataProfilesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProjectDataProfilesRequest, ListProjectDataProfilesPagedResponse> listProjectDataProfilesPagedCallable() {
        return this.stub.listProjectDataProfilesPagedCallable();
    }

    public final UnaryCallable<ListProjectDataProfilesRequest, ListProjectDataProfilesResponse> listProjectDataProfilesCallable() {
        return this.stub.listProjectDataProfilesCallable();
    }

    public final ListTableDataProfilesPagedResponse listTableDataProfiles(LocationName parent) {
        ListTableDataProfilesRequest request = ListTableDataProfilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTableDataProfiles(request);
    }

    public final ListTableDataProfilesPagedResponse listTableDataProfiles(OrganizationLocationName parent) {
        ListTableDataProfilesRequest request = ListTableDataProfilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTableDataProfiles(request);
    }

    public final ListTableDataProfilesPagedResponse listTableDataProfiles(String parent) {
        ListTableDataProfilesRequest request = ListTableDataProfilesRequest.newBuilder().setParent(parent).build();
        return this.listTableDataProfiles(request);
    }

    public final ListTableDataProfilesPagedResponse listTableDataProfiles(ListTableDataProfilesRequest request) {
        return (ListTableDataProfilesPagedResponse)((Object)this.listTableDataProfilesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTableDataProfilesRequest, ListTableDataProfilesPagedResponse> listTableDataProfilesPagedCallable() {
        return this.stub.listTableDataProfilesPagedCallable();
    }

    public final UnaryCallable<ListTableDataProfilesRequest, ListTableDataProfilesResponse> listTableDataProfilesCallable() {
        return this.stub.listTableDataProfilesCallable();
    }

    public final ListColumnDataProfilesPagedResponse listColumnDataProfiles(LocationName parent) {
        ListColumnDataProfilesRequest request = ListColumnDataProfilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listColumnDataProfiles(request);
    }

    public final ListColumnDataProfilesPagedResponse listColumnDataProfiles(OrganizationLocationName parent) {
        ListColumnDataProfilesRequest request = ListColumnDataProfilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listColumnDataProfiles(request);
    }

    public final ListColumnDataProfilesPagedResponse listColumnDataProfiles(String parent) {
        ListColumnDataProfilesRequest request = ListColumnDataProfilesRequest.newBuilder().setParent(parent).build();
        return this.listColumnDataProfiles(request);
    }

    public final ListColumnDataProfilesPagedResponse listColumnDataProfiles(ListColumnDataProfilesRequest request) {
        return (ListColumnDataProfilesPagedResponse)((Object)this.listColumnDataProfilesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListColumnDataProfilesRequest, ListColumnDataProfilesPagedResponse> listColumnDataProfilesPagedCallable() {
        return this.stub.listColumnDataProfilesPagedCallable();
    }

    public final UnaryCallable<ListColumnDataProfilesRequest, ListColumnDataProfilesResponse> listColumnDataProfilesCallable() {
        return this.stub.listColumnDataProfilesCallable();
    }

    public final ProjectDataProfile getProjectDataProfile(ProjectDataProfileName name) {
        GetProjectDataProfileRequest request = GetProjectDataProfileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProjectDataProfile(request);
    }

    public final ProjectDataProfile getProjectDataProfile(String name) {
        GetProjectDataProfileRequest request = GetProjectDataProfileRequest.newBuilder().setName(name).build();
        return this.getProjectDataProfile(request);
    }

    public final ProjectDataProfile getProjectDataProfile(GetProjectDataProfileRequest request) {
        return (ProjectDataProfile)this.getProjectDataProfileCallable().call((Object)request);
    }

    public final UnaryCallable<GetProjectDataProfileRequest, ProjectDataProfile> getProjectDataProfileCallable() {
        return this.stub.getProjectDataProfileCallable();
    }

    public final TableDataProfile getTableDataProfile(TableDataProfileName name) {
        GetTableDataProfileRequest request = GetTableDataProfileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTableDataProfile(request);
    }

    public final TableDataProfile getTableDataProfile(String name) {
        GetTableDataProfileRequest request = GetTableDataProfileRequest.newBuilder().setName(name).build();
        return this.getTableDataProfile(request);
    }

    public final TableDataProfile getTableDataProfile(GetTableDataProfileRequest request) {
        return (TableDataProfile)this.getTableDataProfileCallable().call((Object)request);
    }

    public final UnaryCallable<GetTableDataProfileRequest, TableDataProfile> getTableDataProfileCallable() {
        return this.stub.getTableDataProfileCallable();
    }

    public final ColumnDataProfile getColumnDataProfile(ColumnDataProfileName name) {
        GetColumnDataProfileRequest request = GetColumnDataProfileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getColumnDataProfile(request);
    }

    public final ColumnDataProfile getColumnDataProfile(String name) {
        GetColumnDataProfileRequest request = GetColumnDataProfileRequest.newBuilder().setName(name).build();
        return this.getColumnDataProfile(request);
    }

    public final ColumnDataProfile getColumnDataProfile(GetColumnDataProfileRequest request) {
        return (ColumnDataProfile)this.getColumnDataProfileCallable().call((Object)request);
    }

    public final UnaryCallable<GetColumnDataProfileRequest, ColumnDataProfile> getColumnDataProfileCallable() {
        return this.stub.getColumnDataProfileCallable();
    }

    public final void deleteTableDataProfile(TableDataProfileName name) {
        DeleteTableDataProfileRequest request = DeleteTableDataProfileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteTableDataProfile(request);
    }

    public final void deleteTableDataProfile(String name) {
        DeleteTableDataProfileRequest request = DeleteTableDataProfileRequest.newBuilder().setName(name).build();
        this.deleteTableDataProfile(request);
    }

    public final void deleteTableDataProfile(DeleteTableDataProfileRequest request) {
        this.deleteTableDataProfileCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTableDataProfileRequest, Empty> deleteTableDataProfileCallable() {
        return this.stub.deleteTableDataProfileCallable();
    }

    public final HybridInspectResponse hybridInspectDlpJob(DlpJobName name) {
        HybridInspectDlpJobRequest request = HybridInspectDlpJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.hybridInspectDlpJob(request);
    }

    public final HybridInspectResponse hybridInspectDlpJob(String name) {
        HybridInspectDlpJobRequest request = HybridInspectDlpJobRequest.newBuilder().setName(name).build();
        return this.hybridInspectDlpJob(request);
    }

    public final HybridInspectResponse hybridInspectDlpJob(HybridInspectDlpJobRequest request) {
        return (HybridInspectResponse)this.hybridInspectDlpJobCallable().call((Object)request);
    }

    public final UnaryCallable<HybridInspectDlpJobRequest, HybridInspectResponse> hybridInspectDlpJobCallable() {
        return this.stub.hybridInspectDlpJobCallable();
    }

    public final void finishDlpJob(FinishDlpJobRequest request) {
        this.finishDlpJobCallable().call((Object)request);
    }

    public final UnaryCallable<FinishDlpJobRequest, Empty> finishDlpJobCallable() {
        return this.stub.finishDlpJobCallable();
    }

    public final Connection createConnection(LocationName parent, Connection connection) {
        CreateConnectionRequest request = CreateConnectionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConnection(connection).build();
        return this.createConnection(request);
    }

    public final Connection createConnection(String parent, Connection connection) {
        CreateConnectionRequest request = CreateConnectionRequest.newBuilder().setParent(parent).setConnection(connection).build();
        return this.createConnection(request);
    }

    public final Connection createConnection(CreateConnectionRequest request) {
        return (Connection)this.createConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateConnectionRequest, Connection> createConnectionCallable() {
        return this.stub.createConnectionCallable();
    }

    public final Connection getConnection(ConnectionName name) {
        GetConnectionRequest request = GetConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConnection(request);
    }

    public final Connection getConnection(String name) {
        GetConnectionRequest request = GetConnectionRequest.newBuilder().setName(name).build();
        return this.getConnection(request);
    }

    public final Connection getConnection(GetConnectionRequest request) {
        return (Connection)this.getConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<GetConnectionRequest, Connection> getConnectionCallable() {
        return this.stub.getConnectionCallable();
    }

    public final ListConnectionsPagedResponse listConnections(LocationName parent) {
        ListConnectionsRequest request = ListConnectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConnections(request);
    }

    public final ListConnectionsPagedResponse listConnections(String parent) {
        ListConnectionsRequest request = ListConnectionsRequest.newBuilder().setParent(parent).build();
        return this.listConnections(request);
    }

    public final ListConnectionsPagedResponse listConnections(ListConnectionsRequest request) {
        return (ListConnectionsPagedResponse)((Object)this.listConnectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConnectionsRequest, ListConnectionsPagedResponse> listConnectionsPagedCallable() {
        return this.stub.listConnectionsPagedCallable();
    }

    public final UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> listConnectionsCallable() {
        return this.stub.listConnectionsCallable();
    }

    public final SearchConnectionsPagedResponse searchConnections(LocationName parent) {
        SearchConnectionsRequest request = SearchConnectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.searchConnections(request);
    }

    public final SearchConnectionsPagedResponse searchConnections(String parent) {
        SearchConnectionsRequest request = SearchConnectionsRequest.newBuilder().setParent(parent).build();
        return this.searchConnections(request);
    }

    public final SearchConnectionsPagedResponse searchConnections(SearchConnectionsRequest request) {
        return (SearchConnectionsPagedResponse)((Object)this.searchConnectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchConnectionsRequest, SearchConnectionsPagedResponse> searchConnectionsPagedCallable() {
        return this.stub.searchConnectionsPagedCallable();
    }

    public final UnaryCallable<SearchConnectionsRequest, SearchConnectionsResponse> searchConnectionsCallable() {
        return this.stub.searchConnectionsCallable();
    }

    public final void deleteConnection(ConnectionName name) {
        DeleteConnectionRequest request = DeleteConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteConnection(request);
    }

    public final void deleteConnection(String name) {
        DeleteConnectionRequest request = DeleteConnectionRequest.newBuilder().setName(name).build();
        this.deleteConnection(request);
    }

    public final void deleteConnection(DeleteConnectionRequest request) {
        this.deleteConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteConnectionRequest, Empty> deleteConnectionCallable() {
        return this.stub.deleteConnectionCallable();
    }

    public final Connection updateConnection(ConnectionName name) {
        UpdateConnectionRequest request = UpdateConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.updateConnection(request);
    }

    public final Connection updateConnection(String name) {
        UpdateConnectionRequest request = UpdateConnectionRequest.newBuilder().setName(name).build();
        return this.updateConnection(request);
    }

    public final Connection updateConnection(UpdateConnectionRequest request) {
        return (Connection)this.updateConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateConnectionRequest, Connection> updateConnectionCallable() {
        return this.stub.updateConnectionCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchConnectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchConnectionsRequest, SearchConnectionsResponse, Connection, SearchConnectionsPage, SearchConnectionsFixedSizeCollection> {
        private SearchConnectionsFixedSizeCollection(List<SearchConnectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchConnectionsFixedSizeCollection createEmptyCollection() {
            return new SearchConnectionsFixedSizeCollection(null, 0);
        }

        protected SearchConnectionsFixedSizeCollection createCollection(List<SearchConnectionsPage> pages, int collectionSize) {
            return new SearchConnectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchConnectionsPage
    extends AbstractPage<SearchConnectionsRequest, SearchConnectionsResponse, Connection, SearchConnectionsPage> {
        private SearchConnectionsPage(PageContext<SearchConnectionsRequest, SearchConnectionsResponse, Connection> context, SearchConnectionsResponse response) {
            super(context, (Object)response);
        }

        private static SearchConnectionsPage createEmptyPage() {
            return new SearchConnectionsPage(null, null);
        }

        protected SearchConnectionsPage createPage(PageContext<SearchConnectionsRequest, SearchConnectionsResponse, Connection> context, SearchConnectionsResponse response) {
            return new SearchConnectionsPage(context, response);
        }

        public ApiFuture<SearchConnectionsPage> createPageAsync(PageContext<SearchConnectionsRequest, SearchConnectionsResponse, Connection> context, ApiFuture<SearchConnectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchConnectionsPagedResponse
    extends AbstractPagedListResponse<SearchConnectionsRequest, SearchConnectionsResponse, Connection, SearchConnectionsPage, SearchConnectionsFixedSizeCollection> {
        public static ApiFuture<SearchConnectionsPagedResponse> createAsync(PageContext<SearchConnectionsRequest, SearchConnectionsResponse, Connection> context, ApiFuture<SearchConnectionsResponse> futureResponse) {
            ApiFuture<SearchConnectionsPage> futurePage = SearchConnectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchConnectionsPagedResponse((SearchConnectionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchConnectionsPagedResponse(SearchConnectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchConnectionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConnectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConnectionsRequest, ListConnectionsResponse, Connection, ListConnectionsPage, ListConnectionsFixedSizeCollection> {
        private ListConnectionsFixedSizeCollection(List<ListConnectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConnectionsFixedSizeCollection createEmptyCollection() {
            return new ListConnectionsFixedSizeCollection(null, 0);
        }

        protected ListConnectionsFixedSizeCollection createCollection(List<ListConnectionsPage> pages, int collectionSize) {
            return new ListConnectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConnectionsPage
    extends AbstractPage<ListConnectionsRequest, ListConnectionsResponse, Connection, ListConnectionsPage> {
        private ListConnectionsPage(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ListConnectionsResponse response) {
            super(context, (Object)response);
        }

        private static ListConnectionsPage createEmptyPage() {
            return new ListConnectionsPage(null, null);
        }

        protected ListConnectionsPage createPage(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ListConnectionsResponse response) {
            return new ListConnectionsPage(context, response);
        }

        public ApiFuture<ListConnectionsPage> createPageAsync(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ApiFuture<ListConnectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConnectionsPagedResponse
    extends AbstractPagedListResponse<ListConnectionsRequest, ListConnectionsResponse, Connection, ListConnectionsPage, ListConnectionsFixedSizeCollection> {
        public static ApiFuture<ListConnectionsPagedResponse> createAsync(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ApiFuture<ListConnectionsResponse> futureResponse) {
            ApiFuture<ListConnectionsPage> futurePage = ListConnectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConnectionsPagedResponse((ListConnectionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConnectionsPagedResponse(ListConnectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConnectionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListColumnDataProfilesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListColumnDataProfilesRequest, ListColumnDataProfilesResponse, ColumnDataProfile, ListColumnDataProfilesPage, ListColumnDataProfilesFixedSizeCollection> {
        private ListColumnDataProfilesFixedSizeCollection(List<ListColumnDataProfilesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListColumnDataProfilesFixedSizeCollection createEmptyCollection() {
            return new ListColumnDataProfilesFixedSizeCollection(null, 0);
        }

        protected ListColumnDataProfilesFixedSizeCollection createCollection(List<ListColumnDataProfilesPage> pages, int collectionSize) {
            return new ListColumnDataProfilesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListColumnDataProfilesPage
    extends AbstractPage<ListColumnDataProfilesRequest, ListColumnDataProfilesResponse, ColumnDataProfile, ListColumnDataProfilesPage> {
        private ListColumnDataProfilesPage(PageContext<ListColumnDataProfilesRequest, ListColumnDataProfilesResponse, ColumnDataProfile> context, ListColumnDataProfilesResponse response) {
            super(context, (Object)response);
        }

        private static ListColumnDataProfilesPage createEmptyPage() {
            return new ListColumnDataProfilesPage(null, null);
        }

        protected ListColumnDataProfilesPage createPage(PageContext<ListColumnDataProfilesRequest, ListColumnDataProfilesResponse, ColumnDataProfile> context, ListColumnDataProfilesResponse response) {
            return new ListColumnDataProfilesPage(context, response);
        }

        public ApiFuture<ListColumnDataProfilesPage> createPageAsync(PageContext<ListColumnDataProfilesRequest, ListColumnDataProfilesResponse, ColumnDataProfile> context, ApiFuture<ListColumnDataProfilesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListColumnDataProfilesPagedResponse
    extends AbstractPagedListResponse<ListColumnDataProfilesRequest, ListColumnDataProfilesResponse, ColumnDataProfile, ListColumnDataProfilesPage, ListColumnDataProfilesFixedSizeCollection> {
        public static ApiFuture<ListColumnDataProfilesPagedResponse> createAsync(PageContext<ListColumnDataProfilesRequest, ListColumnDataProfilesResponse, ColumnDataProfile> context, ApiFuture<ListColumnDataProfilesResponse> futureResponse) {
            ApiFuture<ListColumnDataProfilesPage> futurePage = ListColumnDataProfilesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListColumnDataProfilesPagedResponse((ListColumnDataProfilesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListColumnDataProfilesPagedResponse(ListColumnDataProfilesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListColumnDataProfilesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTableDataProfilesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTableDataProfilesRequest, ListTableDataProfilesResponse, TableDataProfile, ListTableDataProfilesPage, ListTableDataProfilesFixedSizeCollection> {
        private ListTableDataProfilesFixedSizeCollection(List<ListTableDataProfilesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTableDataProfilesFixedSizeCollection createEmptyCollection() {
            return new ListTableDataProfilesFixedSizeCollection(null, 0);
        }

        protected ListTableDataProfilesFixedSizeCollection createCollection(List<ListTableDataProfilesPage> pages, int collectionSize) {
            return new ListTableDataProfilesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTableDataProfilesPage
    extends AbstractPage<ListTableDataProfilesRequest, ListTableDataProfilesResponse, TableDataProfile, ListTableDataProfilesPage> {
        private ListTableDataProfilesPage(PageContext<ListTableDataProfilesRequest, ListTableDataProfilesResponse, TableDataProfile> context, ListTableDataProfilesResponse response) {
            super(context, (Object)response);
        }

        private static ListTableDataProfilesPage createEmptyPage() {
            return new ListTableDataProfilesPage(null, null);
        }

        protected ListTableDataProfilesPage createPage(PageContext<ListTableDataProfilesRequest, ListTableDataProfilesResponse, TableDataProfile> context, ListTableDataProfilesResponse response) {
            return new ListTableDataProfilesPage(context, response);
        }

        public ApiFuture<ListTableDataProfilesPage> createPageAsync(PageContext<ListTableDataProfilesRequest, ListTableDataProfilesResponse, TableDataProfile> context, ApiFuture<ListTableDataProfilesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTableDataProfilesPagedResponse
    extends AbstractPagedListResponse<ListTableDataProfilesRequest, ListTableDataProfilesResponse, TableDataProfile, ListTableDataProfilesPage, ListTableDataProfilesFixedSizeCollection> {
        public static ApiFuture<ListTableDataProfilesPagedResponse> createAsync(PageContext<ListTableDataProfilesRequest, ListTableDataProfilesResponse, TableDataProfile> context, ApiFuture<ListTableDataProfilesResponse> futureResponse) {
            ApiFuture<ListTableDataProfilesPage> futurePage = ListTableDataProfilesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTableDataProfilesPagedResponse((ListTableDataProfilesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTableDataProfilesPagedResponse(ListTableDataProfilesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTableDataProfilesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListProjectDataProfilesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProjectDataProfilesRequest, ListProjectDataProfilesResponse, ProjectDataProfile, ListProjectDataProfilesPage, ListProjectDataProfilesFixedSizeCollection> {
        private ListProjectDataProfilesFixedSizeCollection(List<ListProjectDataProfilesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProjectDataProfilesFixedSizeCollection createEmptyCollection() {
            return new ListProjectDataProfilesFixedSizeCollection(null, 0);
        }

        protected ListProjectDataProfilesFixedSizeCollection createCollection(List<ListProjectDataProfilesPage> pages, int collectionSize) {
            return new ListProjectDataProfilesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProjectDataProfilesPage
    extends AbstractPage<ListProjectDataProfilesRequest, ListProjectDataProfilesResponse, ProjectDataProfile, ListProjectDataProfilesPage> {
        private ListProjectDataProfilesPage(PageContext<ListProjectDataProfilesRequest, ListProjectDataProfilesResponse, ProjectDataProfile> context, ListProjectDataProfilesResponse response) {
            super(context, (Object)response);
        }

        private static ListProjectDataProfilesPage createEmptyPage() {
            return new ListProjectDataProfilesPage(null, null);
        }

        protected ListProjectDataProfilesPage createPage(PageContext<ListProjectDataProfilesRequest, ListProjectDataProfilesResponse, ProjectDataProfile> context, ListProjectDataProfilesResponse response) {
            return new ListProjectDataProfilesPage(context, response);
        }

        public ApiFuture<ListProjectDataProfilesPage> createPageAsync(PageContext<ListProjectDataProfilesRequest, ListProjectDataProfilesResponse, ProjectDataProfile> context, ApiFuture<ListProjectDataProfilesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProjectDataProfilesPagedResponse
    extends AbstractPagedListResponse<ListProjectDataProfilesRequest, ListProjectDataProfilesResponse, ProjectDataProfile, ListProjectDataProfilesPage, ListProjectDataProfilesFixedSizeCollection> {
        public static ApiFuture<ListProjectDataProfilesPagedResponse> createAsync(PageContext<ListProjectDataProfilesRequest, ListProjectDataProfilesResponse, ProjectDataProfile> context, ApiFuture<ListProjectDataProfilesResponse> futureResponse) {
            ApiFuture<ListProjectDataProfilesPage> futurePage = ListProjectDataProfilesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListProjectDataProfilesPagedResponse((ListProjectDataProfilesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListProjectDataProfilesPagedResponse(ListProjectDataProfilesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProjectDataProfilesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListStoredInfoTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse, StoredInfoType, ListStoredInfoTypesPage, ListStoredInfoTypesFixedSizeCollection> {
        private ListStoredInfoTypesFixedSizeCollection(List<ListStoredInfoTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListStoredInfoTypesFixedSizeCollection createEmptyCollection() {
            return new ListStoredInfoTypesFixedSizeCollection(null, 0);
        }

        protected ListStoredInfoTypesFixedSizeCollection createCollection(List<ListStoredInfoTypesPage> pages, int collectionSize) {
            return new ListStoredInfoTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListStoredInfoTypesPage
    extends AbstractPage<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse, StoredInfoType, ListStoredInfoTypesPage> {
        private ListStoredInfoTypesPage(PageContext<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse, StoredInfoType> context, ListStoredInfoTypesResponse response) {
            super(context, (Object)response);
        }

        private static ListStoredInfoTypesPage createEmptyPage() {
            return new ListStoredInfoTypesPage(null, null);
        }

        protected ListStoredInfoTypesPage createPage(PageContext<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse, StoredInfoType> context, ListStoredInfoTypesResponse response) {
            return new ListStoredInfoTypesPage(context, response);
        }

        public ApiFuture<ListStoredInfoTypesPage> createPageAsync(PageContext<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse, StoredInfoType> context, ApiFuture<ListStoredInfoTypesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListStoredInfoTypesPagedResponse
    extends AbstractPagedListResponse<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse, StoredInfoType, ListStoredInfoTypesPage, ListStoredInfoTypesFixedSizeCollection> {
        public static ApiFuture<ListStoredInfoTypesPagedResponse> createAsync(PageContext<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse, StoredInfoType> context, ApiFuture<ListStoredInfoTypesResponse> futureResponse) {
            ApiFuture<ListStoredInfoTypesPage> futurePage = ListStoredInfoTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListStoredInfoTypesPagedResponse((ListStoredInfoTypesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListStoredInfoTypesPagedResponse(ListStoredInfoTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListStoredInfoTypesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDlpJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDlpJobsRequest, ListDlpJobsResponse, DlpJob, ListDlpJobsPage, ListDlpJobsFixedSizeCollection> {
        private ListDlpJobsFixedSizeCollection(List<ListDlpJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDlpJobsFixedSizeCollection createEmptyCollection() {
            return new ListDlpJobsFixedSizeCollection(null, 0);
        }

        protected ListDlpJobsFixedSizeCollection createCollection(List<ListDlpJobsPage> pages, int collectionSize) {
            return new ListDlpJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDlpJobsPage
    extends AbstractPage<ListDlpJobsRequest, ListDlpJobsResponse, DlpJob, ListDlpJobsPage> {
        private ListDlpJobsPage(PageContext<ListDlpJobsRequest, ListDlpJobsResponse, DlpJob> context, ListDlpJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListDlpJobsPage createEmptyPage() {
            return new ListDlpJobsPage(null, null);
        }

        protected ListDlpJobsPage createPage(PageContext<ListDlpJobsRequest, ListDlpJobsResponse, DlpJob> context, ListDlpJobsResponse response) {
            return new ListDlpJobsPage(context, response);
        }

        public ApiFuture<ListDlpJobsPage> createPageAsync(PageContext<ListDlpJobsRequest, ListDlpJobsResponse, DlpJob> context, ApiFuture<ListDlpJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDlpJobsPagedResponse
    extends AbstractPagedListResponse<ListDlpJobsRequest, ListDlpJobsResponse, DlpJob, ListDlpJobsPage, ListDlpJobsFixedSizeCollection> {
        public static ApiFuture<ListDlpJobsPagedResponse> createAsync(PageContext<ListDlpJobsRequest, ListDlpJobsResponse, DlpJob> context, ApiFuture<ListDlpJobsResponse> futureResponse) {
            ApiFuture<ListDlpJobsPage> futurePage = ListDlpJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDlpJobsPagedResponse((ListDlpJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDlpJobsPagedResponse(ListDlpJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDlpJobsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDiscoveryConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDiscoveryConfigsRequest, ListDiscoveryConfigsResponse, DiscoveryConfig, ListDiscoveryConfigsPage, ListDiscoveryConfigsFixedSizeCollection> {
        private ListDiscoveryConfigsFixedSizeCollection(List<ListDiscoveryConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDiscoveryConfigsFixedSizeCollection createEmptyCollection() {
            return new ListDiscoveryConfigsFixedSizeCollection(null, 0);
        }

        protected ListDiscoveryConfigsFixedSizeCollection createCollection(List<ListDiscoveryConfigsPage> pages, int collectionSize) {
            return new ListDiscoveryConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDiscoveryConfigsPage
    extends AbstractPage<ListDiscoveryConfigsRequest, ListDiscoveryConfigsResponse, DiscoveryConfig, ListDiscoveryConfigsPage> {
        private ListDiscoveryConfigsPage(PageContext<ListDiscoveryConfigsRequest, ListDiscoveryConfigsResponse, DiscoveryConfig> context, ListDiscoveryConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListDiscoveryConfigsPage createEmptyPage() {
            return new ListDiscoveryConfigsPage(null, null);
        }

        protected ListDiscoveryConfigsPage createPage(PageContext<ListDiscoveryConfigsRequest, ListDiscoveryConfigsResponse, DiscoveryConfig> context, ListDiscoveryConfigsResponse response) {
            return new ListDiscoveryConfigsPage(context, response);
        }

        public ApiFuture<ListDiscoveryConfigsPage> createPageAsync(PageContext<ListDiscoveryConfigsRequest, ListDiscoveryConfigsResponse, DiscoveryConfig> context, ApiFuture<ListDiscoveryConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDiscoveryConfigsPagedResponse
    extends AbstractPagedListResponse<ListDiscoveryConfigsRequest, ListDiscoveryConfigsResponse, DiscoveryConfig, ListDiscoveryConfigsPage, ListDiscoveryConfigsFixedSizeCollection> {
        public static ApiFuture<ListDiscoveryConfigsPagedResponse> createAsync(PageContext<ListDiscoveryConfigsRequest, ListDiscoveryConfigsResponse, DiscoveryConfig> context, ApiFuture<ListDiscoveryConfigsResponse> futureResponse) {
            ApiFuture<ListDiscoveryConfigsPage> futurePage = ListDiscoveryConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDiscoveryConfigsPagedResponse((ListDiscoveryConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDiscoveryConfigsPagedResponse(ListDiscoveryConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDiscoveryConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListJobTriggersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListJobTriggersRequest, ListJobTriggersResponse, JobTrigger, ListJobTriggersPage, ListJobTriggersFixedSizeCollection> {
        private ListJobTriggersFixedSizeCollection(List<ListJobTriggersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListJobTriggersFixedSizeCollection createEmptyCollection() {
            return new ListJobTriggersFixedSizeCollection(null, 0);
        }

        protected ListJobTriggersFixedSizeCollection createCollection(List<ListJobTriggersPage> pages, int collectionSize) {
            return new ListJobTriggersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListJobTriggersPage
    extends AbstractPage<ListJobTriggersRequest, ListJobTriggersResponse, JobTrigger, ListJobTriggersPage> {
        private ListJobTriggersPage(PageContext<ListJobTriggersRequest, ListJobTriggersResponse, JobTrigger> context, ListJobTriggersResponse response) {
            super(context, (Object)response);
        }

        private static ListJobTriggersPage createEmptyPage() {
            return new ListJobTriggersPage(null, null);
        }

        protected ListJobTriggersPage createPage(PageContext<ListJobTriggersRequest, ListJobTriggersResponse, JobTrigger> context, ListJobTriggersResponse response) {
            return new ListJobTriggersPage(context, response);
        }

        public ApiFuture<ListJobTriggersPage> createPageAsync(PageContext<ListJobTriggersRequest, ListJobTriggersResponse, JobTrigger> context, ApiFuture<ListJobTriggersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListJobTriggersPagedResponse
    extends AbstractPagedListResponse<ListJobTriggersRequest, ListJobTriggersResponse, JobTrigger, ListJobTriggersPage, ListJobTriggersFixedSizeCollection> {
        public static ApiFuture<ListJobTriggersPagedResponse> createAsync(PageContext<ListJobTriggersRequest, ListJobTriggersResponse, JobTrigger> context, ApiFuture<ListJobTriggersResponse> futureResponse) {
            ApiFuture<ListJobTriggersPage> futurePage = ListJobTriggersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListJobTriggersPagedResponse((ListJobTriggersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListJobTriggersPagedResponse(ListJobTriggersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListJobTriggersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDeidentifyTemplatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse, DeidentifyTemplate, ListDeidentifyTemplatesPage, ListDeidentifyTemplatesFixedSizeCollection> {
        private ListDeidentifyTemplatesFixedSizeCollection(List<ListDeidentifyTemplatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDeidentifyTemplatesFixedSizeCollection createEmptyCollection() {
            return new ListDeidentifyTemplatesFixedSizeCollection(null, 0);
        }

        protected ListDeidentifyTemplatesFixedSizeCollection createCollection(List<ListDeidentifyTemplatesPage> pages, int collectionSize) {
            return new ListDeidentifyTemplatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDeidentifyTemplatesPage
    extends AbstractPage<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse, DeidentifyTemplate, ListDeidentifyTemplatesPage> {
        private ListDeidentifyTemplatesPage(PageContext<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse, DeidentifyTemplate> context, ListDeidentifyTemplatesResponse response) {
            super(context, (Object)response);
        }

        private static ListDeidentifyTemplatesPage createEmptyPage() {
            return new ListDeidentifyTemplatesPage(null, null);
        }

        protected ListDeidentifyTemplatesPage createPage(PageContext<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse, DeidentifyTemplate> context, ListDeidentifyTemplatesResponse response) {
            return new ListDeidentifyTemplatesPage(context, response);
        }

        public ApiFuture<ListDeidentifyTemplatesPage> createPageAsync(PageContext<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse, DeidentifyTemplate> context, ApiFuture<ListDeidentifyTemplatesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDeidentifyTemplatesPagedResponse
    extends AbstractPagedListResponse<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse, DeidentifyTemplate, ListDeidentifyTemplatesPage, ListDeidentifyTemplatesFixedSizeCollection> {
        public static ApiFuture<ListDeidentifyTemplatesPagedResponse> createAsync(PageContext<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse, DeidentifyTemplate> context, ApiFuture<ListDeidentifyTemplatesResponse> futureResponse) {
            ApiFuture<ListDeidentifyTemplatesPage> futurePage = ListDeidentifyTemplatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDeidentifyTemplatesPagedResponse((ListDeidentifyTemplatesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDeidentifyTemplatesPagedResponse(ListDeidentifyTemplatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDeidentifyTemplatesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInspectTemplatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInspectTemplatesRequest, ListInspectTemplatesResponse, InspectTemplate, ListInspectTemplatesPage, ListInspectTemplatesFixedSizeCollection> {
        private ListInspectTemplatesFixedSizeCollection(List<ListInspectTemplatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInspectTemplatesFixedSizeCollection createEmptyCollection() {
            return new ListInspectTemplatesFixedSizeCollection(null, 0);
        }

        protected ListInspectTemplatesFixedSizeCollection createCollection(List<ListInspectTemplatesPage> pages, int collectionSize) {
            return new ListInspectTemplatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInspectTemplatesPage
    extends AbstractPage<ListInspectTemplatesRequest, ListInspectTemplatesResponse, InspectTemplate, ListInspectTemplatesPage> {
        private ListInspectTemplatesPage(PageContext<ListInspectTemplatesRequest, ListInspectTemplatesResponse, InspectTemplate> context, ListInspectTemplatesResponse response) {
            super(context, (Object)response);
        }

        private static ListInspectTemplatesPage createEmptyPage() {
            return new ListInspectTemplatesPage(null, null);
        }

        protected ListInspectTemplatesPage createPage(PageContext<ListInspectTemplatesRequest, ListInspectTemplatesResponse, InspectTemplate> context, ListInspectTemplatesResponse response) {
            return new ListInspectTemplatesPage(context, response);
        }

        public ApiFuture<ListInspectTemplatesPage> createPageAsync(PageContext<ListInspectTemplatesRequest, ListInspectTemplatesResponse, InspectTemplate> context, ApiFuture<ListInspectTemplatesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInspectTemplatesPagedResponse
    extends AbstractPagedListResponse<ListInspectTemplatesRequest, ListInspectTemplatesResponse, InspectTemplate, ListInspectTemplatesPage, ListInspectTemplatesFixedSizeCollection> {
        public static ApiFuture<ListInspectTemplatesPagedResponse> createAsync(PageContext<ListInspectTemplatesRequest, ListInspectTemplatesResponse, InspectTemplate> context, ApiFuture<ListInspectTemplatesResponse> futureResponse) {
            ApiFuture<ListInspectTemplatesPage> futurePage = ListInspectTemplatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInspectTemplatesPagedResponse((ListInspectTemplatesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInspectTemplatesPagedResponse(ListInspectTemplatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInspectTemplatesFixedSizeCollection.createEmptyCollection());
        }
    }
}

