/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.edgecontainer.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.edgecontainer.v1.Cluster;
import com.google.cloud.edgecontainer.v1.ClusterName;
import com.google.cloud.edgecontainer.v1.CreateClusterRequest;
import com.google.cloud.edgecontainer.v1.CreateNodePoolRequest;
import com.google.cloud.edgecontainer.v1.CreateVpnConnectionRequest;
import com.google.cloud.edgecontainer.v1.DeleteClusterRequest;
import com.google.cloud.edgecontainer.v1.DeleteNodePoolRequest;
import com.google.cloud.edgecontainer.v1.DeleteVpnConnectionRequest;
import com.google.cloud.edgecontainer.v1.EdgeContainerSettings;
import com.google.cloud.edgecontainer.v1.GenerateAccessTokenRequest;
import com.google.cloud.edgecontainer.v1.GenerateAccessTokenResponse;
import com.google.cloud.edgecontainer.v1.GenerateOfflineCredentialRequest;
import com.google.cloud.edgecontainer.v1.GenerateOfflineCredentialResponse;
import com.google.cloud.edgecontainer.v1.GetClusterRequest;
import com.google.cloud.edgecontainer.v1.GetMachineRequest;
import com.google.cloud.edgecontainer.v1.GetNodePoolRequest;
import com.google.cloud.edgecontainer.v1.GetServerConfigRequest;
import com.google.cloud.edgecontainer.v1.GetVpnConnectionRequest;
import com.google.cloud.edgecontainer.v1.ListClustersRequest;
import com.google.cloud.edgecontainer.v1.ListClustersResponse;
import com.google.cloud.edgecontainer.v1.ListMachinesRequest;
import com.google.cloud.edgecontainer.v1.ListMachinesResponse;
import com.google.cloud.edgecontainer.v1.ListNodePoolsRequest;
import com.google.cloud.edgecontainer.v1.ListNodePoolsResponse;
import com.google.cloud.edgecontainer.v1.ListVpnConnectionsRequest;
import com.google.cloud.edgecontainer.v1.ListVpnConnectionsResponse;
import com.google.cloud.edgecontainer.v1.LocationName;
import com.google.cloud.edgecontainer.v1.Machine;
import com.google.cloud.edgecontainer.v1.MachineName;
import com.google.cloud.edgecontainer.v1.NodePool;
import com.google.cloud.edgecontainer.v1.NodePoolName;
import com.google.cloud.edgecontainer.v1.OperationMetadata;
import com.google.cloud.edgecontainer.v1.ServerConfig;
import com.google.cloud.edgecontainer.v1.UpdateClusterRequest;
import com.google.cloud.edgecontainer.v1.UpdateNodePoolRequest;
import com.google.cloud.edgecontainer.v1.UpgradeClusterRequest;
import com.google.cloud.edgecontainer.v1.VpnConnection;
import com.google.cloud.edgecontainer.v1.VpnConnectionName;
import com.google.cloud.edgecontainer.v1.stub.EdgeContainerStub;
import com.google.cloud.edgecontainer.v1.stub.EdgeContainerStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class EdgeContainerClient
implements BackgroundResource {
    private final EdgeContainerSettings settings;
    private final EdgeContainerStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final EdgeContainerClient create() throws IOException {
        return EdgeContainerClient.create(EdgeContainerSettings.newBuilder().build());
    }

    public static final EdgeContainerClient create(EdgeContainerSettings settings) throws IOException {
        return new EdgeContainerClient(settings);
    }

    public static final EdgeContainerClient create(EdgeContainerStub stub) {
        return new EdgeContainerClient(stub);
    }

    protected EdgeContainerClient(EdgeContainerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EdgeContainerStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected EdgeContainerClient(EdgeContainerStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final EdgeContainerSettings getSettings() {
        return this.settings;
    }

    public EdgeContainerStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListClustersPagedResponse listClusters(LocationName parent) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listClusters(request);
    }

    public final ListClustersPagedResponse listClusters(String parent) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(parent).build();
        return this.listClusters(request);
    }

    public final ListClustersPagedResponse listClusters(ListClustersRequest request) {
        return (ListClustersPagedResponse)((Object)this.listClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListClustersRequest, ListClustersPagedResponse> listClustersPagedCallable() {
        return this.stub.listClustersPagedCallable();
    }

    public final UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable() {
        return this.stub.listClustersCallable();
    }

    public final Cluster getCluster(ClusterName name) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(String name) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(GetClusterRequest request) {
        return (Cluster)this.getClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetClusterRequest, Cluster> getClusterCallable() {
        return this.stub.getClusterCallable();
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(LocationName parent, Cluster cluster, String clusterId) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCluster(cluster).setClusterId(clusterId).build();
        return this.createClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(String parent, Cluster cluster, String clusterId) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setParent(parent).setCluster(cluster).setClusterId(clusterId).build();
        return this.createClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationCallable() {
        return this.stub.createClusterOperationCallable();
    }

    public final UnaryCallable<CreateClusterRequest, Operation> createClusterCallable() {
        return this.stub.createClusterCallable();
    }

    public final OperationFuture<Cluster, OperationMetadata> updateClusterAsync(Cluster cluster, FieldMask updateMask) {
        UpdateClusterRequest request = UpdateClusterRequest.newBuilder().setCluster(cluster).setUpdateMask(updateMask).build();
        return this.updateClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> updateClusterAsync(UpdateClusterRequest request) {
        return this.updateClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationCallable() {
        return this.stub.updateClusterOperationCallable();
    }

    public final UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable() {
        return this.stub.updateClusterCallable();
    }

    public final OperationFuture<Cluster, OperationMetadata> upgradeClusterAsync(ClusterName name, String targetVersion, UpgradeClusterRequest.Schedule schedule) {
        UpgradeClusterRequest request = UpgradeClusterRequest.newBuilder().setName(name == null ? null : name.toString()).setTargetVersion(targetVersion).setSchedule(schedule).build();
        return this.upgradeClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> upgradeClusterAsync(String name, String targetVersion, UpgradeClusterRequest.Schedule schedule) {
        UpgradeClusterRequest request = UpgradeClusterRequest.newBuilder().setName(name).setTargetVersion(targetVersion).setSchedule(schedule).build();
        return this.upgradeClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> upgradeClusterAsync(UpgradeClusterRequest request) {
        return this.upgradeClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpgradeClusterRequest, Cluster, OperationMetadata> upgradeClusterOperationCallable() {
        return this.stub.upgradeClusterOperationCallable();
    }

    public final UnaryCallable<UpgradeClusterRequest, Operation> upgradeClusterCallable() {
        return this.stub.upgradeClusterCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(ClusterName name) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(String name) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name).build();
        return this.deleteClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationCallable() {
        return this.stub.deleteClusterOperationCallable();
    }

    public final UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable() {
        return this.stub.deleteClusterCallable();
    }

    public final GenerateAccessTokenResponse generateAccessToken(ClusterName cluster) {
        GenerateAccessTokenRequest request = GenerateAccessTokenRequest.newBuilder().setCluster(cluster == null ? null : cluster.toString()).build();
        return this.generateAccessToken(request);
    }

    public final GenerateAccessTokenResponse generateAccessToken(String cluster) {
        GenerateAccessTokenRequest request = GenerateAccessTokenRequest.newBuilder().setCluster(cluster).build();
        return this.generateAccessToken(request);
    }

    public final GenerateAccessTokenResponse generateAccessToken(GenerateAccessTokenRequest request) {
        return (GenerateAccessTokenResponse)this.generateAccessTokenCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenCallable() {
        return this.stub.generateAccessTokenCallable();
    }

    public final GenerateOfflineCredentialResponse generateOfflineCredential(ClusterName cluster) {
        GenerateOfflineCredentialRequest request = GenerateOfflineCredentialRequest.newBuilder().setCluster(cluster == null ? null : cluster.toString()).build();
        return this.generateOfflineCredential(request);
    }

    public final GenerateOfflineCredentialResponse generateOfflineCredential(String cluster) {
        GenerateOfflineCredentialRequest request = GenerateOfflineCredentialRequest.newBuilder().setCluster(cluster).build();
        return this.generateOfflineCredential(request);
    }

    public final GenerateOfflineCredentialResponse generateOfflineCredential(GenerateOfflineCredentialRequest request) {
        return (GenerateOfflineCredentialResponse)this.generateOfflineCredentialCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateOfflineCredentialRequest, GenerateOfflineCredentialResponse> generateOfflineCredentialCallable() {
        return this.stub.generateOfflineCredentialCallable();
    }

    public final ListNodePoolsPagedResponse listNodePools(ClusterName parent) {
        ListNodePoolsRequest request = ListNodePoolsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNodePools(request);
    }

    public final ListNodePoolsPagedResponse listNodePools(String parent) {
        ListNodePoolsRequest request = ListNodePoolsRequest.newBuilder().setParent(parent).build();
        return this.listNodePools(request);
    }

    public final ListNodePoolsPagedResponse listNodePools(ListNodePoolsRequest request) {
        return (ListNodePoolsPagedResponse)((Object)this.listNodePoolsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNodePoolsRequest, ListNodePoolsPagedResponse> listNodePoolsPagedCallable() {
        return this.stub.listNodePoolsPagedCallable();
    }

    public final UnaryCallable<ListNodePoolsRequest, ListNodePoolsResponse> listNodePoolsCallable() {
        return this.stub.listNodePoolsCallable();
    }

    public final NodePool getNodePool(NodePoolName name) {
        GetNodePoolRequest request = GetNodePoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNodePool(request);
    }

    public final NodePool getNodePool(String name) {
        GetNodePoolRequest request = GetNodePoolRequest.newBuilder().setName(name).build();
        return this.getNodePool(request);
    }

    public final NodePool getNodePool(GetNodePoolRequest request) {
        return (NodePool)this.getNodePoolCallable().call((Object)request);
    }

    public final UnaryCallable<GetNodePoolRequest, NodePool> getNodePoolCallable() {
        return this.stub.getNodePoolCallable();
    }

    public final OperationFuture<NodePool, OperationMetadata> createNodePoolAsync(ClusterName parent, NodePool nodePool, String nodePoolId) {
        CreateNodePoolRequest request = CreateNodePoolRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNodePool(nodePool).setNodePoolId(nodePoolId).build();
        return this.createNodePoolAsync(request);
    }

    public final OperationFuture<NodePool, OperationMetadata> createNodePoolAsync(String parent, NodePool nodePool, String nodePoolId) {
        CreateNodePoolRequest request = CreateNodePoolRequest.newBuilder().setParent(parent).setNodePool(nodePool).setNodePoolId(nodePoolId).build();
        return this.createNodePoolAsync(request);
    }

    public final OperationFuture<NodePool, OperationMetadata> createNodePoolAsync(CreateNodePoolRequest request) {
        return this.createNodePoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateNodePoolRequest, NodePool, OperationMetadata> createNodePoolOperationCallable() {
        return this.stub.createNodePoolOperationCallable();
    }

    public final UnaryCallable<CreateNodePoolRequest, Operation> createNodePoolCallable() {
        return this.stub.createNodePoolCallable();
    }

    public final OperationFuture<NodePool, OperationMetadata> updateNodePoolAsync(NodePool nodePool, FieldMask updateMask) {
        UpdateNodePoolRequest request = UpdateNodePoolRequest.newBuilder().setNodePool(nodePool).setUpdateMask(updateMask).build();
        return this.updateNodePoolAsync(request);
    }

    public final OperationFuture<NodePool, OperationMetadata> updateNodePoolAsync(UpdateNodePoolRequest request) {
        return this.updateNodePoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateNodePoolRequest, NodePool, OperationMetadata> updateNodePoolOperationCallable() {
        return this.stub.updateNodePoolOperationCallable();
    }

    public final UnaryCallable<UpdateNodePoolRequest, Operation> updateNodePoolCallable() {
        return this.stub.updateNodePoolCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNodePoolAsync(NodePoolName name) {
        DeleteNodePoolRequest request = DeleteNodePoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteNodePoolAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNodePoolAsync(String name) {
        DeleteNodePoolRequest request = DeleteNodePoolRequest.newBuilder().setName(name).build();
        return this.deleteNodePoolAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNodePoolAsync(DeleteNodePoolRequest request) {
        return this.deleteNodePoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNodePoolRequest, Empty, OperationMetadata> deleteNodePoolOperationCallable() {
        return this.stub.deleteNodePoolOperationCallable();
    }

    public final UnaryCallable<DeleteNodePoolRequest, Operation> deleteNodePoolCallable() {
        return this.stub.deleteNodePoolCallable();
    }

    public final ListMachinesPagedResponse listMachines(LocationName parent) {
        ListMachinesRequest request = ListMachinesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMachines(request);
    }

    public final ListMachinesPagedResponse listMachines(String parent) {
        ListMachinesRequest request = ListMachinesRequest.newBuilder().setParent(parent).build();
        return this.listMachines(request);
    }

    public final ListMachinesPagedResponse listMachines(ListMachinesRequest request) {
        return (ListMachinesPagedResponse)((Object)this.listMachinesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMachinesRequest, ListMachinesPagedResponse> listMachinesPagedCallable() {
        return this.stub.listMachinesPagedCallable();
    }

    public final UnaryCallable<ListMachinesRequest, ListMachinesResponse> listMachinesCallable() {
        return this.stub.listMachinesCallable();
    }

    public final Machine getMachine(MachineName name) {
        GetMachineRequest request = GetMachineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMachine(request);
    }

    public final Machine getMachine(String name) {
        GetMachineRequest request = GetMachineRequest.newBuilder().setName(name).build();
        return this.getMachine(request);
    }

    public final Machine getMachine(GetMachineRequest request) {
        return (Machine)this.getMachineCallable().call((Object)request);
    }

    public final UnaryCallable<GetMachineRequest, Machine> getMachineCallable() {
        return this.stub.getMachineCallable();
    }

    public final ListVpnConnectionsPagedResponse listVpnConnections(LocationName parent) {
        ListVpnConnectionsRequest request = ListVpnConnectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVpnConnections(request);
    }

    public final ListVpnConnectionsPagedResponse listVpnConnections(String parent) {
        ListVpnConnectionsRequest request = ListVpnConnectionsRequest.newBuilder().setParent(parent).build();
        return this.listVpnConnections(request);
    }

    public final ListVpnConnectionsPagedResponse listVpnConnections(ListVpnConnectionsRequest request) {
        return (ListVpnConnectionsPagedResponse)((Object)this.listVpnConnectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVpnConnectionsRequest, ListVpnConnectionsPagedResponse> listVpnConnectionsPagedCallable() {
        return this.stub.listVpnConnectionsPagedCallable();
    }

    public final UnaryCallable<ListVpnConnectionsRequest, ListVpnConnectionsResponse> listVpnConnectionsCallable() {
        return this.stub.listVpnConnectionsCallable();
    }

    public final VpnConnection getVpnConnection(VpnConnectionName name) {
        GetVpnConnectionRequest request = GetVpnConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVpnConnection(request);
    }

    public final VpnConnection getVpnConnection(String name) {
        GetVpnConnectionRequest request = GetVpnConnectionRequest.newBuilder().setName(name).build();
        return this.getVpnConnection(request);
    }

    public final VpnConnection getVpnConnection(GetVpnConnectionRequest request) {
        return (VpnConnection)this.getVpnConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<GetVpnConnectionRequest, VpnConnection> getVpnConnectionCallable() {
        return this.stub.getVpnConnectionCallable();
    }

    public final OperationFuture<VpnConnection, OperationMetadata> createVpnConnectionAsync(LocationName parent, VpnConnection vpnConnection, String vpnConnectionId) {
        CreateVpnConnectionRequest request = CreateVpnConnectionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setVpnConnection(vpnConnection).setVpnConnectionId(vpnConnectionId).build();
        return this.createVpnConnectionAsync(request);
    }

    public final OperationFuture<VpnConnection, OperationMetadata> createVpnConnectionAsync(String parent, VpnConnection vpnConnection, String vpnConnectionId) {
        CreateVpnConnectionRequest request = CreateVpnConnectionRequest.newBuilder().setParent(parent).setVpnConnection(vpnConnection).setVpnConnectionId(vpnConnectionId).build();
        return this.createVpnConnectionAsync(request);
    }

    public final OperationFuture<VpnConnection, OperationMetadata> createVpnConnectionAsync(CreateVpnConnectionRequest request) {
        return this.createVpnConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateVpnConnectionRequest, VpnConnection, OperationMetadata> createVpnConnectionOperationCallable() {
        return this.stub.createVpnConnectionOperationCallable();
    }

    public final UnaryCallable<CreateVpnConnectionRequest, Operation> createVpnConnectionCallable() {
        return this.stub.createVpnConnectionCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVpnConnectionAsync(VpnConnectionName name) {
        DeleteVpnConnectionRequest request = DeleteVpnConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteVpnConnectionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVpnConnectionAsync(String name) {
        DeleteVpnConnectionRequest request = DeleteVpnConnectionRequest.newBuilder().setName(name).build();
        return this.deleteVpnConnectionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVpnConnectionAsync(DeleteVpnConnectionRequest request) {
        return this.deleteVpnConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteVpnConnectionRequest, Empty, OperationMetadata> deleteVpnConnectionOperationCallable() {
        return this.stub.deleteVpnConnectionOperationCallable();
    }

    public final UnaryCallable<DeleteVpnConnectionRequest, Operation> deleteVpnConnectionCallable() {
        return this.stub.deleteVpnConnectionCallable();
    }

    public final ServerConfig getServerConfig(LocationName name) {
        GetServerConfigRequest request = GetServerConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getServerConfig(request);
    }

    public final ServerConfig getServerConfig(String name) {
        GetServerConfigRequest request = GetServerConfigRequest.newBuilder().setName(name).build();
        return this.getServerConfig(request);
    }

    public final ServerConfig getServerConfig(GetServerConfigRequest request) {
        return (ServerConfig)this.getServerConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetServerConfigRequest, ServerConfig> getServerConfigCallable() {
        return this.stub.getServerConfigCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListVpnConnectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVpnConnectionsRequest, ListVpnConnectionsResponse, VpnConnection, ListVpnConnectionsPage, ListVpnConnectionsFixedSizeCollection> {
        private ListVpnConnectionsFixedSizeCollection(List<ListVpnConnectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVpnConnectionsFixedSizeCollection createEmptyCollection() {
            return new ListVpnConnectionsFixedSizeCollection(null, 0);
        }

        protected ListVpnConnectionsFixedSizeCollection createCollection(List<ListVpnConnectionsPage> pages, int collectionSize) {
            return new ListVpnConnectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVpnConnectionsPage
    extends AbstractPage<ListVpnConnectionsRequest, ListVpnConnectionsResponse, VpnConnection, ListVpnConnectionsPage> {
        private ListVpnConnectionsPage(PageContext<ListVpnConnectionsRequest, ListVpnConnectionsResponse, VpnConnection> context, ListVpnConnectionsResponse response) {
            super(context, (Object)response);
        }

        private static ListVpnConnectionsPage createEmptyPage() {
            return new ListVpnConnectionsPage(null, null);
        }

        protected ListVpnConnectionsPage createPage(PageContext<ListVpnConnectionsRequest, ListVpnConnectionsResponse, VpnConnection> context, ListVpnConnectionsResponse response) {
            return new ListVpnConnectionsPage(context, response);
        }

        public ApiFuture<ListVpnConnectionsPage> createPageAsync(PageContext<ListVpnConnectionsRequest, ListVpnConnectionsResponse, VpnConnection> context, ApiFuture<ListVpnConnectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVpnConnectionsPagedResponse
    extends AbstractPagedListResponse<ListVpnConnectionsRequest, ListVpnConnectionsResponse, VpnConnection, ListVpnConnectionsPage, ListVpnConnectionsFixedSizeCollection> {
        public static ApiFuture<ListVpnConnectionsPagedResponse> createAsync(PageContext<ListVpnConnectionsRequest, ListVpnConnectionsResponse, VpnConnection> context, ApiFuture<ListVpnConnectionsResponse> futureResponse) {
            ApiFuture<ListVpnConnectionsPage> futurePage = ListVpnConnectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVpnConnectionsPagedResponse((ListVpnConnectionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVpnConnectionsPagedResponse(ListVpnConnectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVpnConnectionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMachinesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMachinesRequest, ListMachinesResponse, Machine, ListMachinesPage, ListMachinesFixedSizeCollection> {
        private ListMachinesFixedSizeCollection(List<ListMachinesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMachinesFixedSizeCollection createEmptyCollection() {
            return new ListMachinesFixedSizeCollection(null, 0);
        }

        protected ListMachinesFixedSizeCollection createCollection(List<ListMachinesPage> pages, int collectionSize) {
            return new ListMachinesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMachinesPage
    extends AbstractPage<ListMachinesRequest, ListMachinesResponse, Machine, ListMachinesPage> {
        private ListMachinesPage(PageContext<ListMachinesRequest, ListMachinesResponse, Machine> context, ListMachinesResponse response) {
            super(context, (Object)response);
        }

        private static ListMachinesPage createEmptyPage() {
            return new ListMachinesPage(null, null);
        }

        protected ListMachinesPage createPage(PageContext<ListMachinesRequest, ListMachinesResponse, Machine> context, ListMachinesResponse response) {
            return new ListMachinesPage(context, response);
        }

        public ApiFuture<ListMachinesPage> createPageAsync(PageContext<ListMachinesRequest, ListMachinesResponse, Machine> context, ApiFuture<ListMachinesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMachinesPagedResponse
    extends AbstractPagedListResponse<ListMachinesRequest, ListMachinesResponse, Machine, ListMachinesPage, ListMachinesFixedSizeCollection> {
        public static ApiFuture<ListMachinesPagedResponse> createAsync(PageContext<ListMachinesRequest, ListMachinesResponse, Machine> context, ApiFuture<ListMachinesResponse> futureResponse) {
            ApiFuture<ListMachinesPage> futurePage = ListMachinesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMachinesPagedResponse((ListMachinesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMachinesPagedResponse(ListMachinesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMachinesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNodePoolsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNodePoolsRequest, ListNodePoolsResponse, NodePool, ListNodePoolsPage, ListNodePoolsFixedSizeCollection> {
        private ListNodePoolsFixedSizeCollection(List<ListNodePoolsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNodePoolsFixedSizeCollection createEmptyCollection() {
            return new ListNodePoolsFixedSizeCollection(null, 0);
        }

        protected ListNodePoolsFixedSizeCollection createCollection(List<ListNodePoolsPage> pages, int collectionSize) {
            return new ListNodePoolsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNodePoolsPage
    extends AbstractPage<ListNodePoolsRequest, ListNodePoolsResponse, NodePool, ListNodePoolsPage> {
        private ListNodePoolsPage(PageContext<ListNodePoolsRequest, ListNodePoolsResponse, NodePool> context, ListNodePoolsResponse response) {
            super(context, (Object)response);
        }

        private static ListNodePoolsPage createEmptyPage() {
            return new ListNodePoolsPage(null, null);
        }

        protected ListNodePoolsPage createPage(PageContext<ListNodePoolsRequest, ListNodePoolsResponse, NodePool> context, ListNodePoolsResponse response) {
            return new ListNodePoolsPage(context, response);
        }

        public ApiFuture<ListNodePoolsPage> createPageAsync(PageContext<ListNodePoolsRequest, ListNodePoolsResponse, NodePool> context, ApiFuture<ListNodePoolsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNodePoolsPagedResponse
    extends AbstractPagedListResponse<ListNodePoolsRequest, ListNodePoolsResponse, NodePool, ListNodePoolsPage, ListNodePoolsFixedSizeCollection> {
        public static ApiFuture<ListNodePoolsPagedResponse> createAsync(PageContext<ListNodePoolsRequest, ListNodePoolsResponse, NodePool> context, ApiFuture<ListNodePoolsResponse> futureResponse) {
            ApiFuture<ListNodePoolsPage> futurePage = ListNodePoolsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNodePoolsPagedResponse((ListNodePoolsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNodePoolsPagedResponse(ListNodePoolsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNodePoolsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage, ListClustersFixedSizeCollection> {
        private ListClustersFixedSizeCollection(List<ListClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListClustersFixedSizeCollection createEmptyCollection() {
            return new ListClustersFixedSizeCollection(null, 0);
        }

        protected ListClustersFixedSizeCollection createCollection(List<ListClustersPage> pages, int collectionSize) {
            return new ListClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListClustersPage
    extends AbstractPage<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage> {
        private ListClustersPage(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ListClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListClustersPage createEmptyPage() {
            return new ListClustersPage(null, null);
        }

        protected ListClustersPage createPage(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ListClustersResponse response) {
            return new ListClustersPage(context, response);
        }

        public ApiFuture<ListClustersPage> createPageAsync(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ApiFuture<ListClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListClustersPagedResponse
    extends AbstractPagedListResponse<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage, ListClustersFixedSizeCollection> {
        public static ApiFuture<ListClustersPagedResponse> createAsync(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ApiFuture<ListClustersResponse> futureResponse) {
            ApiFuture<ListClustersPage> futurePage = ListClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListClustersPagedResponse((ListClustersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListClustersPagedResponse(ListClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListClustersFixedSizeCollection.createEmptyCollection());
        }
    }
}

