/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.BatchUpdateUserLicensesMetadata;
import com.google.cloud.discoveryengine.v1.BatchUpdateUserLicensesRequest;
import com.google.cloud.discoveryengine.v1.BatchUpdateUserLicensesResponse;
import com.google.cloud.discoveryengine.v1.ListUserLicensesRequest;
import com.google.cloud.discoveryengine.v1.ListUserLicensesResponse;
import com.google.cloud.discoveryengine.v1.UserLicense;
import com.google.cloud.discoveryengine.v1.UserLicenseServiceSettings;
import com.google.cloud.discoveryengine.v1.UserStoreName;
import com.google.cloud.discoveryengine.v1.stub.UserLicenseServiceStub;
import com.google.cloud.discoveryengine.v1.stub.UserLicenseServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class UserLicenseServiceClient
implements BackgroundResource {
    private final UserLicenseServiceSettings settings;
    private final UserLicenseServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final UserLicenseServiceClient create() throws IOException {
        return UserLicenseServiceClient.create(UserLicenseServiceSettings.newBuilder().build());
    }

    public static final UserLicenseServiceClient create(UserLicenseServiceSettings settings) throws IOException {
        return new UserLicenseServiceClient(settings);
    }

    public static final UserLicenseServiceClient create(UserLicenseServiceStub stub) {
        return new UserLicenseServiceClient(stub);
    }

    protected UserLicenseServiceClient(UserLicenseServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((UserLicenseServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected UserLicenseServiceClient(UserLicenseServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final UserLicenseServiceSettings getSettings() {
        return this.settings;
    }

    public UserLicenseServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListUserLicensesPagedResponse listUserLicenses(UserStoreName parent) {
        ListUserLicensesRequest request = ListUserLicensesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listUserLicenses(request);
    }

    public final ListUserLicensesPagedResponse listUserLicenses(String parent) {
        ListUserLicensesRequest request = ListUserLicensesRequest.newBuilder().setParent(parent).build();
        return this.listUserLicenses(request);
    }

    public final ListUserLicensesPagedResponse listUserLicenses(ListUserLicensesRequest request) {
        return (ListUserLicensesPagedResponse)((Object)this.listUserLicensesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListUserLicensesRequest, ListUserLicensesPagedResponse> listUserLicensesPagedCallable() {
        return this.stub.listUserLicensesPagedCallable();
    }

    public final UnaryCallable<ListUserLicensesRequest, ListUserLicensesResponse> listUserLicensesCallable() {
        return this.stub.listUserLicensesCallable();
    }

    public final OperationFuture<BatchUpdateUserLicensesResponse, BatchUpdateUserLicensesMetadata> batchUpdateUserLicensesAsync(BatchUpdateUserLicensesRequest request) {
        return this.batchUpdateUserLicensesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchUpdateUserLicensesRequest, BatchUpdateUserLicensesResponse, BatchUpdateUserLicensesMetadata> batchUpdateUserLicensesOperationCallable() {
        return this.stub.batchUpdateUserLicensesOperationCallable();
    }

    public final UnaryCallable<BatchUpdateUserLicensesRequest, Operation> batchUpdateUserLicensesCallable() {
        return this.stub.batchUpdateUserLicensesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListUserLicensesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUserLicensesRequest, ListUserLicensesResponse, UserLicense, ListUserLicensesPage, ListUserLicensesFixedSizeCollection> {
        private ListUserLicensesFixedSizeCollection(List<ListUserLicensesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListUserLicensesFixedSizeCollection createEmptyCollection() {
            return new ListUserLicensesFixedSizeCollection(null, 0);
        }

        protected ListUserLicensesFixedSizeCollection createCollection(List<ListUserLicensesPage> pages, int collectionSize) {
            return new ListUserLicensesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListUserLicensesPage
    extends AbstractPage<ListUserLicensesRequest, ListUserLicensesResponse, UserLicense, ListUserLicensesPage> {
        private ListUserLicensesPage(PageContext<ListUserLicensesRequest, ListUserLicensesResponse, UserLicense> context, ListUserLicensesResponse response) {
            super(context, (Object)response);
        }

        private static ListUserLicensesPage createEmptyPage() {
            return new ListUserLicensesPage(null, null);
        }

        protected ListUserLicensesPage createPage(PageContext<ListUserLicensesRequest, ListUserLicensesResponse, UserLicense> context, ListUserLicensesResponse response) {
            return new ListUserLicensesPage(context, response);
        }

        public ApiFuture<ListUserLicensesPage> createPageAsync(PageContext<ListUserLicensesRequest, ListUserLicensesResponse, UserLicense> context, ApiFuture<ListUserLicensesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListUserLicensesPagedResponse
    extends AbstractPagedListResponse<ListUserLicensesRequest, ListUserLicensesResponse, UserLicense, ListUserLicensesPage, ListUserLicensesFixedSizeCollection> {
        public static ApiFuture<ListUserLicensesPagedResponse> createAsync(PageContext<ListUserLicensesRequest, ListUserLicensesResponse, UserLicense> context, ApiFuture<ListUserLicensesResponse> futureResponse) {
            ApiFuture<ListUserLicensesPage> futurePage = ListUserLicensesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListUserLicensesPagedResponse((ListUserLicensesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListUserLicensesPagedResponse(ListUserLicensesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListUserLicensesFixedSizeCollection.createEmptyCollection());
        }
    }
}

