/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.CreateSessionRequest;
import com.google.cloud.discoveryengine.v1beta.DataStoreName;
import com.google.cloud.discoveryengine.v1beta.DeleteSessionRequest;
import com.google.cloud.discoveryengine.v1beta.GetSessionRequest;
import com.google.cloud.discoveryengine.v1beta.ListSessionsRequest;
import com.google.cloud.discoveryengine.v1beta.ListSessionsResponse;
import com.google.cloud.discoveryengine.v1beta.Session;
import com.google.cloud.discoveryengine.v1beta.SessionName;
import com.google.cloud.discoveryengine.v1beta.SessionServiceSettings;
import com.google.cloud.discoveryengine.v1beta.UpdateSessionRequest;
import com.google.cloud.discoveryengine.v1beta.stub.SessionServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.SessionServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SessionServiceClient
implements BackgroundResource {
    private final SessionServiceSettings settings;
    private final SessionServiceStub stub;

    public static final SessionServiceClient create() throws IOException {
        return SessionServiceClient.create(SessionServiceSettings.newBuilder().build());
    }

    public static final SessionServiceClient create(SessionServiceSettings settings) throws IOException {
        return new SessionServiceClient(settings);
    }

    public static final SessionServiceClient create(SessionServiceStub stub) {
        return new SessionServiceClient(stub);
    }

    protected SessionServiceClient(SessionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SessionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected SessionServiceClient(SessionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SessionServiceSettings getSettings() {
        return this.settings;
    }

    public SessionServiceStub getStub() {
        return this.stub;
    }

    public final Session createSession(DataStoreName parent, Session session) {
        CreateSessionRequest request = CreateSessionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSession(session).build();
        return this.createSession(request);
    }

    public final Session createSession(String parent, Session session) {
        CreateSessionRequest request = CreateSessionRequest.newBuilder().setParent(parent).setSession(session).build();
        return this.createSession(request);
    }

    public final Session createSession(CreateSessionRequest request) {
        return (Session)this.createSessionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSessionRequest, Session> createSessionCallable() {
        return this.stub.createSessionCallable();
    }

    public final void deleteSession(SessionName name) {
        DeleteSessionRequest request = DeleteSessionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSession(request);
    }

    public final void deleteSession(String name) {
        DeleteSessionRequest request = DeleteSessionRequest.newBuilder().setName(name).build();
        this.deleteSession(request);
    }

    public final void deleteSession(DeleteSessionRequest request) {
        this.deleteSessionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSessionRequest, Empty> deleteSessionCallable() {
        return this.stub.deleteSessionCallable();
    }

    public final Session updateSession(Session session, FieldMask updateMask) {
        UpdateSessionRequest request = UpdateSessionRequest.newBuilder().setSession(session).setUpdateMask(updateMask).build();
        return this.updateSession(request);
    }

    public final Session updateSession(UpdateSessionRequest request) {
        return (Session)this.updateSessionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSessionRequest, Session> updateSessionCallable() {
        return this.stub.updateSessionCallable();
    }

    public final Session getSession(SessionName name) {
        GetSessionRequest request = GetSessionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSession(request);
    }

    public final Session getSession(String name) {
        GetSessionRequest request = GetSessionRequest.newBuilder().setName(name).build();
        return this.getSession(request);
    }

    public final Session getSession(GetSessionRequest request) {
        return (Session)this.getSessionCallable().call((Object)request);
    }

    public final UnaryCallable<GetSessionRequest, Session> getSessionCallable() {
        return this.stub.getSessionCallable();
    }

    public final ListSessionsPagedResponse listSessions(DataStoreName parent) {
        ListSessionsRequest request = ListSessionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSessions(request);
    }

    public final ListSessionsPagedResponse listSessions(String parent) {
        ListSessionsRequest request = ListSessionsRequest.newBuilder().setParent(parent).build();
        return this.listSessions(request);
    }

    public final ListSessionsPagedResponse listSessions(ListSessionsRequest request) {
        return (ListSessionsPagedResponse)((Object)this.listSessionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSessionsRequest, ListSessionsPagedResponse> listSessionsPagedCallable() {
        return this.stub.listSessionsPagedCallable();
    }

    public final UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable() {
        return this.stub.listSessionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSessionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage, ListSessionsFixedSizeCollection> {
        private ListSessionsFixedSizeCollection(List<ListSessionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSessionsFixedSizeCollection createEmptyCollection() {
            return new ListSessionsFixedSizeCollection(null, 0);
        }

        protected ListSessionsFixedSizeCollection createCollection(List<ListSessionsPage> pages, int collectionSize) {
            return new ListSessionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSessionsPage
    extends AbstractPage<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage> {
        private ListSessionsPage(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ListSessionsResponse response) {
            super(context, (Object)response);
        }

        private static ListSessionsPage createEmptyPage() {
            return new ListSessionsPage(null, null);
        }

        protected ListSessionsPage createPage(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ListSessionsResponse response) {
            return new ListSessionsPage(context, response);
        }

        public ApiFuture<ListSessionsPage> createPageAsync(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ApiFuture<ListSessionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSessionsPagedResponse
    extends AbstractPagedListResponse<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage, ListSessionsFixedSizeCollection> {
        public static ApiFuture<ListSessionsPagedResponse> createAsync(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ApiFuture<ListSessionsResponse> futureResponse) {
            ApiFuture<ListSessionsPage> futurePage = ListSessionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSessionsPagedResponse((ListSessionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSessionsPagedResponse(ListSessionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSessionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

