/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.BatchUpdateUserLicensesMetadata;
import com.google.cloud.discoveryengine.v1.BatchUpdateUserLicensesRequest;
import com.google.cloud.discoveryengine.v1.BatchUpdateUserLicensesResponse;
import com.google.cloud.discoveryengine.v1.ListUserLicensesRequest;
import com.google.cloud.discoveryengine.v1.ListUserLicensesResponse;
import com.google.cloud.discoveryengine.v1.UserLicense;
import com.google.cloud.discoveryengine.v1.UserLicenseServiceClient;
import com.google.cloud.discoveryengine.v1.stub.GrpcUserLicenseServiceStub;
import com.google.cloud.discoveryengine.v1.stub.HttpJsonUserLicenseServiceStub;
import com.google.cloud.discoveryengine.v1.stub.UserLicenseServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class UserLicenseServiceStubSettings
extends StubSettings<UserLicenseServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListUserLicensesRequest, ListUserLicensesResponse, UserLicenseServiceClient.ListUserLicensesPagedResponse> listUserLicensesSettings;
    private final UnaryCallSettings<BatchUpdateUserLicensesRequest, Operation> batchUpdateUserLicensesSettings;
    private final OperationCallSettings<BatchUpdateUserLicensesRequest, BatchUpdateUserLicensesResponse, BatchUpdateUserLicensesMetadata> batchUpdateUserLicensesOperationSettings;
    private static final PagedListDescriptor<ListUserLicensesRequest, ListUserLicensesResponse, UserLicense> LIST_USER_LICENSES_PAGE_STR_DESC = new PagedListDescriptor<ListUserLicensesRequest, ListUserLicensesResponse, UserLicense>(){

        public String emptyToken() {
            return "";
        }

        public ListUserLicensesRequest injectToken(ListUserLicensesRequest payload, String token) {
            return ListUserLicensesRequest.newBuilder((ListUserLicensesRequest)payload).setPageToken(token).build();
        }

        public ListUserLicensesRequest injectPageSize(ListUserLicensesRequest payload, int pageSize) {
            return ListUserLicensesRequest.newBuilder((ListUserLicensesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListUserLicensesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListUserLicensesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<UserLicense> extractResources(ListUserLicensesResponse payload) {
            return payload.getUserLicensesList();
        }
    };
    private static final PagedListResponseFactory<ListUserLicensesRequest, ListUserLicensesResponse, UserLicenseServiceClient.ListUserLicensesPagedResponse> LIST_USER_LICENSES_PAGE_STR_FACT = new PagedListResponseFactory<ListUserLicensesRequest, ListUserLicensesResponse, UserLicenseServiceClient.ListUserLicensesPagedResponse>(){

        public ApiFuture<UserLicenseServiceClient.ListUserLicensesPagedResponse> getFuturePagedResponse(UnaryCallable<ListUserLicensesRequest, ListUserLicensesResponse> callable, ListUserLicensesRequest request, ApiCallContext context, ApiFuture<ListUserLicensesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_USER_LICENSES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return UserLicenseServiceClient.ListUserLicensesPagedResponse.createAsync((PageContext<ListUserLicensesRequest, ListUserLicensesResponse, UserLicense>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListUserLicensesRequest, ListUserLicensesResponse, UserLicenseServiceClient.ListUserLicensesPagedResponse> listUserLicensesSettings() {
        return this.listUserLicensesSettings;
    }

    public UnaryCallSettings<BatchUpdateUserLicensesRequest, Operation> batchUpdateUserLicensesSettings() {
        return this.batchUpdateUserLicensesSettings;
    }

    public OperationCallSettings<BatchUpdateUserLicensesRequest, BatchUpdateUserLicensesResponse, BatchUpdateUserLicensesMetadata> batchUpdateUserLicensesOperationSettings() {
        return this.batchUpdateUserLicensesOperationSettings;
    }

    public UserLicenseServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcUserLicenseServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonUserLicenseServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "discoveryengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "discoveryengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "discoveryengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return UserLicenseServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(UserLicenseServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(UserLicenseServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return UserLicenseServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected UserLicenseServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listUserLicensesSettings = settingsBuilder.listUserLicensesSettings().build();
        this.batchUpdateUserLicensesSettings = settingsBuilder.batchUpdateUserLicensesSettings().build();
        this.batchUpdateUserLicensesOperationSettings = settingsBuilder.batchUpdateUserLicensesOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<UserLicenseServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListUserLicensesRequest, ListUserLicensesResponse, UserLicenseServiceClient.ListUserLicensesPagedResponse> listUserLicensesSettings;
        private final UnaryCallSettings.Builder<BatchUpdateUserLicensesRequest, Operation> batchUpdateUserLicensesSettings;
        private final OperationCallSettings.Builder<BatchUpdateUserLicensesRequest, BatchUpdateUserLicensesResponse, BatchUpdateUserLicensesMetadata> batchUpdateUserLicensesOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listUserLicensesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_USER_LICENSES_PAGE_STR_FACT);
            this.batchUpdateUserLicensesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchUpdateUserLicensesOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listUserLicensesSettings, this.batchUpdateUserLicensesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(UserLicenseServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listUserLicensesSettings = settings.listUserLicensesSettings.toBuilder();
            this.batchUpdateUserLicensesSettings = settings.batchUpdateUserLicensesSettings.toBuilder();
            this.batchUpdateUserLicensesOperationSettings = settings.batchUpdateUserLicensesOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listUserLicensesSettings, this.batchUpdateUserLicensesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(UserLicenseServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)UserLicenseServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)UserLicenseServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(UserLicenseServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)UserLicenseServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)UserLicenseServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)UserLicenseServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(UserLicenseServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listUserLicensesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchUpdateUserLicensesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchUpdateUserLicensesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchUpdateUserLicensesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchUpdateUserLicensesMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListUserLicensesRequest, ListUserLicensesResponse, UserLicenseServiceClient.ListUserLicensesPagedResponse> listUserLicensesSettings() {
            return this.listUserLicensesSettings;
        }

        public UnaryCallSettings.Builder<BatchUpdateUserLicensesRequest, Operation> batchUpdateUserLicensesSettings() {
            return this.batchUpdateUserLicensesSettings;
        }

        public OperationCallSettings.Builder<BatchUpdateUserLicensesRequest, BatchUpdateUserLicensesResponse, BatchUpdateUserLicensesMetadata> batchUpdateUserLicensesOperationSettings() {
            return this.batchUpdateUserLicensesOperationSettings;
        }

        public UserLicenseServiceStubSettings build() throws IOException {
            return new UserLicenseServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

