/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.CollectionName;
import com.google.cloud.discoveryengine.v1alpha.CreateEngineMetadata;
import com.google.cloud.discoveryengine.v1alpha.CreateEngineRequest;
import com.google.cloud.discoveryengine.v1alpha.DeleteEngineMetadata;
import com.google.cloud.discoveryengine.v1alpha.DeleteEngineRequest;
import com.google.cloud.discoveryengine.v1alpha.Engine;
import com.google.cloud.discoveryengine.v1alpha.EngineName;
import com.google.cloud.discoveryengine.v1alpha.EngineServiceSettings;
import com.google.cloud.discoveryengine.v1alpha.GetEngineRequest;
import com.google.cloud.discoveryengine.v1alpha.ListEnginesRequest;
import com.google.cloud.discoveryengine.v1alpha.ListEnginesResponse;
import com.google.cloud.discoveryengine.v1alpha.PauseEngineRequest;
import com.google.cloud.discoveryengine.v1alpha.ResumeEngineRequest;
import com.google.cloud.discoveryengine.v1alpha.TuneEngineMetadata;
import com.google.cloud.discoveryengine.v1alpha.TuneEngineRequest;
import com.google.cloud.discoveryengine.v1alpha.TuneEngineResponse;
import com.google.cloud.discoveryengine.v1alpha.UpdateEngineRequest;
import com.google.cloud.discoveryengine.v1alpha.stub.EngineServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.EngineServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class EngineServiceClient
implements BackgroundResource {
    private final EngineServiceSettings settings;
    private final EngineServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final EngineServiceClient create() throws IOException {
        return EngineServiceClient.create(EngineServiceSettings.newBuilder().build());
    }

    public static final EngineServiceClient create(EngineServiceSettings settings) throws IOException {
        return new EngineServiceClient(settings);
    }

    public static final EngineServiceClient create(EngineServiceStub stub) {
        return new EngineServiceClient(stub);
    }

    protected EngineServiceClient(EngineServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EngineServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected EngineServiceClient(EngineServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final EngineServiceSettings getSettings() {
        return this.settings;
    }

    public EngineServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Engine, CreateEngineMetadata> createEngineAsync(CollectionName parent, Engine engine, String engineId) {
        CreateEngineRequest request = CreateEngineRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEngine(engine).setEngineId(engineId).build();
        return this.createEngineAsync(request);
    }

    public final OperationFuture<Engine, CreateEngineMetadata> createEngineAsync(String parent, Engine engine, String engineId) {
        CreateEngineRequest request = CreateEngineRequest.newBuilder().setParent(parent).setEngine(engine).setEngineId(engineId).build();
        return this.createEngineAsync(request);
    }

    public final OperationFuture<Engine, CreateEngineMetadata> createEngineAsync(CreateEngineRequest request) {
        return this.createEngineOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEngineRequest, Engine, CreateEngineMetadata> createEngineOperationCallable() {
        return this.stub.createEngineOperationCallable();
    }

    public final UnaryCallable<CreateEngineRequest, Operation> createEngineCallable() {
        return this.stub.createEngineCallable();
    }

    public final OperationFuture<Empty, DeleteEngineMetadata> deleteEngineAsync(EngineName name) {
        DeleteEngineRequest request = DeleteEngineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteEngineAsync(request);
    }

    public final OperationFuture<Empty, DeleteEngineMetadata> deleteEngineAsync(String name) {
        DeleteEngineRequest request = DeleteEngineRequest.newBuilder().setName(name).build();
        return this.deleteEngineAsync(request);
    }

    public final OperationFuture<Empty, DeleteEngineMetadata> deleteEngineAsync(DeleteEngineRequest request) {
        return this.deleteEngineOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEngineRequest, Empty, DeleteEngineMetadata> deleteEngineOperationCallable() {
        return this.stub.deleteEngineOperationCallable();
    }

    public final UnaryCallable<DeleteEngineRequest, Operation> deleteEngineCallable() {
        return this.stub.deleteEngineCallable();
    }

    public final Engine updateEngine(Engine engine, FieldMask updateMask) {
        UpdateEngineRequest request = UpdateEngineRequest.newBuilder().setEngine(engine).setUpdateMask(updateMask).build();
        return this.updateEngine(request);
    }

    public final Engine updateEngine(UpdateEngineRequest request) {
        return (Engine)this.updateEngineCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateEngineRequest, Engine> updateEngineCallable() {
        return this.stub.updateEngineCallable();
    }

    public final Engine getEngine(EngineName name) {
        GetEngineRequest request = GetEngineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEngine(request);
    }

    public final Engine getEngine(String name) {
        GetEngineRequest request = GetEngineRequest.newBuilder().setName(name).build();
        return this.getEngine(request);
    }

    public final Engine getEngine(GetEngineRequest request) {
        return (Engine)this.getEngineCallable().call((Object)request);
    }

    public final UnaryCallable<GetEngineRequest, Engine> getEngineCallable() {
        return this.stub.getEngineCallable();
    }

    public final ListEnginesPagedResponse listEngines(CollectionName parent) {
        ListEnginesRequest request = ListEnginesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEngines(request);
    }

    public final ListEnginesPagedResponse listEngines(String parent) {
        ListEnginesRequest request = ListEnginesRequest.newBuilder().setParent(parent).build();
        return this.listEngines(request);
    }

    public final ListEnginesPagedResponse listEngines(ListEnginesRequest request) {
        return (ListEnginesPagedResponse)((Object)this.listEnginesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEnginesRequest, ListEnginesPagedResponse> listEnginesPagedCallable() {
        return this.stub.listEnginesPagedCallable();
    }

    public final UnaryCallable<ListEnginesRequest, ListEnginesResponse> listEnginesCallable() {
        return this.stub.listEnginesCallable();
    }

    public final Engine pauseEngine(EngineName name) {
        PauseEngineRequest request = PauseEngineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.pauseEngine(request);
    }

    public final Engine pauseEngine(String name) {
        PauseEngineRequest request = PauseEngineRequest.newBuilder().setName(name).build();
        return this.pauseEngine(request);
    }

    public final Engine pauseEngine(PauseEngineRequest request) {
        return (Engine)this.pauseEngineCallable().call((Object)request);
    }

    public final UnaryCallable<PauseEngineRequest, Engine> pauseEngineCallable() {
        return this.stub.pauseEngineCallable();
    }

    public final Engine resumeEngine(EngineName name) {
        ResumeEngineRequest request = ResumeEngineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.resumeEngine(request);
    }

    public final Engine resumeEngine(String name) {
        ResumeEngineRequest request = ResumeEngineRequest.newBuilder().setName(name).build();
        return this.resumeEngine(request);
    }

    public final Engine resumeEngine(ResumeEngineRequest request) {
        return (Engine)this.resumeEngineCallable().call((Object)request);
    }

    public final UnaryCallable<ResumeEngineRequest, Engine> resumeEngineCallable() {
        return this.stub.resumeEngineCallable();
    }

    public final OperationFuture<TuneEngineResponse, TuneEngineMetadata> tuneEngineAsync(EngineName name) {
        TuneEngineRequest request = TuneEngineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.tuneEngineAsync(request);
    }

    public final OperationFuture<TuneEngineResponse, TuneEngineMetadata> tuneEngineAsync(String name) {
        TuneEngineRequest request = TuneEngineRequest.newBuilder().setName(name).build();
        return this.tuneEngineAsync(request);
    }

    public final OperationFuture<TuneEngineResponse, TuneEngineMetadata> tuneEngineAsync(TuneEngineRequest request) {
        return this.tuneEngineOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<TuneEngineRequest, TuneEngineResponse, TuneEngineMetadata> tuneEngineOperationCallable() {
        return this.stub.tuneEngineOperationCallable();
    }

    public final UnaryCallable<TuneEngineRequest, Operation> tuneEngineCallable() {
        return this.stub.tuneEngineCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListEnginesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEnginesRequest, ListEnginesResponse, Engine, ListEnginesPage, ListEnginesFixedSizeCollection> {
        private ListEnginesFixedSizeCollection(List<ListEnginesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEnginesFixedSizeCollection createEmptyCollection() {
            return new ListEnginesFixedSizeCollection(null, 0);
        }

        protected ListEnginesFixedSizeCollection createCollection(List<ListEnginesPage> pages, int collectionSize) {
            return new ListEnginesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEnginesPage
    extends AbstractPage<ListEnginesRequest, ListEnginesResponse, Engine, ListEnginesPage> {
        private ListEnginesPage(PageContext<ListEnginesRequest, ListEnginesResponse, Engine> context, ListEnginesResponse response) {
            super(context, (Object)response);
        }

        private static ListEnginesPage createEmptyPage() {
            return new ListEnginesPage(null, null);
        }

        protected ListEnginesPage createPage(PageContext<ListEnginesRequest, ListEnginesResponse, Engine> context, ListEnginesResponse response) {
            return new ListEnginesPage(context, response);
        }

        public ApiFuture<ListEnginesPage> createPageAsync(PageContext<ListEnginesRequest, ListEnginesResponse, Engine> context, ApiFuture<ListEnginesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEnginesPagedResponse
    extends AbstractPagedListResponse<ListEnginesRequest, ListEnginesResponse, Engine, ListEnginesPage, ListEnginesFixedSizeCollection> {
        public static ApiFuture<ListEnginesPagedResponse> createAsync(PageContext<ListEnginesRequest, ListEnginesResponse, Engine> context, ApiFuture<ListEnginesResponse> futureResponse) {
            ApiFuture<ListEnginesPage> futurePage = ListEnginesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEnginesPagedResponse((ListEnginesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEnginesPagedResponse(ListEnginesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEnginesFixedSizeCollection.createEmptyCollection());
        }
    }
}

