/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.Chunk;
import com.google.cloud.discoveryengine.v1alpha.ChunkServiceClient;
import com.google.cloud.discoveryengine.v1alpha.GetChunkRequest;
import com.google.cloud.discoveryengine.v1alpha.ListChunksRequest;
import com.google.cloud.discoveryengine.v1alpha.ListChunksResponse;
import com.google.cloud.discoveryengine.v1alpha.stub.ChunkServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.ChunkServiceStubSettings;
import com.google.cloud.discoveryengine.v1alpha.stub.HttpJsonChunkServiceCallableFactory;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonChunkServiceStub
extends ChunkServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetChunkRequest, Chunk> getChunkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1alpha.ChunkService/GetChunk").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{name=projects/*/locations/*/dataStores/*/branches/*/documents/*/chunks/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/branches/*/documents/*/chunks/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Chunk.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListChunksRequest, ListChunksResponse> listChunksMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1alpha.ChunkService/ListChunks").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{parent=projects/*/locations/*/dataStores/*/branches/*/documents/*}/chunks", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1alpha/{parent=projects/*/locations/*/collections/*/dataStores/*/branches/*/documents/*}/chunks"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListChunksResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetChunkRequest, Chunk> getChunkCallable;
    private final UnaryCallable<ListChunksRequest, ListChunksResponse> listChunksCallable;
    private final UnaryCallable<ListChunksRequest, ChunkServiceClient.ListChunksPagedResponse> listChunksPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonChunkServiceStub create(ChunkServiceStubSettings settings) throws IOException {
        return new HttpJsonChunkServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonChunkServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonChunkServiceStub(ChunkServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonChunkServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonChunkServiceStub(ChunkServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonChunkServiceStub(ChunkServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonChunkServiceCallableFactory());
    }

    protected HttpJsonChunkServiceStub(ChunkServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getChunkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getChunkMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listChunksTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listChunksMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getChunkCallable = callableFactory.createUnaryCallable(getChunkTransportSettings, settings.getChunkSettings(), clientContext);
        this.listChunksCallable = callableFactory.createUnaryCallable(listChunksTransportSettings, settings.listChunksSettings(), clientContext);
        this.listChunksPagedCallable = callableFactory.createPagedCallable(listChunksTransportSettings, settings.listChunksSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getChunkMethodDescriptor);
        methodDescriptors.add(listChunksMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetChunkRequest, Chunk> getChunkCallable() {
        return this.getChunkCallable;
    }

    @Override
    public UnaryCallable<ListChunksRequest, ListChunksResponse> listChunksCallable() {
        return this.listChunksCallable;
    }

    @Override
    public UnaryCallable<ListChunksRequest, ChunkServiceClient.ListChunksPagedResponse> listChunksPagedCallable() {
        return this.listChunksPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

