/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.CreateSchemaMetadata;
import com.google.cloud.discoveryengine.v1alpha.CreateSchemaRequest;
import com.google.cloud.discoveryengine.v1alpha.DeleteSchemaMetadata;
import com.google.cloud.discoveryengine.v1alpha.DeleteSchemaRequest;
import com.google.cloud.discoveryengine.v1alpha.GetSchemaRequest;
import com.google.cloud.discoveryengine.v1alpha.ListSchemasRequest;
import com.google.cloud.discoveryengine.v1alpha.ListSchemasResponse;
import com.google.cloud.discoveryengine.v1alpha.Schema;
import com.google.cloud.discoveryengine.v1alpha.SchemaServiceClient;
import com.google.cloud.discoveryengine.v1alpha.UpdateSchemaMetadata;
import com.google.cloud.discoveryengine.v1alpha.UpdateSchemaRequest;
import com.google.cloud.discoveryengine.v1alpha.stub.GrpcSchemaServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.HttpJsonSchemaServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.SchemaServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class SchemaServiceStubSettings
extends StubSettings<SchemaServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetSchemaRequest, Schema> getSchemaSettings;
    private final PagedCallSettings<ListSchemasRequest, ListSchemasResponse, SchemaServiceClient.ListSchemasPagedResponse> listSchemasSettings;
    private final UnaryCallSettings<CreateSchemaRequest, Operation> createSchemaSettings;
    private final OperationCallSettings<CreateSchemaRequest, Schema, CreateSchemaMetadata> createSchemaOperationSettings;
    private final UnaryCallSettings<UpdateSchemaRequest, Operation> updateSchemaSettings;
    private final OperationCallSettings<UpdateSchemaRequest, Schema, UpdateSchemaMetadata> updateSchemaOperationSettings;
    private final UnaryCallSettings<DeleteSchemaRequest, Operation> deleteSchemaSettings;
    private final OperationCallSettings<DeleteSchemaRequest, Empty, DeleteSchemaMetadata> deleteSchemaOperationSettings;
    private static final PagedListDescriptor<ListSchemasRequest, ListSchemasResponse, Schema> LIST_SCHEMAS_PAGE_STR_DESC = new PagedListDescriptor<ListSchemasRequest, ListSchemasResponse, Schema>(){

        public String emptyToken() {
            return "";
        }

        public ListSchemasRequest injectToken(ListSchemasRequest payload, String token) {
            return ListSchemasRequest.newBuilder((ListSchemasRequest)payload).setPageToken(token).build();
        }

        public ListSchemasRequest injectPageSize(ListSchemasRequest payload, int pageSize) {
            return ListSchemasRequest.newBuilder((ListSchemasRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSchemasRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSchemasResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Schema> extractResources(ListSchemasResponse payload) {
            return payload.getSchemasList() == null ? ImmutableList.of() : payload.getSchemasList();
        }
    };
    private static final PagedListResponseFactory<ListSchemasRequest, ListSchemasResponse, SchemaServiceClient.ListSchemasPagedResponse> LIST_SCHEMAS_PAGE_STR_FACT = new PagedListResponseFactory<ListSchemasRequest, ListSchemasResponse, SchemaServiceClient.ListSchemasPagedResponse>(){

        public ApiFuture<SchemaServiceClient.ListSchemasPagedResponse> getFuturePagedResponse(UnaryCallable<ListSchemasRequest, ListSchemasResponse> callable, ListSchemasRequest request, ApiCallContext context, ApiFuture<ListSchemasResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SCHEMAS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SchemaServiceClient.ListSchemasPagedResponse.createAsync((PageContext<ListSchemasRequest, ListSchemasResponse, Schema>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetSchemaRequest, Schema> getSchemaSettings() {
        return this.getSchemaSettings;
    }

    public PagedCallSettings<ListSchemasRequest, ListSchemasResponse, SchemaServiceClient.ListSchemasPagedResponse> listSchemasSettings() {
        return this.listSchemasSettings;
    }

    public UnaryCallSettings<CreateSchemaRequest, Operation> createSchemaSettings() {
        return this.createSchemaSettings;
    }

    public OperationCallSettings<CreateSchemaRequest, Schema, CreateSchemaMetadata> createSchemaOperationSettings() {
        return this.createSchemaOperationSettings;
    }

    public UnaryCallSettings<UpdateSchemaRequest, Operation> updateSchemaSettings() {
        return this.updateSchemaSettings;
    }

    public OperationCallSettings<UpdateSchemaRequest, Schema, UpdateSchemaMetadata> updateSchemaOperationSettings() {
        return this.updateSchemaOperationSettings;
    }

    public UnaryCallSettings<DeleteSchemaRequest, Operation> deleteSchemaSettings() {
        return this.deleteSchemaSettings;
    }

    public OperationCallSettings<DeleteSchemaRequest, Empty, DeleteSchemaMetadata> deleteSchemaOperationSettings() {
        return this.deleteSchemaOperationSettings;
    }

    public SchemaServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSchemaServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSchemaServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "discoveryengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "discoveryengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "discoveryengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SchemaServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SchemaServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SchemaServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return SchemaServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SchemaServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getSchemaSettings = settingsBuilder.getSchemaSettings().build();
        this.listSchemasSettings = settingsBuilder.listSchemasSettings().build();
        this.createSchemaSettings = settingsBuilder.createSchemaSettings().build();
        this.createSchemaOperationSettings = settingsBuilder.createSchemaOperationSettings().build();
        this.updateSchemaSettings = settingsBuilder.updateSchemaSettings().build();
        this.updateSchemaOperationSettings = settingsBuilder.updateSchemaOperationSettings().build();
        this.deleteSchemaSettings = settingsBuilder.deleteSchemaSettings().build();
        this.deleteSchemaOperationSettings = settingsBuilder.deleteSchemaOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SchemaServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetSchemaRequest, Schema> getSchemaSettings;
        private final PagedCallSettings.Builder<ListSchemasRequest, ListSchemasResponse, SchemaServiceClient.ListSchemasPagedResponse> listSchemasSettings;
        private final UnaryCallSettings.Builder<CreateSchemaRequest, Operation> createSchemaSettings;
        private final OperationCallSettings.Builder<CreateSchemaRequest, Schema, CreateSchemaMetadata> createSchemaOperationSettings;
        private final UnaryCallSettings.Builder<UpdateSchemaRequest, Operation> updateSchemaSettings;
        private final OperationCallSettings.Builder<UpdateSchemaRequest, Schema, UpdateSchemaMetadata> updateSchemaOperationSettings;
        private final UnaryCallSettings.Builder<DeleteSchemaRequest, Operation> deleteSchemaSettings;
        private final OperationCallSettings.Builder<DeleteSchemaRequest, Empty, DeleteSchemaMetadata> deleteSchemaOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getSchemaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSchemasSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SCHEMAS_PAGE_STR_FACT);
            this.createSchemaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSchemaOperationSettings = OperationCallSettings.newBuilder();
            this.updateSchemaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSchemaOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSchemaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSchemaOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSchemaSettings, this.listSchemasSettings, this.createSchemaSettings, this.updateSchemaSettings, this.deleteSchemaSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SchemaServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getSchemaSettings = settings.getSchemaSettings.toBuilder();
            this.listSchemasSettings = settings.listSchemasSettings.toBuilder();
            this.createSchemaSettings = settings.createSchemaSettings.toBuilder();
            this.createSchemaOperationSettings = settings.createSchemaOperationSettings.toBuilder();
            this.updateSchemaSettings = settings.updateSchemaSettings.toBuilder();
            this.updateSchemaOperationSettings = settings.updateSchemaOperationSettings.toBuilder();
            this.deleteSchemaSettings = settings.deleteSchemaSettings.toBuilder();
            this.deleteSchemaOperationSettings = settings.deleteSchemaOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSchemaSettings, this.listSchemasSettings, this.createSchemaSettings, this.updateSchemaSettings, this.deleteSchemaSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SchemaServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SchemaServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SchemaServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SchemaServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)SchemaServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)SchemaServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SchemaServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SchemaServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getSchemaSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listSchemasSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createSchemaSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateSchemaSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteSchemaSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createSchemaOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Schema.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateSchemaMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateSchemaOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Schema.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateSchemaMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteSchemaOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteSchemaMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetSchemaRequest, Schema> getSchemaSettings() {
            return this.getSchemaSettings;
        }

        public PagedCallSettings.Builder<ListSchemasRequest, ListSchemasResponse, SchemaServiceClient.ListSchemasPagedResponse> listSchemasSettings() {
            return this.listSchemasSettings;
        }

        public UnaryCallSettings.Builder<CreateSchemaRequest, Operation> createSchemaSettings() {
            return this.createSchemaSettings;
        }

        public OperationCallSettings.Builder<CreateSchemaRequest, Schema, CreateSchemaMetadata> createSchemaOperationSettings() {
            return this.createSchemaOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateSchemaRequest, Operation> updateSchemaSettings() {
            return this.updateSchemaSettings;
        }

        public OperationCallSettings.Builder<UpdateSchemaRequest, Schema, UpdateSchemaMetadata> updateSchemaOperationSettings() {
            return this.updateSchemaOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteSchemaRequest, Operation> deleteSchemaSettings() {
            return this.deleteSchemaSettings;
        }

        public OperationCallSettings.Builder<DeleteSchemaRequest, Empty, DeleteSchemaMetadata> deleteSchemaOperationSettings() {
            return this.deleteSchemaOperationSettings;
        }

        public SchemaServiceStubSettings build() throws IOException {
            return new SchemaServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

