/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.GetProjectRequest;
import com.google.cloud.discoveryengine.v1alpha.Project;
import com.google.cloud.discoveryengine.v1alpha.ProvisionProjectMetadata;
import com.google.cloud.discoveryengine.v1alpha.ProvisionProjectRequest;
import com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest;
import com.google.cloud.discoveryengine.v1alpha.stub.HttpJsonProjectServiceCallableFactory;
import com.google.cloud.discoveryengine.v1alpha.stub.ProjectServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.ProjectServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonProjectServiceStub
extends ProjectServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(ProvisionProjectMetadata.getDescriptor()).add(Project.getDescriptor()).build();
    private static final ApiMethodDescriptor<GetProjectRequest, Project> getProjectMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1alpha.ProjectService/GetProject").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{name=projects/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Project.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ProvisionProjectRequest, Operation> provisionProjectMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1alpha.ProjectService/ProvisionProject").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{name=projects/*}:provision", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ReportConsentChangeRequest, Project> reportConsentChangeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1alpha.ProjectService/ReportConsentChange").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1alpha/{project=projects/*}:reportConsentChange", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearProject().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Project.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetProjectRequest, Project> getProjectCallable;
    private final UnaryCallable<ProvisionProjectRequest, Operation> provisionProjectCallable;
    private final OperationCallable<ProvisionProjectRequest, Project, ProvisionProjectMetadata> provisionProjectOperationCallable;
    private final UnaryCallable<ReportConsentChangeRequest, Project> reportConsentChangeCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonProjectServiceStub create(ProjectServiceStubSettings settings) throws IOException {
        return new HttpJsonProjectServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonProjectServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonProjectServiceStub(ProjectServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonProjectServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonProjectServiceStub(ProjectServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonProjectServiceStub(ProjectServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonProjectServiceCallableFactory());
    }

    protected HttpJsonProjectServiceStub(ProjectServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataConnector/operations/*}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/branches/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/models/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/schemas/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine/targetSites/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/engines/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/dataStores/*/branches/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/dataStores/*/models/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/dataStores/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/evaluations/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/operations/*}").build()).build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataConnector}/operations").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/branches/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/models/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/schemas/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine/targetSites}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/dataStores/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*/engines/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/collections/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/dataStores/*/branches/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/dataStores/*/models/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*/dataStores/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*/locations/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1alpha/{name=projects/*}/operations").build()).build()).build());
        HttpJsonCallSettings getProjectTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getProjectMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings provisionProjectTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(provisionProjectMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings reportConsentChangeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(reportConsentChangeMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        this.getProjectCallable = callableFactory.createUnaryCallable(getProjectTransportSettings, settings.getProjectSettings(), clientContext);
        this.provisionProjectCallable = callableFactory.createUnaryCallable(provisionProjectTransportSettings, settings.provisionProjectSettings(), clientContext);
        this.provisionProjectOperationCallable = callableFactory.createOperationCallable(provisionProjectTransportSettings, settings.provisionProjectOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.reportConsentChangeCallable = callableFactory.createUnaryCallable(reportConsentChangeTransportSettings, settings.reportConsentChangeSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getProjectMethodDescriptor);
        methodDescriptors.add(provisionProjectMethodDescriptor);
        methodDescriptors.add(reportConsentChangeMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<GetProjectRequest, Project> getProjectCallable() {
        return this.getProjectCallable;
    }

    @Override
    public UnaryCallable<ProvisionProjectRequest, Operation> provisionProjectCallable() {
        return this.provisionProjectCallable;
    }

    @Override
    public OperationCallable<ProvisionProjectRequest, Project, ProvisionProjectMetadata> provisionProjectOperationCallable() {
        return this.provisionProjectOperationCallable;
    }

    @Override
    public UnaryCallable<ReportConsentChangeRequest, Project> reportConsentChangeCallable() {
        return this.reportConsentChangeCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

