/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.CreateEngineMetadata;
import com.google.cloud.discoveryengine.v1beta.CreateEngineRequest;
import com.google.cloud.discoveryengine.v1beta.DeleteEngineMetadata;
import com.google.cloud.discoveryengine.v1beta.DeleteEngineRequest;
import com.google.cloud.discoveryengine.v1beta.Engine;
import com.google.cloud.discoveryengine.v1beta.EngineServiceClient;
import com.google.cloud.discoveryengine.v1beta.GetEngineRequest;
import com.google.cloud.discoveryengine.v1beta.ListEnginesRequest;
import com.google.cloud.discoveryengine.v1beta.ListEnginesResponse;
import com.google.cloud.discoveryengine.v1beta.UpdateEngineRequest;
import com.google.cloud.discoveryengine.v1beta.stub.EngineServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.GrpcEngineServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.HttpJsonEngineServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class EngineServiceStubSettings
extends StubSettings<EngineServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateEngineRequest, Operation> createEngineSettings;
    private final OperationCallSettings<CreateEngineRequest, Engine, CreateEngineMetadata> createEngineOperationSettings;
    private final UnaryCallSettings<DeleteEngineRequest, Operation> deleteEngineSettings;
    private final OperationCallSettings<DeleteEngineRequest, Empty, DeleteEngineMetadata> deleteEngineOperationSettings;
    private final UnaryCallSettings<UpdateEngineRequest, Engine> updateEngineSettings;
    private final UnaryCallSettings<GetEngineRequest, Engine> getEngineSettings;
    private final PagedCallSettings<ListEnginesRequest, ListEnginesResponse, EngineServiceClient.ListEnginesPagedResponse> listEnginesSettings;
    private static final PagedListDescriptor<ListEnginesRequest, ListEnginesResponse, Engine> LIST_ENGINES_PAGE_STR_DESC = new PagedListDescriptor<ListEnginesRequest, ListEnginesResponse, Engine>(){

        public String emptyToken() {
            return "";
        }

        public ListEnginesRequest injectToken(ListEnginesRequest payload, String token) {
            return ListEnginesRequest.newBuilder((ListEnginesRequest)payload).setPageToken(token).build();
        }

        public ListEnginesRequest injectPageSize(ListEnginesRequest payload, int pageSize) {
            return ListEnginesRequest.newBuilder((ListEnginesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEnginesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEnginesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Engine> extractResources(ListEnginesResponse payload) {
            return payload.getEnginesList() == null ? ImmutableList.of() : payload.getEnginesList();
        }
    };
    private static final PagedListResponseFactory<ListEnginesRequest, ListEnginesResponse, EngineServiceClient.ListEnginesPagedResponse> LIST_ENGINES_PAGE_STR_FACT = new PagedListResponseFactory<ListEnginesRequest, ListEnginesResponse, EngineServiceClient.ListEnginesPagedResponse>(){

        public ApiFuture<EngineServiceClient.ListEnginesPagedResponse> getFuturePagedResponse(UnaryCallable<ListEnginesRequest, ListEnginesResponse> callable, ListEnginesRequest request, ApiCallContext context, ApiFuture<ListEnginesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENGINES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EngineServiceClient.ListEnginesPagedResponse.createAsync((PageContext<ListEnginesRequest, ListEnginesResponse, Engine>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateEngineRequest, Operation> createEngineSettings() {
        return this.createEngineSettings;
    }

    public OperationCallSettings<CreateEngineRequest, Engine, CreateEngineMetadata> createEngineOperationSettings() {
        return this.createEngineOperationSettings;
    }

    public UnaryCallSettings<DeleteEngineRequest, Operation> deleteEngineSettings() {
        return this.deleteEngineSettings;
    }

    public OperationCallSettings<DeleteEngineRequest, Empty, DeleteEngineMetadata> deleteEngineOperationSettings() {
        return this.deleteEngineOperationSettings;
    }

    public UnaryCallSettings<UpdateEngineRequest, Engine> updateEngineSettings() {
        return this.updateEngineSettings;
    }

    public UnaryCallSettings<GetEngineRequest, Engine> getEngineSettings() {
        return this.getEngineSettings;
    }

    public PagedCallSettings<ListEnginesRequest, ListEnginesResponse, EngineServiceClient.ListEnginesPagedResponse> listEnginesSettings() {
        return this.listEnginesSettings;
    }

    public EngineServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEngineServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonEngineServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return EngineServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "discoveryengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "discoveryengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "discoveryengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EngineServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EngineServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EngineServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return EngineServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EngineServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createEngineSettings = settingsBuilder.createEngineSettings().build();
        this.createEngineOperationSettings = settingsBuilder.createEngineOperationSettings().build();
        this.deleteEngineSettings = settingsBuilder.deleteEngineSettings().build();
        this.deleteEngineOperationSettings = settingsBuilder.deleteEngineOperationSettings().build();
        this.updateEngineSettings = settingsBuilder.updateEngineSettings().build();
        this.getEngineSettings = settingsBuilder.getEngineSettings().build();
        this.listEnginesSettings = settingsBuilder.listEnginesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EngineServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateEngineRequest, Operation> createEngineSettings;
        private final OperationCallSettings.Builder<CreateEngineRequest, Engine, CreateEngineMetadata> createEngineOperationSettings;
        private final UnaryCallSettings.Builder<DeleteEngineRequest, Operation> deleteEngineSettings;
        private final OperationCallSettings.Builder<DeleteEngineRequest, Empty, DeleteEngineMetadata> deleteEngineOperationSettings;
        private final UnaryCallSettings.Builder<UpdateEngineRequest, Engine> updateEngineSettings;
        private final UnaryCallSettings.Builder<GetEngineRequest, Engine> getEngineSettings;
        private final PagedCallSettings.Builder<ListEnginesRequest, ListEnginesResponse, EngineServiceClient.ListEnginesPagedResponse> listEnginesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createEngineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEngineOperationSettings = OperationCallSettings.newBuilder();
            this.deleteEngineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEngineOperationSettings = OperationCallSettings.newBuilder();
            this.updateEngineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getEngineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEnginesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENGINES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createEngineSettings, this.deleteEngineSettings, this.updateEngineSettings, this.getEngineSettings, this.listEnginesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(EngineServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createEngineSettings = settings.createEngineSettings.toBuilder();
            this.createEngineOperationSettings = settings.createEngineOperationSettings.toBuilder();
            this.deleteEngineSettings = settings.deleteEngineSettings.toBuilder();
            this.deleteEngineOperationSettings = settings.deleteEngineOperationSettings.toBuilder();
            this.updateEngineSettings = settings.updateEngineSettings.toBuilder();
            this.getEngineSettings = settings.getEngineSettings.toBuilder();
            this.listEnginesSettings = settings.listEnginesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createEngineSettings, this.deleteEngineSettings, this.updateEngineSettings, this.getEngineSettings, this.listEnginesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EngineServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EngineServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EngineServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EngineServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)EngineServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)EngineServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EngineServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EngineServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createEngineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteEngineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateEngineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getEngineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listEnginesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createEngineOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Engine.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateEngineMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteEngineOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteEngineMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateEngineRequest, Operation> createEngineSettings() {
            return this.createEngineSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateEngineRequest, Engine, CreateEngineMetadata> createEngineOperationSettings() {
            return this.createEngineOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteEngineRequest, Operation> deleteEngineSettings() {
            return this.deleteEngineSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteEngineRequest, Empty, DeleteEngineMetadata> deleteEngineOperationSettings() {
            return this.deleteEngineOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateEngineRequest, Engine> updateEngineSettings() {
            return this.updateEngineSettings;
        }

        public UnaryCallSettings.Builder<GetEngineRequest, Engine> getEngineSettings() {
            return this.getEngineSettings;
        }

        public PagedCallSettings.Builder<ListEnginesRequest, ListEnginesResponse, EngineServiceClient.ListEnginesPagedResponse> listEnginesSettings() {
            return this.listEnginesSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return EngineServiceStubSettings.getDefaultEndpoint();
        }

        public EngineServiceStubSettings build() throws IOException {
            return new EngineServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

