/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.CreateSipTrunkRequest;
import com.google.cloud.dialogflow.v2.DeleteSipTrunkRequest;
import com.google.cloud.dialogflow.v2.GetSipTrunkRequest;
import com.google.cloud.dialogflow.v2.ListSipTrunksRequest;
import com.google.cloud.dialogflow.v2.ListSipTrunksResponse;
import com.google.cloud.dialogflow.v2.SipTrunk;
import com.google.cloud.dialogflow.v2.SipTrunksClient;
import com.google.cloud.dialogflow.v2.UpdateSipTrunkRequest;
import com.google.cloud.dialogflow.v2.stub.GrpcSipTrunksCallableFactory;
import com.google.cloud.dialogflow.v2.stub.SipTrunksStub;
import com.google.cloud.dialogflow.v2.stub.SipTrunksStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcSipTrunksStub
extends SipTrunksStub {
    private static final MethodDescriptor<CreateSipTrunkRequest, SipTrunk> createSipTrunkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.SipTrunks/CreateSipTrunk").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSipTrunkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SipTrunk.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteSipTrunkRequest, Empty> deleteSipTrunkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.SipTrunks/DeleteSipTrunk").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSipTrunkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListSipTrunksRequest, ListSipTrunksResponse> listSipTrunksMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.SipTrunks/ListSipTrunks").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSipTrunksRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSipTrunksResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetSipTrunkRequest, SipTrunk> getSipTrunkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.SipTrunks/GetSipTrunk").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSipTrunkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SipTrunk.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateSipTrunkRequest, SipTrunk> updateSipTrunkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.SipTrunks/UpdateSipTrunk").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateSipTrunkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SipTrunk.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateSipTrunkRequest, SipTrunk> createSipTrunkCallable;
    private final UnaryCallable<DeleteSipTrunkRequest, Empty> deleteSipTrunkCallable;
    private final UnaryCallable<ListSipTrunksRequest, ListSipTrunksResponse> listSipTrunksCallable;
    private final UnaryCallable<ListSipTrunksRequest, SipTrunksClient.ListSipTrunksPagedResponse> listSipTrunksPagedCallable;
    private final UnaryCallable<GetSipTrunkRequest, SipTrunk> getSipTrunkCallable;
    private final UnaryCallable<UpdateSipTrunkRequest, SipTrunk> updateSipTrunkCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, SipTrunksClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSipTrunksStub create(SipTrunksStubSettings settings) throws IOException {
        return new GrpcSipTrunksStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSipTrunksStub create(ClientContext clientContext) throws IOException {
        return new GrpcSipTrunksStub(SipTrunksStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSipTrunksStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSipTrunksStub(SipTrunksStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSipTrunksStub(SipTrunksStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSipTrunksCallableFactory());
    }

    protected GrpcSipTrunksStub(SipTrunksStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createSipTrunkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSipTrunkMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteSipTrunkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSipTrunkMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listSipTrunksTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSipTrunksMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getSipTrunkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSipTrunkMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateSipTrunkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSipTrunkMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("sip_trunk.name", String.valueOf(request.getSipTrunk().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createSipTrunkCallable = callableFactory.createUnaryCallable(createSipTrunkTransportSettings, settings.createSipTrunkSettings(), clientContext);
        this.deleteSipTrunkCallable = callableFactory.createUnaryCallable(deleteSipTrunkTransportSettings, settings.deleteSipTrunkSettings(), clientContext);
        this.listSipTrunksCallable = callableFactory.createUnaryCallable(listSipTrunksTransportSettings, settings.listSipTrunksSettings(), clientContext);
        this.listSipTrunksPagedCallable = callableFactory.createPagedCallable(listSipTrunksTransportSettings, settings.listSipTrunksSettings(), clientContext);
        this.getSipTrunkCallable = callableFactory.createUnaryCallable(getSipTrunkTransportSettings, settings.getSipTrunkSettings(), clientContext);
        this.updateSipTrunkCallable = callableFactory.createUnaryCallable(updateSipTrunkTransportSettings, settings.updateSipTrunkSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateSipTrunkRequest, SipTrunk> createSipTrunkCallable() {
        return this.createSipTrunkCallable;
    }

    @Override
    public UnaryCallable<DeleteSipTrunkRequest, Empty> deleteSipTrunkCallable() {
        return this.deleteSipTrunkCallable;
    }

    @Override
    public UnaryCallable<ListSipTrunksRequest, ListSipTrunksResponse> listSipTrunksCallable() {
        return this.listSipTrunksCallable;
    }

    @Override
    public UnaryCallable<ListSipTrunksRequest, SipTrunksClient.ListSipTrunksPagedResponse> listSipTrunksPagedCallable() {
        return this.listSipTrunksPagedCallable;
    }

    @Override
    public UnaryCallable<GetSipTrunkRequest, SipTrunk> getSipTrunkCallable() {
        return this.getSipTrunkCallable;
    }

    @Override
    public UnaryCallable<UpdateSipTrunkRequest, SipTrunk> updateSipTrunkCallable() {
        return this.updateSipTrunkCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, SipTrunksClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

