/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.EncryptionSpec;
import com.google.cloud.dialogflow.v2beta1.EncryptionSpecName;
import com.google.cloud.dialogflow.v2beta1.EncryptionSpecServiceSettings;
import com.google.cloud.dialogflow.v2beta1.GetEncryptionSpecRequest;
import com.google.cloud.dialogflow.v2beta1.InitializeEncryptionSpecMetadata;
import com.google.cloud.dialogflow.v2beta1.InitializeEncryptionSpecRequest;
import com.google.cloud.dialogflow.v2beta1.InitializeEncryptionSpecResponse;
import com.google.cloud.dialogflow.v2beta1.stub.EncryptionSpecServiceStub;
import com.google.cloud.dialogflow.v2beta1.stub.EncryptionSpecServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class EncryptionSpecServiceClient
implements BackgroundResource {
    private final EncryptionSpecServiceSettings settings;
    private final EncryptionSpecServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final EncryptionSpecServiceClient create() throws IOException {
        return EncryptionSpecServiceClient.create(EncryptionSpecServiceSettings.newBuilder().build());
    }

    public static final EncryptionSpecServiceClient create(EncryptionSpecServiceSettings settings) throws IOException {
        return new EncryptionSpecServiceClient(settings);
    }

    public static final EncryptionSpecServiceClient create(EncryptionSpecServiceStub stub) {
        return new EncryptionSpecServiceClient(stub);
    }

    protected EncryptionSpecServiceClient(EncryptionSpecServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EncryptionSpecServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected EncryptionSpecServiceClient(EncryptionSpecServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final EncryptionSpecServiceSettings getSettings() {
        return this.settings;
    }

    public EncryptionSpecServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final EncryptionSpec getEncryptionSpec(EncryptionSpecName name) {
        GetEncryptionSpecRequest request = GetEncryptionSpecRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEncryptionSpec(request);
    }

    public final EncryptionSpec getEncryptionSpec(String name) {
        GetEncryptionSpecRequest request = GetEncryptionSpecRequest.newBuilder().setName(name).build();
        return this.getEncryptionSpec(request);
    }

    public final EncryptionSpec getEncryptionSpec(GetEncryptionSpecRequest request) {
        return (EncryptionSpec)this.getEncryptionSpecCallable().call((Object)request);
    }

    public final UnaryCallable<GetEncryptionSpecRequest, EncryptionSpec> getEncryptionSpecCallable() {
        return this.stub.getEncryptionSpecCallable();
    }

    public final OperationFuture<InitializeEncryptionSpecResponse, InitializeEncryptionSpecMetadata> initializeEncryptionSpecAsync(EncryptionSpec encryptionSpec) {
        InitializeEncryptionSpecRequest request = InitializeEncryptionSpecRequest.newBuilder().setEncryptionSpec(encryptionSpec).build();
        return this.initializeEncryptionSpecAsync(request);
    }

    public final OperationFuture<InitializeEncryptionSpecResponse, InitializeEncryptionSpecMetadata> initializeEncryptionSpecAsync(InitializeEncryptionSpecRequest request) {
        return this.initializeEncryptionSpecOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InitializeEncryptionSpecRequest, InitializeEncryptionSpecResponse, InitializeEncryptionSpecMetadata> initializeEncryptionSpecOperationCallable() {
        return this.stub.initializeEncryptionSpecOperationCallable();
    }

    public final UnaryCallable<InitializeEncryptionSpecRequest, Operation> initializeEncryptionSpecCallable() {
        return this.stub.initializeEncryptionSpecCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

