/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.ConversationDataset;
import com.google.cloud.dialogflow.v2.ConversationDatasetsClient;
import com.google.cloud.dialogflow.v2.CreateConversationDatasetOperationMetadata;
import com.google.cloud.dialogflow.v2.CreateConversationDatasetRequest;
import com.google.cloud.dialogflow.v2.DeleteConversationDatasetOperationMetadata;
import com.google.cloud.dialogflow.v2.DeleteConversationDatasetRequest;
import com.google.cloud.dialogflow.v2.GetConversationDatasetRequest;
import com.google.cloud.dialogflow.v2.ImportConversationDataOperationMetadata;
import com.google.cloud.dialogflow.v2.ImportConversationDataOperationResponse;
import com.google.cloud.dialogflow.v2.ImportConversationDataRequest;
import com.google.cloud.dialogflow.v2.ListConversationDatasetsRequest;
import com.google.cloud.dialogflow.v2.ListConversationDatasetsResponse;
import com.google.cloud.dialogflow.v2.stub.ConversationDatasetsStub;
import com.google.cloud.dialogflow.v2.stub.GrpcConversationDatasetsStub;
import com.google.cloud.dialogflow.v2.stub.HttpJsonConversationDatasetsStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ConversationDatasetsStubSettings
extends StubSettings<ConversationDatasetsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final UnaryCallSettings<CreateConversationDatasetRequest, Operation> createConversationDatasetSettings;
    private final OperationCallSettings<CreateConversationDatasetRequest, ConversationDataset, CreateConversationDatasetOperationMetadata> createConversationDatasetOperationSettings;
    private final UnaryCallSettings<GetConversationDatasetRequest, ConversationDataset> getConversationDatasetSettings;
    private final PagedCallSettings<ListConversationDatasetsRequest, ListConversationDatasetsResponse, ConversationDatasetsClient.ListConversationDatasetsPagedResponse> listConversationDatasetsSettings;
    private final UnaryCallSettings<DeleteConversationDatasetRequest, Operation> deleteConversationDatasetSettings;
    private final OperationCallSettings<DeleteConversationDatasetRequest, Empty, DeleteConversationDatasetOperationMetadata> deleteConversationDatasetOperationSettings;
    private final UnaryCallSettings<ImportConversationDataRequest, Operation> importConversationDataSettings;
    private final OperationCallSettings<ImportConversationDataRequest, ImportConversationDataOperationResponse, ImportConversationDataOperationMetadata> importConversationDataOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ConversationDatasetsClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListConversationDatasetsRequest, ListConversationDatasetsResponse, ConversationDataset> LIST_CONVERSATION_DATASETS_PAGE_STR_DESC = new PagedListDescriptor<ListConversationDatasetsRequest, ListConversationDatasetsResponse, ConversationDataset>(){

        public String emptyToken() {
            return "";
        }

        public ListConversationDatasetsRequest injectToken(ListConversationDatasetsRequest payload, String token) {
            return ListConversationDatasetsRequest.newBuilder((ListConversationDatasetsRequest)payload).setPageToken(token).build();
        }

        public ListConversationDatasetsRequest injectPageSize(ListConversationDatasetsRequest payload, int pageSize) {
            return ListConversationDatasetsRequest.newBuilder((ListConversationDatasetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConversationDatasetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConversationDatasetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ConversationDataset> extractResources(ListConversationDatasetsResponse payload) {
            return payload.getConversationDatasetsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListConversationDatasetsRequest, ListConversationDatasetsResponse, ConversationDatasetsClient.ListConversationDatasetsPagedResponse> LIST_CONVERSATION_DATASETS_PAGE_STR_FACT = new PagedListResponseFactory<ListConversationDatasetsRequest, ListConversationDatasetsResponse, ConversationDatasetsClient.ListConversationDatasetsPagedResponse>(){

        public ApiFuture<ConversationDatasetsClient.ListConversationDatasetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListConversationDatasetsRequest, ListConversationDatasetsResponse> callable, ListConversationDatasetsRequest request, ApiCallContext context, ApiFuture<ListConversationDatasetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONVERSATION_DATASETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConversationDatasetsClient.ListConversationDatasetsPagedResponse.createAsync((PageContext<ListConversationDatasetsRequest, ListConversationDatasetsResponse, ConversationDataset>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ConversationDatasetsClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ConversationDatasetsClient.ListLocationsPagedResponse>(){

        public ApiFuture<ConversationDatasetsClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConversationDatasetsClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateConversationDatasetRequest, Operation> createConversationDatasetSettings() {
        return this.createConversationDatasetSettings;
    }

    public OperationCallSettings<CreateConversationDatasetRequest, ConversationDataset, CreateConversationDatasetOperationMetadata> createConversationDatasetOperationSettings() {
        return this.createConversationDatasetOperationSettings;
    }

    public UnaryCallSettings<GetConversationDatasetRequest, ConversationDataset> getConversationDatasetSettings() {
        return this.getConversationDatasetSettings;
    }

    public PagedCallSettings<ListConversationDatasetsRequest, ListConversationDatasetsResponse, ConversationDatasetsClient.ListConversationDatasetsPagedResponse> listConversationDatasetsSettings() {
        return this.listConversationDatasetsSettings;
    }

    public UnaryCallSettings<DeleteConversationDatasetRequest, Operation> deleteConversationDatasetSettings() {
        return this.deleteConversationDatasetSettings;
    }

    public OperationCallSettings<DeleteConversationDatasetRequest, Empty, DeleteConversationDatasetOperationMetadata> deleteConversationDatasetOperationSettings() {
        return this.deleteConversationDatasetOperationSettings;
    }

    public UnaryCallSettings<ImportConversationDataRequest, Operation> importConversationDataSettings() {
        return this.importConversationDataSettings;
    }

    public OperationCallSettings<ImportConversationDataRequest, ImportConversationDataOperationResponse, ImportConversationDataOperationMetadata> importConversationDataOperationSettings() {
        return this.importConversationDataOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ConversationDatasetsClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public ConversationDatasetsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcConversationDatasetsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonConversationDatasetsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dialogflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ConversationDatasetsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConversationDatasetsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConversationDatasetsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ConversationDatasetsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ConversationDatasetsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createConversationDatasetSettings = settingsBuilder.createConversationDatasetSettings().build();
        this.createConversationDatasetOperationSettings = settingsBuilder.createConversationDatasetOperationSettings().build();
        this.getConversationDatasetSettings = settingsBuilder.getConversationDatasetSettings().build();
        this.listConversationDatasetsSettings = settingsBuilder.listConversationDatasetsSettings().build();
        this.deleteConversationDatasetSettings = settingsBuilder.deleteConversationDatasetSettings().build();
        this.deleteConversationDatasetOperationSettings = settingsBuilder.deleteConversationDatasetOperationSettings().build();
        this.importConversationDataSettings = settingsBuilder.importConversationDataSettings().build();
        this.importConversationDataOperationSettings = settingsBuilder.importConversationDataOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ConversationDatasetsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateConversationDatasetRequest, Operation> createConversationDatasetSettings;
        private final OperationCallSettings.Builder<CreateConversationDatasetRequest, ConversationDataset, CreateConversationDatasetOperationMetadata> createConversationDatasetOperationSettings;
        private final UnaryCallSettings.Builder<GetConversationDatasetRequest, ConversationDataset> getConversationDatasetSettings;
        private final PagedCallSettings.Builder<ListConversationDatasetsRequest, ListConversationDatasetsResponse, ConversationDatasetsClient.ListConversationDatasetsPagedResponse> listConversationDatasetsSettings;
        private final UnaryCallSettings.Builder<DeleteConversationDatasetRequest, Operation> deleteConversationDatasetSettings;
        private final OperationCallSettings.Builder<DeleteConversationDatasetRequest, Empty, DeleteConversationDatasetOperationMetadata> deleteConversationDatasetOperationSettings;
        private final UnaryCallSettings.Builder<ImportConversationDataRequest, Operation> importConversationDataSettings;
        private final OperationCallSettings.Builder<ImportConversationDataRequest, ImportConversationDataOperationResponse, ImportConversationDataOperationMetadata> importConversationDataOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ConversationDatasetsClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createConversationDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConversationDatasetOperationSettings = OperationCallSettings.newBuilder();
            this.getConversationDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listConversationDatasetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONVERSATION_DATASETS_PAGE_STR_FACT);
            this.deleteConversationDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteConversationDatasetOperationSettings = OperationCallSettings.newBuilder();
            this.importConversationDataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importConversationDataOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createConversationDatasetSettings, this.getConversationDatasetSettings, this.listConversationDatasetsSettings, this.deleteConversationDatasetSettings, this.importConversationDataSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ConversationDatasetsStubSettings settings) {
            super((StubSettings)settings);
            this.createConversationDatasetSettings = settings.createConversationDatasetSettings.toBuilder();
            this.createConversationDatasetOperationSettings = settings.createConversationDatasetOperationSettings.toBuilder();
            this.getConversationDatasetSettings = settings.getConversationDatasetSettings.toBuilder();
            this.listConversationDatasetsSettings = settings.listConversationDatasetsSettings.toBuilder();
            this.deleteConversationDatasetSettings = settings.deleteConversationDatasetSettings.toBuilder();
            this.deleteConversationDatasetOperationSettings = settings.deleteConversationDatasetOperationSettings.toBuilder();
            this.importConversationDataSettings = settings.importConversationDataSettings.toBuilder();
            this.importConversationDataOperationSettings = settings.importConversationDataOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createConversationDatasetSettings, this.getConversationDatasetSettings, this.listConversationDatasetsSettings, this.deleteConversationDatasetSettings, this.importConversationDataSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ConversationDatasetsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ConversationDatasetsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConversationDatasetsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ConversationDatasetsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ConversationDatasetsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ConversationDatasetsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConversationDatasetsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ConversationDatasetsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createConversationDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getConversationDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listConversationDatasetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteConversationDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.importConversationDataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createConversationDatasetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ConversationDataset.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateConversationDatasetOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteConversationDatasetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteConversationDatasetOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.importConversationDataOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportConversationDataOperationResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportConversationDataOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateConversationDatasetRequest, Operation> createConversationDatasetSettings() {
            return this.createConversationDatasetSettings;
        }

        public OperationCallSettings.Builder<CreateConversationDatasetRequest, ConversationDataset, CreateConversationDatasetOperationMetadata> createConversationDatasetOperationSettings() {
            return this.createConversationDatasetOperationSettings;
        }

        public UnaryCallSettings.Builder<GetConversationDatasetRequest, ConversationDataset> getConversationDatasetSettings() {
            return this.getConversationDatasetSettings;
        }

        public PagedCallSettings.Builder<ListConversationDatasetsRequest, ListConversationDatasetsResponse, ConversationDatasetsClient.ListConversationDatasetsPagedResponse> listConversationDatasetsSettings() {
            return this.listConversationDatasetsSettings;
        }

        public UnaryCallSettings.Builder<DeleteConversationDatasetRequest, Operation> deleteConversationDatasetSettings() {
            return this.deleteConversationDatasetSettings;
        }

        public OperationCallSettings.Builder<DeleteConversationDatasetRequest, Empty, DeleteConversationDatasetOperationMetadata> deleteConversationDatasetOperationSettings() {
            return this.deleteConversationDatasetOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportConversationDataRequest, Operation> importConversationDataSettings() {
            return this.importConversationDataSettings;
        }

        public OperationCallSettings.Builder<ImportConversationDataRequest, ImportConversationDataOperationResponse, ImportConversationDataOperationMetadata> importConversationDataOperationSettings() {
            return this.importConversationDataOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ConversationDatasetsClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public ConversationDatasetsStubSettings build() throws IOException {
            return new ConversationDatasetsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

