/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.Fulfillment;
import com.google.cloud.dialogflow.v2beta1.FulfillmentName;
import com.google.cloud.dialogflow.v2beta1.FulfillmentsSettings;
import com.google.cloud.dialogflow.v2beta1.GetFulfillmentRequest;
import com.google.cloud.dialogflow.v2beta1.UpdateFulfillmentRequest;
import com.google.cloud.dialogflow.v2beta1.stub.FulfillmentsStub;
import com.google.cloud.dialogflow.v2beta1.stub.FulfillmentsStubSettings;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class FulfillmentsClient
implements BackgroundResource {
    private final FulfillmentsSettings settings;
    private final FulfillmentsStub stub;

    public static final FulfillmentsClient create() throws IOException {
        return FulfillmentsClient.create(FulfillmentsSettings.newBuilder().build());
    }

    public static final FulfillmentsClient create(FulfillmentsSettings settings) throws IOException {
        return new FulfillmentsClient(settings);
    }

    public static final FulfillmentsClient create(FulfillmentsStub stub) {
        return new FulfillmentsClient(stub);
    }

    protected FulfillmentsClient(FulfillmentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FulfillmentsStubSettings)settings.getStubSettings()).createStub();
    }

    protected FulfillmentsClient(FulfillmentsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FulfillmentsSettings getSettings() {
        return this.settings;
    }

    public FulfillmentsStub getStub() {
        return this.stub;
    }

    public final Fulfillment getFulfillment(FulfillmentName name) {
        GetFulfillmentRequest request = GetFulfillmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFulfillment(request);
    }

    public final Fulfillment getFulfillment(String name) {
        GetFulfillmentRequest request = GetFulfillmentRequest.newBuilder().setName(name).build();
        return this.getFulfillment(request);
    }

    public final Fulfillment getFulfillment(GetFulfillmentRequest request) {
        return (Fulfillment)this.getFulfillmentCallable().call((Object)request);
    }

    public final UnaryCallable<GetFulfillmentRequest, Fulfillment> getFulfillmentCallable() {
        return this.stub.getFulfillmentCallable();
    }

    public final Fulfillment updateFulfillment(Fulfillment fulfillment, FieldMask updateMask) {
        UpdateFulfillmentRequest request = UpdateFulfillmentRequest.newBuilder().setFulfillment(fulfillment).setUpdateMask(updateMask).build();
        return this.updateFulfillment(request);
    }

    public final Fulfillment updateFulfillment(UpdateFulfillmentRequest request) {
        return (Fulfillment)this.updateFulfillmentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateFulfillmentRequest, Fulfillment> updateFulfillmentCallable() {
        return this.stub.updateFulfillmentCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

