/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.ConversationModel;
import com.google.cloud.dialogflow.v2.ConversationModelEvaluation;
import com.google.cloud.dialogflow.v2.ConversationModelsClient;
import com.google.cloud.dialogflow.v2.CreateConversationModelEvaluationOperationMetadata;
import com.google.cloud.dialogflow.v2.CreateConversationModelEvaluationRequest;
import com.google.cloud.dialogflow.v2.CreateConversationModelOperationMetadata;
import com.google.cloud.dialogflow.v2.CreateConversationModelRequest;
import com.google.cloud.dialogflow.v2.DeleteConversationModelOperationMetadata;
import com.google.cloud.dialogflow.v2.DeleteConversationModelRequest;
import com.google.cloud.dialogflow.v2.DeployConversationModelOperationMetadata;
import com.google.cloud.dialogflow.v2.DeployConversationModelRequest;
import com.google.cloud.dialogflow.v2.GetConversationModelEvaluationRequest;
import com.google.cloud.dialogflow.v2.GetConversationModelRequest;
import com.google.cloud.dialogflow.v2.ListConversationModelEvaluationsRequest;
import com.google.cloud.dialogflow.v2.ListConversationModelEvaluationsResponse;
import com.google.cloud.dialogflow.v2.ListConversationModelsRequest;
import com.google.cloud.dialogflow.v2.ListConversationModelsResponse;
import com.google.cloud.dialogflow.v2.UndeployConversationModelOperationMetadata;
import com.google.cloud.dialogflow.v2.UndeployConversationModelRequest;
import com.google.cloud.dialogflow.v2.stub.ConversationModelsStub;
import com.google.cloud.dialogflow.v2.stub.GrpcConversationModelsStub;
import com.google.cloud.dialogflow.v2.stub.HttpJsonConversationModelsStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ConversationModelsStubSettings
extends StubSettings<ConversationModelsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final UnaryCallSettings<CreateConversationModelRequest, Operation> createConversationModelSettings;
    private final OperationCallSettings<CreateConversationModelRequest, ConversationModel, CreateConversationModelOperationMetadata> createConversationModelOperationSettings;
    private final UnaryCallSettings<GetConversationModelRequest, ConversationModel> getConversationModelSettings;
    private final PagedCallSettings<ListConversationModelsRequest, ListConversationModelsResponse, ConversationModelsClient.ListConversationModelsPagedResponse> listConversationModelsSettings;
    private final UnaryCallSettings<DeleteConversationModelRequest, Operation> deleteConversationModelSettings;
    private final OperationCallSettings<DeleteConversationModelRequest, Empty, DeleteConversationModelOperationMetadata> deleteConversationModelOperationSettings;
    private final UnaryCallSettings<DeployConversationModelRequest, Operation> deployConversationModelSettings;
    private final OperationCallSettings<DeployConversationModelRequest, Empty, DeployConversationModelOperationMetadata> deployConversationModelOperationSettings;
    private final UnaryCallSettings<UndeployConversationModelRequest, Operation> undeployConversationModelSettings;
    private final OperationCallSettings<UndeployConversationModelRequest, Empty, UndeployConversationModelOperationMetadata> undeployConversationModelOperationSettings;
    private final UnaryCallSettings<GetConversationModelEvaluationRequest, ConversationModelEvaluation> getConversationModelEvaluationSettings;
    private final PagedCallSettings<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse, ConversationModelsClient.ListConversationModelEvaluationsPagedResponse> listConversationModelEvaluationsSettings;
    private final UnaryCallSettings<CreateConversationModelEvaluationRequest, Operation> createConversationModelEvaluationSettings;
    private final OperationCallSettings<CreateConversationModelEvaluationRequest, ConversationModelEvaluation, CreateConversationModelEvaluationOperationMetadata> createConversationModelEvaluationOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ConversationModelsClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListConversationModelsRequest, ListConversationModelsResponse, ConversationModel> LIST_CONVERSATION_MODELS_PAGE_STR_DESC = new PagedListDescriptor<ListConversationModelsRequest, ListConversationModelsResponse, ConversationModel>(){

        public String emptyToken() {
            return "";
        }

        public ListConversationModelsRequest injectToken(ListConversationModelsRequest payload, String token) {
            return ListConversationModelsRequest.newBuilder((ListConversationModelsRequest)payload).setPageToken(token).build();
        }

        public ListConversationModelsRequest injectPageSize(ListConversationModelsRequest payload, int pageSize) {
            return ListConversationModelsRequest.newBuilder((ListConversationModelsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConversationModelsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConversationModelsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ConversationModel> extractResources(ListConversationModelsResponse payload) {
            return payload.getConversationModelsList() == null ? ImmutableList.of() : payload.getConversationModelsList();
        }
    };
    private static final PagedListDescriptor<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse, ConversationModelEvaluation> LIST_CONVERSATION_MODEL_EVALUATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse, ConversationModelEvaluation>(){

        public String emptyToken() {
            return "";
        }

        public ListConversationModelEvaluationsRequest injectToken(ListConversationModelEvaluationsRequest payload, String token) {
            return ListConversationModelEvaluationsRequest.newBuilder((ListConversationModelEvaluationsRequest)payload).setPageToken(token).build();
        }

        public ListConversationModelEvaluationsRequest injectPageSize(ListConversationModelEvaluationsRequest payload, int pageSize) {
            return ListConversationModelEvaluationsRequest.newBuilder((ListConversationModelEvaluationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConversationModelEvaluationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConversationModelEvaluationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ConversationModelEvaluation> extractResources(ListConversationModelEvaluationsResponse payload) {
            return payload.getConversationModelEvaluationsList() == null ? ImmutableList.of() : payload.getConversationModelEvaluationsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListConversationModelsRequest, ListConversationModelsResponse, ConversationModelsClient.ListConversationModelsPagedResponse> LIST_CONVERSATION_MODELS_PAGE_STR_FACT = new PagedListResponseFactory<ListConversationModelsRequest, ListConversationModelsResponse, ConversationModelsClient.ListConversationModelsPagedResponse>(){

        public ApiFuture<ConversationModelsClient.ListConversationModelsPagedResponse> getFuturePagedResponse(UnaryCallable<ListConversationModelsRequest, ListConversationModelsResponse> callable, ListConversationModelsRequest request, ApiCallContext context, ApiFuture<ListConversationModelsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONVERSATION_MODELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConversationModelsClient.ListConversationModelsPagedResponse.createAsync((PageContext<ListConversationModelsRequest, ListConversationModelsResponse, ConversationModel>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse, ConversationModelsClient.ListConversationModelEvaluationsPagedResponse> LIST_CONVERSATION_MODEL_EVALUATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse, ConversationModelsClient.ListConversationModelEvaluationsPagedResponse>(){

        public ApiFuture<ConversationModelsClient.ListConversationModelEvaluationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse> callable, ListConversationModelEvaluationsRequest request, ApiCallContext context, ApiFuture<ListConversationModelEvaluationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONVERSATION_MODEL_EVALUATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConversationModelsClient.ListConversationModelEvaluationsPagedResponse.createAsync((PageContext<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse, ConversationModelEvaluation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ConversationModelsClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ConversationModelsClient.ListLocationsPagedResponse>(){

        public ApiFuture<ConversationModelsClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConversationModelsClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateConversationModelRequest, Operation> createConversationModelSettings() {
        return this.createConversationModelSettings;
    }

    public OperationCallSettings<CreateConversationModelRequest, ConversationModel, CreateConversationModelOperationMetadata> createConversationModelOperationSettings() {
        return this.createConversationModelOperationSettings;
    }

    public UnaryCallSettings<GetConversationModelRequest, ConversationModel> getConversationModelSettings() {
        return this.getConversationModelSettings;
    }

    public PagedCallSettings<ListConversationModelsRequest, ListConversationModelsResponse, ConversationModelsClient.ListConversationModelsPagedResponse> listConversationModelsSettings() {
        return this.listConversationModelsSettings;
    }

    public UnaryCallSettings<DeleteConversationModelRequest, Operation> deleteConversationModelSettings() {
        return this.deleteConversationModelSettings;
    }

    public OperationCallSettings<DeleteConversationModelRequest, Empty, DeleteConversationModelOperationMetadata> deleteConversationModelOperationSettings() {
        return this.deleteConversationModelOperationSettings;
    }

    public UnaryCallSettings<DeployConversationModelRequest, Operation> deployConversationModelSettings() {
        return this.deployConversationModelSettings;
    }

    public OperationCallSettings<DeployConversationModelRequest, Empty, DeployConversationModelOperationMetadata> deployConversationModelOperationSettings() {
        return this.deployConversationModelOperationSettings;
    }

    public UnaryCallSettings<UndeployConversationModelRequest, Operation> undeployConversationModelSettings() {
        return this.undeployConversationModelSettings;
    }

    public OperationCallSettings<UndeployConversationModelRequest, Empty, UndeployConversationModelOperationMetadata> undeployConversationModelOperationSettings() {
        return this.undeployConversationModelOperationSettings;
    }

    public UnaryCallSettings<GetConversationModelEvaluationRequest, ConversationModelEvaluation> getConversationModelEvaluationSettings() {
        return this.getConversationModelEvaluationSettings;
    }

    public PagedCallSettings<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse, ConversationModelsClient.ListConversationModelEvaluationsPagedResponse> listConversationModelEvaluationsSettings() {
        return this.listConversationModelEvaluationsSettings;
    }

    public UnaryCallSettings<CreateConversationModelEvaluationRequest, Operation> createConversationModelEvaluationSettings() {
        return this.createConversationModelEvaluationSettings;
    }

    public OperationCallSettings<CreateConversationModelEvaluationRequest, ConversationModelEvaluation, CreateConversationModelEvaluationOperationMetadata> createConversationModelEvaluationOperationSettings() {
        return this.createConversationModelEvaluationOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ConversationModelsClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public ConversationModelsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcConversationModelsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonConversationModelsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return ConversationModelsStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "dialogflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ConversationModelsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConversationModelsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConversationModelsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ConversationModelsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ConversationModelsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createConversationModelSettings = settingsBuilder.createConversationModelSettings().build();
        this.createConversationModelOperationSettings = settingsBuilder.createConversationModelOperationSettings().build();
        this.getConversationModelSettings = settingsBuilder.getConversationModelSettings().build();
        this.listConversationModelsSettings = settingsBuilder.listConversationModelsSettings().build();
        this.deleteConversationModelSettings = settingsBuilder.deleteConversationModelSettings().build();
        this.deleteConversationModelOperationSettings = settingsBuilder.deleteConversationModelOperationSettings().build();
        this.deployConversationModelSettings = settingsBuilder.deployConversationModelSettings().build();
        this.deployConversationModelOperationSettings = settingsBuilder.deployConversationModelOperationSettings().build();
        this.undeployConversationModelSettings = settingsBuilder.undeployConversationModelSettings().build();
        this.undeployConversationModelOperationSettings = settingsBuilder.undeployConversationModelOperationSettings().build();
        this.getConversationModelEvaluationSettings = settingsBuilder.getConversationModelEvaluationSettings().build();
        this.listConversationModelEvaluationsSettings = settingsBuilder.listConversationModelEvaluationsSettings().build();
        this.createConversationModelEvaluationSettings = settingsBuilder.createConversationModelEvaluationSettings().build();
        this.createConversationModelEvaluationOperationSettings = settingsBuilder.createConversationModelEvaluationOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ConversationModelsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateConversationModelRequest, Operation> createConversationModelSettings;
        private final OperationCallSettings.Builder<CreateConversationModelRequest, ConversationModel, CreateConversationModelOperationMetadata> createConversationModelOperationSettings;
        private final UnaryCallSettings.Builder<GetConversationModelRequest, ConversationModel> getConversationModelSettings;
        private final PagedCallSettings.Builder<ListConversationModelsRequest, ListConversationModelsResponse, ConversationModelsClient.ListConversationModelsPagedResponse> listConversationModelsSettings;
        private final UnaryCallSettings.Builder<DeleteConversationModelRequest, Operation> deleteConversationModelSettings;
        private final OperationCallSettings.Builder<DeleteConversationModelRequest, Empty, DeleteConversationModelOperationMetadata> deleteConversationModelOperationSettings;
        private final UnaryCallSettings.Builder<DeployConversationModelRequest, Operation> deployConversationModelSettings;
        private final OperationCallSettings.Builder<DeployConversationModelRequest, Empty, DeployConversationModelOperationMetadata> deployConversationModelOperationSettings;
        private final UnaryCallSettings.Builder<UndeployConversationModelRequest, Operation> undeployConversationModelSettings;
        private final OperationCallSettings.Builder<UndeployConversationModelRequest, Empty, UndeployConversationModelOperationMetadata> undeployConversationModelOperationSettings;
        private final UnaryCallSettings.Builder<GetConversationModelEvaluationRequest, ConversationModelEvaluation> getConversationModelEvaluationSettings;
        private final PagedCallSettings.Builder<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse, ConversationModelsClient.ListConversationModelEvaluationsPagedResponse> listConversationModelEvaluationsSettings;
        private final UnaryCallSettings.Builder<CreateConversationModelEvaluationRequest, Operation> createConversationModelEvaluationSettings;
        private final OperationCallSettings.Builder<CreateConversationModelEvaluationRequest, ConversationModelEvaluation, CreateConversationModelEvaluationOperationMetadata> createConversationModelEvaluationOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ConversationModelsClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createConversationModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConversationModelOperationSettings = OperationCallSettings.newBuilder();
            this.getConversationModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listConversationModelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONVERSATION_MODELS_PAGE_STR_FACT);
            this.deleteConversationModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteConversationModelOperationSettings = OperationCallSettings.newBuilder();
            this.deployConversationModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deployConversationModelOperationSettings = OperationCallSettings.newBuilder();
            this.undeployConversationModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeployConversationModelOperationSettings = OperationCallSettings.newBuilder();
            this.getConversationModelEvaluationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listConversationModelEvaluationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONVERSATION_MODEL_EVALUATIONS_PAGE_STR_FACT);
            this.createConversationModelEvaluationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConversationModelEvaluationOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createConversationModelSettings, this.getConversationModelSettings, this.listConversationModelsSettings, this.deleteConversationModelSettings, this.deployConversationModelSettings, this.undeployConversationModelSettings, this.getConversationModelEvaluationSettings, this.listConversationModelEvaluationsSettings, this.createConversationModelEvaluationSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ConversationModelsStubSettings settings) {
            super((StubSettings)settings);
            this.createConversationModelSettings = settings.createConversationModelSettings.toBuilder();
            this.createConversationModelOperationSettings = settings.createConversationModelOperationSettings.toBuilder();
            this.getConversationModelSettings = settings.getConversationModelSettings.toBuilder();
            this.listConversationModelsSettings = settings.listConversationModelsSettings.toBuilder();
            this.deleteConversationModelSettings = settings.deleteConversationModelSettings.toBuilder();
            this.deleteConversationModelOperationSettings = settings.deleteConversationModelOperationSettings.toBuilder();
            this.deployConversationModelSettings = settings.deployConversationModelSettings.toBuilder();
            this.deployConversationModelOperationSettings = settings.deployConversationModelOperationSettings.toBuilder();
            this.undeployConversationModelSettings = settings.undeployConversationModelSettings.toBuilder();
            this.undeployConversationModelOperationSettings = settings.undeployConversationModelOperationSettings.toBuilder();
            this.getConversationModelEvaluationSettings = settings.getConversationModelEvaluationSettings.toBuilder();
            this.listConversationModelEvaluationsSettings = settings.listConversationModelEvaluationsSettings.toBuilder();
            this.createConversationModelEvaluationSettings = settings.createConversationModelEvaluationSettings.toBuilder();
            this.createConversationModelEvaluationOperationSettings = settings.createConversationModelEvaluationOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createConversationModelSettings, this.getConversationModelSettings, this.listConversationModelsSettings, this.deleteConversationModelSettings, this.deployConversationModelSettings, this.undeployConversationModelSettings, this.getConversationModelEvaluationSettings, this.listConversationModelEvaluationsSettings, this.createConversationModelEvaluationSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ConversationModelsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ConversationModelsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConversationModelsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ConversationModelsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ConversationModelsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ConversationModelsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConversationModelsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ConversationModelsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createConversationModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getConversationModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listConversationModelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteConversationModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deployConversationModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.undeployConversationModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getConversationModelEvaluationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listConversationModelEvaluationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createConversationModelEvaluationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createConversationModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ConversationModel.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateConversationModelOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteConversationModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteConversationModelOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deployConversationModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeployConversationModelOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.undeployConversationModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UndeployConversationModelOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createConversationModelEvaluationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ConversationModelEvaluation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateConversationModelEvaluationOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateConversationModelRequest, Operation> createConversationModelSettings() {
            return this.createConversationModelSettings;
        }

        public OperationCallSettings.Builder<CreateConversationModelRequest, ConversationModel, CreateConversationModelOperationMetadata> createConversationModelOperationSettings() {
            return this.createConversationModelOperationSettings;
        }

        public UnaryCallSettings.Builder<GetConversationModelRequest, ConversationModel> getConversationModelSettings() {
            return this.getConversationModelSettings;
        }

        public PagedCallSettings.Builder<ListConversationModelsRequest, ListConversationModelsResponse, ConversationModelsClient.ListConversationModelsPagedResponse> listConversationModelsSettings() {
            return this.listConversationModelsSettings;
        }

        public UnaryCallSettings.Builder<DeleteConversationModelRequest, Operation> deleteConversationModelSettings() {
            return this.deleteConversationModelSettings;
        }

        public OperationCallSettings.Builder<DeleteConversationModelRequest, Empty, DeleteConversationModelOperationMetadata> deleteConversationModelOperationSettings() {
            return this.deleteConversationModelOperationSettings;
        }

        public UnaryCallSettings.Builder<DeployConversationModelRequest, Operation> deployConversationModelSettings() {
            return this.deployConversationModelSettings;
        }

        public OperationCallSettings.Builder<DeployConversationModelRequest, Empty, DeployConversationModelOperationMetadata> deployConversationModelOperationSettings() {
            return this.deployConversationModelOperationSettings;
        }

        public UnaryCallSettings.Builder<UndeployConversationModelRequest, Operation> undeployConversationModelSettings() {
            return this.undeployConversationModelSettings;
        }

        public OperationCallSettings.Builder<UndeployConversationModelRequest, Empty, UndeployConversationModelOperationMetadata> undeployConversationModelOperationSettings() {
            return this.undeployConversationModelOperationSettings;
        }

        public UnaryCallSettings.Builder<GetConversationModelEvaluationRequest, ConversationModelEvaluation> getConversationModelEvaluationSettings() {
            return this.getConversationModelEvaluationSettings;
        }

        public PagedCallSettings.Builder<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse, ConversationModelsClient.ListConversationModelEvaluationsPagedResponse> listConversationModelEvaluationsSettings() {
            return this.listConversationModelEvaluationsSettings;
        }

        public UnaryCallSettings.Builder<CreateConversationModelEvaluationRequest, Operation> createConversationModelEvaluationSettings() {
            return this.createConversationModelEvaluationSettings;
        }

        public OperationCallSettings.Builder<CreateConversationModelEvaluationRequest, ConversationModelEvaluation, CreateConversationModelEvaluationOperationMetadata> createConversationModelEvaluationOperationSettings() {
            return this.createConversationModelEvaluationOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ConversationModelsClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return ConversationModelsStubSettings.getDefaultEndpoint();
        }

        public ConversationModelsStubSettings build() throws IOException {
            return new ConversationModelsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

