/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.ClearSuggestionFeatureConfigOperationMetadata;
import com.google.cloud.dialogflow.v2.ClearSuggestionFeatureConfigRequest;
import com.google.cloud.dialogflow.v2.ConversationProfile;
import com.google.cloud.dialogflow.v2.ConversationProfilesClient;
import com.google.cloud.dialogflow.v2.CreateConversationProfileRequest;
import com.google.cloud.dialogflow.v2.DeleteConversationProfileRequest;
import com.google.cloud.dialogflow.v2.GetConversationProfileRequest;
import com.google.cloud.dialogflow.v2.ListConversationProfilesRequest;
import com.google.cloud.dialogflow.v2.ListConversationProfilesResponse;
import com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigOperationMetadata;
import com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest;
import com.google.cloud.dialogflow.v2.UpdateConversationProfileRequest;
import com.google.cloud.dialogflow.v2.stub.ConversationProfilesStub;
import com.google.cloud.dialogflow.v2.stub.GrpcConversationProfilesStub;
import com.google.cloud.dialogflow.v2.stub.HttpJsonConversationProfilesStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ConversationProfilesStubSettings
extends StubSettings<ConversationProfilesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final PagedCallSettings<ListConversationProfilesRequest, ListConversationProfilesResponse, ConversationProfilesClient.ListConversationProfilesPagedResponse> listConversationProfilesSettings;
    private final UnaryCallSettings<GetConversationProfileRequest, ConversationProfile> getConversationProfileSettings;
    private final UnaryCallSettings<CreateConversationProfileRequest, ConversationProfile> createConversationProfileSettings;
    private final UnaryCallSettings<UpdateConversationProfileRequest, ConversationProfile> updateConversationProfileSettings;
    private final UnaryCallSettings<DeleteConversationProfileRequest, Empty> deleteConversationProfileSettings;
    private final UnaryCallSettings<SetSuggestionFeatureConfigRequest, Operation> setSuggestionFeatureConfigSettings;
    private final OperationCallSettings<SetSuggestionFeatureConfigRequest, ConversationProfile, SetSuggestionFeatureConfigOperationMetadata> setSuggestionFeatureConfigOperationSettings;
    private final UnaryCallSettings<ClearSuggestionFeatureConfigRequest, Operation> clearSuggestionFeatureConfigSettings;
    private final OperationCallSettings<ClearSuggestionFeatureConfigRequest, ConversationProfile, ClearSuggestionFeatureConfigOperationMetadata> clearSuggestionFeatureConfigOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ConversationProfilesClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListConversationProfilesRequest, ListConversationProfilesResponse, ConversationProfile> LIST_CONVERSATION_PROFILES_PAGE_STR_DESC = new PagedListDescriptor<ListConversationProfilesRequest, ListConversationProfilesResponse, ConversationProfile>(){

        public String emptyToken() {
            return "";
        }

        public ListConversationProfilesRequest injectToken(ListConversationProfilesRequest payload, String token) {
            return ListConversationProfilesRequest.newBuilder((ListConversationProfilesRequest)payload).setPageToken(token).build();
        }

        public ListConversationProfilesRequest injectPageSize(ListConversationProfilesRequest payload, int pageSize) {
            return ListConversationProfilesRequest.newBuilder((ListConversationProfilesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConversationProfilesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConversationProfilesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ConversationProfile> extractResources(ListConversationProfilesResponse payload) {
            return payload.getConversationProfilesList() == null ? ImmutableList.of() : payload.getConversationProfilesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListConversationProfilesRequest, ListConversationProfilesResponse, ConversationProfilesClient.ListConversationProfilesPagedResponse> LIST_CONVERSATION_PROFILES_PAGE_STR_FACT = new PagedListResponseFactory<ListConversationProfilesRequest, ListConversationProfilesResponse, ConversationProfilesClient.ListConversationProfilesPagedResponse>(){

        public ApiFuture<ConversationProfilesClient.ListConversationProfilesPagedResponse> getFuturePagedResponse(UnaryCallable<ListConversationProfilesRequest, ListConversationProfilesResponse> callable, ListConversationProfilesRequest request, ApiCallContext context, ApiFuture<ListConversationProfilesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONVERSATION_PROFILES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConversationProfilesClient.ListConversationProfilesPagedResponse.createAsync((PageContext<ListConversationProfilesRequest, ListConversationProfilesResponse, ConversationProfile>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ConversationProfilesClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ConversationProfilesClient.ListLocationsPagedResponse>(){

        public ApiFuture<ConversationProfilesClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConversationProfilesClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListConversationProfilesRequest, ListConversationProfilesResponse, ConversationProfilesClient.ListConversationProfilesPagedResponse> listConversationProfilesSettings() {
        return this.listConversationProfilesSettings;
    }

    public UnaryCallSettings<GetConversationProfileRequest, ConversationProfile> getConversationProfileSettings() {
        return this.getConversationProfileSettings;
    }

    public UnaryCallSettings<CreateConversationProfileRequest, ConversationProfile> createConversationProfileSettings() {
        return this.createConversationProfileSettings;
    }

    public UnaryCallSettings<UpdateConversationProfileRequest, ConversationProfile> updateConversationProfileSettings() {
        return this.updateConversationProfileSettings;
    }

    public UnaryCallSettings<DeleteConversationProfileRequest, Empty> deleteConversationProfileSettings() {
        return this.deleteConversationProfileSettings;
    }

    public UnaryCallSettings<SetSuggestionFeatureConfigRequest, Operation> setSuggestionFeatureConfigSettings() {
        return this.setSuggestionFeatureConfigSettings;
    }

    public OperationCallSettings<SetSuggestionFeatureConfigRequest, ConversationProfile, SetSuggestionFeatureConfigOperationMetadata> setSuggestionFeatureConfigOperationSettings() {
        return this.setSuggestionFeatureConfigOperationSettings;
    }

    public UnaryCallSettings<ClearSuggestionFeatureConfigRequest, Operation> clearSuggestionFeatureConfigSettings() {
        return this.clearSuggestionFeatureConfigSettings;
    }

    public OperationCallSettings<ClearSuggestionFeatureConfigRequest, ConversationProfile, ClearSuggestionFeatureConfigOperationMetadata> clearSuggestionFeatureConfigOperationSettings() {
        return this.clearSuggestionFeatureConfigOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ConversationProfilesClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public ConversationProfilesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcConversationProfilesStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonConversationProfilesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dialogflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ConversationProfilesStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConversationProfilesStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConversationProfilesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ConversationProfilesStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ConversationProfilesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listConversationProfilesSettings = settingsBuilder.listConversationProfilesSettings().build();
        this.getConversationProfileSettings = settingsBuilder.getConversationProfileSettings().build();
        this.createConversationProfileSettings = settingsBuilder.createConversationProfileSettings().build();
        this.updateConversationProfileSettings = settingsBuilder.updateConversationProfileSettings().build();
        this.deleteConversationProfileSettings = settingsBuilder.deleteConversationProfileSettings().build();
        this.setSuggestionFeatureConfigSettings = settingsBuilder.setSuggestionFeatureConfigSettings().build();
        this.setSuggestionFeatureConfigOperationSettings = settingsBuilder.setSuggestionFeatureConfigOperationSettings().build();
        this.clearSuggestionFeatureConfigSettings = settingsBuilder.clearSuggestionFeatureConfigSettings().build();
        this.clearSuggestionFeatureConfigOperationSettings = settingsBuilder.clearSuggestionFeatureConfigOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ConversationProfilesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListConversationProfilesRequest, ListConversationProfilesResponse, ConversationProfilesClient.ListConversationProfilesPagedResponse> listConversationProfilesSettings;
        private final UnaryCallSettings.Builder<GetConversationProfileRequest, ConversationProfile> getConversationProfileSettings;
        private final UnaryCallSettings.Builder<CreateConversationProfileRequest, ConversationProfile> createConversationProfileSettings;
        private final UnaryCallSettings.Builder<UpdateConversationProfileRequest, ConversationProfile> updateConversationProfileSettings;
        private final UnaryCallSettings.Builder<DeleteConversationProfileRequest, Empty> deleteConversationProfileSettings;
        private final UnaryCallSettings.Builder<SetSuggestionFeatureConfigRequest, Operation> setSuggestionFeatureConfigSettings;
        private final OperationCallSettings.Builder<SetSuggestionFeatureConfigRequest, ConversationProfile, SetSuggestionFeatureConfigOperationMetadata> setSuggestionFeatureConfigOperationSettings;
        private final UnaryCallSettings.Builder<ClearSuggestionFeatureConfigRequest, Operation> clearSuggestionFeatureConfigSettings;
        private final OperationCallSettings.Builder<ClearSuggestionFeatureConfigRequest, ConversationProfile, ClearSuggestionFeatureConfigOperationMetadata> clearSuggestionFeatureConfigOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ConversationProfilesClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listConversationProfilesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONVERSATION_PROFILES_PAGE_STR_FACT);
            this.getConversationProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConversationProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateConversationProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteConversationProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSuggestionFeatureConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSuggestionFeatureConfigOperationSettings = OperationCallSettings.newBuilder();
            this.clearSuggestionFeatureConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.clearSuggestionFeatureConfigOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listConversationProfilesSettings, this.getConversationProfileSettings, this.createConversationProfileSettings, this.updateConversationProfileSettings, this.deleteConversationProfileSettings, this.setSuggestionFeatureConfigSettings, this.clearSuggestionFeatureConfigSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ConversationProfilesStubSettings settings) {
            super((StubSettings)settings);
            this.listConversationProfilesSettings = settings.listConversationProfilesSettings.toBuilder();
            this.getConversationProfileSettings = settings.getConversationProfileSettings.toBuilder();
            this.createConversationProfileSettings = settings.createConversationProfileSettings.toBuilder();
            this.updateConversationProfileSettings = settings.updateConversationProfileSettings.toBuilder();
            this.deleteConversationProfileSettings = settings.deleteConversationProfileSettings.toBuilder();
            this.setSuggestionFeatureConfigSettings = settings.setSuggestionFeatureConfigSettings.toBuilder();
            this.setSuggestionFeatureConfigOperationSettings = settings.setSuggestionFeatureConfigOperationSettings.toBuilder();
            this.clearSuggestionFeatureConfigSettings = settings.clearSuggestionFeatureConfigSettings.toBuilder();
            this.clearSuggestionFeatureConfigOperationSettings = settings.clearSuggestionFeatureConfigOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listConversationProfilesSettings, this.getConversationProfileSettings, this.createConversationProfileSettings, this.updateConversationProfileSettings, this.deleteConversationProfileSettings, this.setSuggestionFeatureConfigSettings, this.clearSuggestionFeatureConfigSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ConversationProfilesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ConversationProfilesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConversationProfilesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ConversationProfilesStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ConversationProfilesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ConversationProfilesStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ConversationProfilesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConversationProfilesStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ConversationProfilesStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ConversationProfilesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listConversationProfilesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getConversationProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createConversationProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateConversationProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteConversationProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setSuggestionFeatureConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.clearSuggestionFeatureConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setSuggestionFeatureConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ConversationProfile.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(SetSuggestionFeatureConfigOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.clearSuggestionFeatureConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ConversationProfile.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ClearSuggestionFeatureConfigOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListConversationProfilesRequest, ListConversationProfilesResponse, ConversationProfilesClient.ListConversationProfilesPagedResponse> listConversationProfilesSettings() {
            return this.listConversationProfilesSettings;
        }

        public UnaryCallSettings.Builder<GetConversationProfileRequest, ConversationProfile> getConversationProfileSettings() {
            return this.getConversationProfileSettings;
        }

        public UnaryCallSettings.Builder<CreateConversationProfileRequest, ConversationProfile> createConversationProfileSettings() {
            return this.createConversationProfileSettings;
        }

        public UnaryCallSettings.Builder<UpdateConversationProfileRequest, ConversationProfile> updateConversationProfileSettings() {
            return this.updateConversationProfileSettings;
        }

        public UnaryCallSettings.Builder<DeleteConversationProfileRequest, Empty> deleteConversationProfileSettings() {
            return this.deleteConversationProfileSettings;
        }

        public UnaryCallSettings.Builder<SetSuggestionFeatureConfigRequest, Operation> setSuggestionFeatureConfigSettings() {
            return this.setSuggestionFeatureConfigSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetSuggestionFeatureConfigRequest, ConversationProfile, SetSuggestionFeatureConfigOperationMetadata> setSuggestionFeatureConfigOperationSettings() {
            return this.setSuggestionFeatureConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<ClearSuggestionFeatureConfigRequest, Operation> clearSuggestionFeatureConfigSettings() {
            return this.clearSuggestionFeatureConfigSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ClearSuggestionFeatureConfigRequest, ConversationProfile, ClearSuggestionFeatureConfigOperationMetadata> clearSuggestionFeatureConfigOperationSettings() {
            return this.clearSuggestionFeatureConfigOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ConversationProfilesClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public ConversationProfilesStubSettings build() throws IOException {
            return new ConversationProfilesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

