/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.CreateSessionEntityTypeRequest;
import com.google.cloud.dialogflow.v2.DeleteSessionEntityTypeRequest;
import com.google.cloud.dialogflow.v2.GetSessionEntityTypeRequest;
import com.google.cloud.dialogflow.v2.ListSessionEntityTypesRequest;
import com.google.cloud.dialogflow.v2.ListSessionEntityTypesResponse;
import com.google.cloud.dialogflow.v2.SessionEntityType;
import com.google.cloud.dialogflow.v2.SessionEntityTypesClient;
import com.google.cloud.dialogflow.v2.UpdateSessionEntityTypeRequest;
import com.google.cloud.dialogflow.v2.stub.GrpcSessionEntityTypesStub;
import com.google.cloud.dialogflow.v2.stub.SessionEntityTypesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class SessionEntityTypesStubSettings
extends StubSettings<SessionEntityTypesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final UnaryCallSettings<DeleteSessionEntityTypeRequest, Empty> deleteSessionEntityTypeSettings;
    private final PagedCallSettings<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityTypesClient.ListSessionEntityTypesPagedResponse> listSessionEntityTypesSettings;
    private final UnaryCallSettings<GetSessionEntityTypeRequest, SessionEntityType> getSessionEntityTypeSettings;
    private final UnaryCallSettings<CreateSessionEntityTypeRequest, SessionEntityType> createSessionEntityTypeSettings;
    private final UnaryCallSettings<UpdateSessionEntityTypeRequest, SessionEntityType> updateSessionEntityTypeSettings;
    private static final PagedListDescriptor<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityType> LIST_SESSION_ENTITY_TYPES_PAGE_STR_DESC = new PagedListDescriptor<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityType>(){

        public String emptyToken() {
            return "";
        }

        public ListSessionEntityTypesRequest injectToken(ListSessionEntityTypesRequest payload, String token) {
            return ListSessionEntityTypesRequest.newBuilder((ListSessionEntityTypesRequest)payload).setPageToken(token).build();
        }

        public ListSessionEntityTypesRequest injectPageSize(ListSessionEntityTypesRequest payload, int pageSize) {
            return ListSessionEntityTypesRequest.newBuilder((ListSessionEntityTypesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSessionEntityTypesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSessionEntityTypesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SessionEntityType> extractResources(ListSessionEntityTypesResponse payload) {
            return payload.getSessionEntityTypesList() != null ? payload.getSessionEntityTypesList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityTypesClient.ListSessionEntityTypesPagedResponse> LIST_SESSION_ENTITY_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityTypesClient.ListSessionEntityTypesPagedResponse>(){

        public ApiFuture<SessionEntityTypesClient.ListSessionEntityTypesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse> callable, ListSessionEntityTypesRequest request, ApiCallContext context, ApiFuture<ListSessionEntityTypesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SESSION_ENTITY_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SessionEntityTypesClient.ListSessionEntityTypesPagedResponse.createAsync((PageContext<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityType>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteSessionEntityTypeRequest, Empty> deleteSessionEntityTypeSettings() {
        return this.deleteSessionEntityTypeSettings;
    }

    public PagedCallSettings<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityTypesClient.ListSessionEntityTypesPagedResponse> listSessionEntityTypesSettings() {
        return this.listSessionEntityTypesSettings;
    }

    public UnaryCallSettings<GetSessionEntityTypeRequest, SessionEntityType> getSessionEntityTypeSettings() {
        return this.getSessionEntityTypeSettings;
    }

    public UnaryCallSettings<CreateSessionEntityTypeRequest, SessionEntityType> createSessionEntityTypeSettings() {
        return this.createSessionEntityTypeSettings;
    }

    public UnaryCallSettings<UpdateSessionEntityTypeRequest, SessionEntityType> updateSessionEntityTypeSettings() {
        return this.updateSessionEntityTypeSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SessionEntityTypesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSessionEntityTypesStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SessionEntityTypesStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SessionEntityTypesStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SessionEntityTypesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteSessionEntityTypeSettings = settingsBuilder.deleteSessionEntityTypeSettings().build();
        this.listSessionEntityTypesSettings = settingsBuilder.listSessionEntityTypesSettings().build();
        this.getSessionEntityTypeSettings = settingsBuilder.getSessionEntityTypeSettings().build();
        this.createSessionEntityTypeSettings = settingsBuilder.createSessionEntityTypeSettings().build();
        this.updateSessionEntityTypeSettings = settingsBuilder.updateSessionEntityTypeSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SessionEntityTypesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteSessionEntityTypeRequest, Empty> deleteSessionEntityTypeSettings;
        private final PagedCallSettings.Builder<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityTypesClient.ListSessionEntityTypesPagedResponse> listSessionEntityTypesSettings;
        private final UnaryCallSettings.Builder<GetSessionEntityTypeRequest, SessionEntityType> getSessionEntityTypeSettings;
        private final UnaryCallSettings.Builder<CreateSessionEntityTypeRequest, SessionEntityType> createSessionEntityTypeSettings;
        private final UnaryCallSettings.Builder<UpdateSessionEntityTypeRequest, SessionEntityType> updateSessionEntityTypeSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteSessionEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSessionEntityTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SESSION_ENTITY_TYPES_PAGE_STR_FACT);
            this.getSessionEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSessionEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSessionEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSessionEntityTypeSettings, this.listSessionEntityTypesSettings, this.getSessionEntityTypeSettings, this.createSessionEntityTypeSettings, this.updateSessionEntityTypeSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SessionEntityTypesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SessionEntityTypesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SessionEntityTypesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SessionEntityTypesStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteSessionEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listSessionEntityTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSessionEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createSessionEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateSessionEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(SessionEntityTypesStubSettings settings) {
            super((StubSettings)settings);
            this.deleteSessionEntityTypeSettings = settings.deleteSessionEntityTypeSettings.toBuilder();
            this.listSessionEntityTypesSettings = settings.listSessionEntityTypesSettings.toBuilder();
            this.getSessionEntityTypeSettings = settings.getSessionEntityTypeSettings.toBuilder();
            this.createSessionEntityTypeSettings = settings.createSessionEntityTypeSettings.toBuilder();
            this.updateSessionEntityTypeSettings = settings.updateSessionEntityTypeSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSessionEntityTypeSettings, this.listSessionEntityTypesSettings, this.getSessionEntityTypeSettings, this.createSessionEntityTypeSettings, this.updateSessionEntityTypeSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteSessionEntityTypeRequest, Empty> deleteSessionEntityTypeSettings() {
            return this.deleteSessionEntityTypeSettings;
        }

        public PagedCallSettings.Builder<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse, SessionEntityTypesClient.ListSessionEntityTypesPagedResponse> listSessionEntityTypesSettings() {
            return this.listSessionEntityTypesSettings;
        }

        public UnaryCallSettings.Builder<GetSessionEntityTypeRequest, SessionEntityType> getSessionEntityTypeSettings() {
            return this.getSessionEntityTypeSettings;
        }

        public UnaryCallSettings.Builder<CreateSessionEntityTypeRequest, SessionEntityType> createSessionEntityTypeSettings() {
            return this.createSessionEntityTypeSettings;
        }

        public UnaryCallSettings.Builder<UpdateSessionEntityTypeRequest, SessionEntityType> updateSessionEntityTypeSettings() {
            return this.updateSessionEntityTypeSettings;
        }

        public SessionEntityTypesStubSettings build() throws IOException {
            return new SessionEntityTypesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

