/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.BatchDeleteIntentsRequest;
import com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest;
import com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsResponse;
import com.google.cloud.dialogflow.v2beta1.CreateIntentRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteIntentRequest;
import com.google.cloud.dialogflow.v2beta1.GetIntentRequest;
import com.google.cloud.dialogflow.v2beta1.Intent;
import com.google.cloud.dialogflow.v2beta1.IntentsClient;
import com.google.cloud.dialogflow.v2beta1.ListIntentsRequest;
import com.google.cloud.dialogflow.v2beta1.ListIntentsResponse;
import com.google.cloud.dialogflow.v2beta1.UpdateIntentRequest;
import com.google.cloud.dialogflow.v2beta1.stub.GrpcIntentsStub;
import com.google.cloud.dialogflow.v2beta1.stub.IntentsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class IntentsStubSettings
extends StubSettings<IntentsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final PagedCallSettings<ListIntentsRequest, ListIntentsResponse, IntentsClient.ListIntentsPagedResponse> listIntentsSettings;
    private final UnaryCallSettings<GetIntentRequest, Intent> getIntentSettings;
    private final UnaryCallSettings<CreateIntentRequest, Intent> createIntentSettings;
    private final UnaryCallSettings<UpdateIntentRequest, Intent> updateIntentSettings;
    private final UnaryCallSettings<DeleteIntentRequest, Empty> deleteIntentSettings;
    private final UnaryCallSettings<BatchUpdateIntentsRequest, Operation> batchUpdateIntentsSettings;
    private final OperationCallSettings<BatchUpdateIntentsRequest, BatchUpdateIntentsResponse, Struct> batchUpdateIntentsOperationSettings;
    private final UnaryCallSettings<BatchDeleteIntentsRequest, Operation> batchDeleteIntentsSettings;
    private final OperationCallSettings<BatchDeleteIntentsRequest, Empty, Struct> batchDeleteIntentsOperationSettings;
    private static final PagedListDescriptor<ListIntentsRequest, ListIntentsResponse, Intent> LIST_INTENTS_PAGE_STR_DESC = new PagedListDescriptor<ListIntentsRequest, ListIntentsResponse, Intent>(){

        public String emptyToken() {
            return "";
        }

        public ListIntentsRequest injectToken(ListIntentsRequest payload, String token) {
            return ListIntentsRequest.newBuilder((ListIntentsRequest)payload).setPageToken(token).build();
        }

        public ListIntentsRequest injectPageSize(ListIntentsRequest payload, int pageSize) {
            return ListIntentsRequest.newBuilder((ListIntentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListIntentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListIntentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Intent> extractResources(ListIntentsResponse payload) {
            return payload.getIntentsList() != null ? payload.getIntentsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListIntentsRequest, ListIntentsResponse, IntentsClient.ListIntentsPagedResponse> LIST_INTENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListIntentsRequest, ListIntentsResponse, IntentsClient.ListIntentsPagedResponse>(){

        public ApiFuture<IntentsClient.ListIntentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListIntentsRequest, ListIntentsResponse> callable, ListIntentsRequest request, ApiCallContext context, ApiFuture<ListIntentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INTENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return IntentsClient.ListIntentsPagedResponse.createAsync((PageContext<ListIntentsRequest, ListIntentsResponse, Intent>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListIntentsRequest, ListIntentsResponse, IntentsClient.ListIntentsPagedResponse> listIntentsSettings() {
        return this.listIntentsSettings;
    }

    public UnaryCallSettings<GetIntentRequest, Intent> getIntentSettings() {
        return this.getIntentSettings;
    }

    public UnaryCallSettings<CreateIntentRequest, Intent> createIntentSettings() {
        return this.createIntentSettings;
    }

    public UnaryCallSettings<UpdateIntentRequest, Intent> updateIntentSettings() {
        return this.updateIntentSettings;
    }

    public UnaryCallSettings<DeleteIntentRequest, Empty> deleteIntentSettings() {
        return this.deleteIntentSettings;
    }

    public UnaryCallSettings<BatchUpdateIntentsRequest, Operation> batchUpdateIntentsSettings() {
        return this.batchUpdateIntentsSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<BatchUpdateIntentsRequest, BatchUpdateIntentsResponse, Struct> batchUpdateIntentsOperationSettings() {
        return this.batchUpdateIntentsOperationSettings;
    }

    public UnaryCallSettings<BatchDeleteIntentsRequest, Operation> batchDeleteIntentsSettings() {
        return this.batchDeleteIntentsSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<BatchDeleteIntentsRequest, Empty, Struct> batchDeleteIntentsOperationSettings() {
        return this.batchDeleteIntentsOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public IntentsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcIntentsStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return IntentsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IntentsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected IntentsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listIntentsSettings = settingsBuilder.listIntentsSettings().build();
        this.getIntentSettings = settingsBuilder.getIntentSettings().build();
        this.createIntentSettings = settingsBuilder.createIntentSettings().build();
        this.updateIntentSettings = settingsBuilder.updateIntentSettings().build();
        this.deleteIntentSettings = settingsBuilder.deleteIntentSettings().build();
        this.batchUpdateIntentsSettings = settingsBuilder.batchUpdateIntentsSettings().build();
        this.batchUpdateIntentsOperationSettings = settingsBuilder.batchUpdateIntentsOperationSettings().build();
        this.batchDeleteIntentsSettings = settingsBuilder.batchDeleteIntentsSettings().build();
        this.batchDeleteIntentsOperationSettings = settingsBuilder.batchDeleteIntentsOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<IntentsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListIntentsRequest, ListIntentsResponse, IntentsClient.ListIntentsPagedResponse> listIntentsSettings;
        private final UnaryCallSettings.Builder<GetIntentRequest, Intent> getIntentSettings;
        private final UnaryCallSettings.Builder<CreateIntentRequest, Intent> createIntentSettings;
        private final UnaryCallSettings.Builder<UpdateIntentRequest, Intent> updateIntentSettings;
        private final UnaryCallSettings.Builder<DeleteIntentRequest, Empty> deleteIntentSettings;
        private final UnaryCallSettings.Builder<BatchUpdateIntentsRequest, Operation> batchUpdateIntentsSettings;
        private final OperationCallSettings.Builder<BatchUpdateIntentsRequest, BatchUpdateIntentsResponse, Struct> batchUpdateIntentsOperationSettings;
        private final UnaryCallSettings.Builder<BatchDeleteIntentsRequest, Operation> batchDeleteIntentsSettings;
        private final OperationCallSettings.Builder<BatchDeleteIntentsRequest, Empty, Struct> batchDeleteIntentsOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listIntentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INTENTS_PAGE_STR_FACT);
            this.getIntentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createIntentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateIntentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteIntentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchUpdateIntentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchUpdateIntentsOperationSettings = OperationCallSettings.newBuilder();
            this.batchDeleteIntentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchDeleteIntentsOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listIntentsSettings, this.getIntentSettings, this.createIntentSettings, this.updateIntentSettings, this.deleteIntentSettings, this.batchUpdateIntentsSettings, this.batchDeleteIntentsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(IntentsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)IntentsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IntentsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(IntentsStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listIntentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getIntentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createIntentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateIntentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteIntentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.batchUpdateIntentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.batchDeleteIntentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.batchUpdateIntentsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchUpdateIntentsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.batchDeleteIntentsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        protected Builder(IntentsStubSettings settings) {
            super((StubSettings)settings);
            this.listIntentsSettings = settings.listIntentsSettings.toBuilder();
            this.getIntentSettings = settings.getIntentSettings.toBuilder();
            this.createIntentSettings = settings.createIntentSettings.toBuilder();
            this.updateIntentSettings = settings.updateIntentSettings.toBuilder();
            this.deleteIntentSettings = settings.deleteIntentSettings.toBuilder();
            this.batchUpdateIntentsSettings = settings.batchUpdateIntentsSettings.toBuilder();
            this.batchUpdateIntentsOperationSettings = settings.batchUpdateIntentsOperationSettings.toBuilder();
            this.batchDeleteIntentsSettings = settings.batchDeleteIntentsSettings.toBuilder();
            this.batchDeleteIntentsOperationSettings = settings.batchDeleteIntentsOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listIntentsSettings, this.getIntentSettings, this.createIntentSettings, this.updateIntentSettings, this.deleteIntentSettings, this.batchUpdateIntentsSettings, this.batchDeleteIntentsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListIntentsRequest, ListIntentsResponse, IntentsClient.ListIntentsPagedResponse> listIntentsSettings() {
            return this.listIntentsSettings;
        }

        public UnaryCallSettings.Builder<GetIntentRequest, Intent> getIntentSettings() {
            return this.getIntentSettings;
        }

        public UnaryCallSettings.Builder<CreateIntentRequest, Intent> createIntentSettings() {
            return this.createIntentSettings;
        }

        public UnaryCallSettings.Builder<UpdateIntentRequest, Intent> updateIntentSettings() {
            return this.updateIntentSettings;
        }

        public UnaryCallSettings.Builder<DeleteIntentRequest, Empty> deleteIntentSettings() {
            return this.deleteIntentSettings;
        }

        public UnaryCallSettings.Builder<BatchUpdateIntentsRequest, Operation> batchUpdateIntentsSettings() {
            return this.batchUpdateIntentsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchUpdateIntentsRequest, BatchUpdateIntentsResponse, Struct> batchUpdateIntentsOperationSettings() {
            return this.batchUpdateIntentsOperationSettings;
        }

        public UnaryCallSettings.Builder<BatchDeleteIntentsRequest, Operation> batchDeleteIntentsSettings() {
            return this.batchDeleteIntentsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchDeleteIntentsRequest, Empty, Struct> batchDeleteIntentsOperationSettings() {
            return this.batchDeleteIntentsOperationSettings;
        }

        public IntentsStubSettings build() throws IOException {
            return new IntentsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

