/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.CreateKnowledgeBaseRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteKnowledgeBaseRequest;
import com.google.cloud.dialogflow.v2beta1.GetKnowledgeBaseRequest;
import com.google.cloud.dialogflow.v2beta1.KnowledgeBase;
import com.google.cloud.dialogflow.v2beta1.KnowledgeBaseName;
import com.google.cloud.dialogflow.v2beta1.KnowledgeBasesSettings;
import com.google.cloud.dialogflow.v2beta1.ListKnowledgeBasesRequest;
import com.google.cloud.dialogflow.v2beta1.ListKnowledgeBasesResponse;
import com.google.cloud.dialogflow.v2beta1.ProjectName;
import com.google.cloud.dialogflow.v2beta1.UpdateKnowledgeBaseRequest;
import com.google.cloud.dialogflow.v2beta1.stub.KnowledgeBasesStub;
import com.google.cloud.dialogflow.v2beta1.stub.KnowledgeBasesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class KnowledgeBasesClient
implements BackgroundResource {
    private final KnowledgeBasesSettings settings;
    private final KnowledgeBasesStub stub;

    public static final KnowledgeBasesClient create() throws IOException {
        return KnowledgeBasesClient.create(KnowledgeBasesSettings.newBuilder().build());
    }

    public static final KnowledgeBasesClient create(KnowledgeBasesSettings settings) throws IOException {
        return new KnowledgeBasesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final KnowledgeBasesClient create(KnowledgeBasesStub stub) {
        return new KnowledgeBasesClient(stub);
    }

    protected KnowledgeBasesClient(KnowledgeBasesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((KnowledgeBasesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected KnowledgeBasesClient(KnowledgeBasesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final KnowledgeBasesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public KnowledgeBasesStub getStub() {
        return this.stub;
    }

    public final ListKnowledgeBasesPagedResponse listKnowledgeBases(ProjectName parent) {
        ListKnowledgeBasesRequest request = ListKnowledgeBasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listKnowledgeBases(request);
    }

    public final ListKnowledgeBasesPagedResponse listKnowledgeBases(String parent) {
        ListKnowledgeBasesRequest request = ListKnowledgeBasesRequest.newBuilder().setParent(parent).build();
        return this.listKnowledgeBases(request);
    }

    public final ListKnowledgeBasesPagedResponse listKnowledgeBases(ListKnowledgeBasesRequest request) {
        return (ListKnowledgeBasesPagedResponse)((Object)this.listKnowledgeBasesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListKnowledgeBasesRequest, ListKnowledgeBasesPagedResponse> listKnowledgeBasesPagedCallable() {
        return this.stub.listKnowledgeBasesPagedCallable();
    }

    public final UnaryCallable<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse> listKnowledgeBasesCallable() {
        return this.stub.listKnowledgeBasesCallable();
    }

    public final KnowledgeBase getKnowledgeBase(KnowledgeBaseName name) {
        GetKnowledgeBaseRequest request = GetKnowledgeBaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getKnowledgeBase(request);
    }

    public final KnowledgeBase getKnowledgeBase(String name) {
        GetKnowledgeBaseRequest request = GetKnowledgeBaseRequest.newBuilder().setName(name).build();
        return this.getKnowledgeBase(request);
    }

    public final KnowledgeBase getKnowledgeBase(GetKnowledgeBaseRequest request) {
        return (KnowledgeBase)this.getKnowledgeBaseCallable().call((Object)request);
    }

    public final UnaryCallable<GetKnowledgeBaseRequest, KnowledgeBase> getKnowledgeBaseCallable() {
        return this.stub.getKnowledgeBaseCallable();
    }

    public final KnowledgeBase createKnowledgeBase(ProjectName parent, KnowledgeBase knowledgeBase) {
        CreateKnowledgeBaseRequest request = CreateKnowledgeBaseRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setKnowledgeBase(knowledgeBase).build();
        return this.createKnowledgeBase(request);
    }

    public final KnowledgeBase createKnowledgeBase(String parent, KnowledgeBase knowledgeBase) {
        CreateKnowledgeBaseRequest request = CreateKnowledgeBaseRequest.newBuilder().setParent(parent).setKnowledgeBase(knowledgeBase).build();
        return this.createKnowledgeBase(request);
    }

    public final KnowledgeBase createKnowledgeBase(CreateKnowledgeBaseRequest request) {
        return (KnowledgeBase)this.createKnowledgeBaseCallable().call((Object)request);
    }

    public final UnaryCallable<CreateKnowledgeBaseRequest, KnowledgeBase> createKnowledgeBaseCallable() {
        return this.stub.createKnowledgeBaseCallable();
    }

    public final void deleteKnowledgeBase(KnowledgeBaseName name) {
        DeleteKnowledgeBaseRequest request = DeleteKnowledgeBaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteKnowledgeBase(request);
    }

    public final void deleteKnowledgeBase(String name) {
        DeleteKnowledgeBaseRequest request = DeleteKnowledgeBaseRequest.newBuilder().setName(name).build();
        this.deleteKnowledgeBase(request);
    }

    public final void deleteKnowledgeBase(DeleteKnowledgeBaseRequest request) {
        this.deleteKnowledgeBaseCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteKnowledgeBaseRequest, Empty> deleteKnowledgeBaseCallable() {
        return this.stub.deleteKnowledgeBaseCallable();
    }

    public final KnowledgeBase updateKnowledgeBase(UpdateKnowledgeBaseRequest request) {
        return (KnowledgeBase)this.updateKnowledgeBaseCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateKnowledgeBaseRequest, KnowledgeBase> updateKnowledgeBaseCallable() {
        return this.stub.updateKnowledgeBaseCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListKnowledgeBasesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBase, ListKnowledgeBasesPage, ListKnowledgeBasesFixedSizeCollection> {
        private ListKnowledgeBasesFixedSizeCollection(List<ListKnowledgeBasesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListKnowledgeBasesFixedSizeCollection createEmptyCollection() {
            return new ListKnowledgeBasesFixedSizeCollection(null, 0);
        }

        protected ListKnowledgeBasesFixedSizeCollection createCollection(List<ListKnowledgeBasesPage> pages, int collectionSize) {
            return new ListKnowledgeBasesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListKnowledgeBasesPage
    extends AbstractPage<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBase, ListKnowledgeBasesPage> {
        private ListKnowledgeBasesPage(PageContext<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBase> context, ListKnowledgeBasesResponse response) {
            super(context, (Object)response);
        }

        private static ListKnowledgeBasesPage createEmptyPage() {
            return new ListKnowledgeBasesPage(null, null);
        }

        protected ListKnowledgeBasesPage createPage(PageContext<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBase> context, ListKnowledgeBasesResponse response) {
            return new ListKnowledgeBasesPage(context, response);
        }

        public ApiFuture<ListKnowledgeBasesPage> createPageAsync(PageContext<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBase> context, ApiFuture<ListKnowledgeBasesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListKnowledgeBasesPagedResponse
    extends AbstractPagedListResponse<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBase, ListKnowledgeBasesPage, ListKnowledgeBasesFixedSizeCollection> {
        public static ApiFuture<ListKnowledgeBasesPagedResponse> createAsync(PageContext<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBase> context, ApiFuture<ListKnowledgeBasesResponse> futureResponse) {
            ApiFuture<ListKnowledgeBasesPage> futurePage = ListKnowledgeBasesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListKnowledgeBasesPage, ListKnowledgeBasesPagedResponse>(){

                public ListKnowledgeBasesPagedResponse apply(ListKnowledgeBasesPage input) {
                    return new ListKnowledgeBasesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListKnowledgeBasesPagedResponse(ListKnowledgeBasesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListKnowledgeBasesFixedSizeCollection.createEmptyCollection());
        }
    }
}

