/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.CreateDocumentRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteDocumentRequest;
import com.google.cloud.dialogflow.v2beta1.Document;
import com.google.cloud.dialogflow.v2beta1.DocumentsClient;
import com.google.cloud.dialogflow.v2beta1.GetDocumentRequest;
import com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata;
import com.google.cloud.dialogflow.v2beta1.ListDocumentsRequest;
import com.google.cloud.dialogflow.v2beta1.ListDocumentsResponse;
import com.google.cloud.dialogflow.v2beta1.stub.DocumentsStub;
import com.google.cloud.dialogflow.v2beta1.stub.GrpcDocumentsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DocumentsStubSettings
extends StubSettings<DocumentsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListDocumentsRequest, ListDocumentsResponse, DocumentsClient.ListDocumentsPagedResponse> listDocumentsSettings;
    private final UnaryCallSettings<GetDocumentRequest, Document> getDocumentSettings;
    private final UnaryCallSettings<CreateDocumentRequest, Operation> createDocumentSettings;
    private final OperationCallSettings<CreateDocumentRequest, Document, KnowledgeOperationMetadata> createDocumentOperationSettings;
    private final UnaryCallSettings<DeleteDocumentRequest, Operation> deleteDocumentSettings;
    private final OperationCallSettings<DeleteDocumentRequest, Empty, KnowledgeOperationMetadata> deleteDocumentOperationSettings;
    private static final PagedListDescriptor<ListDocumentsRequest, ListDocumentsResponse, Document> LIST_DOCUMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListDocumentsRequest, ListDocumentsResponse, Document>(){

        public String emptyToken() {
            return "";
        }

        public ListDocumentsRequest injectToken(ListDocumentsRequest payload, String token) {
            return ListDocumentsRequest.newBuilder((ListDocumentsRequest)payload).setPageToken(token).build();
        }

        public ListDocumentsRequest injectPageSize(ListDocumentsRequest payload, int pageSize) {
            return ListDocumentsRequest.newBuilder((ListDocumentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDocumentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDocumentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Document> extractResources(ListDocumentsResponse payload) {
            return payload.getDocumentsList() != null ? payload.getDocumentsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListDocumentsRequest, ListDocumentsResponse, DocumentsClient.ListDocumentsPagedResponse> LIST_DOCUMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListDocumentsRequest, ListDocumentsResponse, DocumentsClient.ListDocumentsPagedResponse>(){

        public ApiFuture<DocumentsClient.ListDocumentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> callable, ListDocumentsRequest request, ApiCallContext context, ApiFuture<ListDocumentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DOCUMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DocumentsClient.ListDocumentsPagedResponse.createAsync((PageContext<ListDocumentsRequest, ListDocumentsResponse, Document>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListDocumentsRequest, ListDocumentsResponse, DocumentsClient.ListDocumentsPagedResponse> listDocumentsSettings() {
        return this.listDocumentsSettings;
    }

    public UnaryCallSettings<GetDocumentRequest, Document> getDocumentSettings() {
        return this.getDocumentSettings;
    }

    public UnaryCallSettings<CreateDocumentRequest, Operation> createDocumentSettings() {
        return this.createDocumentSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<CreateDocumentRequest, Document, KnowledgeOperationMetadata> createDocumentOperationSettings() {
        return this.createDocumentOperationSettings;
    }

    public UnaryCallSettings<DeleteDocumentRequest, Operation> deleteDocumentSettings() {
        return this.deleteDocumentSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<DeleteDocumentRequest, Empty, KnowledgeOperationMetadata> deleteDocumentOperationSettings() {
        return this.deleteDocumentOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DocumentsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDocumentsStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DocumentsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DocumentsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DocumentsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listDocumentsSettings = settingsBuilder.listDocumentsSettings().build();
        this.getDocumentSettings = settingsBuilder.getDocumentSettings().build();
        this.createDocumentSettings = settingsBuilder.createDocumentSettings().build();
        this.createDocumentOperationSettings = settingsBuilder.createDocumentOperationSettings().build();
        this.deleteDocumentSettings = settingsBuilder.deleteDocumentSettings().build();
        this.deleteDocumentOperationSettings = settingsBuilder.deleteDocumentOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DocumentsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListDocumentsRequest, ListDocumentsResponse, DocumentsClient.ListDocumentsPagedResponse> listDocumentsSettings;
        private final UnaryCallSettings.Builder<GetDocumentRequest, Document> getDocumentSettings;
        private final UnaryCallSettings.Builder<CreateDocumentRequest, Operation> createDocumentSettings;
        private final OperationCallSettings.Builder<CreateDocumentRequest, Document, KnowledgeOperationMetadata> createDocumentOperationSettings;
        private final UnaryCallSettings.Builder<DeleteDocumentRequest, Operation> deleteDocumentSettings;
        private final OperationCallSettings.Builder<DeleteDocumentRequest, Empty, KnowledgeOperationMetadata> deleteDocumentOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listDocumentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DOCUMENTS_PAGE_STR_FACT);
            this.getDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDocumentOperationSettings = OperationCallSettings.newBuilder();
            this.deleteDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDocumentOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDocumentsSettings, this.getDocumentSettings, this.createDocumentSettings, this.deleteDocumentSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DocumentsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DocumentsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DocumentsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DocumentsStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listDocumentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createDocumentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Document.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(KnowledgeOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteDocumentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(KnowledgeOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        protected Builder(DocumentsStubSettings settings) {
            super((StubSettings)settings);
            this.listDocumentsSettings = settings.listDocumentsSettings.toBuilder();
            this.getDocumentSettings = settings.getDocumentSettings.toBuilder();
            this.createDocumentSettings = settings.createDocumentSettings.toBuilder();
            this.createDocumentOperationSettings = settings.createDocumentOperationSettings.toBuilder();
            this.deleteDocumentSettings = settings.deleteDocumentSettings.toBuilder();
            this.deleteDocumentOperationSettings = settings.deleteDocumentOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDocumentsSettings, this.getDocumentSettings, this.createDocumentSettings, this.deleteDocumentSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListDocumentsRequest, ListDocumentsResponse, DocumentsClient.ListDocumentsPagedResponse> listDocumentsSettings() {
            return this.listDocumentsSettings;
        }

        public UnaryCallSettings.Builder<GetDocumentRequest, Document> getDocumentSettings() {
            return this.getDocumentSettings;
        }

        public UnaryCallSettings.Builder<CreateDocumentRequest, Operation> createDocumentSettings() {
            return this.createDocumentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateDocumentRequest, Document, KnowledgeOperationMetadata> createDocumentOperationSettings() {
            return this.createDocumentOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteDocumentRequest, Operation> deleteDocumentSettings() {
            return this.deleteDocumentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteDocumentRequest, Empty, KnowledgeOperationMetadata> deleteDocumentOperationSettings() {
            return this.deleteDocumentOperationSettings;
        }

        public DocumentsStubSettings build() throws IOException {
            return new DocumentsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

