/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.Agent;
import com.google.cloud.dialogflow.v2beta1.AgentsClient;
import com.google.cloud.dialogflow.v2beta1.ExportAgentRequest;
import com.google.cloud.dialogflow.v2beta1.ExportAgentResponse;
import com.google.cloud.dialogflow.v2beta1.GetAgentRequest;
import com.google.cloud.dialogflow.v2beta1.ImportAgentRequest;
import com.google.cloud.dialogflow.v2beta1.RestoreAgentRequest;
import com.google.cloud.dialogflow.v2beta1.SearchAgentsRequest;
import com.google.cloud.dialogflow.v2beta1.SearchAgentsResponse;
import com.google.cloud.dialogflow.v2beta1.TrainAgentRequest;
import com.google.cloud.dialogflow.v2beta1.stub.AgentsStub;
import com.google.cloud.dialogflow.v2beta1.stub.GrpcAgentsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class AgentsStubSettings
extends StubSettings<AgentsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetAgentRequest, Agent> getAgentSettings;
    private final PagedCallSettings<SearchAgentsRequest, SearchAgentsResponse, AgentsClient.SearchAgentsPagedResponse> searchAgentsSettings;
    private final UnaryCallSettings<TrainAgentRequest, Operation> trainAgentSettings;
    private final OperationCallSettings<TrainAgentRequest, Empty, Struct> trainAgentOperationSettings;
    private final UnaryCallSettings<ExportAgentRequest, Operation> exportAgentSettings;
    private final OperationCallSettings<ExportAgentRequest, ExportAgentResponse, Struct> exportAgentOperationSettings;
    private final UnaryCallSettings<ImportAgentRequest, Operation> importAgentSettings;
    private final OperationCallSettings<ImportAgentRequest, Empty, Struct> importAgentOperationSettings;
    private final UnaryCallSettings<RestoreAgentRequest, Operation> restoreAgentSettings;
    private final OperationCallSettings<RestoreAgentRequest, Empty, Struct> restoreAgentOperationSettings;
    private static final PagedListDescriptor<SearchAgentsRequest, SearchAgentsResponse, Agent> SEARCH_AGENTS_PAGE_STR_DESC = new PagedListDescriptor<SearchAgentsRequest, SearchAgentsResponse, Agent>(){

        public String emptyToken() {
            return "";
        }

        public SearchAgentsRequest injectToken(SearchAgentsRequest payload, String token) {
            return SearchAgentsRequest.newBuilder((SearchAgentsRequest)payload).setPageToken(token).build();
        }

        public SearchAgentsRequest injectPageSize(SearchAgentsRequest payload, int pageSize) {
            return SearchAgentsRequest.newBuilder((SearchAgentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchAgentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchAgentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Agent> extractResources(SearchAgentsResponse payload) {
            return payload.getAgentsList();
        }
    };
    private static final PagedListResponseFactory<SearchAgentsRequest, SearchAgentsResponse, AgentsClient.SearchAgentsPagedResponse> SEARCH_AGENTS_PAGE_STR_FACT = new PagedListResponseFactory<SearchAgentsRequest, SearchAgentsResponse, AgentsClient.SearchAgentsPagedResponse>(){

        public ApiFuture<AgentsClient.SearchAgentsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchAgentsRequest, SearchAgentsResponse> callable, SearchAgentsRequest request, ApiCallContext context, ApiFuture<SearchAgentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_AGENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AgentsClient.SearchAgentsPagedResponse.createAsync((PageContext<SearchAgentsRequest, SearchAgentsResponse, Agent>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetAgentRequest, Agent> getAgentSettings() {
        return this.getAgentSettings;
    }

    public PagedCallSettings<SearchAgentsRequest, SearchAgentsResponse, AgentsClient.SearchAgentsPagedResponse> searchAgentsSettings() {
        return this.searchAgentsSettings;
    }

    public UnaryCallSettings<TrainAgentRequest, Operation> trainAgentSettings() {
        return this.trainAgentSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<TrainAgentRequest, Empty, Struct> trainAgentOperationSettings() {
        return this.trainAgentOperationSettings;
    }

    public UnaryCallSettings<ExportAgentRequest, Operation> exportAgentSettings() {
        return this.exportAgentSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<ExportAgentRequest, ExportAgentResponse, Struct> exportAgentOperationSettings() {
        return this.exportAgentOperationSettings;
    }

    public UnaryCallSettings<ImportAgentRequest, Operation> importAgentSettings() {
        return this.importAgentSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<ImportAgentRequest, Empty, Struct> importAgentOperationSettings() {
        return this.importAgentOperationSettings;
    }

    public UnaryCallSettings<RestoreAgentRequest, Operation> restoreAgentSettings() {
        return this.restoreAgentSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<RestoreAgentRequest, Empty, Struct> restoreAgentOperationSettings() {
        return this.restoreAgentOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AgentsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAgentsStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AgentsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AgentsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AgentsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getAgentSettings = settingsBuilder.getAgentSettings().build();
        this.searchAgentsSettings = settingsBuilder.searchAgentsSettings().build();
        this.trainAgentSettings = settingsBuilder.trainAgentSettings().build();
        this.trainAgentOperationSettings = settingsBuilder.trainAgentOperationSettings().build();
        this.exportAgentSettings = settingsBuilder.exportAgentSettings().build();
        this.exportAgentOperationSettings = settingsBuilder.exportAgentOperationSettings().build();
        this.importAgentSettings = settingsBuilder.importAgentSettings().build();
        this.importAgentOperationSettings = settingsBuilder.importAgentOperationSettings().build();
        this.restoreAgentSettings = settingsBuilder.restoreAgentSettings().build();
        this.restoreAgentOperationSettings = settingsBuilder.restoreAgentOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AgentsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetAgentRequest, Agent> getAgentSettings;
        private final PagedCallSettings.Builder<SearchAgentsRequest, SearchAgentsResponse, AgentsClient.SearchAgentsPagedResponse> searchAgentsSettings;
        private final UnaryCallSettings.Builder<TrainAgentRequest, Operation> trainAgentSettings;
        private final OperationCallSettings.Builder<TrainAgentRequest, Empty, Struct> trainAgentOperationSettings;
        private final UnaryCallSettings.Builder<ExportAgentRequest, Operation> exportAgentSettings;
        private final OperationCallSettings.Builder<ExportAgentRequest, ExportAgentResponse, Struct> exportAgentOperationSettings;
        private final UnaryCallSettings.Builder<ImportAgentRequest, Operation> importAgentSettings;
        private final OperationCallSettings.Builder<ImportAgentRequest, Empty, Struct> importAgentOperationSettings;
        private final UnaryCallSettings.Builder<RestoreAgentRequest, Operation> restoreAgentSettings;
        private final OperationCallSettings.Builder<RestoreAgentRequest, Empty, Struct> restoreAgentOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getAgentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchAgentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_AGENTS_PAGE_STR_FACT);
            this.trainAgentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.trainAgentOperationSettings = OperationCallSettings.newBuilder();
            this.exportAgentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportAgentOperationSettings = OperationCallSettings.newBuilder();
            this.importAgentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importAgentOperationSettings = OperationCallSettings.newBuilder();
            this.restoreAgentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restoreAgentOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getAgentSettings, this.searchAgentsSettings, this.trainAgentSettings, this.exportAgentSettings, this.importAgentSettings, this.restoreAgentSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AgentsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AgentsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AgentsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AgentsStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getAgentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.searchAgentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.trainAgentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.exportAgentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.importAgentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.restoreAgentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.trainAgentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.exportAgentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportAgentResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.importAgentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.restoreAgentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        protected Builder(AgentsStubSettings settings) {
            super((StubSettings)settings);
            this.getAgentSettings = settings.getAgentSettings.toBuilder();
            this.searchAgentsSettings = settings.searchAgentsSettings.toBuilder();
            this.trainAgentSettings = settings.trainAgentSettings.toBuilder();
            this.trainAgentOperationSettings = settings.trainAgentOperationSettings.toBuilder();
            this.exportAgentSettings = settings.exportAgentSettings.toBuilder();
            this.exportAgentOperationSettings = settings.exportAgentOperationSettings.toBuilder();
            this.importAgentSettings = settings.importAgentSettings.toBuilder();
            this.importAgentOperationSettings = settings.importAgentOperationSettings.toBuilder();
            this.restoreAgentSettings = settings.restoreAgentSettings.toBuilder();
            this.restoreAgentOperationSettings = settings.restoreAgentOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getAgentSettings, this.searchAgentsSettings, this.trainAgentSettings, this.exportAgentSettings, this.importAgentSettings, this.restoreAgentSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetAgentRequest, Agent> getAgentSettings() {
            return this.getAgentSettings;
        }

        public PagedCallSettings.Builder<SearchAgentsRequest, SearchAgentsResponse, AgentsClient.SearchAgentsPagedResponse> searchAgentsSettings() {
            return this.searchAgentsSettings;
        }

        public UnaryCallSettings.Builder<TrainAgentRequest, Operation> trainAgentSettings() {
            return this.trainAgentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<TrainAgentRequest, Empty, Struct> trainAgentOperationSettings() {
            return this.trainAgentOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportAgentRequest, Operation> exportAgentSettings() {
            return this.exportAgentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ExportAgentRequest, ExportAgentResponse, Struct> exportAgentOperationSettings() {
            return this.exportAgentOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportAgentRequest, Operation> importAgentSettings() {
            return this.importAgentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ImportAgentRequest, Empty, Struct> importAgentOperationSettings() {
            return this.importAgentOperationSettings;
        }

        public UnaryCallSettings.Builder<RestoreAgentRequest, Operation> restoreAgentSettings() {
            return this.restoreAgentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RestoreAgentRequest, Empty, Struct> restoreAgentOperationSettings() {
            return this.restoreAgentOperationSettings;
        }

        public AgentsStubSettings build() throws IOException {
            return new AgentsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

