/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.BatchCreateEntitiesRequest;
import com.google.cloud.dialogflow.v2beta1.BatchDeleteEntitiesRequest;
import com.google.cloud.dialogflow.v2beta1.BatchDeleteEntityTypesRequest;
import com.google.cloud.dialogflow.v2beta1.BatchUpdateEntitiesRequest;
import com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest;
import com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesResponse;
import com.google.cloud.dialogflow.v2beta1.CreateEntityTypeRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteEntityTypeRequest;
import com.google.cloud.dialogflow.v2beta1.EntityType;
import com.google.cloud.dialogflow.v2beta1.EntityTypeName;
import com.google.cloud.dialogflow.v2beta1.EntityTypesSettings;
import com.google.cloud.dialogflow.v2beta1.GetEntityTypeRequest;
import com.google.cloud.dialogflow.v2beta1.ListEntityTypesRequest;
import com.google.cloud.dialogflow.v2beta1.ListEntityTypesResponse;
import com.google.cloud.dialogflow.v2beta1.PagedResponseWrappers;
import com.google.cloud.dialogflow.v2beta1.ProjectAgentName;
import com.google.cloud.dialogflow.v2beta1.UpdateEntityTypeRequest;
import com.google.cloud.dialogflow.v2beta1.stub.EntityTypesStub;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class EntityTypesClient
implements BackgroundResource {
    private final EntityTypesSettings settings;
    private final EntityTypesStub stub;
    private final OperationsClient operationsClient;

    public static final EntityTypesClient create() throws IOException {
        return EntityTypesClient.create(EntityTypesSettings.newBuilder().build());
    }

    public static final EntityTypesClient create(EntityTypesSettings settings) throws IOException {
        return new EntityTypesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final EntityTypesClient create(EntityTypesStub stub) {
        return new EntityTypesClient(stub);
    }

    protected EntityTypesClient(EntityTypesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected EntityTypesClient(EntityTypesStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final EntityTypesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public EntityTypesStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final PagedResponseWrappers.ListEntityTypesPagedResponse listEntityTypes(ProjectAgentName parent) {
        ListEntityTypesRequest request = ListEntityTypesRequest.newBuilder().setParent(parent.toString()).build();
        return this.listEntityTypes(request);
    }

    public final PagedResponseWrappers.ListEntityTypesPagedResponse listEntityTypes(ProjectAgentName parent, String languageCode) {
        ListEntityTypesRequest request = ListEntityTypesRequest.newBuilder().setParent(parent.toString()).setLanguageCode(languageCode).build();
        return this.listEntityTypes(request);
    }

    public final PagedResponseWrappers.ListEntityTypesPagedResponse listEntityTypes(ListEntityTypesRequest request) {
        return (PagedResponseWrappers.ListEntityTypesPagedResponse)((Object)this.listEntityTypesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEntityTypesRequest, PagedResponseWrappers.ListEntityTypesPagedResponse> listEntityTypesPagedCallable() {
        return this.stub.listEntityTypesPagedCallable();
    }

    public final UnaryCallable<ListEntityTypesRequest, ListEntityTypesResponse> listEntityTypesCallable() {
        return this.stub.listEntityTypesCallable();
    }

    public final EntityType getEntityType(EntityTypeName name) {
        GetEntityTypeRequest request = GetEntityTypeRequest.newBuilder().setName(name.toString()).build();
        return this.getEntityType(request);
    }

    public final EntityType getEntityType(EntityTypeName name, String languageCode) {
        GetEntityTypeRequest request = GetEntityTypeRequest.newBuilder().setName(name.toString()).setLanguageCode(languageCode).build();
        return this.getEntityType(request);
    }

    public final EntityType getEntityType(GetEntityTypeRequest request) {
        return (EntityType)this.getEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<GetEntityTypeRequest, EntityType> getEntityTypeCallable() {
        return this.stub.getEntityTypeCallable();
    }

    public final EntityType createEntityType(ProjectAgentName parent, EntityType entityType) {
        CreateEntityTypeRequest request = CreateEntityTypeRequest.newBuilder().setParent(parent.toString()).setEntityType(entityType).build();
        return this.createEntityType(request);
    }

    public final EntityType createEntityType(ProjectAgentName parent, EntityType entityType, String languageCode) {
        CreateEntityTypeRequest request = CreateEntityTypeRequest.newBuilder().setParent(parent.toString()).setEntityType(entityType).setLanguageCode(languageCode).build();
        return this.createEntityType(request);
    }

    public final EntityType createEntityType(CreateEntityTypeRequest request) {
        return (EntityType)this.createEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<CreateEntityTypeRequest, EntityType> createEntityTypeCallable() {
        return this.stub.createEntityTypeCallable();
    }

    public final EntityType updateEntityType(EntityType entityType) {
        UpdateEntityTypeRequest request = UpdateEntityTypeRequest.newBuilder().setEntityType(entityType).build();
        return this.updateEntityType(request);
    }

    public final EntityType updateEntityType(EntityType entityType, String languageCode) {
        UpdateEntityTypeRequest request = UpdateEntityTypeRequest.newBuilder().setEntityType(entityType).setLanguageCode(languageCode).build();
        return this.updateEntityType(request);
    }

    public final EntityType updateEntityType(UpdateEntityTypeRequest request) {
        return (EntityType)this.updateEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateEntityTypeRequest, EntityType> updateEntityTypeCallable() {
        return this.stub.updateEntityTypeCallable();
    }

    public final void deleteEntityType(EntityTypeName name) {
        DeleteEntityTypeRequest request = DeleteEntityTypeRequest.newBuilder().setName(name.toString()).build();
        this.deleteEntityType(request);
    }

    private final void deleteEntityType(DeleteEntityTypeRequest request) {
        this.deleteEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEntityTypeRequest, Empty> deleteEntityTypeCallable() {
        return this.stub.deleteEntityTypeCallable();
    }

    public final OperationFuture<BatchUpdateEntityTypesResponse, Struct> batchUpdateEntityTypesAsync(BatchUpdateEntityTypesRequest request) {
        return this.batchUpdateEntityTypesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchUpdateEntityTypesRequest, BatchUpdateEntityTypesResponse, Struct> batchUpdateEntityTypesOperationCallable() {
        return this.stub.batchUpdateEntityTypesOperationCallable();
    }

    public final UnaryCallable<BatchUpdateEntityTypesRequest, Operation> batchUpdateEntityTypesCallable() {
        return this.stub.batchUpdateEntityTypesCallable();
    }

    public final OperationFuture<Empty, Struct> batchDeleteEntityTypesAsync(ProjectAgentName parent, List<String> entityTypeNames) {
        BatchDeleteEntityTypesRequest request = BatchDeleteEntityTypesRequest.newBuilder().setParent(parent.toString()).addAllEntityTypeNames(entityTypeNames).build();
        return this.batchDeleteEntityTypesAsync(request);
    }

    public final OperationFuture<Empty, Struct> batchDeleteEntityTypesAsync(BatchDeleteEntityTypesRequest request) {
        return this.batchDeleteEntityTypesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchDeleteEntityTypesRequest, Empty, Struct> batchDeleteEntityTypesOperationCallable() {
        return this.stub.batchDeleteEntityTypesOperationCallable();
    }

    public final UnaryCallable<BatchDeleteEntityTypesRequest, Operation> batchDeleteEntityTypesCallable() {
        return this.stub.batchDeleteEntityTypesCallable();
    }

    public final OperationFuture<Empty, Struct> batchCreateEntitiesAsync(EntityTypeName parent, List<EntityType.Entity> entities) {
        BatchCreateEntitiesRequest request = BatchCreateEntitiesRequest.newBuilder().setParent(parent.toString()).addAllEntities(entities).build();
        return this.batchCreateEntitiesAsync(request);
    }

    public final OperationFuture<Empty, Struct> batchCreateEntitiesAsync(EntityTypeName parent, List<EntityType.Entity> entities, String languageCode) {
        BatchCreateEntitiesRequest request = BatchCreateEntitiesRequest.newBuilder().setParent(parent.toString()).addAllEntities(entities).setLanguageCode(languageCode).build();
        return this.batchCreateEntitiesAsync(request);
    }

    public final OperationFuture<Empty, Struct> batchCreateEntitiesAsync(BatchCreateEntitiesRequest request) {
        return this.batchCreateEntitiesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchCreateEntitiesRequest, Empty, Struct> batchCreateEntitiesOperationCallable() {
        return this.stub.batchCreateEntitiesOperationCallable();
    }

    public final UnaryCallable<BatchCreateEntitiesRequest, Operation> batchCreateEntitiesCallable() {
        return this.stub.batchCreateEntitiesCallable();
    }

    public final OperationFuture<Empty, Struct> batchUpdateEntitiesAsync(EntityTypeName parent, List<EntityType.Entity> entities) {
        BatchUpdateEntitiesRequest request = BatchUpdateEntitiesRequest.newBuilder().setParent(parent.toString()).addAllEntities(entities).build();
        return this.batchUpdateEntitiesAsync(request);
    }

    public final OperationFuture<Empty, Struct> batchUpdateEntitiesAsync(EntityTypeName parent, List<EntityType.Entity> entities, String languageCode) {
        BatchUpdateEntitiesRequest request = BatchUpdateEntitiesRequest.newBuilder().setParent(parent.toString()).addAllEntities(entities).setLanguageCode(languageCode).build();
        return this.batchUpdateEntitiesAsync(request);
    }

    public final OperationFuture<Empty, Struct> batchUpdateEntitiesAsync(BatchUpdateEntitiesRequest request) {
        return this.batchUpdateEntitiesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchUpdateEntitiesRequest, Empty, Struct> batchUpdateEntitiesOperationCallable() {
        return this.stub.batchUpdateEntitiesOperationCallable();
    }

    public final UnaryCallable<BatchUpdateEntitiesRequest, Operation> batchUpdateEntitiesCallable() {
        return this.stub.batchUpdateEntitiesCallable();
    }

    public final OperationFuture<Empty, Struct> batchDeleteEntitiesAsync(EntityTypeName parent, List<String> entityValues) {
        BatchDeleteEntitiesRequest request = BatchDeleteEntitiesRequest.newBuilder().setParent(parent.toString()).addAllEntityValues(entityValues).build();
        return this.batchDeleteEntitiesAsync(request);
    }

    public final OperationFuture<Empty, Struct> batchDeleteEntitiesAsync(EntityTypeName parent, List<String> entityValues, String languageCode) {
        BatchDeleteEntitiesRequest request = BatchDeleteEntitiesRequest.newBuilder().setParent(parent.toString()).addAllEntityValues(entityValues).setLanguageCode(languageCode).build();
        return this.batchDeleteEntitiesAsync(request);
    }

    public final OperationFuture<Empty, Struct> batchDeleteEntitiesAsync(BatchDeleteEntitiesRequest request) {
        return this.batchDeleteEntitiesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchDeleteEntitiesRequest, Empty, Struct> batchDeleteEntitiesOperationCallable() {
        return this.stub.batchDeleteEntitiesOperationCallable();
    }

    public final UnaryCallable<BatchDeleteEntitiesRequest, Operation> batchDeleteEntitiesCallable() {
        return this.stub.batchDeleteEntitiesCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

