/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.CreateTransitionRouteGroupRequest;
import com.google.cloud.dialogflow.cx.v3.DeleteTransitionRouteGroupRequest;
import com.google.cloud.dialogflow.cx.v3.GetTransitionRouteGroupRequest;
import com.google.cloud.dialogflow.cx.v3.ListTransitionRouteGroupsRequest;
import com.google.cloud.dialogflow.cx.v3.ListTransitionRouteGroupsResponse;
import com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup;
import com.google.cloud.dialogflow.cx.v3.TransitionRouteGroupsClient;
import com.google.cloud.dialogflow.cx.v3.UpdateTransitionRouteGroupRequest;
import com.google.cloud.dialogflow.cx.v3.stub.GrpcTransitionRouteGroupsStub;
import com.google.cloud.dialogflow.cx.v3.stub.TransitionRouteGroupsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class TransitionRouteGroupsStubSettings
extends StubSettings<TransitionRouteGroupsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final PagedCallSettings<ListTransitionRouteGroupsRequest, ListTransitionRouteGroupsResponse, TransitionRouteGroupsClient.ListTransitionRouteGroupsPagedResponse> listTransitionRouteGroupsSettings;
    private final UnaryCallSettings<GetTransitionRouteGroupRequest, TransitionRouteGroup> getTransitionRouteGroupSettings;
    private final UnaryCallSettings<CreateTransitionRouteGroupRequest, TransitionRouteGroup> createTransitionRouteGroupSettings;
    private final UnaryCallSettings<UpdateTransitionRouteGroupRequest, TransitionRouteGroup> updateTransitionRouteGroupSettings;
    private final UnaryCallSettings<DeleteTransitionRouteGroupRequest, Empty> deleteTransitionRouteGroupSettings;
    private static final PagedListDescriptor<ListTransitionRouteGroupsRequest, ListTransitionRouteGroupsResponse, TransitionRouteGroup> LIST_TRANSITION_ROUTE_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListTransitionRouteGroupsRequest, ListTransitionRouteGroupsResponse, TransitionRouteGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListTransitionRouteGroupsRequest injectToken(ListTransitionRouteGroupsRequest payload, String token) {
            return ListTransitionRouteGroupsRequest.newBuilder((ListTransitionRouteGroupsRequest)payload).setPageToken(token).build();
        }

        public ListTransitionRouteGroupsRequest injectPageSize(ListTransitionRouteGroupsRequest payload, int pageSize) {
            return ListTransitionRouteGroupsRequest.newBuilder((ListTransitionRouteGroupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTransitionRouteGroupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTransitionRouteGroupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TransitionRouteGroup> extractResources(ListTransitionRouteGroupsResponse payload) {
            return payload.getTransitionRouteGroupsList() == null ? ImmutableList.of() : payload.getTransitionRouteGroupsList();
        }
    };
    private static final PagedListResponseFactory<ListTransitionRouteGroupsRequest, ListTransitionRouteGroupsResponse, TransitionRouteGroupsClient.ListTransitionRouteGroupsPagedResponse> LIST_TRANSITION_ROUTE_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListTransitionRouteGroupsRequest, ListTransitionRouteGroupsResponse, TransitionRouteGroupsClient.ListTransitionRouteGroupsPagedResponse>(){

        public ApiFuture<TransitionRouteGroupsClient.ListTransitionRouteGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTransitionRouteGroupsRequest, ListTransitionRouteGroupsResponse> callable, ListTransitionRouteGroupsRequest request, ApiCallContext context, ApiFuture<ListTransitionRouteGroupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRANSITION_ROUTE_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TransitionRouteGroupsClient.ListTransitionRouteGroupsPagedResponse.createAsync((PageContext<ListTransitionRouteGroupsRequest, ListTransitionRouteGroupsResponse, TransitionRouteGroup>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListTransitionRouteGroupsRequest, ListTransitionRouteGroupsResponse, TransitionRouteGroupsClient.ListTransitionRouteGroupsPagedResponse> listTransitionRouteGroupsSettings() {
        return this.listTransitionRouteGroupsSettings;
    }

    public UnaryCallSettings<GetTransitionRouteGroupRequest, TransitionRouteGroup> getTransitionRouteGroupSettings() {
        return this.getTransitionRouteGroupSettings;
    }

    public UnaryCallSettings<CreateTransitionRouteGroupRequest, TransitionRouteGroup> createTransitionRouteGroupSettings() {
        return this.createTransitionRouteGroupSettings;
    }

    public UnaryCallSettings<UpdateTransitionRouteGroupRequest, TransitionRouteGroup> updateTransitionRouteGroupSettings() {
        return this.updateTransitionRouteGroupSettings;
    }

    public UnaryCallSettings<DeleteTransitionRouteGroupRequest, Empty> deleteTransitionRouteGroupSettings() {
        return this.deleteTransitionRouteGroupSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TransitionRouteGroupsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTransitionRouteGroupsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TransitionRouteGroupsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TransitionRouteGroupsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TransitionRouteGroupsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listTransitionRouteGroupsSettings = settingsBuilder.listTransitionRouteGroupsSettings().build();
        this.getTransitionRouteGroupSettings = settingsBuilder.getTransitionRouteGroupSettings().build();
        this.createTransitionRouteGroupSettings = settingsBuilder.createTransitionRouteGroupSettings().build();
        this.updateTransitionRouteGroupSettings = settingsBuilder.updateTransitionRouteGroupSettings().build();
        this.deleteTransitionRouteGroupSettings = settingsBuilder.deleteTransitionRouteGroupSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TransitionRouteGroupsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListTransitionRouteGroupsRequest, ListTransitionRouteGroupsResponse, TransitionRouteGroupsClient.ListTransitionRouteGroupsPagedResponse> listTransitionRouteGroupsSettings;
        private final UnaryCallSettings.Builder<GetTransitionRouteGroupRequest, TransitionRouteGroup> getTransitionRouteGroupSettings;
        private final UnaryCallSettings.Builder<CreateTransitionRouteGroupRequest, TransitionRouteGroup> createTransitionRouteGroupSettings;
        private final UnaryCallSettings.Builder<UpdateTransitionRouteGroupRequest, TransitionRouteGroup> updateTransitionRouteGroupSettings;
        private final UnaryCallSettings.Builder<DeleteTransitionRouteGroupRequest, Empty> deleteTransitionRouteGroupSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listTransitionRouteGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TRANSITION_ROUTE_GROUPS_PAGE_STR_FACT);
            this.getTransitionRouteGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTransitionRouteGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTransitionRouteGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTransitionRouteGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listTransitionRouteGroupsSettings, this.getTransitionRouteGroupSettings, this.createTransitionRouteGroupSettings, this.updateTransitionRouteGroupSettings, this.deleteTransitionRouteGroupSettings);
            Builder.initDefaults(this);
        }

        protected Builder(TransitionRouteGroupsStubSettings settings) {
            super((StubSettings)settings);
            this.listTransitionRouteGroupsSettings = settings.listTransitionRouteGroupsSettings.toBuilder();
            this.getTransitionRouteGroupSettings = settings.getTransitionRouteGroupSettings.toBuilder();
            this.createTransitionRouteGroupSettings = settings.createTransitionRouteGroupSettings.toBuilder();
            this.updateTransitionRouteGroupSettings = settings.updateTransitionRouteGroupSettings.toBuilder();
            this.deleteTransitionRouteGroupSettings = settings.deleteTransitionRouteGroupSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listTransitionRouteGroupsSettings, this.getTransitionRouteGroupSettings, this.createTransitionRouteGroupSettings, this.updateTransitionRouteGroupSettings, this.deleteTransitionRouteGroupSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TransitionRouteGroupsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TransitionRouteGroupsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TransitionRouteGroupsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TransitionRouteGroupsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(TransitionRouteGroupsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listTransitionRouteGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getTransitionRouteGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createTransitionRouteGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateTransitionRouteGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteTransitionRouteGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListTransitionRouteGroupsRequest, ListTransitionRouteGroupsResponse, TransitionRouteGroupsClient.ListTransitionRouteGroupsPagedResponse> listTransitionRouteGroupsSettings() {
            return this.listTransitionRouteGroupsSettings;
        }

        public UnaryCallSettings.Builder<GetTransitionRouteGroupRequest, TransitionRouteGroup> getTransitionRouteGroupSettings() {
            return this.getTransitionRouteGroupSettings;
        }

        public UnaryCallSettings.Builder<CreateTransitionRouteGroupRequest, TransitionRouteGroup> createTransitionRouteGroupSettings() {
            return this.createTransitionRouteGroupSettings;
        }

        public UnaryCallSettings.Builder<UpdateTransitionRouteGroupRequest, TransitionRouteGroup> updateTransitionRouteGroupSettings() {
            return this.updateTransitionRouteGroupSettings;
        }

        public UnaryCallSettings.Builder<DeleteTransitionRouteGroupRequest, Empty> deleteTransitionRouteGroupSettings() {
            return this.deleteTransitionRouteGroupSettings;
        }

        public TransitionRouteGroupsStubSettings build() throws IOException {
            return new TransitionRouteGroupsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

