/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.CreateFlowRequest;
import com.google.cloud.dialogflow.cx.v3.DeleteFlowRequest;
import com.google.cloud.dialogflow.cx.v3.ExportFlowRequest;
import com.google.cloud.dialogflow.cx.v3.ExportFlowResponse;
import com.google.cloud.dialogflow.cx.v3.Flow;
import com.google.cloud.dialogflow.cx.v3.FlowValidationResult;
import com.google.cloud.dialogflow.cx.v3.FlowsClient;
import com.google.cloud.dialogflow.cx.v3.GetFlowRequest;
import com.google.cloud.dialogflow.cx.v3.GetFlowValidationResultRequest;
import com.google.cloud.dialogflow.cx.v3.ImportFlowRequest;
import com.google.cloud.dialogflow.cx.v3.ImportFlowResponse;
import com.google.cloud.dialogflow.cx.v3.ListFlowsRequest;
import com.google.cloud.dialogflow.cx.v3.ListFlowsResponse;
import com.google.cloud.dialogflow.cx.v3.TrainFlowRequest;
import com.google.cloud.dialogflow.cx.v3.UpdateFlowRequest;
import com.google.cloud.dialogflow.cx.v3.ValidateFlowRequest;
import com.google.cloud.dialogflow.cx.v3.stub.FlowsStub;
import com.google.cloud.dialogflow.cx.v3.stub.GrpcFlowsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class FlowsStubSettings
extends StubSettings<FlowsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final UnaryCallSettings<CreateFlowRequest, Flow> createFlowSettings;
    private final UnaryCallSettings<DeleteFlowRequest, Empty> deleteFlowSettings;
    private final PagedCallSettings<ListFlowsRequest, ListFlowsResponse, FlowsClient.ListFlowsPagedResponse> listFlowsSettings;
    private final UnaryCallSettings<GetFlowRequest, Flow> getFlowSettings;
    private final UnaryCallSettings<UpdateFlowRequest, Flow> updateFlowSettings;
    private final UnaryCallSettings<TrainFlowRequest, Operation> trainFlowSettings;
    private final OperationCallSettings<TrainFlowRequest, Empty, Struct> trainFlowOperationSettings;
    private final UnaryCallSettings<ValidateFlowRequest, FlowValidationResult> validateFlowSettings;
    private final UnaryCallSettings<GetFlowValidationResultRequest, FlowValidationResult> getFlowValidationResultSettings;
    private final UnaryCallSettings<ImportFlowRequest, Operation> importFlowSettings;
    private final OperationCallSettings<ImportFlowRequest, ImportFlowResponse, Struct> importFlowOperationSettings;
    private final UnaryCallSettings<ExportFlowRequest, Operation> exportFlowSettings;
    private final OperationCallSettings<ExportFlowRequest, ExportFlowResponse, Struct> exportFlowOperationSettings;
    private static final PagedListDescriptor<ListFlowsRequest, ListFlowsResponse, Flow> LIST_FLOWS_PAGE_STR_DESC = new PagedListDescriptor<ListFlowsRequest, ListFlowsResponse, Flow>(){

        public String emptyToken() {
            return "";
        }

        public ListFlowsRequest injectToken(ListFlowsRequest payload, String token) {
            return ListFlowsRequest.newBuilder((ListFlowsRequest)payload).setPageToken(token).build();
        }

        public ListFlowsRequest injectPageSize(ListFlowsRequest payload, int pageSize) {
            return ListFlowsRequest.newBuilder((ListFlowsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFlowsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFlowsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Flow> extractResources(ListFlowsResponse payload) {
            return payload.getFlowsList() == null ? ImmutableList.of() : payload.getFlowsList();
        }
    };
    private static final PagedListResponseFactory<ListFlowsRequest, ListFlowsResponse, FlowsClient.ListFlowsPagedResponse> LIST_FLOWS_PAGE_STR_FACT = new PagedListResponseFactory<ListFlowsRequest, ListFlowsResponse, FlowsClient.ListFlowsPagedResponse>(){

        public ApiFuture<FlowsClient.ListFlowsPagedResponse> getFuturePagedResponse(UnaryCallable<ListFlowsRequest, ListFlowsResponse> callable, ListFlowsRequest request, ApiCallContext context, ApiFuture<ListFlowsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FLOWS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FlowsClient.ListFlowsPagedResponse.createAsync((PageContext<ListFlowsRequest, ListFlowsResponse, Flow>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateFlowRequest, Flow> createFlowSettings() {
        return this.createFlowSettings;
    }

    public UnaryCallSettings<DeleteFlowRequest, Empty> deleteFlowSettings() {
        return this.deleteFlowSettings;
    }

    public PagedCallSettings<ListFlowsRequest, ListFlowsResponse, FlowsClient.ListFlowsPagedResponse> listFlowsSettings() {
        return this.listFlowsSettings;
    }

    public UnaryCallSettings<GetFlowRequest, Flow> getFlowSettings() {
        return this.getFlowSettings;
    }

    public UnaryCallSettings<UpdateFlowRequest, Flow> updateFlowSettings() {
        return this.updateFlowSettings;
    }

    public UnaryCallSettings<TrainFlowRequest, Operation> trainFlowSettings() {
        return this.trainFlowSettings;
    }

    public OperationCallSettings<TrainFlowRequest, Empty, Struct> trainFlowOperationSettings() {
        return this.trainFlowOperationSettings;
    }

    public UnaryCallSettings<ValidateFlowRequest, FlowValidationResult> validateFlowSettings() {
        return this.validateFlowSettings;
    }

    public UnaryCallSettings<GetFlowValidationResultRequest, FlowValidationResult> getFlowValidationResultSettings() {
        return this.getFlowValidationResultSettings;
    }

    public UnaryCallSettings<ImportFlowRequest, Operation> importFlowSettings() {
        return this.importFlowSettings;
    }

    public OperationCallSettings<ImportFlowRequest, ImportFlowResponse, Struct> importFlowOperationSettings() {
        return this.importFlowOperationSettings;
    }

    public UnaryCallSettings<ExportFlowRequest, Operation> exportFlowSettings() {
        return this.exportFlowSettings;
    }

    public OperationCallSettings<ExportFlowRequest, ExportFlowResponse, Struct> exportFlowOperationSettings() {
        return this.exportFlowOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public FlowsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcFlowsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return FlowsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FlowsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected FlowsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createFlowSettings = settingsBuilder.createFlowSettings().build();
        this.deleteFlowSettings = settingsBuilder.deleteFlowSettings().build();
        this.listFlowsSettings = settingsBuilder.listFlowsSettings().build();
        this.getFlowSettings = settingsBuilder.getFlowSettings().build();
        this.updateFlowSettings = settingsBuilder.updateFlowSettings().build();
        this.trainFlowSettings = settingsBuilder.trainFlowSettings().build();
        this.trainFlowOperationSettings = settingsBuilder.trainFlowOperationSettings().build();
        this.validateFlowSettings = settingsBuilder.validateFlowSettings().build();
        this.getFlowValidationResultSettings = settingsBuilder.getFlowValidationResultSettings().build();
        this.importFlowSettings = settingsBuilder.importFlowSettings().build();
        this.importFlowOperationSettings = settingsBuilder.importFlowOperationSettings().build();
        this.exportFlowSettings = settingsBuilder.exportFlowSettings().build();
        this.exportFlowOperationSettings = settingsBuilder.exportFlowOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<FlowsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateFlowRequest, Flow> createFlowSettings;
        private final UnaryCallSettings.Builder<DeleteFlowRequest, Empty> deleteFlowSettings;
        private final PagedCallSettings.Builder<ListFlowsRequest, ListFlowsResponse, FlowsClient.ListFlowsPagedResponse> listFlowsSettings;
        private final UnaryCallSettings.Builder<GetFlowRequest, Flow> getFlowSettings;
        private final UnaryCallSettings.Builder<UpdateFlowRequest, Flow> updateFlowSettings;
        private final UnaryCallSettings.Builder<TrainFlowRequest, Operation> trainFlowSettings;
        private final OperationCallSettings.Builder<TrainFlowRequest, Empty, Struct> trainFlowOperationSettings;
        private final UnaryCallSettings.Builder<ValidateFlowRequest, FlowValidationResult> validateFlowSettings;
        private final UnaryCallSettings.Builder<GetFlowValidationResultRequest, FlowValidationResult> getFlowValidationResultSettings;
        private final UnaryCallSettings.Builder<ImportFlowRequest, Operation> importFlowSettings;
        private final OperationCallSettings.Builder<ImportFlowRequest, ImportFlowResponse, Struct> importFlowOperationSettings;
        private final UnaryCallSettings.Builder<ExportFlowRequest, Operation> exportFlowSettings;
        private final OperationCallSettings.Builder<ExportFlowRequest, ExportFlowResponse, Struct> exportFlowOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createFlowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteFlowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listFlowsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FLOWS_PAGE_STR_FACT);
            this.getFlowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFlowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.trainFlowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.trainFlowOperationSettings = OperationCallSettings.newBuilder();
            this.validateFlowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getFlowValidationResultSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importFlowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importFlowOperationSettings = OperationCallSettings.newBuilder();
            this.exportFlowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportFlowOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createFlowSettings, this.deleteFlowSettings, this.listFlowsSettings, this.getFlowSettings, this.updateFlowSettings, this.trainFlowSettings, this.validateFlowSettings, this.getFlowValidationResultSettings, this.importFlowSettings, this.exportFlowSettings);
            Builder.initDefaults(this);
        }

        protected Builder(FlowsStubSettings settings) {
            super((StubSettings)settings);
            this.createFlowSettings = settings.createFlowSettings.toBuilder();
            this.deleteFlowSettings = settings.deleteFlowSettings.toBuilder();
            this.listFlowsSettings = settings.listFlowsSettings.toBuilder();
            this.getFlowSettings = settings.getFlowSettings.toBuilder();
            this.updateFlowSettings = settings.updateFlowSettings.toBuilder();
            this.trainFlowSettings = settings.trainFlowSettings.toBuilder();
            this.trainFlowOperationSettings = settings.trainFlowOperationSettings.toBuilder();
            this.validateFlowSettings = settings.validateFlowSettings.toBuilder();
            this.getFlowValidationResultSettings = settings.getFlowValidationResultSettings.toBuilder();
            this.importFlowSettings = settings.importFlowSettings.toBuilder();
            this.importFlowOperationSettings = settings.importFlowOperationSettings.toBuilder();
            this.exportFlowSettings = settings.exportFlowSettings.toBuilder();
            this.exportFlowOperationSettings = settings.exportFlowOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createFlowSettings, this.deleteFlowSettings, this.listFlowsSettings, this.getFlowSettings, this.updateFlowSettings, this.trainFlowSettings, this.validateFlowSettings, this.getFlowValidationResultSettings, this.importFlowSettings, this.exportFlowSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(FlowsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)FlowsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)FlowsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(FlowsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(FlowsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createFlowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteFlowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listFlowsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getFlowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateFlowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.trainFlowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.validateFlowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getFlowValidationResultSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.importFlowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.exportFlowSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.trainFlowOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.importFlowOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportFlowResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.exportFlowOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportFlowResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateFlowRequest, Flow> createFlowSettings() {
            return this.createFlowSettings;
        }

        public UnaryCallSettings.Builder<DeleteFlowRequest, Empty> deleteFlowSettings() {
            return this.deleteFlowSettings;
        }

        public PagedCallSettings.Builder<ListFlowsRequest, ListFlowsResponse, FlowsClient.ListFlowsPagedResponse> listFlowsSettings() {
            return this.listFlowsSettings;
        }

        public UnaryCallSettings.Builder<GetFlowRequest, Flow> getFlowSettings() {
            return this.getFlowSettings;
        }

        public UnaryCallSettings.Builder<UpdateFlowRequest, Flow> updateFlowSettings() {
            return this.updateFlowSettings;
        }

        public UnaryCallSettings.Builder<TrainFlowRequest, Operation> trainFlowSettings() {
            return this.trainFlowSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<TrainFlowRequest, Empty, Struct> trainFlowOperationSettings() {
            return this.trainFlowOperationSettings;
        }

        public UnaryCallSettings.Builder<ValidateFlowRequest, FlowValidationResult> validateFlowSettings() {
            return this.validateFlowSettings;
        }

        public UnaryCallSettings.Builder<GetFlowValidationResultRequest, FlowValidationResult> getFlowValidationResultSettings() {
            return this.getFlowValidationResultSettings;
        }

        public UnaryCallSettings.Builder<ImportFlowRequest, Operation> importFlowSettings() {
            return this.importFlowSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ImportFlowRequest, ImportFlowResponse, Struct> importFlowOperationSettings() {
            return this.importFlowOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportFlowRequest, Operation> exportFlowSettings() {
            return this.exportFlowSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ExportFlowRequest, ExportFlowResponse, Struct> exportFlowOperationSettings() {
            return this.exportFlowOperationSettings;
        }

        public FlowsStubSettings build() throws IOException {
            return new FlowsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

