/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.CreateGeneratorRequest;
import com.google.cloud.dialogflow.cx.v3.DeleteGeneratorRequest;
import com.google.cloud.dialogflow.cx.v3.Generator;
import com.google.cloud.dialogflow.cx.v3.GeneratorsClient;
import com.google.cloud.dialogflow.cx.v3.GetGeneratorRequest;
import com.google.cloud.dialogflow.cx.v3.ListGeneratorsRequest;
import com.google.cloud.dialogflow.cx.v3.ListGeneratorsResponse;
import com.google.cloud.dialogflow.cx.v3.UpdateGeneratorRequest;
import com.google.cloud.dialogflow.cx.v3.stub.GeneratorsStub;
import com.google.cloud.dialogflow.cx.v3.stub.GrpcGeneratorsStub;
import com.google.cloud.dialogflow.cx.v3.stub.HttpJsonGeneratorsStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class GeneratorsStubSettings
extends StubSettings<GeneratorsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final PagedCallSettings<ListGeneratorsRequest, ListGeneratorsResponse, GeneratorsClient.ListGeneratorsPagedResponse> listGeneratorsSettings;
    private final UnaryCallSettings<GetGeneratorRequest, Generator> getGeneratorSettings;
    private final UnaryCallSettings<CreateGeneratorRequest, Generator> createGeneratorSettings;
    private final UnaryCallSettings<UpdateGeneratorRequest, Generator> updateGeneratorSettings;
    private final UnaryCallSettings<DeleteGeneratorRequest, Empty> deleteGeneratorSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, GeneratorsClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListGeneratorsRequest, ListGeneratorsResponse, Generator> LIST_GENERATORS_PAGE_STR_DESC = new PagedListDescriptor<ListGeneratorsRequest, ListGeneratorsResponse, Generator>(){

        public String emptyToken() {
            return "";
        }

        public ListGeneratorsRequest injectToken(ListGeneratorsRequest payload, String token) {
            return ListGeneratorsRequest.newBuilder((ListGeneratorsRequest)payload).setPageToken(token).build();
        }

        public ListGeneratorsRequest injectPageSize(ListGeneratorsRequest payload, int pageSize) {
            return ListGeneratorsRequest.newBuilder((ListGeneratorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGeneratorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGeneratorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Generator> extractResources(ListGeneratorsResponse payload) {
            return payload.getGeneratorsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListGeneratorsRequest, ListGeneratorsResponse, GeneratorsClient.ListGeneratorsPagedResponse> LIST_GENERATORS_PAGE_STR_FACT = new PagedListResponseFactory<ListGeneratorsRequest, ListGeneratorsResponse, GeneratorsClient.ListGeneratorsPagedResponse>(){

        public ApiFuture<GeneratorsClient.ListGeneratorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListGeneratorsRequest, ListGeneratorsResponse> callable, ListGeneratorsRequest request, ApiCallContext context, ApiFuture<ListGeneratorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GENERATORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GeneratorsClient.ListGeneratorsPagedResponse.createAsync((PageContext<ListGeneratorsRequest, ListGeneratorsResponse, Generator>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, GeneratorsClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, GeneratorsClient.ListLocationsPagedResponse>(){

        public ApiFuture<GeneratorsClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GeneratorsClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListGeneratorsRequest, ListGeneratorsResponse, GeneratorsClient.ListGeneratorsPagedResponse> listGeneratorsSettings() {
        return this.listGeneratorsSettings;
    }

    public UnaryCallSettings<GetGeneratorRequest, Generator> getGeneratorSettings() {
        return this.getGeneratorSettings;
    }

    public UnaryCallSettings<CreateGeneratorRequest, Generator> createGeneratorSettings() {
        return this.createGeneratorSettings;
    }

    public UnaryCallSettings<UpdateGeneratorRequest, Generator> updateGeneratorSettings() {
        return this.updateGeneratorSettings;
    }

    public UnaryCallSettings<DeleteGeneratorRequest, Empty> deleteGeneratorSettings() {
        return this.deleteGeneratorSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, GeneratorsClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public GeneratorsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcGeneratorsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonGeneratorsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dialogflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GeneratorsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GeneratorsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GeneratorsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return GeneratorsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GeneratorsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listGeneratorsSettings = settingsBuilder.listGeneratorsSettings().build();
        this.getGeneratorSettings = settingsBuilder.getGeneratorSettings().build();
        this.createGeneratorSettings = settingsBuilder.createGeneratorSettings().build();
        this.updateGeneratorSettings = settingsBuilder.updateGeneratorSettings().build();
        this.deleteGeneratorSettings = settingsBuilder.deleteGeneratorSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GeneratorsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListGeneratorsRequest, ListGeneratorsResponse, GeneratorsClient.ListGeneratorsPagedResponse> listGeneratorsSettings;
        private final UnaryCallSettings.Builder<GetGeneratorRequest, Generator> getGeneratorSettings;
        private final UnaryCallSettings.Builder<CreateGeneratorRequest, Generator> createGeneratorSettings;
        private final UnaryCallSettings.Builder<UpdateGeneratorRequest, Generator> updateGeneratorSettings;
        private final UnaryCallSettings.Builder<DeleteGeneratorRequest, Empty> deleteGeneratorSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, GeneratorsClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listGeneratorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GENERATORS_PAGE_STR_FACT);
            this.getGeneratorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGeneratorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGeneratorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGeneratorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGeneratorsSettings, this.getGeneratorSettings, this.createGeneratorSettings, this.updateGeneratorSettings, this.deleteGeneratorSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(GeneratorsStubSettings settings) {
            super((StubSettings)settings);
            this.listGeneratorsSettings = settings.listGeneratorsSettings.toBuilder();
            this.getGeneratorSettings = settings.getGeneratorSettings.toBuilder();
            this.createGeneratorSettings = settings.createGeneratorSettings.toBuilder();
            this.updateGeneratorSettings = settings.updateGeneratorSettings.toBuilder();
            this.deleteGeneratorSettings = settings.deleteGeneratorSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGeneratorsSettings, this.getGeneratorSettings, this.createGeneratorSettings, this.updateGeneratorSettings, this.deleteGeneratorSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GeneratorsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GeneratorsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GeneratorsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(GeneratorsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)GeneratorsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)GeneratorsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GeneratorsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(GeneratorsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listGeneratorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getGeneratorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createGeneratorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateGeneratorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteGeneratorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListGeneratorsRequest, ListGeneratorsResponse, GeneratorsClient.ListGeneratorsPagedResponse> listGeneratorsSettings() {
            return this.listGeneratorsSettings;
        }

        public UnaryCallSettings.Builder<GetGeneratorRequest, Generator> getGeneratorSettings() {
            return this.getGeneratorSettings;
        }

        public UnaryCallSettings.Builder<CreateGeneratorRequest, Generator> createGeneratorSettings() {
            return this.createGeneratorSettings;
        }

        public UnaryCallSettings.Builder<UpdateGeneratorRequest, Generator> updateGeneratorSettings() {
            return this.updateGeneratorSettings;
        }

        public UnaryCallSettings.Builder<DeleteGeneratorRequest, Empty> deleteGeneratorSettings() {
            return this.deleteGeneratorSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, GeneratorsClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public GeneratorsStubSettings build() throws IOException {
            return new GeneratorsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

